#!/bin/bash

# Ask the user if they want to install aibridge_analytics_plugin

read -p "Do you want to install aibridge_analytics_plugin? (y/n): " answer

if [ "$answer" == "y" ]; then
    # Check if libzmq5 package is installed
    if ! dpkg -l | grep -q "libzmq5"; then
        echo "The libzmq5 package is not installed. Starting installation."
        sudo apt-get update
        sudo apt-get install -y libzmq5
    else
        echo "The libzmq5 package is already installed."
    fi

    sleep 1

    # Check if libboost-system1.65.1 package is installed
    if ! dpkg -l | grep -q "libboost-system1.65.1"; then
        echo "The libboost-system1.65.1 package is not installed. Installing from local file."
        sudo apt-get install ./libboost-system1.65.1_1.65.1+dfsg-0ubuntu5_amd64.deb
    else
        echo "The libboost-system1.65.1 package is already installed."
    fi

    sleep 1

    # Check both possible plugin directories
    PLUGIN_DIR1="/opt/networkoptix/mediaserver/bin/plugins"
    PLUGIN_DIR2="/opt/networkoptix-metavms/mediaserver/bin/plugins"
    
    if [ -d "$PLUGIN_DIR1" ]; then
        echo "Copying libaibridge_analytics_plugin.so to $PLUGIN_DIR1"
        sudo cp ./libaibridge_analytics_plugin.so $PLUGIN_DIR1
        echo "Restarting networkoptix-mediaserver service"

        echo "Installation completed successfully."
        read -p "Do you want to restart the networkoptix-mediaserver service? (y/n): " restart
        if [ "$restart" == "y" ]; then
            echo "Restarting networkoptix-mediaserver service"
            sudo systemctl restart networkoptix-mediaserver.service
        else
            echo "Service restart was declined. Please restart the service manually."
            echo "#sudo systemctl restart networkoptix-mediaserver.service"
        fi

        sleep 1
        sudo systemctl status networkoptix-mediaserver.service | head -n 10

    elif [ -d "$PLUGIN_DIR2" ]; then
        echo "Copying libaibridge_analytics_plugin.so to $PLUGIN_DIR2"
        sudo cp ./libaibridge_analytics_plugin.so $PLUGIN_DIR2

        echo "Installation completed successfully."

        read -p "Do you want to restart the networkoptix-metavms-mediaserver service? (y/n): " restart
        if [ "$restart" == "y" ]; then
            echo "Restarting networkoptix-metavms-mediaserver service"
            sudo systemctl restart networkoptix-metavms-mediaserver.service
        else
            echo "Service restart was declined. Please restart the service manually."
        fi

        sleep 1
        sudo systemctl status networkoptix-metavms-mediaserver.service | head -n 10

    else
        echo "Both directories $PLUGIN_DIR1 and $PLUGIN_DIR2 do not exist."
		echo "Please check the installation path."
    fi

else
    echo "aibridge_analytics_plugin installation was declined."
fi

echo "Bye!"

