////////////////////////////
// LPR CONFIGURATION PAGE //
////////////////////////////

$(function()
{
	function parseToFloat(numParse)
	{
		var decimal = "0."
		if (numParse < 1000)
		{
			decimal = "0.0"
		}
		return parseFloat(decimal + numParse);
	}

	function resetCalibration()
	{
		var canvas = document.getElementById('canvasSpeed');
		var ctx = canvas.getContext('2d');
		ctx.clearRect(0, 0, canvas.width, canvas.height);
		var img = document.getElementById("monoSpd");
		var tmpImg = new Image();
		tmpImg.src = $('#monoSpd').attr('src');

		ctx.drawImage(img, 0, 0, width, height);

		var pointArray = [];
		for(var i = 0; i < 4; i++)
		{
			pointArray.push({x: 0, y: 0})
		}
		
		var urlinsert = "update|table=nlcameraspeed|camp0=id|value0=" + ident + "|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000";
		urlinsert += "|camp3=reserve|value3=";
		urlinsert += "|camp4=cameraid|value4=1";
		urlinsert += "|camp5=computerid|value5=1";
		urlinsert += "|camp6=lpoint00X|value6=0";
		urlinsert += "|camp7=lpoint00Y|value7=0";
		urlinsert += "|camp8=lpoint01X|value8=0";
		urlinsert += "|camp9=lpoint01Y|value9=0";
		urlinsert += "|camp10=lpoint10X|value10=0";
		urlinsert += "|camp11=lpoint10Y|value11=0";
		urlinsert += "|camp12=lpoint11X|value12=0";
		urlinsert += "|camp13=lpoint11Y|value13=0";
		urlinsert += "|camp14=calibrated|value14=0";

		var response = executeCGI(computerid, urlinsert, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

		if(response != "error")
		{
			DevExpress.ui.notify("Data saved", "success", 600);
			var sroi = "";
			sroi = "Speed calibration [(0,0) - (0,0) - (0,0) - (0,0)]";
			$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);
		}
		else
		{
			DevExpress.ui.notify("Data saving error", "error", 600);
		}
		
		document.getElementById("monoSpd").src = getSnapshot();
		var tmpImg = new Image();
		tmpImg.src = $('#monoSpd').attr('src');
		tmpImg.onload = function()
		{
			ctx.drawImage(img, 0, 0, width, height);
		}
	}

	function resetROI()
	{
		var canvas = document.getElementById('canvas');
		var ctx = canvas.getContext('2d');
		ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
		ctx.beginPath();
		ctx.stroke();
		var img = document.getElementById("mono");
		ctx.drawImage(img, 0, 0, width, height);
		ctx.stroke();
		var roi = "0;0;0;0";
		$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi"));

		var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=5|camp1=value|value1=" + roi + "|camp2=computerid|value2=" + computerid + "|camp3=cameraid|value3=1", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

		if(response != "error")
		{
			DevExpress.ui.notify("Data saved", "success", 600);
		}
		else
		{
			DevExpress.ui.notify("Data saving error", "error", 600);
		}

		document.getElementById("mono").src = getSnapshot();
		var tmpImg = new Image();
		tmpImg.src = $('#mono').attr('src');
		tmpImg.onload = function()
		{
			ctx.drawImage(img, 0, 0, width, height);
		}
	}

	function checkCalibration()
	{
		var pointArray = [];

		var response = executeCGI(computerid, "speedcalibrate", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

		if(response != "error")
		{
			DevExpress.ui.notify("Calibrated Successful", "success", 600);

			var data = executeCGI(computerid, "select|table=nlcameraspeed|maxvalues=1", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

			if(data != "error")
			{
				if (data.length > 0)
				{
					haveLanes = true;
				}
				
				DevExpress.ui.notify("Calibrated", "success", 600);
				var context2 = document.getElementById("canvasSpeed").getContext("2d");
				var x = parseToFloat(data[0].lpoint00X); var y = parseToFloat(data[0].lpoint00Y); 
				pointArray.push({x:x * width, y:y * height});
				var x = parseToFloat(data[0].lpoint01X); var y = parseToFloat(data[0].lpoint01Y);
				pointArray.push({x:x * width, y:y * height});
				var x = parseToFloat(data[0].lpoint10X); var y = parseToFloat(data[0].lpoint10Y);
				pointArray.push({x:x * width, y:y * height});
				var x = parseToFloat(data[0].lpoint11X); var y = parseToFloat(data[0].lpoint11Y);
				pointArray.push({x:x * width, y:y * height});
				
	
				var slope = (pointArray[2].y - pointArray[0].y)/(pointArray[2].x - pointArray[0].x)
				//y = mx + b | b = y - mx
				var intercept = pointArray[2].y - (slope * pointArray[2].x)
	
				function getX(y) { return (y - intercept)/slope; }
	
				// mark points in the canvas
				context2.fillStyle = "red";
				// draw a line between two points
				context2.beginPath();
				context2.strokeStyle = "blue";
				context2.lineWidth = 3;
				context2.moveTo(getX(0), 0);
				context2.lineTo(pointArray[0].x, pointArray[0].y);
				context2.lineTo(pointArray[2].x, pointArray[2].y);
				context2.lineTo(getX(context2.canvas.height), context2.canvas.height);
				context2.stroke();

				context2.beginPath();
				slope = (pointArray[3].y - pointArray[1].y)/(pointArray[3].x - pointArray[1].x)

				intercept = pointArray[3].y - (slope * pointArray[3].x)
				context2.strokeStyle = "blue";
				context2.lineWidth = 3;
				context2.moveTo(getX(0), 0);
				context2.lineTo(pointArray[1].x, pointArray[1].y);
				context2.lineTo(pointArray[3].x, pointArray[3].y);
				context2.lineTo(getX(context2.canvas.height), context2.canvas.height);
				context2.stroke();
				context2.beginPath();
				context2.fillStyle = "red";
				context2.strokeStyle = "red";
				context2.lineWidth = 5;
				context2.stroke();
			}
		}
		else
		{
			DevExpress.ui.notify("Calibration Error", "error", 600);
		}
	}

	function convertTriggermodeToInt(mode)
	{
		var value = 1;
		if (typeof mode !== 'undefined')
		{
			if (mode == DevExpress.localization.formatMessage("Entering"))
			{
				value = 1;
			}
			else if (mode == DevExpress.localization.formatMessage("Leaving"))
			{
				value = 2;
			}
			else if (mode == DevExpress.localization.formatMessage("Both"))
			{
				value = 3;
			}
		}
		return value;
	}
	
	function convertIntToTriggermode(value)
	{
		var mode = DevExpress.localization.formatMessage("Entering");
		if (value == 1)
		{
			mode = DevExpress.localization.formatMessage("Entering");
		}
		else if (value == 2)
		{
			mode = DevExpress.localization.formatMessage("Leaving");
		}
		else if (value == 3)
		{
			mode = DevExpress.localization.formatMessage("Both");
		}
		return mode;
	}

	function resetLANES()
	{
		var canvas2 = document.getElementById('canvaslanes');
		var ctx2 = canvas2.getContext('2d');
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		ctx2.stroke();
		var img2 = document.getElementById("monolanes");
		ctx2.drawImage(img2, 0, 0, width, height);
		ctx2.stroke();
		$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes"));

		var response = executeCGI(computerid, "delete|table=nlcameralane", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

		if(response != "error")
		{
			DevExpress.ui.notify("Data saved", "success", 600);
		}
		else
		{
			DevExpress.ui.notify("Data saving error", "error", 600);
		}

		document.getElementById("monolanes").src = getSnapshot();
		var tmpImg = new Image();
		tmpImg.src = $('#monolanes').attr('src');
		tmpImg.onload = function()
		{
			ctx2.drawImage(img2, 0, 0, width, height);
		}
	}

	function loadcrossline()
	{
		var data = executeCGI(computerid, "select|table=nlcrossline|maxvalues=20|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		if(data != "error")
		{
			actdict = {};
			cross_lista = data;
			crossdatagrid.option("dataSource", cross_lista);
			$.each(data, function(i, item)
			{
				data[i].triggermode = convertIntToTriggermode(data[i].triggermode);
				actdict["cross" + item.id] = item;
			});
		}
	};

	function loadcrosslinedetails(idcross)
	{
		var cross = actdict["cross" + idcross];
		//Draw lane cross
		var canvas2 = document.getElementById('canvascrossline');
		var ctx2 = canvas2.getContext('2d');
		var img2 = document.getElementById("crosslineimg");
		var tmpImg2 = new Image();
		tmpImg2.src = $('#crosslineimg').attr('src');

		tmpImg2.onload = function()
		{
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			ctx2.stroke();
			ctx2.drawImage(img2, 0, 0, width, height);
			var ppcX = parseFloat(cross.lineX0);
			var ppcX2 = parseFloat(cross.lineX1);
			var ppcY = parseFloat(cross.lineY0);
			var ppcY2 = parseFloat(cross.lineY1);
			ctx2.moveTo(ppcX * width, ppcY * height);
			ctx2.lineTo(ppcX2 * width, ppcY2 * height);
			ctx2.strokeStyle = 'red';
			ctx2.lineWidth = 5;
			ctx2.stroke();
		};

		var canvas = document.getElementById('canvascrossarea');
		var ctx = canvas.getContext('2d');
		var imgrect = document.getElementById("crossareaimg");
		var tmpImgrect = new Image();
		tmpImgrect.src = $('#crossareaimg').attr('src');

		tmpImgrect.onload = function()
		{
			ctx.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx.beginPath();
			ctx.stroke();
			ctx.drawImage(imgrect, 0, 0, width, height);
			var ppcX = parseFloat(cross.roi1);
			var ppcY = parseFloat(cross.roi2);
			var ppcwidth = parseFloat(cross.roi3);
			var ppcheight = parseFloat(cross.roi4);
			ctx.rect(ppcX * width, ppcY * height, ppcwidth * width, ppcheight * height);
			ctx.strokeStyle = 'red';
			ctx.lineWidth = 5;
			ctx.stroke();
		};
	}

	function resetLaneCross()
	{
		var canvas2 = document.getElementById('canvascrossline');
		var ctx2 = canvas2.getContext('2d');
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		ctx2.stroke();
		var img2 = document.getElementById("crosslineimg");
		ctx2.drawImage(img2, 0, 0);
		ctx2.stroke();

		var response = executeCGI(computerid, "update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=lineY0|value1=0|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=lineX0|value4=0|camp5=lineY1|value5=0|camp6=lineX1|value6=0", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

		if(response != "error")
		{
			DevExpress.ui.notify("Data saved", "success", 600);
		}
		else
		{
			DevExpress.ui.notify("Data saving error", "error", 600);
		}

		actdict["cross" + crosslineediting].lineY = 0;
		actdict["cross" + crosslineediting].lineXleft = 0;
		actdict["cross" + crosslineediting].lineXright = 0;
	}

	function resetLaneArea()
	{
		var canvas2 = document.getElementById('canvascrossarea');
		var ctx2 = canvas2.getContext('2d');
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		ctx2.stroke();
		var img2 = document.getElementById("crossareaimg");
		ctx2.drawImage(img2, 0, 0, width, height);
		ctx2.stroke();

		var response = executeCGI(computerid, "update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=roi1|value1=0|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=roi2|value4=0|camp5=roi3|value5=0|camp6=roi4|value6=0", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

		if(response != "error")
		{
			DevExpress.ui.notify("Data saved", "success", 600);
		}
		else
		{
			DevExpress.ui.notify("Data saving error", "error", 600);
		}

		actdict["cross" + crosslineediting].roi1 = 0;
		actdict["cross" + crosslineediting].roi2 = 0;
		actdict["cross" + crosslineediting].roi3 = 0;
		actdict["cross" + crosslineediting].roi4 = 0;
	}

	function getDataSourceRegions()
	{
		var regions = "";
		var data = executeCGI(computerid, "select|table=nlregion|maxvalues=250", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		if(data != "error")
		{
			regions = data;
		}

		var regionds = new DevExpress.data.DataSource(
		{
			store: regions,
			key: "id",
		});

		return regionds;
	}

	function getDataSourceLocations()
	{
		var locations = "";
		var data = executeCGI(computerid, "select|table=nllocation|maxvalues=250", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		if(data != "error")
		{
			locations = data;
		}

		var locationsds = new DevExpress.data.DataSource(
		{
			store: locations,
			key: "id",
		});

		return locationsds;
	}

	function createRestartDefaultConfigurationButton()
	{
		$("#restartdefault").dxButton(
		{
			type: "default",
			text: DevExpress.localization.formatMessage("Restart default configuration"),
			onClick: function()
			{
				var result = DevExpress.ui.dialog.confirm(DevExpress.localization.formatMessage("Are you sure to restart default configuration?"), DevExpress.localization.formatMessage("Default configuration"));
				result.done(function(dialogResult)
				{
					if (dialogResult)
					{
						executeCGI(computerid, "defaultcameraconfig", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
						resetLANES();
						location.reload();
					}
				});
			}
		});
	}

	function createCamConfigurationFields()
	{
		var data = executeCGI(computerid, "select|table=nlconfcamera|maxvalues=250|camp0=cameraid|comp0=minor|value0=2", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='ROIheader' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Roi") + "hhhh</div> ");
		$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlROI'  ></div> ");
		$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='LH1' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Lanes") + "</div> ");
		$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlLANES'  ></div> ");
		$("#fiedlROI").hide();
		$("#fiedlLANES").hide();
		$("#LH1").click(function()
		{
			if ($("#LH1").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedlLANES").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedlLANES").show();
			}
		});

		//First bucle to create checkbox and div
		$.each(data, function(i, item)
		{
			if (item.grouppar != "")
			{
				if (typeof dict[item.grouppar] === "undefined")
				{
					item.indexg = i;
					dict[item.grouppar] = i;
					var toadd = "<div class='dx-fieldset-header cerrado' id='group" + i + "' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage(item.grouppar) + "</div> ";
					toadd += "<div class='dx-fieldset' id= 'fiedl" + i + "'  ></div>";
					$(".content_wrapper").append(toadd);
					$("#fiedl" + i).hide();
					$("#group" + i).click(function()
					{
						if ($("#group" + i).hasClass("abierto"))
						{
							$(this).removeClass('abierto');
							$(this).addClass('cerrado');
							$("#fiedl" + i).hide();
							listplatesabierto = false;
						}
						else
						{
							$(this).addClass('abierto');
							$(this).removeClass('cerrado');
							$("#fiedl" + i).show();
							listplatesabierto = true;
						}
					});
				}
				else
				{
					item.indexg = dict[item.grouppar];
				}
			}
			else
			{
				item.indexg = -1;
			}
			if (item.id == 57)
			{
				if (item.name.includes("umresolution"))
				{
					var resopt = (item.value).split("x");
					resx = resopt[0];
					resy = resopt[1];
					resolutions = (item.options).split(";");
				}
			}
		});
		$.each(data, function(i, item)
		{
			if (item.visible == 1)
			{
				if (item.typepar == "int")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "'></div></div></div>");
					var valopt = (item.options).split(";");
					$("#elem" + i).dxNumberBox(
					{
						value: item.value,
						min: valopt[0],
						max: valopt[1],
						showSpinButtons: true,
						onInitialized: function(e)
						{
							var elemFreeFlowOption1 = "#elem" + (freeflowElem + 1);
							var elemFreeFlowOption2 = "#elem" + (freeflowElem + 2);
							var elemFreeFlowOption3 = "#elem" + (freeflowElem + 3);
							if(freeflowOptions[0] == true)
							{
								$(elemFreeFlowOption1).dxNumberBox("option", "disabled", true);
								$(elemFreeFlowOption2).dxNumberBox("option", "disabled", true);
								$(elemFreeFlowOption3).dxNumberBox("option", "disabled", true);
							}
							if(freeflowOptions[1] == true)
							{
								$(elemFreeFlowOption1).dxNumberBox("option", "disabled", false);
								$(elemFreeFlowOption2).dxNumberBox("option", "disabled", true);
								$(elemFreeFlowOption3).dxNumberBox("option", "disabled", false);
							}
							if(freeflowOptions[2] == true)
							{
								$(elemFreeFlowOption1).dxNumberBox("option", "disabled", true);
								$(elemFreeFlowOption2).dxNumberBox("option", "disabled", false);
								$(elemFreeFlowOption3).dxNumberBox("option", "disabled", false);
							}
							
							for (var j = angleFilterElem; j < (angleFilterElem+2); j++) 
							{
								var elemAngleOption = "#elem" + (j + 1);
								$(elemAngleOption).dxNumberBox("option", "disabled", !enableAngleFilter);	
							}

							for (var j = bestResultElem; i < (bestResultElem+4); i++) 
							{
								var elemBestResultOption = "#elem" + (i + 1);
								$(elemBestResultOption).dxNumberBox("option", "disabled", !enableBestResult);	
							}
						},
						onValueChanged: function(e)
						{
							var is_changed = true;
							var newValue = e.value;
							if (newValue != null)
							{
								if ((item.id == 10) || (item.id == 63))
								{
									if (newValue > data[i+1].value)
									{
										is_changed = false;
										DevExpress.ui.notify("ERROR: " + item.name + " > " + data[i+1].name, "error", 1000);
									}
								}
								else if ((item.id == 11) || (item.id == 64))
								{
									if (newValue < data[i-1].value)
									{
										is_changed = false;
										DevExpress.ui.notify("ERROR: " + data[i-1].name + " > " + item.name, "error", 1000);
									}
								}
								
								if (is_changed)
								{
									if(Number.isInteger(parseInt(newValue)))
									{
										data[i].value = newValue;

										var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

										if(response != "error")
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										}
										else
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										}
									}
									else
									{
										DevExpress.ui.notify("Element is not an integer", "error", 600);
									}
								}
							}
							else
							{
								DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
							}
						}
					});
				}
				else if (item.typepar == "multioption")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value' id='multioption" + i + "'></div></div>");
					var valopt = (item.options).split(";");
					var valvalue = (item.value).split(";");
					var options_disabled = false;
					if (item.name == "trigger_io_type") //disable trigger options
					{
						options_disabled = true;
					}
					multioptdict["multioption" + i] = [];
					$.each(valvalue, function(k, itemvalue)
					{
						multioptdict["multioption" + i].push(itemvalue);
					});
					$.each(valopt, function(j, itemoptions)
					{
						$("#multioption" + i).append("<div id='elem" + i + "-" + j + "' style='float: left;margin-right: 10px;' ></div>");
						$("#elem" + i + "-" + j).dxCheckBox(
						{
							value: item.value.includes(itemoptions),
							text: itemoptions,
							disabled: options_disabled,
							onValueChanged: function(e)
							{
								var newValue = e.value;
								if (newValue)
								{
									multioptdict["multioption" + i].push(e.element[0].textContent);
								}
								else
								{
									var index = multioptdict["multioption" + i].indexOf(e.element[0].textContent);
									if (index > -1)
									{
										multioptdict["multioption" + i].splice(index, 1);
									}
								}

								var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + multioptdict["multioption" + i].toString().replace(/,/g, ';') + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid , getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

								if(response != "error")
								{
									DevExpress.ui.notify("Data saved", "success", 600);
								}
								else
								{
									DevExpress.ui.notify("Data saving error", "error", 600);
								}
							}
						});
					});
				}
				else if (item.typepar == "nllocation")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item.text + "</div><div class='dx-field-value'><div id='location'></div></div></div>");
					$("#location").dxSelectBox(
					{
						dataSource: locationsds,
						valueExpr: "id",
						searchEnabled: true,
						value: parseInt(item.value, 10),
						displayExpr: "description",
						onValueChanged: function(e)
						{
							var newValue = e.value;
							var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

							if(response != "error")
							{
								DevExpress.ui.notify("Data saved", "success", 600);
							}
							else
							{
								DevExpress.ui.notify("Data saving error", "error", 600);
							}
						}
					});
				}
				else if (item.typepar == "nlregion")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='region'></div></div></div>");
					$("#region").dxSelectBox(
					{
						dataSource: regiondsrc,
						valueExpr: "id",
						searchEnabled: true,
						value: parseInt(item.value, 10),
						displayExpr: "description",
						onValueChanged: function(e)
						{
							var newValue = e.value;
							var response;

							if(newValue != null)
							{
								response = executeCGI(computerid, "select|table=nlcountry|comp0=equal|camp0=regionid|value0=" + newValue + "|maxvalues=250" + "|sortasc=description", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

								if(response != "error")
								{
									$("#country").dxTagBox("instance").option("dataSource", response);
									$("#country").dxTagBox("instance").reset();
								}

								response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=2|camp1=value|value1=|camp2=computerid|value2=" + computerid + "|camp3=cameraid|value3=-1", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

								if(response != "error")
								{
									DevExpress.ui.notify("Data saved", "success", 600);
								}
								else
								{
									DevExpress.ui.notify("Data saving error", "error", 600);
								}
							
								response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=-1", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

								if(response != "error")
								{
									DevExpress.ui.notify("Data saved", "success", 600);
								}
								else
								{
									DevExpress.ui.notify("Data saving error", "error", 600);
								}
							}
							else
							{
								DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
							}
						}
					});
					selected_region = item.value;

					var dataCountries = executeCGI(computerid, "select|table=nlcountry|comp0=equal|camp0=regionid|value0=" + selected_region + "|maxvalues=250" + "|sortasc=description", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

					if(dataCountries != "error")
					{
						countriesds = new DevExpress.data.DataSource(
						{
							store: dataCountries,
							key: "id",
						});
					}		
				}
				else if (item.typepar == "nlcountry")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}

					console.log("Test field name: " + item.text);
					if(item.text == "Countries:")
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("CountryState") + ":</div><div class='dx-field-value'><div id='country'></div></div></div>");
					else
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='country'></div></div></div>");
					var valopt = (item.value).split(";");
					var valores = [];
					$.each(valopt, function(i, item)
					{
						valores.push(parseInt(item));
					});

					// Fix for bug #3314 regarding the presence of NaN in the list of countries
					if (valores.length >= 1)
					{
						if (isNaN(valores[0]))
						{
							valores = [];
						}
					}
					$("#country").dxTagBox(
					{
						dataSource: countriesds,
						valueExpr: "id",
						searchEnabled: true,
						value: valores,
						displayExpr: "description",
						onValueChanged: function(e)
						{
							var newValue = e.value;
							var response;

							if(newValue.length != 0)
							{
								var counts = "";
								$.each(newValue, function(i, item)
								{
									counts += item + ";";
								});
								counts = counts.substring(0, counts.length - 1);

								response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + counts + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=-1", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

								if(response != "error")
								{
									DevExpress.ui.notify("Data saved", "success", 600);
								}
								else
								{
									DevExpress.ui.notify("Data saving error", "error", 600);
								}
							}
							else
							{
								DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
							}
						}
					});
				}
				if (item.typepar == "bool")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					var options_disabled = false;
					
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
					var isTrueSet = (item.value == 'true');
					$("#elem" + i).dxCheckBox(
					{
						value: isTrueSet,
						disabled: options_disabled,
						onInitialized:function(e)
						{
							if(item.id == 62)
							{
								enableAngleFilter = e.component.option("value");
								angleFilterElem = i;
							}
							if(item.id == 49)
							{
								enableBestResult = e.component.option("value");
								bestResultElem = i;
							}
						},
						onValueChanged: function(e)
						{
							var newValue = e.value;
							if(item.id == 62)
							{

								enableAngleFilter = newValue;
								for (var i = angleFilterElem; i < (angleFilterElem+2); i++) 
								{
									var elemAngleOption = "#elem" + (i + 1);
									$(elemAngleOption).dxNumberBox("option", "disabled", !enableAngleFilter);	
								}
							}
							if(item.id == 49)
							{
								enableBestResult = newValue;
								for (var i = bestResultElem; i < (bestResultElem+4); i++) 
								{
									var elemBestResultOption = "#elem" + (i + 1);
									$(elemBestResultOption).dxNumberBox("option", "disabled", !enableBestResult);	
								}
							}

							var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

							if(response != "error")
							{
								DevExpress.ui.notify("Data saved", "success", 600);
							}
							else
							{
								DevExpress.ui.notify("Data saving error", "error", 600);
							}
						}
					});
				}
				if (item.typepar == "info")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).prepend(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
					var mh = 400;
					var mw = 600;
					if (item.help == "infoexpertcamera-c.html" || item.help == "infoexpertcamera-n.html" || item.help == "infoexpertcamera-n25.html" || item.help == "infoexpertcamera-v.html" || item.help == "infoexpertcamera-z.html")
					{
						mh = 700;
						mw = 600;
					}

					$("#elem" + i).dxButton(
					{
						icon: "help",
						type: "success",
						mode: "contained",
						onClick: function(e)
						{
							var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
								.done(function(data)
								{
									$("#popupinfo" + i).append(data);
									var poup = $("#popupinfo" + i).dxPopup(
									{
										showTitle: true,
										title: DevExpress.localization.formatMessage("Help"),
										visible: true,
										maxWidth: mw,
										maxHeight: mh,
										loseOnOutsideClick: true
									});
								});
						}
					});
				}
				if (item.typepar == "string")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
					var passmode = "Text";
					if (item.text == "Password:") passmode = "password";
					$("#elem" + i).dxTextBox(
					{
						value: item.value,
						mode: passmode,
						onValueChanged: function(e)
						{
							var newValue = e.value;
							newValue = newValue.replace(/\\/g, '/');

							var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + encodeURIComponent(newValue) + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

							if(response != "error")
							{
								DevExpress.ui.notify("Data saved", "success", 600);
							}
							else
							{
								DevExpress.ui.notify("Data saving error", "error", 600);
							}
						}
					});
				}
				if (item.typepar == "option")
				{
					var valopt = (item.options).split(";");
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					var helpdiv = "";
					if (item.help != "")
					{
						helpdiv = "<div id='icon" + i + "'></div><div id='popup" + i + "' style='display:none' ></div> ";
					}
					var item_name = DevExpress.localization.formatMessage(item.text);
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item_name + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
					if (item.help != "")
					{
						var mh = 250;
						var mw = 500;

						if (item.help == "help_mode_camera.html" || item.help == "help_installation_camera.html")
						{
							mh = 400;
							mw = 800;
						}

						$("#icon" + i).dxButton(
						{
							icon: "help",
							type: "success",
							mode: "contained",
							onClick: function(e)
							{
								var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
									.done(function(data)
									{
										$("#popup" + i).append(data);
										var poup = $("#popup" + i).dxPopup(
										{
											showTitle: true,
											title: DevExpress.localization.formatMessage("Help"),
											visible: true,
											maxWidth: mw,
											maxHeight: mh,
											loseOnOutsideClick: true
										});
									});
							}
						});
					}
					var isTrueSet = (item.value == 'true');
					
					var dict_translations = {};
					var current_val;
					if (((item.name == 'resolution') && (item.value.toLowerCase().includes("motorbikes"))) || (item.name == 'camposition') || (item.name == 'ff_filtermode') || (item.name == 'installation'))
					{
						valopt.forEach(function(element, index)
						{
							dict_translations[DevExpress.localization.formatMessage(element)] = element;
							valopt[index] = DevExpress.localization.formatMessage(element);
						})
						current_val = DevExpress.localization.formatMessage(item.value);
					}
					else
					{
						valopt.forEach(function(element, index)
						{
							dict_translations[element] = element;
						})
						current_val = item.value
					}
					$("#elem" + i).dxRadioGroup(
					{
						items: valopt,
						value: current_val,
						layout: "horizontal",
						onInitialized:function(e)
						{
							if(item.id == 33)
							{
								var radioValue = e.component.option("value");
								if (radioValue == "NONE")
								{
									freeflowOptions[0] = true;
									freeflowOptions[1] = false;
									freeflowOptions[2] = false;
								}
								if (radioValue == "CAPTURES")
								{
									freeflowOptions[0] = false;
									freeflowOptions[1] = true;
									freeflowOptions[2] = false;
								}
								if (radioValue == "TIME")
								{
									freeflowOptions[0] = false;
									freeflowOptions[1] = false;
									freeflowOptions[2] = true;
								}
								enableAngleFilter = e.component.option("value");
								freeflowElem = i;
							}
						},
						onValueChanged: function(e)
						{
							var newValue = dict_translations[e.value];

							if(item.id == 33)
							{
								var elemFreeFlowOption1 = "#elem" + (freeflowElem + 1);
                                var elemFreeFlowOption2 = "#elem" + (freeflowElem + 2);
                                var elemFreeFlowOption3 = "#elem" + (freeflowElem + 3);

                                if (newValue == "NONE")
                                {
                                    $(elemFreeFlowOption1).dxNumberBox("instance").option("disabled", true);
                                    $(elemFreeFlowOption2).dxNumberBox("instance").option("disabled", true);
                                    $(elemFreeFlowOption3).dxNumberBox("instance").option("disabled", true);
                                }

                                if (newValue == "CAPTURES")
                                {
                                    $(elemFreeFlowOption1).dxNumberBox("instance").option("disabled", false);
                                    $(elemFreeFlowOption2).dxNumberBox("instance").option("disabled", true);
                                    $(elemFreeFlowOption3).dxNumberBox("instance").option("disabled", false);
                                }

                                if (newValue == "TIME")
                                {
                                    $(elemFreeFlowOption1).dxNumberBox("instance").option("disabled", true);
                                    $(elemFreeFlowOption2).dxNumberBox("instance").option("disabled", false);
                                    $(elemFreeFlowOption3).dxNumberBox("instance").option("disabled", false);
                                }
							}
							
							var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

							if(response != "error")
							{
								DevExpress.ui.notify("Data saved", "success", 600);
							}
							else
							{
								DevExpress.ui.notify("Data saving error", "error", 600);
							}

							if (item.id == 4)
							{
								if (newValue == 'Do not allow motorbikes')
								{
									newValue = resolutions[0];
								}
								else
								{
									newValue = resolutions[1];
								}
								var resopt = newValue.split("x");
								resx = resopt[0];
								resy = resopt[1];

								var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=57|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

								if(response != "error")
								{
									DevExpress.ui.notify("Data saved", "success", 600);
								}
								else
								{
									DevExpress.ui.notify("Data saving error", "error", 600);
								}
							}
						}
					});
				}
				if (item.typepar == "roi")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}

					$("#fiedlROI").append(" <div class='dx-field' id ='ROICANVAS'  ><div id='icon-done_info'></div><br><br><img src='./images/ROIGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvas' width='" + width + "' height='" + height + "' '></canvas><img id = 'mono' src=' " + getSnapshot() + "' width='" + width + "' height='" + height + "' style= 'visibility:hidden;display:none'></div></div>");
					//$("#fiedlROI").append(" <div class='dx-field' id ='ROICANVAS'  ><div id='icon-done_info'></div><br><br><img src='./images/ROIGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvas' width='" + width + "' height='" + height + "' '></canvas></div></div>");
					$("#ROIheader").click(function()
					{
						if ($("#ROIheader").hasClass("abierto"))
						{
							$(this).removeClass('abierto');
							$(this).addClass('cerrado');
							$("#fiedlROI").hide();
						}
						else
						{
							$(this).addClass('abierto');
							$(this).removeClass('cerrado');
							$("#fiedlROI").show();
						}
					});
					var valopt = (item.value).split(";");
					var sroi = "";
					if (valopt[0] != 0 || valopt[1] != 0 || valopt[2] != 0 || valopt[3] != 0)
					{
						sroi = " (" + valopt[0] + ";" + valopt[1] + ";" + valopt[2] + ";" + valopt[3] + ")";
					}
					$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + sroi);

					btroi = $("#icon-done_info").dxButton(
					{
						type: "success",
						text: DevExpress.localization.formatMessage("Reset ROI"),
						onClick: function()
						{	
							resetROI();
						}
					}).dxButton('instance');;

					var canvas = document.getElementById('canvas');
					var ctx = canvas.getContext('2d');
					var img = document.getElementById("mono");
					var tmpImg = new Image();
					tmpImg.src = $('#mono').attr('src');
					tmpImg.onload = function()
					{
						ctx.drawImage(img, 0, 0, width, height);
						var ppcX = parseFloat("0." + valopt[0]);
						var ppcY = parseFloat("0." + valopt[1]);
						var ppcwidth = parseFloat("0." + valopt[2]);
						var ppcheight = parseFloat("0." + valopt[3]);
						ctx.rect(ppcX * width, ppcY * height, ppcwidth * width, ppcheight * height);
						ctx.strokeStyle = 'red';
						ctx.lineWidth = 5;
						ctx.stroke();
					};
					//Variables
					var last_mousex = last_mousey = 0;
					var mousex = mousey = 0;
					var mousedown = false;
					//Mousedown
					$(canvas).on('mousedown', function(e)
					{
						last_mousex = e.offsetX;
						last_mousey = e.offsetY;
						mousedown = true;
					});
					//Mouseup
					$(canvas).on('mouseup', function(e)
					{
						mousedown = false;
						var initpointx,
							initpointy,
							endpointx,
							endpointy;
						mousex = e.offsetX;
						mousey = e.offsetY;
						if (mousex > last_mousex)
						{
							initpointx = last_mousex;
							endpointx = mousex;
						}
						else
						{
							initpointx = mousex;
							endpointx = last_mousex;
						}
						if (mousey > last_mousey)
						{
							initpointy = last_mousey;
							endpointy = mousey;
						}
						else
						{
							initpointy = mousey;
							endpointy = last_mousey;
						}
						console.log("Init points:  x: " +initpointx+ " y: " +initpointy);
						console.log("Res:  x: " +resx+ " y: " +resy);
						console.log("End points:  x: " +endpointx+ " y: " +endpointy);
						var pointXReal = Math.round(initpointx * (resx / width));
						var pointYReal = Math.round(initpointy * (resy / height));
						var endpointXReal = Math.round(endpointx * (resx / width));
						var endpointYReal = Math.round(endpointy * (resy / height));
						if (pointXReal == endpointXReal || pointYReal == endpointYReal)
						{
							return;
						}
						if (pointXReal < 0)
						{
							pointXReal = 0;
						}
						if (pointYReal < 0)
						{
							pointYReal = 0;
						}
						var tpcx = (pointXReal / resx).toFixed(4);
						console.log("pointXReal " + pointXReal + "  tpcx" + tpcx);
						var tpcy = (pointYReal / resy).toFixed(4);
						console.log("pointYReal " + pointYReal + "  tpcy" + tpcy);
						var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
						console.log("endpointXReal " + endpointXReal + "  tpcwidth" + tpcwidth);
						var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);
						console.log("endpointYReal " + endpointYReal + "  tpcheigth" + tpcheigth);
						var tpcx_dec = (tpcx + "").split(".")[1];
						var tpcy_dec = (tpcy + "").split(".")[1];
						var tpcwidth_dec = (tpcwidth + "").split(".")[1];
						var tpcheigth_dec = (tpcheigth + "").split(".")[1];
						var roi = tpcx_dec + ";" + tpcy_dec + ";" + tpcwidth_dec + ";" + tpcheigth_dec;
						console.log("roi " + roi);

						$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + " (" + roi + ")");

						var response = executeCGI(computerid, "update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + roi + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

						if(response != "error")
						{
							DevExpress.ui.notify("Data saved", "success", 600);
						}
						else
						{
							DevExpress.ui.notify("Data saving error", "error", 600);
						}
					});
					//Mousemove
					$(canvas).on('mousemove', function(e)
					{
						mousex = e.offsetX;
						mousey = e.offsetY;
						if (mousedown)
						{
							ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
							ctx.beginPath();
							var width_rect = mousex - last_mousex;
							var height_rect = mousey - last_mousey;
							ctx.rect(last_mousex, last_mousey, width_rect, height_rect);
							ctx.strokeStyle = 'red';
							ctx.lineWidth = 5;
							ctx.stroke();
							var img = document.getElementById("mono");
							ctx.drawImage(img, 0, 0, width, height);
							ctx.stroke();
						}
					});
				}
				/////////////////END ROI///////////////////////////////////////////////////////////////////////////////////////////////////////////////
				if (item.typepar == "nlcameraspeed")
				{
					var pointArray = [];

					var data2 = executeCGI(computerid, "select|table=nlcameraspeed|maxvalues=5", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

					ident = data2[0].id;
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}

					$(normalexper).append("<div class='dx-field'> <div class='dx-field-label' id='speedHeader' style= 'padding: 10px 0px;width: 100%' >Speed calibration </div>  </div>");
					$(normalexper).append(" <div class='dx-fieldset' id= 'fiedlSpeed'  ></div> ");

					$("#fiedlSpeed").append(" <div class='dx-field' id ='ROISPEED'  ><div id='icon-done_info2' style='width:155px; height:35px'></div><div id='icon-done_info3' style='margin-left:5px; width:155px; height:35px'></div><br><br><img src='./images/speedGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvasSpeed' width='800' height='600' '></canvas><img id = 'monoSpd' src=' " + getSnapshot() + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
					$("#speedHeader").click(function()
					{
						if ($("#speedHeader").hasClass("abierto"))
						{
							$(this).removeClass('abierto');
							$(this).addClass('cerrado');
							$("#fiedlSpeed").hide();
						}
						else
						{
							$(this).addClass('abierto');
							$(this).removeClass('cerrado');
							$("#fiedlSpeed").show();
						}
					});

					var valopt = (item.value).split(";");
					
					btroi = $("#icon-done_info2").dxButton(
					{
						type: "success",
						text: DevExpress.localization.formatMessage("Reset Calibration"),
						onClick: function()
						{
							pointArray = [];
							resetCalibration();
						}
					}).dxButton('instance');

					btroi = $("#icon-done_info3").dxButton(
					{
						type: "success",
						text: DevExpress.localization.formatMessage("Check Calibration"),
						onClick: function()
						{
							checkCalibration();
						}
					}).dxButton('instance');;
					var canvas = document.getElementById('canvasSpeed');
					var ctx = canvas.getContext('2d');
					
					var x = parseToFloat(data2[0].lpoint00X); var y = parseToFloat(data2[0].lpoint00Y); 
					pointArray.push({x:x * width, y:y * height});
					var x = parseToFloat(data2[0].lpoint01X); var y = parseToFloat(data2[0].lpoint01Y);
					pointArray.push({x:x * width, y:y * height});
					var x = parseToFloat(data2[0].lpoint10X); var y = parseToFloat(data2[0].lpoint10Y);
					pointArray.push({x:x * width, y:y * height});
					var x = parseToFloat(data2[0].lpoint11X); var y = parseToFloat(data2[0].lpoint11Y);
					pointArray.push({x:x * width, y:y * height});

					var img = document.getElementById("monoSpd");
					var tmpImg = new Image();
					tmpImg.src = $('#monoSpd').attr('src');
					tmpImg.onload = function()
					{
						ctx.drawImage(img, 0, 0, width, height);
						ctx.fillStyle="red";
						ctx.strokeStyle = 'red';
						ctx.lineWidth = 5;
						ctx.fillRect(pointArray[0].x-5, pointArray[0].y-5, 10,10);
						ctx.fillRect(pointArray[1].x-5, pointArray[1].y-5, 10,10);
						ctx.fillRect(pointArray[2].x-5, pointArray[2].y-5, 10,10);
						ctx.fillRect(pointArray[3].x-5, pointArray[3].y-5, 10,10);
						ctx.beginPath();
						ctx.moveTo(pointArray[2].x, pointArray[2].y);
						ctx.lineTo(pointArray[0].x, pointArray[0].y);
						ctx.lineTo(pointArray[1].x, pointArray[1].y);
						ctx.lineTo(pointArray[3].x, pointArray[3].y);
						ctx.lineTo(pointArray[2].x, pointArray[2].y);
							
						ctx.stroke();
					};

					var sroi = "";
					sroi = "Speed calibration [(" + data2[0].lpoint00X + "," + data2[0].lpoint00Y + ") - (" + data2[0].lpoint01X + "," + data2[0].lpoint01Y + ") - (" + data2[0].lpoint10X + "," + data2[0].lpoint10Y + ") - (" + data2[0].lpoint11X + "," + data2[0].lpoint11Y + ")]";
					$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);

					//Variables
					var last_mousex = last_mousey = 0;
					var mousex = mousey = 0;
					var mousedown = false;
					//Mousedown
					$(canvas).on('mousedown', function(e)
					{
						mousedown = true;
					});
					//Mouseup
					$(canvas).on('mouseup', function(e)
					{
						mousedown = false;
						mousex = e.offsetX;
						mousey = e.offsetY;
						console.log("mousex: " + mousex)
						console.log("mousey: " + mousey)
						console.log("resx: " + resx)
						console.log("resy: " + resy)
						var pointXReal = Math.round(mousex * (resx / width));
						var pointYReal = Math.round(mousey * (resy / height));

						//console.log("points: " + roi);
						pointArray.push({x: mousex, y: mousey});
						//console.log(pointArray.length);
						if(pointArray.length == 5)
						{
							ctx.clearRect(0, 0, canvas.width, canvas.height);
							var img = document.getElementById("monoSpd");
							var tmpImg = new Image();
							tmpImg.src = $('#monoSpd').attr('src');

							ctx.drawImage(img, 0, 0, width, height);
							pointArray = [];


							ctx.fillStyle="red";
							ctx.fillRect(mousex-5, mousey-5, 10,10);
							pointArray.push({x: mousex, y: mousey});
						}else if(pointArray.length == 4)
						{
							console.log("Points Array: " + JSON.stringify(pointArray));
							
							ctx.fillRect(mousex-5, mousey-5, 10,10);
							ctx.beginPath();
							ctx.moveTo(pointArray[2].x, pointArray[2].y);
							ctx.lineTo(pointArray[0].x, pointArray[0].y);
							ctx.lineTo(pointArray[1].x, pointArray[1].y);
							ctx.lineTo(pointArray[3].x, pointArray[3].y);
							ctx.lineTo(pointArray[2].x, pointArray[2].y);
							ctx.stroke();

							for(var i = 0; i < pointArray.length; i++)
							{
								var realX = Math.round(pointArray[i].x * (resx / width));;
								var realY = Math.round(pointArray[i].y * (resy / height));;
								var transformedx = (realX / resx).toFixed(4);
								var transformedy = (realY / resy).toFixed(4);
								pointArray[i].x = (transformedx + "").split(".")[1];
								pointArray[i].y = (transformedy + "").split(".")[1];
							}

							console.log("Percent Array: " + JSON.stringify(pointArray));

							var urlinsert = "update|table=nlcameraspeed|camp0=id|value0=" + data2[0].id + "|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000" + localStorage.getItem("TOKEN");
							urlinsert += "|camp3=reserve|value3=";
							urlinsert += "|camp4=cameraid|value4=1";
							urlinsert += "|camp5=computerid|value5=1";
							urlinsert += "|camp6=lpoint00X|value6=" + pointArray[0].x;   //0
							urlinsert += "|camp7=lpoint00Y|value7=" + pointArray[0].y;   //0
							urlinsert += "|camp8=lpoint01X|value8=" + pointArray[1].x;   //1
							urlinsert += "|camp9=lpoint01Y|value9=" + pointArray[1].y;   //1
							urlinsert += "|camp10=lpoint10X|value10=" + pointArray[2].x; //2
							urlinsert += "|camp11=lpoint10Y|value11=" + pointArray[2].y; //2
							urlinsert += "|camp12=lpoint11X|value12=" + pointArray[3].x; //3
							urlinsert += "|camp13=lpoint11Y|value13=" + pointArray[3].y; //3
							urlinsert += "|camp14=calibrated|value14=1";

							var response = executeCGI(computerid, urlinsert, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

							if(response != "error")
							{
								DevExpress.ui.notify("Data saved", "success", 600);
								sroi = "Speed calibration [(" + pointArray[0].x + "," + pointArray[0].y + ") - (" + pointArray[1].x + "," + pointArray[1].y + ") - (" + pointArray[2].x + "," + pointArray[2].y + ") - (" + pointArray[3].x+ "," + pointArray[3].y + ")]";
								$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);
							}
							else
							{
								DevExpress.ui.notify("Data saving error", "error", 600);
							}
						}else
						{
							ctx.fillStyle="red";
							ctx.fillRect(mousex-5, mousey-5, 10,10);
						}
					});
				}
				////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
				if (item.typepar == "nlcameralane")
				{
					var data2 = executeCGI(computerid, "select|table=nlcameralane|maxvalues=250", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$("#fiedlLANES").append(" <div class='dx-field' id ='LANECANVAS'  ><div id='ResetLan'></div><br><br><img src='./images/LANEGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvaslanes' width='800' height='600' ></canvas><img id = 'monolanes' src=' " + getSnapshot() + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
					$("#ResetLan").dxButton(
					{
						type: "success",
						text: DevExpress.localization.formatMessage("Delete Lanes"),
						onClick: function()
						{
							resetLANES();
						}
					});
					var canvas2 = document.getElementById('canvaslanes');
					var ctx2 = canvas2.getContext('2d');
					var img2 = document.getElementById("monolanes");
					var tmpImg2 = new Image();
					tmpImg2.src = $('#monolanes').attr('src');
					tmpImg2.onload = function()
					{
						ctx2.drawImage(img2, 0, 0, width, height);
						if (data2.length > 0)
						{
							var p0;
							var p1;
							p0 = parseFloat(data2[0].lpoint00X / 10000) * width;
							p1 = parseFloat(data2[0].lpoint01X / 10000) * width;
							ctx2.moveTo(p0, 0);
							ctx2.lineTo(p1, height);
							ctx2.strokeStyle = 'red';
							ctx2.lineWidth = 5;
							ctx2.font = "30px Arial";
							ctx2.fillStyle = "red";
							ctx2.textAlign = "left";
							ctx2.fillText("LANE1", 10, 25);
							ctx2.fillText("LANE2", 690, 25);
							$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + data2[0].lpoint00X + ";" + data2[0].lpoint01X + ";" + data2[0].lpoint01X + ";" + data2[0].lpoint01Y + ")");
						}
						ctx2.stroke();
					};
					//Variables
					var mousex2 = mousey2 = 0;
					var mousedown2 = false;
					//Mousedown
					$(canvas2).on('mousedown', function(e)
					{
						last_mousex2 = e.offsetX;
						last_mousey2 = e.offsetY;
						mousedown2 = true;
					});
					//Mouseup
					$(canvas2).on('mouseup', function(e)
					{
						mousedown2 = false;
						var initpointx,
							initpointy,
							endpointx,
							endpointy;
						var initpointx1,
							initpointy1,
							endpointx1,
							endpointy1;
						mousex2 = e.offsetX;
						mousey2 = e.offsetY;
						initpointx1 = last_mousex2;
						endpointx1 = mousex2;
						initpointy1 = last_mousey2;
						endpointy1 = mousey2;
						if (initpointx1 <= endpointx1)
						{
							initpointx = initpointx1;
							initpointy = initpointy1;
							endpointx = endpointx1;
							endpointy = endpointy1;
						}
						else
						{
							initpointx = endpointx1;
							initpointy = endpointy1;
							endpointx = initpointx1;
							endpointy = initpointy1;
						}
						if ((endpointx - initpointx) == 0)
						{
							return;
						}
						var pendiente = (endpointy - initpointy) / (endpointx - initpointx);
						var b = endpointy - (pendiente * endpointx);
						ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
						ctx2.beginPath();
						var x0 = (-b / pendiente);
						var x1 = (height - b) / pendiente;
						ctx2.moveTo(x0, 0);
						ctx2.lineTo(x1, height);
						ctx2.strokeStyle = 'red';
						ctx2.lineWidth = 5;
						ctx2.stroke();
						var img2 = document.getElementById("monolanes");
						ctx2.drawImage(img2, 0, 0, width, height);
						ctx2.font = "30px Arial";
						ctx2.fillStyle = "red";
						ctx2.textAlign = "left";
						ctx2.fillText("LANE1", 10, 25);
						ctx2.fillText("LANE2", 690, 25);
						ctx2.stroke();
						var pointXReal = Math.round(x0 * (resx / width));
						var endpointXReal = Math.round(x1 * (resx / width));
						var endpointYReal = resy;
						var ltpcx = (pointXReal / resx).toFixed(4);
						var ltpcendx = (endpointXReal / resx).toFixed(4);
						var ltpcendy = (endpointYReal / resy).toFixed(4);
						var ltpcx_dec = ltpcx * 10000
						var ltpcendx_dec = ltpcendx * 10000
						var ltpcendy_dec = ltpcendy * 10000
						var lanestr = (ltpcx_dec + ";0;" + ltpcendx_dec + ";" + ltpcendy_dec);
						$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + lanestr + ")");

						var response = executeCGI(computerid, "delete|table=nlcameralane", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

						if(response != "error")
						{
							var urlinsert = "insert|table=nlcameralane|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000";
							urlinsert += "|camp3=reserve|value3=";
							urlinsert += "|camp4=cameraid|value4=1";
							urlinsert += "|camp5=computerid|value5=1";
							urlinsert += "|camp6=name|value6=LANE1";
							urlinsert += "|camp7=direction|value7=1";
							urlinsert += "|camp8=lpoint00X|value8=" + ltpcx_dec;
							urlinsert += "|camp9=lpoint00Y|value9=0";
							urlinsert += "|camp10=lpoint01X|value10=" + ltpcendx_dec;
							urlinsert += "|camp11=lpoint01Y|value11=" + ltpcendy_dec;
							urlinsert += "|camp12=lpoint10X|value12=0";
							urlinsert += "|camp13=lpoint10Y|value13=0";
							urlinsert += "|camp14=lpoint11X|value14=0";
							urlinsert += "|camp15=lpoint11Y|value15=0";
							urlinsert += "|camp16=occoming|value16=1";
							urlinsert += "|camp17=ocgoing|value17=1";
							urlinsert += "|camp18=enabled|value18=1";

							response = executeCGI(computerid, urlinsert, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

							if(response != "error")
							{
								urlinsert = "insert|table=nlcameralane|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000";
								urlinsert += "|camp3=reserve|value3=";
								urlinsert += "|camp4=cameraid|value4=1";
								urlinsert += "|camp5=computerid|value5=1";
								urlinsert += "|camp6=name|value6=LANE2";
								urlinsert += "|camp7=direction|value7=1";
								urlinsert += "|camp8=lpoint00X|value8=0";
								urlinsert += "|camp9=lpoint00Y|value9=0";
								urlinsert += "|camp10=lpoint01X|value10=0";
								urlinsert += "|camp11=lpoint01Y|value11=0";
								urlinsert += "|camp12=lpoint10X|value12=" + ltpcx_dec;
								urlinsert += "|camp13=lpoint10Y|value13=0";
								urlinsert += "|camp14=lpoint11X|value14=" + ltpcendx_dec;
								urlinsert += "|camp15=lpoint11Y|value15=" + ltpcendy_dec;
								urlinsert += "|camp16=occoming|value16=1";
								urlinsert += "|camp17=ocgoing|value17=1";
								urlinsert += "|camp18=enabled|value18=1";

								response = executeCGI(computerid, urlinsert, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

								if(response != "error")
								{
									DevExpress.ui.notify("Data saved", "success", 600);
								}
							}
						}
						
						if(response == "error")
						{
							DevExpress.ui.notify("Data saving error", "error", 600);
						}
					});
					//Mousemove
					$(canvas2).on('mousemove', function(e)
					{
						mousex2 = e.offsetX;
						mousey2 = e.offsetY;
						if (mousedown2)
						{
							ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
							ctx2.beginPath();
							ctx2.moveTo(last_mousex2, last_mousey2);
							ctx2.lineTo(mousex2, mousey2);
							ctx2.strokeStyle = 'red';
							ctx2.lineWidth = 5;
							ctx2.stroke();
							var img2 = document.getElementById("monolanes");
							ctx2.drawImage(img2, 0, 0, width, height);
							ctx2.stroke();
						}
					});
				}
			}
		});
		
		if (DEFINE_INTERFACE == "ZKTECO")
		{
			$("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
			" <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
			" 		<div id='crossdatagriddiv'></div>" +
			" <div id='crossdetaildiv' > " +
			" 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
			" 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
			" <div class='dx-field' id ='CROSSLINE'  > " +
			"<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
			"<br><br><br><div id='ressetcrossline'></div> " +
			"</div>" +
			"<div class='dx-field-value' style= ' width:auto' >" +
			"<br><canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src=' " + getSnapshot() + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			"</div> " +
			"<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
			"<br><br><br><div id='ressetcrossarea'></div> " +
			"</div>" +
			"<div class='dx-field-value' style='width:auto;margin-top: 0px;' >" +
			"<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src=' " + getSnapshot() + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			"</div> " +
			"</div>" +
			"</div>" +
			"</div>" +
			" </div> ");
		}
		else if ((!DEFINE_INTERFACE.includes("VIVOTEK")) || ((DEFINE_INTERFACE == "VIVOTEK"  || DEFINE_INTERFACE == "VIVOTEK_CV25" || DEFINE_INTERFACE == "HANWHA") && (aplication != "eVivotek")))
		{
			$("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
			" <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
			" 		<div id='crossdatagriddiv'></div>" +
			" <div id='crossdetaildiv' > " +
			" 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
			" 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
			" <div class='dx-field' id ='CROSSLINE'  > " +
			"<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
			"<br> <br><br><br><div id='ressetcrossline'></div> " +
			"</div>" +
			"<div class='dx-field-value' style= ' width:auto' >" +
			"<canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src=' " + getSnapshot() + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			"</div> " +
			"<br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
			"<br> <br><br><br><div id='ressetcrossarea'></div> " +
			"</div>" +
			"<div class='dx-field-value' style='width:auto;margin-top: -125px;' >" +
			"<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src=' " +  getSnapshot() + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			"</div> " +
			"</div>" +
			"</div>" +
			"</div>" +
			" </div> ");
		}
	}

	function configureClickCrossLine()
	{
		$("#fiedlCrossLine").hide();
		$("#crossdetaildiv").hide();
		$("#CrossLine").click(function()
		{
			if ($("#CrossLine").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedlCrossLine").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedlCrossLine").show();
			}
		});
		$("#crossdet").click(function()
		{
			if ($("#crossdet").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedlcrossdetails").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedlcrossdetails").show();
			}
		});
	}

	function createCrossDataGrid()
	{
		crossdatagrid = $("#crossdatagriddiv").dxDataGrid(
		{
			dataSource: cross_lista,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			paging:
			{
				pageSize: 10
			},
			searchPanel:
			{
				visible: true,
				width: 240,
			},
			columns: [
				{
					dataField: "id",
					caption: DevExpress.localization.formatMessage("ID"),
					width: 50,
					allowEditing: false
				},
				{
					width: "30%",
					dataField: "name",
					caption: DevExpress.localization.formatMessage("Name"),
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					width: "15%",
					dataField: "triggermode",
					caption: DevExpress.localization.formatMessage("Mode"),
					validationRules: [
					{
						type: "required"
					}],
					lookup:
					{
						dataSource: [
							DevExpress.localization.formatMessage("Entering"),
							DevExpress.localization.formatMessage("Leaving"),
							DevExpress.localization.formatMessage("Both")
						]
					}
				},
				{
					dataField: "pixelchange",
					caption: DevExpress.localization.formatMessage("Pixel Change"),
					dataType: "number",
					width: "10%",
					format:
					{
						type: "decimal",
						precision: 0
					},
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					dataField: "minchangepc",
					caption: DevExpress.localization.formatMessage("Min. change pc"),
					dataType: "number",
					width: "10%",
					format:
					{
						type: "decimal",
						precision: 0
					},
					validationRules: [
					{
						type: "required"
					}]
				}
			],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the cross line?")
				},
				allowAdding: true
			},
			selection:
			{
				mode: "single"
			},
			onSelectionChanged: function(selectedItems)
			{
				var data = selectedItems.selectedRowsData[0];
				if (data)
				{
					$("#crossdetaildiv").show();
					crosslineediting = data.id;
					loadcrosslinedetails(data.id);
				}
			},
			onRowUpdating: function(e)
			{
				var description;
				if (typeof e.newData.name !== 'undefined')
				{
					description = e.newData.name.replaceAll('"', '').replaceAll('\'', '');
				}
				else
				{
					description = e.oldData.name.replaceAll('"', '').replaceAll('\'', '');
				}
				var pixelchange;
				if (typeof e.newData.pixelchange !== 'undefined')
				{
					pixelchange = e.newData.pixelchange;
				}
				else
				{
					pixelchange = e.oldData.pixelchange;
				}
				
				var triggermode;
				if (typeof e.newData.triggermode !== 'undefined')
				{
					triggermode = convertTriggermodeToInt(e.newData.triggermode);
				}
				else
				{
					triggermode = convertTriggermodeToInt(e.oldData.triggermode);
				}
				var minchangepc;
				if (typeof e.newData.minchangepc !== 'undefined')
				{
					minchangepc = e.newData.minchangepc;
				}
				else
				{
					minchangepc = e.oldData.minchangepc;
				}

				var urlUpdate = "update|table=nlcrossline|camp0=id|value0=" + e.key +
				"|camp1=name|value1=" + description +
				"|camp2=computerid|value2=1" +
				"|camp3=cameraid|value3=1" +
				"|camp4=pixelchange|value4=" + pixelchange +
				"|camp5=triggermode|value5=" + triggermode +
				"|camp6=minchangepc|value6=" + minchangepc;
				
				response = executeCGI(computerid, urlUpdate, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

				if(response != "error")
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				}
				else
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				}
			},
			onRowInserting: function(e)
			{
				var triggermode = convertTriggermodeToInt(e.data.triggermode);
				executeCGIAsync(computerid, "insertcross|name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '') + "|triggermode=" + triggermode + "|pixelchange=" + e.data.pixelchange + "|minchangepc=" + e.data.minchangep, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false, loadcrossline);
				var response = getAsyncResponse();
				if(response != "error")
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				}
			},
			onRowRemoving: function(e)
			{
				executeCGI(computerid, "delete|table=nlcrossline|camp0=id|comp0=equal|value0=" + e.key, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

				loadcrossline();
				$("#crossdetaildiv").hide();
			}
		}).dxDataGrid("instance");

		return crossdatagrid;
	}

	function createResetCrossLineButton()
	{
		$("#ressetcrossline").dxButton(
		{
			type: "success",
			text: DevExpress.localization.formatMessage("Delete line"),
			onClick: function()
			{
				resetLaneCross();
			}
		});
	}

	function createResetCrossAreaButton()
	{
		$("#ressetcrossarea").dxButton(
		{
			type: "success",
			text: DevExpress.localization.formatMessage("Delete area"),
			onClick: function()
			{
				resetLaneArea();
			}
		});
	}

	function configureCanvasCrossLine()
	{
		loadcrossline();
		var canvas2 = document.getElementById('canvascrossline');
		var ctx2 = canvas2.getContext('2d');
		var last_mousex2 = last_mousey2 = 0;
		var mousex2 = mousey2 = 0;
		var mousedown2 = false;
		//Mousedown
		$(canvas2).on('mousedown', function(e)
		{
			last_mousex2 = e.offsetX;
			last_mousey2 = e.offsetY;
			mousedown2 = true;
		});
		//Mouseup
		$(canvas2).on('mouseup', function(e)
		{
			mousedown2 = false;
			var initpointx,
				initpointy,
				endpointx,
				endpointy;
			var initpointx1,
				initpointy1,
				endpointx1,
				endpointy1;
			mousex2 = e.offsetX;
			mousey2 = e.offsetY;
			initpointx1 = last_mousex2;
			endpointx1 = mousex2;
			initpointy1 = last_mousey2;
			endpointy1 = mousey2;
			initpointx = initpointx1;
			endpointx = endpointx1;
			initpointy = initpointy1;
			endpointy = endpointy1;
			
			if ((endpointx - initpointx) == 0 || (endpointy - initpointy) == 0)
			{
				return;
			}

			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			var img2 = document.getElementById("crosslineimg");
			ctx2.drawImage(img2, 0, 0, width, height);
			ctx2.moveTo(initpointx, last_mousey2);
			ctx2.lineTo(endpointx, mousey2);
			ctx2.strokeStyle = 'red';
			ctx2.lineWidth = 5;
			ctx2.stroke();
			var pointXReal = Math.round(last_mousex2 * (resx / width));
			var pointYReal = Math.round(last_mousey2 * (resy / height));
			var endpointXReal = Math.round(endpointx * (resx / width));
			var endpointYReal = Math.round(endpointy * (resy / height));;
			var ltpcx = (pointXReal / resx).toFixed(4);
			var ltpcy = (pointYReal / resy).toFixed(4);
			var ltpcendx = (endpointXReal / resx).toFixed(4);
			var ltpcendy = (endpointYReal / resy).toFixed(4);

			var response = executeCGI(computerid, "update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=lineY0|value1=" + ltpcy + "|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=lineX0|value4=" + ltpcx + "|camp5=lineY1|value5=" + ltpcendy + "|camp6=lineX1|value6=" + ltpcendx, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

			if(response != "error")
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			}
			else
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			}

			actdict["cross" + crosslineediting].lineY0 = ltpcy;
			actdict["cross" + crosslineediting].lineX0 = ltpcx;
			actdict["cross" + crosslineediting].lineY1 = ltpcendy;
			actdict["cross" + crosslineediting].lineX1 = ltpcendx;
		});
		//Mousemove
		$(canvas2).on('mousemove', function(e)
		{
			mousex2 = e.offsetX;
			mousey2 = e.offsetY;
			if (mousedown2)
			{
				ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
				ctx2.beginPath();
				ctx2.moveTo(last_mousex2, last_mousey2);
				ctx2.lineTo(mousex2, mousey2);
				ctx2.strokeStyle = 'red';
				ctx2.lineWidth = 5;
				ctx2.stroke();
				var img2 = document.getElementById("crosslineimg");
				ctx2.drawImage(img2, 0, 0, width, height);
				ctx2.stroke();
			}
		});
	}

	function configureCanvasCrossArea()
	{
		var canvas = document.getElementById('canvascrossarea');
		var ctx = canvas.getContext('2d');
		var last_mousex = last_mousey = 0;
		var mousex = mousey = 0;
		var mousedown = false;
		//Mousedown
		$(canvas).on('mousedown', function(e)
		{
			last_mousex = e.offsetX;
			last_mousey = e.offsetY;
			mousedown = true;
		});
		//Mouseup
		$(canvas).on('mouseup', function(e)
		{
			mousedown = false;
			var initpointx,
				initpointy,
				endpointx,
				endpointy;
			mousex = e.offsetX;
			mousey = e.offsetY;
			if (mousex > last_mousex)
			{
				initpointx = last_mousex;
				endpointx = mousex;
			}
			else
			{
				initpointx = mousex;
				endpointx = last_mousex;
			}
			if (mousey > last_mousey)
			{
				initpointy = last_mousey;
				endpointy = mousey;
			}
			else
			{
				initpointy = mousey;
				endpointy = last_mousey;
			}
			var pointXReal = Math.round(initpointx * (resx / width));
			var pointYReal = Math.round(initpointy * (resy / height));
			var endpointXReal = Math.round(endpointx * (resx / width));
			var endpointYReal = Math.round(endpointy * (resy / height));
			if (pointXReal == endpointXReal || pointYReal == endpointYReal)
			{
				return;
			}
			if (pointXReal < 0)
			{
				pointXReal = 0;
			}
			if (pointYReal < 0)
			{
				pointYReal = 0;
			}
			var tpcx = (pointXReal / resx).toFixed(4);
			var tpcy = (pointYReal / resy).toFixed(4);
			var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
			var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);

			var response = executeCGI(computerid, "update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=roi1|value1=" + tpcx + "|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=roi2|value4=" + tpcy + "|camp5=roi3|value5=" + tpcwidth + "|camp6=roi4|value6=" + tpcheigth, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

			if(response != "error")
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			}
			else
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			}

			actdict["cross" + crosslineediting].roi1 = tpcx;
			actdict["cross" + crosslineediting].roi2 = tpcy;
			actdict["cross" + crosslineediting].roi3 = tpcwidth;
			actdict["cross" + crosslineediting].roi4 = tpcheigth;
		});
		//Mousemove
		$(canvas).on('mousemove', function(e)
		{
			mousex = e.offsetX;
			mousey = e.offsetY;
			if (mousedown)
			{
				ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
				ctx.beginPath();
				var width_area = mousex - last_mousex;
				var height_area = mousey - last_mousey;
				ctx.rect(last_mousex, last_mousey, width_area, height_area);
				ctx.strokeStyle = 'red';
				ctx.lineWidth = 5;
				ctx.stroke();
				var img = document.getElementById("crossareaimg");
				ctx.drawImage(img, 0, 0, width, height);
				ctx.stroke();
			}
		});
	}
	
	function configureCanvasCross()
	{
		if ((!DEFINE_INTERFACE.includes("VIVOTEK")) || ((DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25") && (aplication != "eVivotek")) || (DEFINE_INTERFACE == "HANWHA"))
		{
			configureCanvasCrossLine();
			configureCanvasCrossArea();
		}
	}

	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};
	
	String.prototype.insert = function(index, string)
	{
		if (index > 0)
			return this.substring(0, index) + string + this.substring(index, this.length);
		return string + this;
	};

	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}

	var resx = 0;
	var resy = 0;
	var dict = {};
	var multioptdict = {};
	var ident = 0;
	var selected_region = 0;
	var countriesds;
	var cross_lista;
	var crossdatagrid;
	var crosslineediting = -1;
	var actdict = {};
	var resolutions;
	var freeflowOptions = [false,false,false];
	var enableAngleFilter = false;
	var angleFilterElem;
	var enableBestResult = false;
	var bestResultElem;									
	var aplication;
	var loadPanel;
	var freeflowElem;
	var width = 800;
	var height = 600;
	
	Init_translate();

	make_header("camconfiguration");

	set_rcpopup();

	set_uppopup();

	configureWebIcon();

	loadPanel = getLoadingPanel(getRestartingMessage());

	var regiondsrc = getDataSourceRegions();

	locationsds = getDataSourceLocations();

	ident = getIdent();

	createRestartButton("#restartserv", loadPanel);

	createRestartDefaultConfigurationButton();

	createCamConfigurationFields();

	configureClickCrossLine();

	crossdatagrid = createCrossDataGrid();

	configureCanvasCross();

	createResetCrossLineButton();

	createResetCrossAreaButton();
});
