////////////////////////////////
// GENERAL CONFIGURATION PAGE //
////////////////////////////////


$(function()
{

	function disabledPurgeOptions(i, value)
	{
		if (value == "DISABLED") //quitar para volver a habilitar el action time -> expert options
		{
			$("#elem" + (i-1)).dxRadioGroup("instance").option("disabled", true);
			$("#elem" + (i+1)).dxNumberBox("instance").option("disabled", true);
			$("#elem" + (i+2)).dxNumberBox("instance").option("disabled", true);
			$("#elem" + (i+3)).dxNumberBox("instance").option("disabled", true);
		}
		else if (value == "DAYS")
		{
			$("#elem" + (i-1)).dxRadioGroup("instance").option("disabled", false);
			$("#elem" + (i+1)).dxNumberBox("instance").option("disabled", false);
			$("#elem" + (i+2)).dxNumberBox("instance").option("disabled", true);
			$("#elem" + (i+3)).dxNumberBox("instance").option("disabled", true);
		}
		else if (value == "FREESPACE")
		{
			$("#elem" + (i-1)).dxRadioGroup("instance").option("disabled", false);
			$("#elem" + (i+1)).dxNumberBox("instance").option("disabled", true);
			$("#elem" + (i+2)).dxNumberBox("instance").option("disabled", false);
			$("#elem" + (i+3)).dxNumberBox("instance").option("disabled", false);
		}
	}

	function isEmptyCustomOptions()
	{
		var numberOfOptions = 0;
		$.ajax(
			{
				async: false,
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=count&table=nlconfcustom&dd=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
	
				success: function(data)
				{
					CheckTokenValidity(data);
					numberOfOptions = data;
				}
			});
	
			return (numberOfOptions == 0);
	}
	
	function checkExportCCButton()
	{
		if(isEmptyCustomOptions() == true)
		{
			$("#ExportCC").dxButton("instance").option("disabled", true);
		}
		else
		{
			$("#ExportCC").dxButton("instance").option("disabled", false);
		}
	}
	
	function getNumberOfCustomOps()
	{
		var numberOfTotalCustomOps;
		$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=count&table=nlconfcustom&maxvalues=8&dd=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					CheckTokenValidity(data);
					totalCustomOps = data;
					numberOfTotalCustomOps = totalCustomOps;
				}
			});
		
			return numberOfTotalCustomOps;
	}
	
	function getRegion()
	{
		return executeCGI(computerid, "select|table=nlregion|maxvalues=250", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	}

	function getIdent()
	{
		return executeCGI(computerid, "getident", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	}

	
	function createRestartDefaultButton()
	{
		$("#restartdefault").dxButton(
		{
			type: "default",
			text: DevExpress.localization.formatMessage("Restart default configuration"),
			onClick: function()
			{
				var result = DevExpress.ui.dialog.confirm(DevExpress.localization.formatMessage("Are you sure to restart default configuration?"), DevExpress.localization.formatMessage("Default configuration"));
				result.done(function(dialogResult)
				{
					if (dialogResult)
					{
						var dataValue = executeCGI(computerid, "defaultgeneralconfig", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
						location.reload();
					}
				});
			}
		});
	}

	function createRegionsDataSource()
	{
		var data = new DevExpress.data.DataSource(
		{
			store: regions,
			key: "id",
		});
		return data;
	}

	function createUpdateButton()
		{
			$("#Updatebutton").dxFileUploader(
			{
				accept: "*.*",
				multiple: false,
				value: [],
				uploadMode: "instantly",
				selectButtonText: DevExpress.localization.formatMessage("Upload file"),
				labelText: DevExpress.localization.formatMessage("or Drop import files here"),
				chunkSize: 200000,
				uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=uploadfileblob" + localStorage.getItem("TOKEN"),
				onUploadError: function(e)
				{
					DevExpress.ui.notify("Error uploading file", "error", 1000);
				}
			});
	}

	function createResetdbButton()
	{
		$("#resetdb").dxButton(
		{
			text: DevExpress.localization.formatMessage("Reset the database"),
			onClick: function()
			{
				var myDialog = DevExpress.ui.dialog.custom(
				{
					title: DevExpress.localization.formatMessage("Reset the database"),
					dragEnabled: false,
					showTitle: true,
					message: DevExpress.localization.formatMessage("CLEARDB") + "<br><br>" + DevExpress.localization.formatMessage("Password:") + "<input type='password' id='fname' name='fname' >",
					buttons: [
					{
						text: DevExpress.localization.formatMessage("Yes"),
						onClick: function(e)
						{
							var macname = $("#fname").val();
							if (macname == "")
							{
								DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("PASS EMPTY"));
							}
							else
							{
								return {
									buttonText: "YES",
									MAC: macname
								}
							}
						}
					},
					{
						text: DevExpress.localization.formatMessage("No"),
						onClick: function(e)
						{
							return {
								buttonText: "CANCEL",
								MAC: ""
							}
						}
					}]
				});
				myDialog.show().done(customdiag);
			}
		});
	}

	function createResetCounterButton()
	{
		$("#resetcounters").dxButton(
		{
			text: DevExpress.localization.formatMessage("Reset Counters"),
			onClick: function()
			{
				var myDialogCT = DevExpress.ui.dialog.custom(
				{
					title: DevExpress.localization.formatMessage("Reset Counters"),
					dragEnabled: false,
					showTitle: true,
					message: DevExpress.localization.formatMessage("CLEARCT") + "<br><br>" + DevExpress.localization.formatMessage("Password:") + "<input type='password' id='fnamect' name='fname' >",
					buttons: [
					{
						text: DevExpress.localization.formatMessage("Yes"),
						onClick: function(e)
						{
							var macname = $("#fnamect").val();
							if (macname == "")
							{
								DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("PASS EMPTY"));
							}
							else
							{
								return {
									buttonText: "YES",
									MAC: macname
								}
							}
						}
					},
					{
						text: DevExpress.localization.formatMessage("No"),
						onClick: function(e)
						{
							return {
								buttonText: "CANCEL",
								MAC: ""
							}
						}
					}]
				});
				myDialogCT.show().done(customdiagCT);
			}
		});
	}

	function createInfoCamButton()
	{
		$("#infocam").dxButton(
		{
			text: DevExpress.localization.formatMessage("Show info"),
			onClick: function()
			{

				var data = executeCGI(computerid, "getinfo", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				$("#popupContainer").append(data.replace(/(?:\r\n|\r|\n)/g, '<br>'));
				var poup = $("#popupContainer").dxPopup(
				{
					showTitle: true,
					title: "Information",
					visible: true,
					maxWidth: 500,
					maxHeight: 250,
					loseOnOutsideClick: true
				});
			}
		});
	}

	function createRecoveryButton()
	{
		$("#recovery").dxButton(
		{
			text: DevExpress.localization.formatMessage("Revert last files"),
			onClick: function()
			{
				var data = executeCGI(computerid, "getinfo", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				if(data != "error")
				{
					DevExpress.ui.notify("Revert last files ok", "success", 600);
				}
			}
		});
	}
	
	function createExportButton()
	{
		$("#ExportCC").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export to CSV file"),
			disabled: isEmptyCustomOptions(),
			onClick: function()
			{
				window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportcustomconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});
	}

	function createImportCustomizedButton()
	{
		var importbutton = $("#ImportCC").dxFileUploader(
		{
			accept: "*.csv",
			multiple: false,
			value: [],
			width: "50%",
			uploadMode: "instantly",
			selectButtonText: DevExpress.localization.formatMessage("Select import CSV file"),
			labelText: DevExpress.localization.formatMessage("or Drop import CSV file here"),
			invalidFileExtensionMessage: "File type is not allowed",
			allowedFileExtensions: [".CSV"],
			chunkSize: 200000,
			uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importcustomconfig" + localStorage.getItem("TOKEN"),
			showFileList: false,
			onUploaded: function(data)
			{
				loadPanel.hide();
				DevExpress.ui.notify(data.request.responseText, "success", 1500);
				loadlists(true);
				var currentNumberOfCustomOpsInBBDD = getNumberOfCustomOps();
				if (currentNumberOfCustomOpsInBBDD != currentNumberOfCustomOps)
				{
					currentNumberOfCustomOps = getNumberOfCustomOps();
				}
				if(currentNumberOfCustomOpsInBBDD == MAX_TOTAL_CUSTOM_OPTIONS)
				{
					var dxDataGrid = $("#gridContainer").dxDataGrid("instance");
					var addButton = dxDataGrid.element().find(".dx-datagrid-addrow-button");
					addButton.hide();
					addButton.on("click", function(event) {
						event.stopPropagation();
					});
				}
			},
			onUploadError: function(e)
			{
				loadPanel.hide();
				DevExpress.ui.notify("Error uploading file", "error", 1000);
			},
			onUploadStarted: function(e)
			{
				loadPanel.show();
			}
		}).dxFileUploader("instance");

		return importbutton;
	}	

	function createDConfigButton()
	{
		$("#dconfig").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export general config"),
			onClick: function()
			{
				window.location = getUrlCgi() + "computerid=" + computerid + "&oper=exportgeneralconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});	
	}

	function createExportDBButton()
	{
		$("#exportdb").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export database"),
			onClick: function()
			{
				window.location = getUrlCgi() + "computerid=" + computerid + "&oper=exportdatabase&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});	
	}	

	function createImportGeneralButton()
	{
		var importbutton = $("#uconfig").dxFileUploader(
		{
			accept: "*.csv",
			multiple: false,
			value: [],
			width: "50%",
			uploadMode: "instantly",
			selectButtonText: DevExpress.localization.formatMessage("Import CSV general config file"),
			labelText: DevExpress.localization.formatMessage("or Drop import CSV general config file here"),
			invalidFileExtensionMessage: "File type is not allowed",
			allowedFileExtensions: [".CSV"],
			chunkSize: 200000,
			uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importgeneralconfig" + localStorage.getItem("TOKEN"),
			showFileList: false,
			onUploaded: function(data)
			{
				loadPanel.hide();
				DevExpress.ui.notify(data.request.responseText, "success", 2000);
				location.reload();
				loadPanel.show();
				lp = loadPanel;
				restartapp();
			},
			onUploadError: function(e)
			{
				loadPanel.hide();
				DevExpress.ui.notify("Error uploading file", "error", 1000);
			},
			onUploadStarted: function(e)
			{
				loadPanel.show();
			}
		}).dxFileUploader("instance");
		return importbutton;
	}

	function createExportVparConfButton()
	{
		$("#exportvparcfg").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export VPAR config"),
			onClick: function()
			{
				window.location = getUrlCgi() + "computerid=" + computerid + "&oper=exportvparcfg&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});
	}

	function createGridContainer()
	{
		var vlists = $("#gridContainer").dxDataGrid(
			{
				dataSource: listas,
				showBorders: true,
				showRowLines: true,
				keyExpr: "id",
				hoverStateEnabled: true,
				paging:
				{
					pageSize: 10
				},
				searchPanel:
				{
					visible: true,
					width: 240,
					placeholder: DevExpress.localization.formatMessage("Search...")
				},
				pager:
				{
					showPageSizeSelector: true,
					allowedPageSizes: [5, 10, 20],
					showInfo: true
				},
				columns: [
				{
					dataField: "id",
					caption: DevExpress.localization.formatMessage("ID"),
					width: 50,
					allowEditing: false
				},
				{
					dataField: "name",
					caption: DevExpress.localization.formatMessage("Name"),
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					dataField: "svalue",
					caption: DevExpress.localization.formatMessage("Value"),
					validationRules: [
					{
						type: "required"
					}]
				}],
				editing:
				{
					mode: "row",
					allowUpdating: true,
					allowDeleting: true,
					texts:
					{
						confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the element?")
					},
					allowAdding: true
				},
				paging: 
				{
					enabled: false  // Deshabilitar la paginación
				},
				pager: 
				{
					visible: false  // Ocultar la barra de paginación
				},
				paging: 
				{
					pageSize: 10  // Mostrar solo 10 elementos por página
				},
				selection:
				{
					mode: "single"
				},
				onToolbarPreparing: function(e)
				{
					let toolbarItemsCustomOps = e.toolbarOptions.items;
					toolbarItemsCustomOps.forEach(function(item)
					{
						if (item.name === "addRowButton")
						{
							item.visible = showaddrowCustomOps;
						}
					});
				},
				onSelectionChanged: function(selectedItems)
				{
					var data = selectedItems.selectedRowsData[0];
					if (data)
					{}
				},
				onRowUpdating: function(e)
				{
					var name;
					var svalue;
					if (typeof e.newData.name !== 'undefined')
					{
						name = e.newData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
						var newlength = e.newData.name.length;
						while (e.newData.name.match(/^\d/))
						{
							name = e.newData.name.replace(/^\d/, '');
							e.newData.name = name;
						}
						if (e.newData.name.length == 0)
						{
							DevExpress.ui.notify(DevExpress.localization.formatMessage("Name cannot be only numbers"), "error", 1500);
							name = e.oldData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
							e.newData.name = name;
						}
						else
						{
							if (e.newData.name.length != newlength)
							{
								DevExpress.ui.notify(DevExpress.localization.formatMessage("Numbers at the beginning of Name have been removed"), "info", 1500);
							}
						}
					}
					else
					{
						name = e.oldData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					if (typeof e.newData.svalue !== 'undefined')
					{
						svalue = e.newData.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					else
					{
						svalue = e.oldData.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					
					var jqxhr = $.ajax(
					{
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcustom&camp0=id&value0=" + e.oldData.id + "&camp1=name&value1=" + name + "&camp2=svalue&value2=" + svalue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						success: function(data)
						{
							CheckTokenValidity(data);
							checkExportCCButton();
						}
					});
				},
				onRowInserted: function(e)
				{
					currentNumberOfCustomOps++;
					var currentNumberOfCustomOpsInBBDD = getNumberOfCustomOps();
					
					if (currentNumberOfCustomOpsInBBDD != currentNumberOfCustomOps)
					{
						currentNumberOfCustomOps = getNumberOfCustomOps();
					}
					if(currentNumberOfCustomOps == MAX_TOTAL_CUSTOM_OPTIONS)
					{
						e.element.find(".dx-datagrid-addrow-button").hide();
					}
				},
				onRowInserting: function(e)
				{
					var name;
					var newlength = e.data.name.length;
					while (e.data.name.match(/^\d/))
					{
						name = e.data.name.replace(/^\d/, '');
						e.data.name = name;
					}
					if (e.data.name.length == 0)
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Name cannot be only numbers"), "error", 1500);
					}
					else
					{
						if (e.data.name.length != newlength)
						{
							DevExpress.ui.notify(DevExpress.localization.formatMessage("Numbers at the beginning of Name have been removed"), "info", 1500);
						}
					}

					executeCGIAsync(computerid, "insertconfcustom|name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '') + "|svalue=" + e.data.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', ''), getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false, loadlists);
					var response = getAsyncResponse();
					
					if(response != "error")
					{
						if(response.indexOf("Max elems") == -1)
						{
							DevExpress.ui.notify("List added succesfully", "success", 1000);
						}
						else
						{
							DevExpress.ui.notify("Maximum number of lists limited to" + response.substr(10), "error", 1000);
							e.element.find(".dx-datagrid-addrow-button").hide();
						}
					}
				},
				onRowRemoving: function(e)
				{
					var dataRemoved = executeCGI(computerid, "delete|table=nlconfcustom|camp0=id|comp0=equal|value0=" + e.key, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
					if (dataRemoved != "error")
					{
						checkExportCCButton();
						currentNumberOfCustomOps--;
						showaddrowCustomOps = true;
						e.element.find(".dx-datagrid-addrow-button").show();
						var repaint = $("#gridContainer").dxDataGrid("repaint");
					}
				}
			}).dxDataGrid("instance");
		return vlists;
	}

	function createAllField()
	{
		var data = executeCGI (computerid, "select|table=nlconfgeneral|maxvalues=50", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	
		//First bucle to create checkbox and div
		$.each(data, function(i, item)
		{
			if (item.grouppar != "")
			{
				if (typeof dict[item.grouppar] === "undefined")
				{
					item.indexg = i;
					dict[item.grouppar] = i;
					var toadd = "<div class='dx-fieldset-header cerrado' id='group" + i + "' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage(item.grouppar) + "</div> ";
					toadd += "<div class='dx-fieldset' id= 'fiedl" + i + "'  ></div>";
					$(".content_wrapper").append(toadd);
					$("#fiedl" + i).hide();
					$("#group" + i).click(function()
					{
						if ($("#group" + i).hasClass("abierto"))
						{
							$(this).removeClass('abierto');
							$(this).addClass('cerrado');
							$("#fiedl" + i).hide();
							listplatesabierto = false;
						}
						else
						{
							$(this).addClass('abierto');
							$(this).removeClass('cerrado');
							$("#fiedl" + i).show();
							listplatesabierto = true;
						}
					});
				}
				else
				{
					item.indexg = dict[item.grouppar];
				}
			}
			else
			{
				item.indexg = -1;
			}
		});
		$.each(data, function(i, item)
		{
			if (item.visible == 1)
			{
				if (item.typepar == "int")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;' ></div></div></div>");
					var valopt = (item.options).split(";");
					$("#elem" + i).dxNumberBox(
					{
						value: item.value,
						min: valopt[0],
						max: valopt[1],
						showSpinButtons: true,
						onInitialized: function(e)
						{
							if (enableLogServer == true)
							{
								$(elemLogServerPort).dxNumberBox("option", "disabled", false);
							}
							else
							{
								$(elemLogServerPort).dxNumberBox("option", "disabled", true);
							}
							
						},
						onValueChanged: function(e)
						{
							var previousValue = e.previousValue;
							var newValue = e.value;
							if(Number.isInteger(parseInt(newValue)))
							{
								// Event handling commands go here
								updateTableValue("nlconfgeneral", item.id, "value", newValue + "|camp2=computerid|value2=" + item.computerid);
							}
							else
							{
								DevExpress.ui.notify("Element is not an integer", "error", 600);
							}
						}
					});
				}
				if (item.typepar == "bool")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					var options_disabled = false;
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
					var isTrueSet = (item.value == 'true');
					$("#elem" + i).dxCheckBox(
					{
						value: isTrueSet,
						disabled: options_disabled,
						onInitialized:function(e)
							{
								if(item.id == 24)
								{
									enableLogServer = e.component.option("value");
									elemLogServerHost = "#elem" + (i + 1);
									elemLogServerPort = "#elem" + (i + 2);
								}
							},
						onValueChanged: function(e)
						{
							var previousValue = e.previousValue;
							var newValue = e.value;
							if (item.id == 24)
							{
								elemLogServerHost = "#elem" + (i + 1);
								elemLogServerPort = "#elem" + (i + 2);
								if (newValue == true)
								{
									$(elemLogServerHost).dxTextBox("option", "disabled", false);
									$(elemLogServerPort).dxNumberBox("option", "disabled", false);
									enableLogServer = true;
								}
								else
								{
									$(elemLogServerHost).dxTextBox("option", "disabled", true);
									$(elemLogServerPort).dxNumberBox("option", "disabled", true);
									enableLogServer = false;
								}
							}
							// Event handling commands go here
							updateTableValue("nlconfgeneral", item.id, "value", newValue + "|camp2=computerid|value2=" + item.computerid);
						}
					});
				}
				if (item.typepar == "info")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).prepend(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
					var heightpop = 350;
					var widthpop = 500;
					if (item.help == "infopurgegeneral.html" || item.help == "infoexpertgeneral.html" || item.help == "infologgeneralserver.html" || item.help == "infologgeneralserver-CV25.html" || item.help == "infologgeneral.html" || item.help == "infologgeneral-CV25.html")
					{
						heightpop = 650;
					}
					$("#elem" + i).dxButton(
					{
						icon: "help",
						type: "success",
						mode: "contained",
						onClick: function(e)
						{
							var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
								.done(function(data)
								{
									$("#popupinfo" + i).append(data);
									var poup = $("#popupinfo" + i).dxPopup(
									{
										showTitle: true,
										title: DevExpress.localization.formatMessage("Help"),
										visible: true,
										maxWidth: widthpop,
										maxHeight: heightpop,
										loseOnOutsideClick: true
									});
								});
						}
					});
				}
				if (item.typepar == "string")
				{
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;width:197.2px'></div></div></div>");
					var passmode = "Text";
					if (item.text == "Password:") passmode = "password";
					$("#elem" + i).dxTextBox(
					{
						value: item.value,
						mode: passmode,
						onInitialized: function(e)
						{
							if (enableLogServer == true)
							{
								$(elemLogServerHost).dxTextBox("option", "disabled", false);
							}
							else
							{
								$(elemLogServerHost).dxTextBox("option", "disabled", true);
							}
						},
						onValueChanged: function(e)
						{
							var previousValue = e.previousValue;
							var newValue = e.value;
							newValue = newValue.replace(/\\/g, '/');
							// Event handling commands go here
							updateTableValue("nlconfgeneral", item.id, "value", encodeURIComponent(newValue) + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid );
						}
					});
				}
				if (item.typepar == "multioption")
				{
					var normalexper = "";
					var indicef = 0;
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value' id='multioption" + i + "'></div></div>");
					var valopt = (item.options).split(";");
					valopt.forEach(function(element)
					{
						dicttraduccionesMulti[DevExpress.localization.formatMessage(element)] = element;
					});
					console.log("Test dic: " + JSON.stringify(dicttraduccionesMulti));
					var valvalue = (item.value).split(";");
					var options_disabled = false;
					if (item.name == "trigger_io_type") //disable trigger options
					{
						options_disabled = true;
					}
					multioptdict["multioption" + i] = [];
					$.each(valvalue, function(k, itemvalue)
					{
						multioptdict["multioption" + i].push(dicttraduccionesMulti[DevExpress.localization.formatMessage(itemvalue)]);
					});
					$.each(valopt, function(j, itemoptions)
					{
						$("#multioption" + i).append("<div id='elem" + i + "-" + j + "' style='float: left;margin-right: 10px;' ></div>");
						$("#elem" + i + "-" + j).dxCheckBox(
						{
							value: item.value.includes(itemoptions),
							text: DevExpress.localization.formatMessage(itemoptions),
							disabled: options_disabled,
							onValueChanged: function(e)
							{
								var newValue= e.value;
								if (newValue)
								{
									multioptdict["multioption" + i].push(dicttraduccionesMulti[e.element[0].textContent]);
								}
								else
								{
									var index = multioptdict["multioption" + i].indexOf(dicttraduccionesMulti[e.element[0].textContent]);
									if (index > -1)
									{
										multioptdict["multioption" + i].splice(index, 1);
									}
								}
								updateTableValue("nlconfgeneral", item.id, "value", multioptdict["multioption" + i].toString().replace(/,/g, ';') + "|camp2=computerid|value2=" + item.computerid);
							}
						});
					});
				}
				if (item.typepar == "option")
				{
					var valopt = (item.options).split(";");
					var indicef = 0;
					valopt.forEach(function(element)
					{
						dicttraducciones[DevExpress.localization.formatMessage(element)] = element;
						valopt[indicef] = DevExpress.localization.formatMessage(element);
						indicef++;
					});
					var normalexper = "";
					if (item.indexg == -1)
					{
						normalexper = "#field";
					}
					else
					{
						normalexper = "#fiedl" + item.indexg;
					}
					var helpdiv = "";
					if (item.help != "")
					{
						helpdiv = "<div id='icon" + i + "'></div><div id='popup" + i + "' style='display:none' ></div> ";
					}
					$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
					if (item.help == "help_purge_type.html")
					{
						mh = 300;
						mw = 600;
					}
					if (item.help != "")
					{
						$("#icon" + i).dxButton(
						{
							icon: "help",
							type: "success",
							mode: "contained",
							onClick: function(e)
							{
								var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
									.done(function(data)
									{
										$("#popup" + i).append(data);
										var poup = $("#popup" + i).dxPopup(
										{
											showTitle: true,
											title: DevExpress.localization.formatMessage("Help"),
											visible: true,
											maxWidth: mw,
											maxHeight: mh,
											loseOnOutsideClick: true
										});
									});
							}
						});
					}
					var isTrueSet = (item.value == 'true');
					var options_disabled = false;
					
					/*if (item.value == "PERSISTENT") //quitar para volver a habilitar el action time -> expert options
					{
						options_disabled = true;
					}*/
					$("#elem" + i).dxRadioGroup(
					{
						items: valopt,
						value: DevExpress.localization.formatMessage(item.value),
						disabled: options_disabled, //quitar para volver a habilitar el action time -> expert options
						layout: "horizontal",
						onValueChanged: function(e)
						{
							var previousValue = e.previousValue;
							var newValue = dicttraducciones[e.value];
							if(item.id == 41)
							{
								disabledPurgeOptions(i, newValue);
							}
							// Event handling commands go here
							updateTableValue("nlconfgeneral", item.id, "value", newValue + "|camp2=computerid|value2=" + item.computerid);
						}
					});
				}
			}
		});
		$.each(data, function(i, item)
		{
			for (var key in item) 
			{
				var disableValue = item[key];
				if ((disableValue == "DISABLED") || (disableValue == "DAYS") || (disableValue == "FREESPACE"))
				{
					disabledPurgeOptions(i, disableValue);
				}
			}
		});

		var toadd = "<div class='dx-fieldset-header cerrado' id='Maintenance' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Maintenance Options") + "</div> ";
		toadd += "<div id= 'fiedmaintenance'  ></div>";
		$(".content_wrapper").append(toadd);
		$("#fiedmaintenance").hide();
		$("#Maintenance").click(function()
		{
			if ($("#Maintenance").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedmaintenance").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedmaintenance").show();
			}
		});
		var fieldmantext = " <div id='Updatebutton' ></div>";
		fieldmantext += "<div id='recovery' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
		fieldmantext += "<br><br><div id='infocam' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
		fieldmantext += "<br><br><div id='resetdb' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
		fieldmantext += "<br><br><div id='resetcounters' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
		fieldmantext += "<br><br><div id='dconfig' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
		fieldmantext += "<br><br><div id='exportdb' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
		fieldmantext += "<br><br><div id='exportvparcfg' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
		fieldmantext += "<br><div id='uconfig' style='color: #fff;border-color: transparent ; '  ></div>";
		$("#fiedmaintenance").append(fieldmantext);

		createUpdateButton();

		createResetdbButton();

		createResetCounterButton();
	
		createInfoCamButton();
	
		createRecoveryButton();
		
		$(".dx-fileuploader-input-wrapper .dx-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff",
			"float": "left"
		});

		var toadd2 = "<div class='dx-fieldset-header cerrado' id='Customized' style= 'padding: 10px 40px; cursor: pointer;margin-bottom: 0px;' >" + DevExpress.localization.formatMessage("Customized Options") + "</div> ";
		toadd2 += "<div id= 'fiedcustomized'  ><div class='demo-container' id ='gridlistytpes'>";
		toadd2 += "<div id='importsbuttons'><br>";
		toadd2 += "<div id='ExportCC' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;float:none;display: inline-block;'  > </div>";
		toadd2 += "<div id='ImportCC'  ></div>";
		toadd2 += "<br><br></div>";
		toadd2 += "<div id='gridContainer'></div>";
		toadd2 += "</div></div>";
		$(".content_wrapper").append(toadd2);
		$("#fiedcustomized").hide();
		$("#Customized").click(function()
		{
			if ($("#Customized").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedcustomized").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedcustomized").show();
			}
		});

		createExportButton();
		
		createImportGeneralButton()
		
		createDConfigButton();
		
		createExportDBButton();
		
		createExportVparConfButton();
		
		createImportCustomizedButton();
		
		$(".dx-fileuploader-input-wrapper .dx-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff"
		});

		$(".dx-fileuploader-content > .dx-fileuploader-upload-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff"
		});

		$(".dx-fileuploader-file-container .dx-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff"
		});
		
		vlists = createGridContainer();
		
		loadlists(false);

		$(".dx-fileuploader-input-wrapper .dx-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff",
			"float": "left"
		});
		
	}

	function customdiag(dialogResult)
	{
		if (dialogResult)
		{
			if (dialogResult.buttonText == "YES")
			{
				var data = executeCGI(computerid, "resetdb|pass=" + dialogResult.MAC, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				if (DEFINE_INTERFACE == "AXIS")
				{
					if (data.includes("404 Not Found"))
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + " - OK", "success", 1000);
						setTimeout(reloadpage, 1000);
					}
					else
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + " - ERROR", "error", 1000);
					}
				}
				else
				{
					if (data.includes("error"))
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + " - ERROR", "error", 1000);
					}
					else
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + " - OK", "success", 1000);
						setTimeout(reloadpage, 1000);
					}
				}
			}
		}
	};

	function customdiagCT(dialogResult)
	{
		if (dialogResult)
		{
			if (dialogResult.buttonText == "YES")
			{
				var data = executeCGI(computerid, "resetcounters|pass=" + dialogResult.MAC, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				if (DEFINE_INTERFACE == "AXIS")
				{
					if (data.includes("404 Not Found"))
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + " - OK", "success", 1000);
						setTimeout(reloadpage, 1000);
					}
					else
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + " - ERROR", "error", 1000);
					}
				}
				else
				{
					if (data.includes("error"))
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + " - ERROR", "error", 1000);
					}
					else
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + " - OK", "success", 1000);
						setTimeout(reloadpage, 1000);
					}
				}
			}
		}
	};

	function loadlists(isimport)
	{
		var d = new Date();
		var error = false;
		//elementos listas
		var dataLoad = executeCGI(computerid, "select|table=nlconfcustom|maxvalues=50|sortasc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		if (dataLoad != "error")
		{
			
				for (var i = 0; i < dataLoad.length; i++)
				{
					var arrayelem = dataLoad[i];
					while (arrayelem.name.match(/^\d/))
					{
						dataLoad[i].name = arrayelem.name.replace(/^\d/, '');
					}
					dataLoad[i].name = arrayelem.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					if (arrayelem.name.length == 0)
					{
						for (var j = 1; j < (dataLoad.length - i); j++)
						{
							var tmp = dataLoad[i+j].id;
							dataLoad[i+j].id = dataLoad[i].id;
							dataLoad[i].id = tmp;
						}

						var dataLoad2 = executeCGI(computerid, "delete|table=nlconfcustom|camp0=id|comp0=equal|value0=" + dataLoad[i].id, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
						if(dataLoad2 != "error")
						{
							dataLoad.splice(i,1);
							i -= 1;
							error = true;
							checkExportCCButton();
						}
					}
					else
					{
						var dataLoad2 = executeCGI(computerid, "update|table=nlconfcustom|camp0=id|value0=" + dataLoad[i].id + "|camp1=name|value1=" + dataLoad[i].name + "|camp2=svalue|value2=" + dataLoad[i].svalue, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
						if(dataLoad2 != "error")
						{
							checkExportCCButton();
						}
					}
				}
				if ((isimport == true) && (error == true))
				{
					DevExpress.ui.notify(DevExpress.localization.formatMessage("Import error: At least one Name contains only numbers. Please check import CSV file"), "error", 3500);
					error = false;
				}
				vlists.option("dataSource", dataLoad);
		}
		
	};

	function reloadpage()
	{
		location.reload();
	};

	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};

	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}
	
	var MAX_TOTAL_CUSTOM_OPTIONS = 10;
	var currentNumberOfCustomOps = 0;
	var showaddrowCustomOps = true;
	var listas;
	var countries;
	var regions;
	var selected_region = 0;
	var countriesds;
	var countryelem;
	var ident;
	var dict = {};
	var multioptdict = {};
	var dicttraducciones = {};
	var dicttraduccionesMulti = {};
	var mh = 500;
	var mw = 250;
	var enableLogServer = false;
	var elemLogServerHost;
	var elemLogServerPort;
	var vlists;

	Init_translate();
	make_header("configuration");
	set_rcpopup();

	var msg1 = getRestartingMessage();

	configureWebIcon();

	var loadPanel = getLoadingPanel(getRestartingMessage());
	
	currentNumberOfCustomOps = getNumberOfCustomOps();
	
	if (currentNumberOfCustomOps == MAX_TOTAL_CUSTOM_OPTIONS)
	{
		showaddrowCustomOps = false
	}

	regions = getRegion();
	
	ident = getIdent();
	
	createRestartDefaultButton();

	createRestartButton("#icon-done_info", loadPanel);
	
	var regionds = createRegionsDataSource();
	
	createAllField();
});
