////////////////////////////////
// GENERAL CONFIGURATION PAGE //
////////////////////////////////
function isEmptyCustomOptions()
{
	var numberOfOptions = 0;
	$.ajax(
		{
			async: false,
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=count&table=nlconfcustom&dd=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),

			success: function(data)
			{
				CheckTokenValidity(data);
				numberOfOptions = data;
			}
		});

		return (numberOfOptions == 0);
}

function checkExportCCButton()
{
	if(isEmptyCustomOptions() == true)
	{
		$("#ExportCC").dxButton("instance").option("disabled", true);
	}
	else
	{
		$("#ExportCC").dxButton("instance").option("disabled", false);
	}
}

$(function()
{
	Init_translate();
	make_header("configuration");
	set_rcpopup();
	var listas;
	var countries;
	var regions;
	var selected_region = 0;
	var countriesds;
	var countryelem;
	var ident;
	var dict = {};
	var multioptdict = {};
	var dicttraducciones = {};
	var dicttraduccionesMulti = {};
	var mh = 500;
	var mw = 250;
	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};

	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}

	var msg1 = "";
	if(DEFINE_INTERFACE=="VIVOTEK_CV25")
	{
		msg1 = DevExpress.localization.formatMessage("Service restarting CV25...");
	}
	else
	{
		msg1 = DevExpress.localization.formatMessage("Service restarting...");
	}

	var loadPanel = $(".loadpanel").dxLoadPanel(
	{
		shadingColor: "rgba(0,0,0,0.4)",
		visible: false,
		showIndicator: true,
		showPane: true,
		shading: true,
		width: 300,        
		onShown: function() {
			if(DEFINE_INTERFACE=="HANWHA")
				setTimeout(checkStatus, 5000);
			else
				setTimeout(checkStatus, 5000);

            setTimeout(function(){
				  loadPanel.hide();
				}, popupTime);
        },
		message: msg1,
		closeOnOutsideClick: false
	}).dxLoadPanel("instance");
	var tries = 0;
	function checkStatus(){
		var d = new Date();

		if(DEFINE_INTERFACE == "HANWHA"){
			var msg1 = "";
			msg1 += "<GetSDK_APP_DATA>";
			msg1 += "<AppName>NeuralEdge</AppName>";	
			msg1 += "<Data>computerid=" + computerid + "|oper=status|adinfo=notvalue</Data>";	
			msg1 += "</GetSDK_APP_DATA>";

			addToQueue(msg1, function(response) {
					var data = response; 
		        	if(data!=undefined){
		        		try{
	        				data = JSON.parse(data);
		        		}catch(e){
		        			console.log("Invalid json");
		        			if(tries < 6){
								setTimeout(checkStatus, 5000);
								tries++;
							}else{
								tries = 0;
							}
		        			return;
		        		}
		        		console.log("Response Status: " + JSON.stringify(data));
		        		if(Array.isArray(data)){
		        			console.log("Data is array");
							for(var i = 0; i < data.length; i++){
								if(data[i].ident == "service"){
									if(data[i].value < 4 && data[i].value >= 0){
										loadPanel.hide();
										tries = 0;
									}else{
										if(tries < 6){
											setTimeout(checkStatus, 5000);
											tries++;
										}else{
											tries = 0;
										}
									}
								}
							}
		        		}else{
							if(tries < 6){
								setTimeout(checkStatus, 5000);
								tries++;
							}else{
								tries = 0;
							}
		        		}

					}else{
							if(tries < 6){
								setTimeout(checkStatus, 5000);
								tries++;
							}else{
								tries = 0;
							}
					}
	  			
	  		});	
		}else{

			$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=status&d=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					for(var i = 0; i < data.length; i++){
						if(data[i].ident == "service"){
							if(data[i].value < 4 && data[i].value >= 0){
								loadPanel.hide();
								tries = 0;
							}else{
								if(tries < 6){
									setTimeout(checkStatus, 5000);
									tries++;
								}else{
									tries = 0;
								}
							}
						}
					}
				},
				error: function(){
					if(tries < 6){
						setTimeout(checkStatus, 5000);
						tries++;
					}else{
						tries = 0;
					}
				}
			});
		}
	}

	if(DEFINE_INTERFACE == "HANWHA"){
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";	
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlregion|maxvalues=250|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		addToQueue(msg, function(response) {
			var data = response; 
        	if(data!=undefined){
        		try{
    				data = JSON.parse(data);
        		}catch(e){
        			console.log("Invalid json");
        			return;
        		}
				CheckTokenValidity(data);
				regions = data;
			}
		});

		var msg2 = "";
		msg2 += "<GetSDK_APP_DATA>";
		msg2 += "<AppName>NeuralEdge</AppName>";	
		msg2 += "<Data>computerid=" + computerid + "|oper=getident|adinfo=notvalue</Data>";	
		msg2 += "</GetSDK_APP_DATA>";

		addToQueue(msg2, function(response) {
			var data = response; 
        	if(data!=undefined){
				CheckTokenValidity(data);
				ident = data;
			}
		});
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlregion&maxvalues=250" + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				regions = data;
			}
		});
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getident" + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				ident = data;
			}
		});
	}
	$("#restartdefault").dxButton(
	{
		type: "default",
		text: DevExpress.localization.formatMessage("Restart default configuration"),
		onClick: function()
		{
			var result = DevExpress.ui.dialog.confirm(DevExpress.localization.formatMessage("Are you sure to restart default configuration?"), DevExpress.localization.formatMessage("Default configuration"));
			result.done(function(dialogResult)
			{
				if (dialogResult)
				{
					if(DEFINE_INTERFACE == "HANWHA"){
						/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
						var msg = "";
						msg += "<GetSDK_APP_DATA>";
						msg += "<AppName>NeuralEdge</AppName>";
						msg += "<Data>computerid=" + computerid + "|oper=defaultgeneralconfig</Data>";	
						msg += "</GetSDK_APP_DATA>";

						addToQueue(msg, function(response) {
							var resData = response; 
							console.log("Datos consulta: " + msg);
							console.log("Respuesta status: " + resData);
				        	if(resData!=undefined && resData!=""){
								CheckTokenValidity(data);
								location.reload();
							} 
				    	}); 
						/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					}else{
						$.ajax(
						{
							dataType: "json",
							url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=defaultgeneralconfig&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
							async: false,
							success: function(data)
							{
								CheckTokenValidity(data);
							}
						});
						location.reload();
					}
				}
			});
		}
	});
	$("#icon-done_info").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Restart service"),
		onClick: function()
		{
			loadPanel.show();
			//lp = loadPanel;
			restartapp();
		}
	});
	
	var regionds = new DevExpress.data.DataSource(
	{
		store: regions,
		key: "id",
	});
	if(DEFINE_INTERFACE == "HANWHA"){
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";	
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfgeneral|maxvalues=50|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		addToQueue(msg, function(response) {
			var data = response; 
			
			data = data.replace(/,,/g, "");
			data = data.replace(/\},]/g, "\}]");
			console.log("Datos consulta: " + msg);
			console.log("Respuesta status: " + data);
        	if(data!=undefined){
        		try{
    				data = JSON.parse(data);
        		}catch(e){
        			console.log("Invalid json");
        			return;
        		}
			}
			$.each(data, function(i, item)
			{
				if (item.grouppar != "")
				{
					if (typeof dict[item.grouppar] === "undefined")
					{
						item.indexg = i;
						dict[item.grouppar] = i;
						var toadd = "<div class='dx-fieldset-header cerrado' id='group" + i + "' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage(item.grouppar) + "</div> ";
						toadd += "<div class='dx-fieldset' id= 'fiedl" + i + "'  ></div>";
						$(".content_wrapper").append(toadd);
						$("#fiedl" + i).hide();
						$("#group" + i).click(function()
						{
							if ($("#group" + i).hasClass("abierto"))
							{
								$(this).removeClass('abierto');
								$(this).addClass('cerrado');
								$("#fiedl" + i).hide();
								listplatesabierto = false;
							}
							else
							{
								$(this).addClass('abierto');
								$(this).removeClass('cerrado');
								$("#fiedl" + i).show();
								listplatesabierto = true;
							}
						});
					}
					else
					{
						item.indexg = dict[item.grouppar];
					}
				}
				else
				{
					item.indexg = -1;
				}
			});
			$.each(data, function(i, item)
			{
				if (item.visible == 1)
				{
					if (item.typepar == "int")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;' ></div></div></div>");
						var valopt = (item.options).split(";");
						$("#elem" + i).dxNumberBox(
						{
							value: item.value,
							min: valopt[0],
							max: valopt[1],
							showSpinButtons: true,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here

								var msg = "";
								msg += "<GetSDK_APP_DATA>";
								msg += "<AppName>NeuralEdge</AppName>";
								msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfgeneral|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "</Data>";	
								msg += "</GetSDK_APP_DATA>";

								addToQueue(msg, function(response) {
									var resData = response; 
									console.log("Datos consulta: " + msg);
									console.log("Respuesta status: " + resData);
						        	if(resData!=undefined && resData!=""){
										DevExpress.ui.notify("Data saved", "success", 600);
									}else{
										DevExpress.ui.notify("Data saving error", "error", 600);																
									}   
						    	}); 
	
							}
						});
					}
					if (item.typepar == "bool")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						var options_disabled = false;
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
						var isTrueSet = (item.value == 'true');
						$("#elem" + i).dxCheckBox(
						{
							value: isTrueSet,
							disabled: options_disabled,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here

								var msg = "";
								msg += "<GetSDK_APP_DATA>";
								msg += "<AppName>NeuralEdge</AppName>";
								msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfgeneral|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "</Data>";	
								msg += "</GetSDK_APP_DATA>";

								addToQueue(msg, function(response) {
									var resData = response; 
									console.log("Datos consulta: " + msg);
									console.log("Respuesta status: " + resData);
						        	if(resData!=undefined && resData!=""){
										DevExpress.ui.notify("Data saved", "success", 600);
									}else{
										DevExpress.ui.notify("Data saving error", "error", 600);																
									}   
						    	}); 
							}
						});
					}

					if (item.typepar == "info")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).prepend(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
						var heightpop = 350;
						var widthpop = 500;
						if (item.help == "infopurgegeneral.html" || item.help == "infoexpertgeneral.html" || item.help == "infologgeneralserver.html" || item.help == "infologgeneral.html")
						{
							heightpop = 550;
						}
						$("#elem" + i).dxButton(
						{
							icon: "help",
							type: "success",
							mode: "contained",
							onClick: function(e)
							{
								var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
									.done(function(data)
									{
										$("#popupinfo" + i).append(data);
										var poup = $("#popupinfo" + i).dxPopup(
										{
											showTitle: true,
											title: DevExpress.localization.formatMessage("Help"),
											visible: true,
											maxWidth: widthpop,
											maxHeight: heightpop,
											loseOnOutsideClick: true
										});
									});
							}
						});
					}
					if (item.typepar == "string")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;width:197.2px'></div></div></div>");
						var passmode = "Text";
						if (item.text == "Password:") passmode = "password";
						$("#elem" + i).dxTextBox(
						{
							value: item.value,
							mode: passmode,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here

								var msg = "";
								msg += "<GetSDK_APP_DATA>";
								msg += "<AppName>NeuralEdge</AppName>";
								msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfgeneral|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "</Data>";	
								msg += "</GetSDK_APP_DATA>";

								addToQueue(msg, function(response) {
									var resData = response; 
									console.log("Datos consulta: " + msg);
									console.log("Respuesta status: " + resData);
						        	if(resData!=undefined && resData!=""){
										DevExpress.ui.notify("Data saved", "success", 600);
									}else{
										DevExpress.ui.notify("Data saving error", "error", 600);																
									}   
						    	}); 
							}
						});
					}
					if (item.typepar == "multioption")
					{
						var normalexper = "";
						var indicef = 0;
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value' id='multioption" + i + "'></div></div>");
						var valopt = (item.options).split(";");
						valopt.forEach(function(element)
						{
							dicttraduccionesMulti[DevExpress.localization.formatMessage(element)] = element;
						});
						console.log("Test dic: " + JSON.stringify(dicttraduccionesMulti));
						var valvalue = (item.value).split(";");
						var options_disabled = false;
						if (item.name == "trigger_io_type") //disable trigger options
						{
							options_disabled = true;
						}
						multioptdict["multioption" + i] = [];
						$.each(valvalue, function(k, itemvalue)
						{
							multioptdict["multioption" + i].push(dicttraduccionesMulti[DevExpress.localization.formatMessage(itemvalue)]);
						});
						$.each(valopt, function(j, itemoptions)
						{
							$("#multioption" + i).append("<div id='elem" + i + "-" + j + "' style='float: left;margin-right: 10px;' ></div>");
							$("#elem" + i + "-" + j).dxCheckBox(
							{
								value: item.value.includes(itemoptions),
								text: DevExpress.localization.formatMessage(itemoptions),
								disabled: options_disabled,
								onValueChanged: function(e)
								{
									var newValue= e.value;
									if (newValue)
									{
										multioptdict["multioption" + i].push(dicttraduccionesMulti[e.element[0].textContent]);
									}
									else
									{
										var index = multioptdict["multioption" + i].indexOf(dicttraduccionesMulti[e.element[0].textContent]);
										if (index > -1)
										{
											multioptdict["multioption" + i].splice(index, 1);
										}
									}

									var msg = "";
									msg += "<GetSDK_APP_DATA>";
									msg += "<AppName>NeuralEdge</AppName>";
									msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfgeneral|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "</Data>";	
									msg += "</GetSDK_APP_DATA>";

									addToQueue(msg, function(response) {
										var resData = response; 
										console.log("Datos consulta: " + msg);
										console.log("Respuesta status: " + resData);
							        	if(resData!=undefined && resData!=""){
											DevExpress.ui.notify("Data saved", "success", 600);
										}else{
											DevExpress.ui.notify("Data saving error", "error", 600);																
										}   
							    	}); 
								}
							});
						});
					}
					if (item.typepar == "option")
					{
						var valopt = (item.options).split(";");
						var indicef = 0;
						valopt.forEach(function(element)
						{
							dicttraducciones[DevExpress.localization.formatMessage(element)] = element;
							valopt[indicef] = DevExpress.localization.formatMessage(element);
							indicef++;
						});
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						var helpdiv = "";
						if (item.help != "")
						{
							helpdiv = "<div id='icon" + i + "'></div><div id='popup" + i + "' style='display:none' ></div> ";
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
						if (item.help == "help_purge_type.html")
						{
							mh = 300;
							mw = 600;
						}
						if (item.help != "")
						{
							$("#icon" + i).dxButton(
							{
								icon: "help",
								type: "success",
								mode: "contained",
								onClick: function(e)
								{
									var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
										.done(function(data)
										{
											$("#popup" + i).append(data);
											var poup = $("#popup" + i).dxPopup(
											{
												showTitle: true,
												title: DevExpress.localization.formatMessage("Help"),
												visible: true,
												maxWidth: mw,
												maxHeight: mh,
												loseOnOutsideClick: true
											});
										});
								}
							});
						}
						var isTrueSet = (item.value == 'true');
						$("#elem" + i).dxRadioGroup(
						{
							items: valopt,
							value: DevExpress.localization.formatMessage(item.value),
							layout: "horizontal",
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = dicttraducciones[e.value];
								// Event handling commands go here

								var msg = "";
								msg += "<GetSDK_APP_DATA>";
								msg += "<AppName>NeuralEdge</AppName>";
								msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfgeneral|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "</Data>";	
								msg += "</GetSDK_APP_DATA>";

								addToQueue(msg, function(response) {
									var resData = response; 
									console.log("Datos consulta: " + msg);
									console.log("Respuesta status: " + resData);
						        	if(resData!=undefined && resData!=""){
										DevExpress.ui.notify("Data saved", "success", 600);
									}else{
										DevExpress.ui.notify("Data saving error", "error", 600);																
									}   
						    	}); 
							}
						});
					}
				}
			});
			var toadd = "<div class='dx-fieldset-header cerrado' id='Maintenance' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Maintenance Options") + "</div> ";
			toadd += "<div id= 'fiedmaintenance'  ></div>";
			$(".content_wrapper").append(toadd);
			$("#fiedmaintenance").hide();
			$("#Maintenance").click(function()
			{
				if ($("#Maintenance").hasClass("abierto"))
				{
					$(this).removeClass('abierto');
					$(this).addClass('cerrado');
					$("#fiedmaintenance").hide();
				}
				else
				{
					$(this).addClass('abierto');
					$(this).removeClass('cerrado');
					$("#fiedmaintenance").show();
				}
			});
			var fieldmantext = " <div id='Updatebutton' ></div>";
			fieldmantext += "<div id='recovery' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='infocam' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='resetdb' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='resetcounters' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='dconfig' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='exportdb' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='exportvparcfg' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><div id='uconfig' style='color: #fff;border-color: transparent ; '  ></div>";
			$("#fiedmaintenance").append(fieldmantext);
			$("#Updatebutton").dxFileUploader(
			{
				accept: "*.*",
				multiple: false,
				value: [],
				uploadMode: "instantly",
				selectButtonText: DevExpress.localization.formatMessage("Upload file"),
				labelText: DevExpress.localization.formatMessage("or Drop import files here"),
				chunkSize: 200000,
				uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=uploadfileblob" + localStorage.getItem("TOKEN"),
				onUploadError: function(e)
				{
					DevExpress.ui.notify("Error uploading file", "error", 1000);
				}
			});
			$("#resetdb").dxButton(
			{
				text: DevExpress.localization.formatMessage("Reset the database"),
				onClick: function()
				{
					var myDialog = DevExpress.ui.dialog.custom(
					{
						title: DevExpress.localization.formatMessage("Reset the database"),
						dragEnabled: false,
						showTitle: true,
						message: DevExpress.localization.formatMessage("CLEARDB") + "<br><br>" + DevExpress.localization.formatMessage("Password:") + "<input type='password' id='fname' name='fname' >",
						buttons: [
						{
							text: DevExpress.localization.formatMessage("Yes"),
							onClick: function(e)
							{
								var macname = $("#fname").val();
								if (macname == "")
								{
									DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("PASS EMPTY"));
								}
								else
								{
									return {
										buttonText: "YES",
										MAC: macname
									}
								}
							}
						},
						{
							text: DevExpress.localization.formatMessage("No"),
							onClick: function(e)
							{
								return {
									buttonText: "CANCEL",
									MAC: ""
								}
							}
						}]
					});
					myDialog.show().done(customdiag);
				}
			});

			function customdiag(dialogResult)
			{
				if (dialogResult)
				{
					if (dialogResult.buttonText == "YES")
					{

						var msg = "";
						msg += "<GetSDK_APP_DATA>";
						msg += "<AppName>NeuralEdge</AppName>";
						msg += "<Data>computerid=" + computerid + "|oper=resetdb|pass=" + dialogResult.MAC + "</Data>";	
						msg += "</GetSDK_APP_DATA>";

						addToQueue(msg, function(response) {
							var data = response; 
							console.log("Datos consulta: " + msg);
							console.log("Respuesta status: " + data);
				        	if(data!=undefined && data!=""){
								CheckTokenValidity(data);
								if (data.includes("Error"))
								{
									DevExpress.ui.notify(data, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + "OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}
							}else{
								if (data.responseText.includes("Error"))
								{
									DevExpress.ui.notify(data.responseText, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + " OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}																
							}   
				    	});
					}
				}
			};
			$("#resetcounters").dxButton(
			{
				text: DevExpress.localization.formatMessage("Reset Counters"),
				onClick: function()
				{
					var myDialogCT = DevExpress.ui.dialog.custom(
					{
						title: DevExpress.localization.formatMessage("Reset Counters"),
						dragEnabled: false,
						showTitle: true,
						message: DevExpress.localization.formatMessage("CLEARCT") + "<br><br>" + DevExpress.localization.formatMessage("Password:") + "<input type='password' id='fnamect' name='fname' >",
						buttons: [
						{
							text: DevExpress.localization.formatMessage("Yes"),
							onClick: function(e)
							{
								var macname = $("#fnamect").val();
								if (macname == "")
								{
									DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("PASS EMPTY"));
								}
								else
								{
									return {
										buttonText: "YES",
										MAC: macname
									}
								}
							}
						},
						{
							text: DevExpress.localization.formatMessage("No"),
							onClick: function(e)
							{
								return {
									buttonText: "CANCEL",
									MAC: ""
								}
							}
						}]
					});
					myDialogCT.show().done(customdiagCT);
				}
			});

			function customdiagCT(dialogResult)
			{
				if (dialogResult)
				{
					if (dialogResult.buttonText == "YES")
					{
						var msg = "";
						msg += "<GetSDK_APP_DATA>";
						msg += "<AppName>NeuralEdge</AppName>";
						msg += "<Data>computerid=" + computerid + "|oper=resetcounters|pass=" + dialogResult.MAC + "</Data>";	
						msg += "</GetSDK_APP_DATA>";

						addToQueue(msg, function(response) {
							var data = response; 
							console.log("Datos consulta: " + msg);
							console.log("Respuesta status: " + data);
				        	if(data!=undefined && data!=""){
								CheckTokenValidity(data);
								if (data.includes("Error"))
								{
									DevExpress.ui.notify(data, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + "OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}
							}else{
								if (data.responseText.includes("Error"))
								{
									DevExpress.ui.notify(data.responseText, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + " OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}																
							}   
				    	});
					}
				}
			};

			function reloadpage()
			{
				location.reload();
			};
			$("#infocam").dxButton(
			{
				text: DevExpress.localization.formatMessage("Show info"),
				onClick: function()
				{
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=getinfo|</Data>";	
					msg += "</GetSDK_APP_DATA>";

					addToQueue(msg, function(response) {
						var data = response; 
						console.log("Datos consulta: " + msg);
						console.log("Respuesta status: " + data);
			        	if(data!=undefined && data!=""){
							$("#popupContainer").append(data.replace(/(?:\r\n|\r|\n)/g, '<br>'));
							var poup = $("#popupContainer").dxPopup(
							{
								showTitle: true,
								title: "Information",
								visible: true,
								maxWidth: 500,
								maxHeight: 250,
								loseOnOutsideClick: true
							});
						}else{																
						}   
			    	});
				}
			});
			$("#recovery").dxButton(
			{
				text: DevExpress.localization.formatMessage("Revert last files"),
				onClick: function()
				{
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=recoverfiles|</Data>";	
					msg += "</GetSDK_APP_DATA>";

					addToQueue(msg, function(response) {
						var data = response; 
						console.log("Datos consulta: " + msg);
						console.log("Respuesta status: " + data);
			        	if(data!=undefined && data!=""){
							DevExpress.ui.notify("Revert last files ok", "success", 600);
						}else{																
						}   
			    	});
				}
			});
			$(".dx-fileuploader-input-wrapper .dx-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff",
				"float": "left"
			})
			var toadd2 = "<div class='dx-fieldset-header cerrado' id='Customized' style= 'padding: 10px 40px; cursor: pointer;margin-bottom: 0px;' >" + DevExpress.localization.formatMessage("Customized Options") + "</div> ";
			toadd2 += "<div id= 'fiedcustomized'  ><div class='demo-container' id ='gridlistytpes'>";
			toadd2 += "<div id='importsbuttons'><br>";
			toadd2 += "<div id='ExportCC' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;float:none;display: inline-block;'  > </div>";
			toadd2 += "<div id='ImportCC'  ></div>";
			toadd2 += "<br><br></div>";
			toadd2 += "<div id='gridContainer'></div>";
			toadd2 += "</div></div>";
			$(".content_wrapper").append(toadd2);
			$("#fiedcustomized").hide();
			$("#Customized").click(function()
			{
				if ($("#Customized").hasClass("abierto"))
				{
					$(this).removeClass('abierto');
					$(this).addClass('cerrado');
					$("#fiedcustomized").hide();
				}
				else
				{
					$(this).addClass('abierto');
					$(this).removeClass('cerrado');
					$("#fiedcustomized").show();
				}
			});
			$("#ExportCC").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export to CSV file"),
				disabled: isEmptyCustomOptions(),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportcustomconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			var importbutton = $("#ImportCC").dxFileUploader(
			{
				accept: "*.csv",
				multiple: false,
				value: [],
				width: "50%",
				uploadMode: "instantly",
				selectButtonText: DevExpress.localization.formatMessage("Select import CSV file"),
				labelText: DevExpress.localization.formatMessage("or Drop import CSV file here"),
				invalidFileExtensionMessage: "File type is not allowed",
				allowedFileExtensions: [".CSV"],
				chunkSize: 200000,
				uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importcustomconfig" + localStorage.getItem("TOKEN"),
				showFileList: false,
				onUploaded: function(data)
				{
					loadPanel.hide();
					DevExpress.ui.notify(data.request.responseText, "success", 1500);
					loadlists(true);
				},
				onUploadError: function(e)
				{
					loadPanel.hide();
					DevExpress.ui.notify("Error uploading file", "error", 1000);
				},
				onUploadStarted: function(e)
				{
					loadPanel.show();
				}
			}).dxFileUploader("instance");
			$("#dconfig").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export general config"),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportgeneralconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			$("#exportdb").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export database"),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportdatabase&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			$("#exportvparcfg").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export VPAR config"),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportvparcfg&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			var importbutton = $("#uconfig").dxFileUploader(
			{
				accept: "*.csv",
				multiple: false,
				value: [],
				width: "50%",
				uploadMode: "instantly",
				selectButtonText: DevExpress.localization.formatMessage("Import CSV general config file"),
				labelText: DevExpress.localization.formatMessage("or Drop import CSV general config file here"),
				invalidFileExtensionMessage: "File type is not allowed",
				allowedFileExtensions: [".CSV"],
				chunkSize: 200000,
				uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importgeneralconfig" + localStorage.getItem("TOKEN"),
				showFileList: false,
				onUploaded: function(data)
				{
					loadPanel.hide();
					DevExpress.ui.notify(data.request.responseText, "success", 2000);
					location.reload();
					loadPanel.show();
					lp = loadPanel;
					restartapp();
				},
				onUploadError: function(e)
				{
					loadPanel.hide();
					DevExpress.ui.notify("Error uploading file", "error", 1000);
				},
				onUploadStarted: function(e)
				{
					loadPanel.show();
				}
			}).dxFileUploader("instance");
			$(".dx-fileuploader-input-wrapper .dx-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff"
			});
			$(".dx-fileuploader-content > .dx-fileuploader-upload-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff"
			});
			$(".dx-fileuploader-file-container .dx-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff"
			});
			var vlists = $("#gridContainer").dxDataGrid(
			{
				dataSource: listas,
				showBorders: true,
				showRowLines: true,
				keyExpr: "id",
				hoverStateEnabled: true,
				paging:
				{
					pageSize: 10
				},
				searchPanel:
				{
					visible: true,
					width: 240,
					placeholder: DevExpress.localization.formatMessage("Search...")
				},
				pager:
				{
					showPageSizeSelector: true,
					allowedPageSizes: [5, 10, 20],
					showInfo: true
				},
				columns: [
				{
					dataField: "id",
					caption: DevExpress.localization.formatMessage("ID"),
					width: 50,
					allowEditing: false
				},
				{
					dataField: "name",
					caption: DevExpress.localization.formatMessage("Name"),
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					dataField: "svalue",
					caption: DevExpress.localization.formatMessage("Value"),
					validationRules: [
					{
						type: "required"
					}]
				}],
				editing:
				{
					mode: "row",
					allowUpdating: true,
					allowDeleting: true,
					texts:
					{
						confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the element?")
					},
					allowAdding: true
				},
				selection:
				{
					mode: "single"
				},
				onSelectionChanged: function(selectedItems)
				{
					var data = selectedItems.selectedRowsData[0];
					if (data)
					{}
				},
				onRowUpdating: function(e)
				{
					var name;
					var svalue;
					if (typeof e.newData.name !== 'undefined')
					{
						name = e.newData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
						var newlength = e.newData.name.length;
						while (e.newData.name.match(/^\d/))
						{
							name = e.newData.name.replace(/^\d/, '');
							e.newData.name = name;
						}
						if (e.newData.name.length == 0)
						{
							DevExpress.ui.notify(DevExpress.localization.formatMessage("Name cannot be only numbers"), "error", 1500);
							name = e.oldData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
							e.newData.name = name;
						}
						else
						{
							if (e.newData.name.length != newlength)
							{
								DevExpress.ui.notify(DevExpress.localization.formatMessage("Numbers at the beginning of Name have been removed"), "info", 1500);
							}
						}
					}
					else
					{
						name = e.oldData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					if (typeof e.newData.svalue !== 'undefined')
					{
						svalue = e.newData.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					else
					{
						svalue = e.oldData.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcustom&camp0=id&value0=" + e.oldData.id + "&camp1=name&value1=" + name + "&camp2=svalue&value2=" + svalue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
				},
				onRowInserting: function(e)
				{
					var name;
					var newlength = e.data.name.length;
					while (e.data.name.match(/^\d/))
					{
						name = e.data.name.replace(/^\d/, '');
						e.data.name = name;
					}
					if (e.data.name.length == 0)
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Name cannot be only numbers"), "error", 1500);
					}
					else
					{
						if (e.data.name.length != newlength)
						{
							DevExpress.ui.notify(DevExpress.localization.formatMessage("Numbers at the beginning of Name have been removed"), "info", 1500);
						}
					}
					var jqxhr = $.ajax(
					{
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insertconfcustom&name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '') + "&svalue=" + e.data.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '') + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						success: function(data)
						{
							CheckTokenValidity(data);
							loadlists(false);
						}
					});

					checkExportCCButton();
				},
				onRowRemoving: function(e)
				{
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlconfcustom&camp0=id&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
					checkExportCCButton();
				}
			}).dxDataGrid("instance");

			function loadlists(isimport)
			{
				// var d = new Date();
				// var error = false;
				// //elementos listas
				// $.ajax(
				// {
				// 	dataType: "json",
				// 	url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfcustom&maxvalues=50&sortasc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
				// 	success: function(data)
				// 	{
				// 		CheckTokenValidity(data);
				// 		for (var i = 0; i < data.length; i++)
				// 		{
				// 			var arrayelem = data[i];
				// 			while (arrayelem.name.match(/^\d/))
				// 			{
				// 				data[i].name = arrayelem.name.replace(/^\d/, '');
				// 			}
				// 			data[i].name = arrayelem.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
				// 			if (arrayelem.name.length == 0)
				// 			{
				// 				for (var j = 1; j < (data.length - i); j++)
				// 				{
				// 					var tmp = data[i+j].id;
				// 					data[i+j].id = data[i].id;
				// 					data[i].id = tmp;
				// 				}
				// 				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlconfcustom&camp0=id&comp0=equal&value0=" + data[i].id + localStorage.getItem("TOKEN"));
				// 				data.splice(i,1);
				// 				i -= 1;
				// 				error = true;
				// 			}
				// 			else
				// 			{
				// 				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcustom&camp0=id&value0=" + data[i].id + "&camp1=name&value1=" + data[i].name + "&camp2=svalue&value2=" + data[i].svalue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
				// 			}
				// 		}
				// 		if ((isimport == true) && (error == true))
				// 		{
				// 			DevExpress.ui.notify(DevExpress.localization.formatMessage("Import error: At least one Name contains only numbers. Please check import CSV file"), "error", 3500);
				// 			error = false;
				// 		}
				// 		vlists.option("dataSource", data);
				// 	}
				// });
			};
			loadlists(false);

		});

	}else{
		$.getJSON(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfgeneral&maxvalues=50&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN")).done(function(data)
		{
			//First bucle to create checkbox and div
			$.each(data, function(i, item)
			{
				if (item.grouppar != "")
				{
					if (typeof dict[item.grouppar] === "undefined")
					{
						item.indexg = i;
						dict[item.grouppar] = i;
						var toadd = "<div class='dx-fieldset-header cerrado' id='group" + i + "' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage(item.grouppar) + "</div> ";
						toadd += "<div class='dx-fieldset' id= 'fiedl" + i + "'  ></div>";
						$(".content_wrapper").append(toadd);
						$("#fiedl" + i).hide();
						$("#group" + i).click(function()
						{
							if ($("#group" + i).hasClass("abierto"))
							{
								$(this).removeClass('abierto');
								$(this).addClass('cerrado');
								$("#fiedl" + i).hide();
								listplatesabierto = false;
							}
							else
							{
								$(this).addClass('abierto');
								$(this).removeClass('cerrado');
								$("#fiedl" + i).show();
								listplatesabierto = true;
							}
						});
					}
					else
					{
						item.indexg = dict[item.grouppar];
					}
				}
				else
				{
					item.indexg = -1;
				}
			});
			$.each(data, function(i, item)
			{
				if (item.visible == 1)
				{
					if (item.typepar == "int")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;' ></div></div></div>");
						var valopt = (item.options).split(";");
						$("#elem" + i).dxNumberBox(
						{
							value: item.value,
							min: valopt[0],
							max: valopt[1],
							showSpinButtons: true,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								if(Number.isInteger(newValue))
								{
									// Event handling commands go here
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfgeneral&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
								}
								else
								{
									DevExpress.ui.notify("Element is not an integer", "error", 600);
								}
							}
						});
					}
					if (item.typepar == "bool")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						var options_disabled = false;
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
						var isTrueSet = (item.value == 'true');
						$("#elem" + i).dxCheckBox(
						{
							value: isTrueSet,
							disabled: options_disabled,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfgeneral&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							}
						});
					}
					if (item.typepar == "info")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).prepend(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
						var heightpop = 350;
						var widthpop = 500;
						if (item.help == "infopurgegeneral.html" || item.help == "infoexpertgeneral.html" || item.help == "infologgeneralserver.html" || item.help == "infologgeneral.html")
						{
							heightpop = 550;
						}
						$("#elem" + i).dxButton(
						{
							icon: "help",
							type: "success",
							mode: "contained",
							onClick: function(e)
							{
								var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
									.done(function(data)
									{
										$("#popupinfo" + i).append(data);
										var poup = $("#popupinfo" + i).dxPopup(
										{
											showTitle: true,
											title: DevExpress.localization.formatMessage("Help"),
											visible: true,
											maxWidth: widthpop,
											maxHeight: heightpop,
											loseOnOutsideClick: true
										});
									});
							}
						});
					}
					if (item.typepar == "string")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;width:197.2px'></div></div></div>");
						var passmode = "Text";
						if (item.text == "Password:") passmode = "password";
						$("#elem" + i).dxTextBox(
						{
							value: item.value,
							mode: passmode,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								newValue = newValue.replace(/\\/g, '/');
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfgeneral&camp0=id&value0=" + item.id + "&camp1=value&value1=" + encodeURIComponent(newValue) + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							}
						});
					}
					if (item.typepar == "multioption")
					{
						var normalexper = "";
						var indicef = 0;
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value' id='multioption" + i + "'></div></div>");
						var valopt = (item.options).split(";");
						valopt.forEach(function(element)
						{
							dicttraduccionesMulti[DevExpress.localization.formatMessage(element)] = element;
						});
						console.log("Test dic: " + JSON.stringify(dicttraduccionesMulti));
						var valvalue = (item.value).split(";");
						var options_disabled = false;
						if (item.name == "trigger_io_type") //disable trigger options
						{
							options_disabled = true;
						}
						multioptdict["multioption" + i] = [];
						$.each(valvalue, function(k, itemvalue)
						{
							multioptdict["multioption" + i].push(dicttraduccionesMulti[DevExpress.localization.formatMessage(itemvalue)]);
						});
						$.each(valopt, function(j, itemoptions)
						{
							$("#multioption" + i).append("<div id='elem" + i + "-" + j + "' style='float: left;margin-right: 10px;' ></div>");
							$("#elem" + i + "-" + j).dxCheckBox(
							{
								value: item.value.includes(itemoptions),
								text: DevExpress.localization.formatMessage(itemoptions),
								disabled: options_disabled,
								onValueChanged: function(e)
								{
									var newValue= e.value;
									if (newValue)
									{
										multioptdict["multioption" + i].push(dicttraduccionesMulti[e.element[0].textContent]);
									}
									else
									{
										var index = multioptdict["multioption" + i].indexOf(dicttraduccionesMulti[e.element[0].textContent]);
										if (index > -1)
										{
											multioptdict["multioption" + i].splice(index, 1);
										}
									}
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfgeneral&camp0=id&value0=" + item.id + "&camp1=value&value1=" + multioptdict["multioption" + i].toString().replace(/,/g, ';') + "&camp2=computerid&value2=" + item.computerid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
										.done(function()
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
								}
							});
						});
					}
					if (item.typepar == "option")
					{
						var valopt = (item.options).split(";");
						var indicef = 0;
						valopt.forEach(function(element)
						{
							dicttraducciones[DevExpress.localization.formatMessage(element)] = element;
							valopt[indicef] = DevExpress.localization.formatMessage(element);
							indicef++;
						});
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						var helpdiv = "";
						if (item.help != "")
						{
							helpdiv = "<div id='icon" + i + "'></div><div id='popup" + i + "' style='display:none' ></div> ";
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
						if (item.help == "help_purge_type.html")
						{
							mh = 300;
							mw = 600;
						}
						if (item.help != "")
						{
							$("#icon" + i).dxButton(
							{
								icon: "help",
								type: "success",
								mode: "contained",
								onClick: function(e)
								{
									var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
										.done(function(data)
										{
											$("#popup" + i).append(data);
											var poup = $("#popup" + i).dxPopup(
											{
												showTitle: true,
												title: DevExpress.localization.formatMessage("Help"),
												visible: true,
												maxWidth: mw,
												maxHeight: mh,
												loseOnOutsideClick: true
											});
										});
								}
							});
						}
						var isTrueSet = (item.value == 'true');
						var options_disabled = false;
						/*if (item.value == "PERSISTENT") //quitar para volver a habilitar el action time -> expert options
						{
							options_disabled = true;
						}*/
						$("#elem" + i).dxRadioGroup(
						{
							items: valopt,
							value: DevExpress.localization.formatMessage(item.value),
							disabled: options_disabled, //quitar para volver a habilitar el action time -> expert options
							layout: "horizontal",
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = dicttraducciones[e.value];
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfgeneral&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							}
						});
					}
				}
			});
			var toadd = "<div class='dx-fieldset-header cerrado' id='Maintenance' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Maintenance Options") + "</div> ";
			toadd += "<div id= 'fiedmaintenance'  ></div>";
			$(".content_wrapper").append(toadd);
			$("#fiedmaintenance").hide();
			$("#Maintenance").click(function()
			{
				if ($("#Maintenance").hasClass("abierto"))
				{
					$(this).removeClass('abierto');
					$(this).addClass('cerrado');
					$("#fiedmaintenance").hide();
				}
				else
				{
					$(this).addClass('abierto');
					$(this).removeClass('cerrado');
					$("#fiedmaintenance").show();
				}
			});
			var fieldmantext = " <div id='Updatebutton' ></div>";
			fieldmantext += "<div id='recovery' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='infocam' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='resetdb' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='resetcounters' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='dconfig' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='exportdb' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><br><div id='exportvparcfg' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;'  ></div>";
			fieldmantext += "<br><div id='uconfig' style='color: #fff;border-color: transparent ; '  ></div>";
			$("#fiedmaintenance").append(fieldmantext);
			$("#Updatebutton").dxFileUploader(
			{
				accept: "*.*",
				multiple: false,
				value: [],
				uploadMode: "instantly",
				selectButtonText: DevExpress.localization.formatMessage("Upload file"),
				labelText: DevExpress.localization.formatMessage("or Drop import files here"),
				chunkSize: 200000,
				uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=uploadfileblob" + localStorage.getItem("TOKEN"),
				onUploadError: function(e)
				{
					DevExpress.ui.notify("Error uploading file", "error", 1000);
				}
			});
			$("#resetdb").dxButton(
			{
				text: DevExpress.localization.formatMessage("Reset the database"),
				onClick: function()
				{
					var myDialog = DevExpress.ui.dialog.custom(
					{
						title: DevExpress.localization.formatMessage("Reset the database"),
						dragEnabled: false,
						showTitle: true,
						message: DevExpress.localization.formatMessage("CLEARDB") + "<br><br>" + DevExpress.localization.formatMessage("Password:") + "<input type='password' id='fname' name='fname' >",
						buttons: [
						{
							text: DevExpress.localization.formatMessage("Yes"),
							onClick: function(e)
							{
								var macname = $("#fname").val();
								if (macname == "")
								{
									DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("PASS EMPTY"));
								}
								else
								{
									return {
										buttonText: "YES",
										MAC: macname
									}
								}
							}
						},
						{
							text: DevExpress.localization.formatMessage("No"),
							onClick: function(e)
							{
								return {
									buttonText: "CANCEL",
									MAC: ""
								}
							}
						}]
					});
					myDialog.show().done(customdiag);
				}
			});

			function customdiag(dialogResult)
			{
				if (dialogResult)
				{
					if (dialogResult.buttonText == "YES")
					{
						$.ajax(
						{
							dataType: "json",
							url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=resetdb&pass=" + dialogResult.MAC + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
							async: false,
							success: function(data)
							{
								CheckTokenValidity(data);
								if (data.includes("Error"))
								{
									DevExpress.ui.notify(data, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + "OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}
							},
							error: function(data)
							{
								if (data.responseText.includes("Error"))
								{
									DevExpress.ui.notify(data.responseText, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset the database") + " OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}
							}
						});
					}
				}
			};
			$("#resetcounters").dxButton(
			{
				text: DevExpress.localization.formatMessage("Reset Counters"),
				onClick: function()
				{
					var myDialogCT = DevExpress.ui.dialog.custom(
					{
						title: DevExpress.localization.formatMessage("Reset Counters"),
						dragEnabled: false,
						showTitle: true,
						message: DevExpress.localization.formatMessage("CLEARCT") + "<br><br>" + DevExpress.localization.formatMessage("Password:") + "<input type='password' id='fnamect' name='fname' >",
						buttons: [
						{
							text: DevExpress.localization.formatMessage("Yes"),
							onClick: function(e)
							{
								var macname = $("#fnamect").val();
								if (macname == "")
								{
									DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("PASS EMPTY"));
								}
								else
								{
									return {
										buttonText: "YES",
										MAC: macname
									}
								}
							}
						},
						{
							text: DevExpress.localization.formatMessage("No"),
							onClick: function(e)
							{
								return {
									buttonText: "CANCEL",
									MAC: ""
								}
							}
						}]
					});
					myDialogCT.show().done(customdiagCT);
				}
			});

			function customdiagCT(dialogResult)
			{
				if (dialogResult)
				{
					if (dialogResult.buttonText == "YES")
					{
						$.ajax(
						{
							dataType: "json",
							url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=resetcounters&pass=" + dialogResult.MAC + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
							async: false,
							success: function(data)
							{
								CheckTokenValidity(data);
								if (data.includes("Error"))
								{
									DevExpress.ui.notify(data, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + "OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}
							},
							error: function(data)
							{
								if (data.responseText.includes("Error"))
								{
									DevExpress.ui.notify(data.responseText, "error", 1000);
								}
								else
								{
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Reset Counters") + " OK", "success", 1000);
									setTimeout(reloadpage, 1000);
								}
							}
						});
					}
				}
			};

			function reloadpage()
			{
				location.reload();
			};
			$("#infocam").dxButton(
			{
				text: DevExpress.localization.formatMessage("Show info"),
				onClick: function()
				{
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getinfo" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
						.done(function(data)
						{
							$("#popupContainer").append(data.replace(/(?:\r\n|\r|\n)/g, '<br>'));
							var poup = $("#popupContainer").dxPopup(
							{
								showTitle: true,
								title: "Information",
								visible: true,
								maxWidth: 500,
								maxHeight: 250,
								loseOnOutsideClick: true
							});
						})
				}
			});
			$("#recovery").dxButton(
			{
				text: DevExpress.localization.formatMessage("Revert last files"),
				onClick: function()
				{
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=recoverfiles" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
						.done(function(data)
						{
							DevExpress.ui.notify("Revert last files ok", "success", 600);
						})
				}
			});
			$(".dx-fileuploader-input-wrapper .dx-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff",
				"float": "left"
			})
			var toadd2 = "<div class='dx-fieldset-header cerrado' id='Customized' style= 'padding: 10px 40px; cursor: pointer;margin-bottom: 0px;' >" + DevExpress.localization.formatMessage("Customized Options") + "</div> ";
			toadd2 += "<div id= 'fiedcustomized'  ><div class='demo-container' id ='gridlistytpes'>";
			toadd2 += "<div id='importsbuttons'><br>";
			toadd2 += "<div id='ExportCC' style='color: #fff;background-color: #5cb85c;border-color: transparent ; margin-left: 9px;float:none;display: inline-block;'  > </div>";
			toadd2 += "<div id='ImportCC'  ></div>";
			toadd2 += "<br><br></div>";
			toadd2 += "<div id='gridContainer'></div>";
			toadd2 += "</div></div>";
			$(".content_wrapper").append(toadd2);
			$("#fiedcustomized").hide();
			$("#Customized").click(function()
			{
				if ($("#Customized").hasClass("abierto"))
				{
					$(this).removeClass('abierto');
					$(this).addClass('cerrado');
					$("#fiedcustomized").hide();
				}
				else
				{
					$(this).addClass('abierto');
					$(this).removeClass('cerrado');
					$("#fiedcustomized").show();
				}
			});
			$("#ExportCC").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export to CSV file"),
				disabled: isEmptyCustomOptions(),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportcustomconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			var importbutton = $("#ImportCC").dxFileUploader(
			{
				accept: "*.csv",
				multiple: false,
				value: [],
				width: "50%",
				uploadMode: "instantly",
				selectButtonText: DevExpress.localization.formatMessage("Select import CSV file"),
				labelText: DevExpress.localization.formatMessage("or Drop import CSV file here"),
				invalidFileExtensionMessage: "File type is not allowed",
				allowedFileExtensions: [".CSV"],
				chunkSize: 200000,
				uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importcustomconfig" + localStorage.getItem("TOKEN"),
				showFileList: false,
				onUploaded: function(data)
				{
					loadPanel.hide();
					DevExpress.ui.notify(data.request.responseText, "success", 1500);
					loadlists(true);
				},
				onUploadError: function(e)
				{
					loadPanel.hide();
					DevExpress.ui.notify("Error uploading file", "error", 1000);
				},
				onUploadStarted: function(e)
				{
					loadPanel.show();
				}
			}).dxFileUploader("instance");
			$("#dconfig").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export general config"),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportgeneralconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			$("#exportdb").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export database"),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportdatabase&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			$("#exportvparcfg").dxButton(
			{
				text: DevExpress.localization.formatMessage("Export VPAR config"),
				onClick: function()
				{
					window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportvparcfg&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
				}
			});
			var importbutton = $("#uconfig").dxFileUploader(
			{
				accept: "*.csv",
				multiple: false,
				value: [],
				width: "50%",
				uploadMode: "instantly",
				selectButtonText: DevExpress.localization.formatMessage("Import CSV general config file"),
				labelText: DevExpress.localization.formatMessage("or Drop import CSV general config file here"),
				invalidFileExtensionMessage: "File type is not allowed",
				allowedFileExtensions: [".CSV"],
				chunkSize: 200000,
				uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importgeneralconfig" + localStorage.getItem("TOKEN"),
				showFileList: false,
				onUploaded: function(data)
				{
					loadPanel.hide();
					DevExpress.ui.notify(data.request.responseText, "success", 2000);
					location.reload();
					loadPanel.show();
					lp = loadPanel;
					restartapp();
				},
				onUploadError: function(e)
				{
					loadPanel.hide();
					DevExpress.ui.notify("Error uploading file", "error", 1000);
				},
				onUploadStarted: function(e)
				{
					loadPanel.show();
				}
			}).dxFileUploader("instance");
			$(".dx-fileuploader-input-wrapper .dx-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff"
			});
			$(".dx-fileuploader-content > .dx-fileuploader-upload-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff"
			});
			$(".dx-fileuploader-file-container .dx-button").css(
			{
				"background-color": "#5cb85c",
				"border-color": "transparent",
				"color": "#fff"
			});
			var vlists = $("#gridContainer").dxDataGrid(
			{
				dataSource: listas,
				showBorders: true,
				showRowLines: true,
				keyExpr: "id",
				hoverStateEnabled: true,
				paging:
				{
					pageSize: 10
				},
				searchPanel:
				{
					visible: true,
					width: 240,
					placeholder: DevExpress.localization.formatMessage("Search...")
				},
				pager:
				{
					showPageSizeSelector: true,
					allowedPageSizes: [5, 10, 20],
					showInfo: true
				},
				columns: [
				{
					dataField: "id",
					caption: DevExpress.localization.formatMessage("ID"),
					width: 50,
					allowEditing: false
				},
				{
					dataField: "name",
					caption: DevExpress.localization.formatMessage("Name"),
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					dataField: "svalue",
					caption: DevExpress.localization.formatMessage("Value"),
					validationRules: [
					{
						type: "required"
					}]
				}],
				editing:
				{
					mode: "row",
					allowUpdating: true,
					allowDeleting: true,
					texts:
					{
						confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the element?")
					},
					allowAdding: true
				},
				selection:
				{
					mode: "single"
				},
				onSelectionChanged: function(selectedItems)
				{
					var data = selectedItems.selectedRowsData[0];
					if (data)
					{}
				},
				onRowUpdating: function(e)
				{
					var name;
					var svalue;
					if (typeof e.newData.name !== 'undefined')
					{
						name = e.newData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
						var newlength = e.newData.name.length;
						while (e.newData.name.match(/^\d/))
						{
							name = e.newData.name.replace(/^\d/, '');
							e.newData.name = name;
						}
						if (e.newData.name.length == 0)
						{
							DevExpress.ui.notify(DevExpress.localization.formatMessage("Name cannot be only numbers"), "error", 1500);
							name = e.oldData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
							e.newData.name = name;
						}
						else
						{
							if (e.newData.name.length != newlength)
							{
								DevExpress.ui.notify(DevExpress.localization.formatMessage("Numbers at the beginning of Name have been removed"), "info", 1500);
							}
						}
					}
					else
					{
						name = e.oldData.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					if (typeof e.newData.svalue !== 'undefined')
					{
						svalue = e.newData.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					else
					{
						svalue = e.oldData.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
					}
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcustom&camp0=id&value0=" + e.oldData.id + "&camp1=name&value1=" + name + "&camp2=svalue&value2=" + svalue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
				},
				onRowInserting: function(e)
				{
					var name;
					var newlength = e.data.name.length;
					while (e.data.name.match(/^\d/))
					{
						name = e.data.name.replace(/^\d/, '');
						e.data.name = name;
					}
					if (e.data.name.length == 0)
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Name cannot be only numbers"), "error", 1500);
					}
					else
					{
						if (e.data.name.length != newlength)
						{
							DevExpress.ui.notify(DevExpress.localization.formatMessage("Numbers at the beginning of Name have been removed"), "info", 1500);
						}
					}
					var jqxhr = $.ajax(
					{
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insertconfcustom&name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '') + "&svalue=" + e.data.svalue.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '') + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						success: function(data)
						{
							CheckTokenValidity(data);
							loadlists(false);
						}
					});
					
					checkExportCCButton();
				},
				onRowRemoving: function(e)
				{
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlconfcustom&camp0=id&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
					
					checkExportCCButton();
				}
			}).dxDataGrid("instance");

			function loadlists(isimport)
			{
				var d = new Date();
				var error = false;
				//elementos listas
				$.ajax(
				{
					dataType: "json",
					url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfcustom&maxvalues=50&sortasc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						for (var i = 0; i < data.length; i++)
						{
							var arrayelem = data[i];
							while (arrayelem.name.match(/^\d/))
							{
								data[i].name = arrayelem.name.replace(/^\d/, '');
							}
							data[i].name = arrayelem.name.replaceAll('"', '').replaceAll('\'', '').replaceAll(' ', '');
							if (arrayelem.name.length == 0)
							{
								for (var j = 1; j < (data.length - i); j++)
								{
									var tmp = data[i+j].id;
									data[i+j].id = data[i].id;
									data[i].id = tmp;
								}
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlconfcustom&camp0=id&comp0=equal&value0=" + data[i].id + localStorage.getItem("TOKEN"));
								data.splice(i,1);
								i -= 1;
								error = true;
							}
							else
							{
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcustom&camp0=id&value0=" + data[i].id + "&camp1=name&value1=" + data[i].name + "&camp2=svalue&value2=" + data[i].svalue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
							}
						}
						if ((isimport == true) && (error == true))
						{
							DevExpress.ui.notify(DevExpress.localization.formatMessage("Import error: At least one Name contains only numbers. Please check import CSV file"), "error", 3500);
							error = false;
						}
						vlists.option("dataSource", data);
					}
				});
			};
			loadlists(false);
		});
	}
	$(".dx-fileuploader-input-wrapper .dx-button").css(
	{
		"background-color": "#7ab8eb",
		"border-color": "transparent",
		"color": "#fff",
		"float": "right"
	})
});
