/////////////////
// REVIEW PAGE //
/////////////////

function getConfig2(dict, dictlist, listas){		
	var msgConf1 = "";
	msgConf1 += "<GetSDK_APP_DATA>";
	msgConf1 += "<AppName>NeuralEdge</AppName>";
	msgConf1 += "<Data>computerid=" + computerid + "|oper=select|table=nllist|maxvalues=50|adinfo=notvalue</Data>";	
	msgConf1 += "</GetSDK_APP_DATA>";
	addToQueue(msgConf1, function(response) {
		var config1 = response;
		console.log("Respuesta status: " + config1);
		try {  
		  config1 = JSON.parse(config1); 
		} catch (e) {  
		  console.log('invalid json'); 
		  return; 
		}
		CheckTokenValidity(config1);
		if(Array.isArray(config1)){
			if(config1.length>0){
				$.each(config1, function(i, item)
				{
					var elem = {};
					elem["ID"] = item.id;
					elem["description"] = item.description;
					listas.push(elem);
					dictlist["[" + item.id + "]"] = item.description;
				});
			}
		}	
	});

	var msgConf2 = "";
	msgConf2 += "<GetSDK_APP_DATA>";
	msgConf2 += "<AppName>NeuralEdge</AppName>";
	msgConf2 += "<Data>computerid=" + computerid + "|oper=select|table=nlcountry|maxvalues=200|sortasc=description|adinfo=notvalue</Data>";	
	msgConf2 += "</GetSDK_APP_DATA>";
	addToQueue(msgConf2, function(response) {
		var config2 = response;
		console.log("Respuesta msgConf2: " + msgConf2);
		console.log("Respuesta status: " + config2);
		try {  
		  config2 = JSON.parse(config2); 
		} catch (e) {  
		  console.log('invalid json'); 
		  return; 
		}
		CheckTokenValidity(config2);
		if(Array.isArray(config2)){
			if(config2.length>0){
				$.each(config2, function(i, item)
				{
					dict[item.id] = item.description;
				});
			}
		}
		$("#radio-group-simple").dxSelectBox(
		{
			dataSource: new DevExpress.data.ArrayStore(
			{
				data: listas,
				key: "ID"
			}),
			displayExpr: "description",
			valueExpr: "ID",
			value: listas[0].ID,
		});
	});
}

$(function()
{
	if (DEFINE_INTERFACE == "ZKTECO")
	{
		//No cargamos traducciones ni header. 
		$("#htmlcentral").width(1800);
	}
	else
	{
		Init_translate();
		make_header("review");
	}
	$("#lbfromdate").text(DevExpress.localization.formatMessage("From date"));
	$("#lbtodate").text(DevExpress.localization.formatMessage("To date"));
	$("#lbplate").text(DevExpress.localization.formatMessage("Plate"));
	$("#lblist").text(DevExpress.localization.formatMessage("List"));
	$("#lblane").text(DevExpress.localization.formatMessage("Lane"));
	console.log("Test DEFINE_INTERFACE: " + DEFINE_INTERFACE);

	$("#lbmaker").text(DevExpress.localization.formatMessage("Make"));
	$("#lbcolor").text(DevExpress.localization.formatMessage("Color"));
	$("#lbclass").text(DevExpress.localization.formatMessage("Class"));
	$("#lbspeed1").text(DevExpress.localization.formatMessage("Speed"));
	$("#shnumreg").text(DevExpress.localization.formatMessage("Show num registers:"));
	if(DEFINE_INTERFACE == "HANWHA"){
		$("#shnumreg").hide();
		$("#numreg").hide();
	}
	// }
	$("#lbdirection").text(DevExpress.localization.formatMessage("Direction"));
	if (DEFINE_INTERFACE == "ZKTECO")
	{
		//No hacemos nada
	}
	else
	{
		set_rcpopup();
	}

	var priorities = [DevExpress.localization.formatMessage("All"), DevExpress.localization.formatMessage("In list"), DevExpress.localization.formatMessage("Not in list")];
	var sellist = 0;
	var dateact = new Date();
	var dateiniday;
	var dateendday;
	var results = [];
	var dictlist = {};
	var dict = {};
	var listas = [];
	var d2;
	var mostrarAnterior = false;
	var mostrarPosterior = false;
	var num_registros_consulta = 0;
	var num_pages = 0;
	var page_actual = 0;
	var id_inicial = 0;
	var id_final = 0;
	var num_regs = 10;
	var dir_selected = DevExpress.localization.formatMessage("(All Directions)");
	var application = "";
	var debugoptions = false;
	var json_data;
	var vehiclesclass;
	var vehiclescolor;
	var vehiclesmakes;

	//Visibility Options
	var LaneVisible = false;
	var DirectionVisible = false;
	var ConfVisible = false;
	var SpeedVisible = false;
	var HeightVisible = false;
	var CountryVisible = false;
	var ListVisible = false;
	var ClassVisible = false;
	var ColorVisible = false;
	var MakeVisible = false;

	//lane names
	var lanenames = [];

	var actual_date;
	var sortby_data="timestamp";
	var sortby_order="sortdesc";
	var lastsort = "timestamp";
	var repeat_idx = 0;

	var selectfield = "|selectfield=id;timestamp;numberplate;laneid;direction;speed;globalconfidence;averagecharheight;country;listid;veclass_str;make_str;color_str;imageretailpath;imagepath;resultleft;resulttop;resultright;resultbottom;width;height";
	$.urlParam = function(name)
	{
		var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
		if (results == null)
		{
			return null;
		}
		else
		{
			return results[1] || 0;
		}
	}
	
	if ($.urlParam('debugoptions') != null && $.urlParam('debugoptions') == 1)
	{
		debugoptions = true;
	}
	//Load info vehicles
	//class
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlvehicleclass&maxvalues=8&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			CheckTokenValidity(data);
			vehiclesclass = data;
		}
	});

	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlvehiclecolor&maxvalues=10&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			CheckTokenValidity(data);
			vehiclescolor = data;
		}
	});

	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlvehiclemake&maxvalues=35&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			CheckTokenValidity(data);
			vehiclesmakes = data;
		}
	});
	
	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}

	var vehiclesclassds = new DevExpress.data.DataSource(
	{
		store: vehiclesclass,
		key: "id",
	});

	var vehiclescolords = new DevExpress.data.DataSource(
	{
		store: vehiclescolor,
		key: "id",
	});

	var vehiclesmakeds = new DevExpress.data.DataSource(
	{
		store: vehiclesmakes,
		key: "id",
	});
	
	//Get application reviewfields
	if(DEFINE_INTERFACE == "HANWHA"){
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfgeneral|camp0=name|comp0=equal|value0=reviewfields|maxvalues=1|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		
		addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Datos consulta: " + msg);
				console.log("Respuesta reviewfields: " + resData);
	        	if(resData!=undefined && resData!=""){
					try {  
					  resData = JSON.parse(resData); 
					} catch (e) {  
					  console.log('invalid json'); 
					  return; 
					}
					if(Array.isArray(resData)){
						LaneVisible = resData[0]["value"].includes("Lane");
						DirectionVisible = resData[0]["value"].includes("Direction");
						ConfVisible = resData[0]["value"].includes("Conf");
						SpeedVisible = resData[0]["value"].includes("Speed");
						HeightVisible = resData[0]["value"].includes("Height");
						CountryVisible = resData[0]["value"].includes("Country");
						ListVisible = resData[0]["value"].includes("List");
						ClassVisible = resData[0]["value"].includes("Class");
						ColorVisible = resData[0]["value"].includes("Color");
						MakeVisible = resData[0]["value"].includes("Make");
					}
					loadGrid();
				} 
    	}); 
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfgeneral&camp0=name&comp0=equal&value0=reviewfields&maxvalues=1" + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				LaneVisible = data[0]["value"].includes("Lane");
				DirectionVisible = data[0]["value"].includes("Direction");
				ConfVisible = data[0]["value"].includes("Conf");
				SpeedVisible = data[0]["value"].includes("Speed");
				HeightVisible = data[0]["value"].includes("Height");
				console.log("HeightVisible:" + HeightVisible);
				CountryVisible = data[0]["value"].includes("Country");
				ListVisible = data[0]["value"].includes("List");
				ClassVisible = data[0]["value"].includes("Class");
				ColorVisible = data[0]["value"].includes("Color");
				MakeVisible = data[0]["value"].includes("Make");
			}
		});
	}

	//GET TIME
	if(DEFINE_INTERFACE == "HANWHA"){
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=gettime|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		
		addToQueue(msg, function(response) {
			var resData = response; 
			console.log("Response in first query response: " + JSON.stringify(resData));
				console.log("Datos consulta: " + msg);
			console.log("Respuesta : " + JSON.stringify(resData));
			console.log("Respuesta status: " + resData);
        	if(resData!=undefined && resData!=""){
				d2 = new Date(resData);
				dateiniday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 0, 0, 0);
				dateendday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 23, 59, 59);

				fdata1 = $("#data1").dxDateBox(
				{
					type: "datetime",
					displayFormat: "dd/MM/yyyy HH:mm:ss",
					value: dateiniday
				}).dxDateBox('instance');
				fdata2 = $("#data2").dxDateBox(
				{
					type: "datetime",
					displayFormat: "dd/MM/yyyy HH:mm:ss",
					value: dateendday
				}).dxDateBox('instance');
			}			
    	}); 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}else{
		$.ajax(
		{
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=gettime&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				d2 = new Date(data);
				dateiniday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 0, 0, 0);
				dateendday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 23, 59, 59);
			}
		});
	}
	
	if(DEFINE_INTERFACE == "HANWHA"){
		getConfig2(dict, dictlist, listas);
	
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				$.each(data[1], function(i, item)
				{
					dict[item.id] = item.description;
				});
				$.each(data[0], function(i, item)
				{
					var elem = {};
					elem["ID"] = item.id;
					elem["description"] = item.description;
					listas.push(elem);
					dictlist["[" + item.id + "]"] = item.description;
				});
			}
		});
	}
	
	//Get application value
	if(DEFINE_INTERFACE == "HANWHA"){
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfgeneral|camp0=name|comp0=equal|value0=aplication|maxvalues=1|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		
		addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Response in first query response: " + JSON.stringify(resData));
					console.log("Datos consulta: " + msg);
				console.log("Respuesta : " + JSON.stringify(resData));
				console.log("Respuesta status: " + resData);
	        	if(resData!=undefined && resData!=""){
					try {  
					  resData = JSON.parse(resData); 
					} catch (e) {  
					  console.log('invalid json'); 
					  return; 
					}
					if(Array.isArray(resData)){
						application = resData[0]["value"];
					}
				} 
    	}); 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}else{
		application = getApplication();
	}	

	//Get application lane names
	if(DEFINE_INTERFACE == "HANWHA"){
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfgeneral|camp0=name|comp0=equal|value0=aplication|maxvalues=1|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		
		addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Response in first query response: " + JSON.stringify(resData));
					console.log("Datos consulta: " + msg);
				console.log("Respuesta : " + JSON.stringify(resData));
				console.log("Respuesta status: " + resData);
	        	if(resData!=undefined && resData!=""){
					try {  
					  resData = JSON.parse(resData); 
					} catch (e) {  
					  console.log('invalid json'); 
					  return; 
					}
					if(Array.isArray(resData)){
						application = resData[0]["value"];
					}
				} 
    	}); 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcameralane&maxvalues=10" + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				console.log("LANENAMES: " + JSON.stringify(data));
				lanenames.push({ID: "", Name: ""});
				lanenames.push({ID: "LANE", Name: "No lane"});
				for(var i = 0; i < data.length; i++){
					lanenames.push({ID: data[i].id, Name: data[i].name});
				}
				console.log("Lanenames: " + JSON.stringify(lanenames));
			}
		});
	}	
	//Get application reviewfields
	if(DEFINE_INTERFACE == "HANWHA"){
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfgeneral|camp0=name|comp0=equal|value0=reviewfields|maxvalues=1|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		
		addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Response in first query response: " + JSON.stringify(resData));
					console.log("Datos consulta: " + msg);
				console.log("Respuesta : " + JSON.stringify(resData));
				console.log("Respuesta status: " + resData);
	        	if(resData!=undefined && resData!=""){
					try {  
					  resData = JSON.parse(resData); 
					} catch (e) {  
					  console.log('invalid json'); 
					  return; 
					}
					if(Array.isArray(resData)){
						LaneVisible = resData[0]["value"].includes("Lane");
						DirectionVisible = resData[0]["value"].includes("Direction");
						ConfVisible = resData[0]["value"].includes("Conf");
						SpeedVisible = resData[0]["value"].includes("Speed");
						HeightVisible = resData[0]["value"].includes("Height");
						CountryVisible = resData[0]["value"].includes("Country");
						ListVisible = resData[0]["value"].includes("List");
						ClassVisible = resData[0]["value"].includes("Class");
						ColorVisible = resData[0]["value"].includes("Color");
						MakeVisible = resData[0]["value"].includes("Make");


						if(ClassVisible){
							/*var classList = [{ID: -1,Name: ''},{ID: 0,Name: 'UNKNOWN'}, {ID: 1,Name: 'MOTORBIKE'}, {ID: 2,Name: 'CAR'}, {ID: 3,Name: 'VAN'},
							 {ID: 4,Name: 'TRUCK'}, {ID: 5,Name: 'BUS'}];*/
							var fClass = $("#class_list").dxSelectBox(
							{
								dataSource: vehiclesclassds,
								valueExpr: "id",
								searchEnabled: true,
								displayExpr: "description"
							});
						}else{
							$("#lbclass").parent().remove();
						}
						
						if(MakeVisible){
							/*const makerList = [{ID: -1,Name: ''},{ID: 0,Name: 'AUDI'}, {ID: 1,Name: 'BMW'}, {ID: 2,Name: 'CHEVROLET'}, {ID: 3,Name: 'CITROEN'}, {ID: 4,Name: 'DACIA'}, {ID: 5,Name: 'FIAT'},
							 {ID: 6,Name: 'FORD'}, {ID: 7,Name: 'HONDA'}, {ID: 8,Name: 'HYUNDAI'}, {ID: 9,Name: 'JEEP'},{ID: 10,Name: 'KIA'}, {ID: 11,Name: 'LAND_ROVER'},
							 {ID: 12,Name: 'LEXUS'}, {ID: 13,Name: 'MAZDA'}, {ID: 14,Name: 'MERCEDES'}, {ID: 15,Name: 'MINI'},{ID: 16,Name: 'MITSUBISHI'},{ID: 17,Name: 'NISSAN'}, {ID: 18,Name: 'OPEL'},
							 {ID: 19,Name: 'PEUGEOT'}, {ID: 20,Name: 'RENAULT'}, {ID: 21,Name: 'SEAT'}, {ID: 22,Name: 'SKODA'}, {ID: 23,Name: 'SSANGYONG'}, {ID: 24,Name: 'SUBARU'}, {ID: 25,Name: 'SUZUKI'},
							 {ID: 26,Name: 'TOYOTA'}, {ID: 27,Name: 'VOLKSWAGEN'}, {ID: 28,Name: 'VOLVO'}, {ID: 29,Name: 'UNKNOWN'}];*/
							var fMaker =  $("#maker_list").dxSelectBox(
							{
								dataSource: vehiclesmakeds,
								valueExpr: "id",
								searchEnabled: true,
								displayExpr: "description"
							});
						}else{
							$("#lbmaker").parent().remove();
						}

						if(ColorVisible){
							/*var dataColors = [{ID: -1,Name: ''},{ID: 1,Name: 'WHITE'}, {ID: 2,Name: 'GREY'}, {ID: 3,Name: 'BLACK'}, {ID: 4,Name: 'RED'}, {ID: 5,Name: 'ORANGE'}, {ID: 6,Name: 'YELLOW'},
							 {ID: 7,Name: 'GREEN'}, {ID: 8,Name: 'BLUE'}, {ID: 9,Name: 'PURPLE'}, {ID: 10,Name: 'UNKNOWN'}];*/
							var fColor = $("#color_list").dxSelectBox(
							{
								dataSource: vehiclescolords,
								valueExpr: "id",
								searchEnabled: true,
								displayExpr: "description"
							});
						}else{
							$("#lbcolor").parent().remove();
						}
						
					}
				} 
    	}); 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfgeneral&camp0=name&comp0=equal&value0=reviewfields&maxvalues=1" + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				LaneVisible = data[0]["value"].includes("Lane");
				DirectionVisible = data[0]["value"].includes("Direction");
				ConfVisible = data[0]["value"].includes("Conf");
				SpeedVisible = data[0]["value"].includes("Speed");
				HeightVisible = data[0]["value"].includes("Height");
				console.log("HeightVisible:" + HeightVisible);
				CountryVisible = data[0]["value"].includes("Country");
				ListVisible = data[0]["value"].includes("List");
				ClassVisible = data[0]["value"].includes("Class");
				ColorVisible = data[0]["value"].includes("Color");
				MakeVisible = data[0]["value"].includes("Make");
			}
		});
	}
	var fdata1 = $("#data1").dxDateBox(
	{
		type: "datetime",
		displayFormat: "dd/MM/yyyy HH:mm:ss",
		value: dateiniday
	}).dxDateBox('instance');
	var fdata2 = $("#data2").dxDateBox(
	{
		type: "datetime",
		displayFormat: "dd/MM/yyyy HH:mm:ss",
		value: dateendday
	}).dxDateBox('instance');
	var fentitat = $("#TxPlate").dxTextBox();
	var fdir = $("#TxDir").dxTextBox();
	var paginitas = $("#paginitas").dxTextBox(
	{
		readOnly: true,
		width: 120,
		value: ""
	});
	if(ListVisible){
		if(listas.length > 0){
			$("#radio-group-simple").dxSelectBox(
			{
				dataSource: new DevExpress.data.ArrayStore(
				{
					data: listas,
					key: "ID"
				}),
				displayExpr: "description",
				valueExpr: "ID",
				value: listas[0].ID,
			});
		}
	}else{
		$("#radio-group-simple").parent().parent().remove();
	}
	var itemsNumReg = [10, 20, 50, 100];
	if (DEFINE_INTERFACE == "ZKTECO")
	{
		itemsNumReg = [5];
	}
	
	
	console.log(ClassVisible);

	if (!ClassVisible && !MakeVisible && !ColorVisible && !LaneVisible)
	{
		$("#col1").css({width: 540});
		$("#col2").remove();
		$("#col3").css({width: 550});
	}

	if(ClassVisible){
		/*var classList = [{ID: -1,Name: ''},{ID: 0,Name: 'UNKNOWN'}, {ID: 1,Name: 'MOTORBIKE'}, {ID: 2,Name: 'CAR'}, {ID: 3,Name: 'VAN'},
		 {ID: 4,Name: 'TRUCK'}, {ID: 5,Name: 'BUS'}];*/
		var fClass = $("#class_list").dxSelectBox(
		{
			dataSource: vehiclesclassds,
			valueExpr: "id",
			searchEnabled: true,
			displayExpr: "description"
		});
	}else{
		$("#lbclass").parent().remove();
	}
	
	if(MakeVisible){
		/*const makerList = [{ID: -1,Name: ''},{ID: 1,Name: 'AUDI'}, {ID: 2,Name: 'BMW'}, {ID: 3,Name: 'CHEVROLET'}, {ID: 4,Name: 'CITROEN'}, {ID: 5,Name: 'DACIA'}, {ID: 6,Name: 'FIAT'},
		 {ID: 7,Name: 'FORD'}, {ID: 8,Name: 'HONDA'}, {ID: 9,Name: 'HYUNDAI'}, {ID: 10,Name: 'KIA'},{ID: 11,Name: 'LEXUS'}, {ID: 12,Name: 'MAZDA'},
		 {ID: 13,Name: 'MERCEDES'}, {ID: 14,Name: 'MITSUBISHI'}, {ID: 15,Name: 'NISSAN'}, {ID: 16,Name: 'OPEL'},{ID: 17,Name: 'PEUGEOT'}, {ID: 18,Name: 'RENAULT'},
		 {ID: 19,Name: 'SEAT'}, {ID: 20,Name: 'SKODA'}, {ID: 21,Name: 'SUBARU'}, {ID: 22,Name: 'SUZUKI'},{ID: 23,Name: 'TOYOTA'}, {ID: 24,Name: 'VOLKSWAGEN'},
		 {ID: 25,Name: 'VOLVO'}, {ID: 26,Name: 'UNKNOWN'}, {ID: 27,Name: 'ACCURA'}, {ID: 28,Name: 'DODGE'}, {ID: 29,Name: 'JEEP'}, {ID: 30,Name: 'PONTIAC'},
		 {ID: 31,Name: 'CHERY'}, {ID: 32,Name: 'DFM'}, {ID: 33,Name: 'GREAT WALL'}, {ID: 34,Name: 'JAC'}, {ID: 35,Name: 'LAND ROVER'}, {ID: 36,Name: 'MAHINDRA'},
		 {ID: 37,Name: 'MG'}, {ID: 38,Name: 'MINI'}, {ID: 39,Name: 'SAMSUNG'}];*/
		
		var fMaker =  $("#maker_list").dxSelectBox(
		{
			dataSource: vehiclesmakeds,
			valueExpr: "id",
			searchEnabled: true,
			displayExpr: "description"
		});
	}else{
		$("#lbmaker").parent().remove();
	}

	if(ColorVisible){
		/*var dataColors = [{ID: -1,Name: ''},{ID: 1,Name: 'WHITE'}, {ID: 2,Name: 'GREY'}, {ID: 3,Name: 'BLACK'}, {ID: 4,Name: 'RED'}, {ID: 5,Name: 'ORANGE'}, {ID: 6,Name: 'YELLOW'},
		 {ID: 7,Name: 'GREEN'}, {ID: 8,Name: 'BLUE'}, {ID: 9,Name: 'PURPLE'}, {ID: 10,Name: 'UNKNOWN'}];*/
		var fColor = $("#color_list").dxSelectBox(
		{
			dataSource: vehiclescolords,
			valueExpr: "id",
			searchEnabled: true,
			displayExpr: "description"
		});
	}else{
		$("#lbcolor").parent().remove();
	}

	if(LaneVisible){
		var dataLanes = [{ID: '',Name: ''}, {ID: 'LANE',Name: 'VACIO'}, {ID: 'LANE1',Name: '1'}, {ID: 'LANE2',Name: '2'}];
		var fColor = $("#lane_list").dxSelectBox({
			dataSource: lanenames,
			valueExpr: "ID",
			displayExpr: "Name",
			value: lanenames[0].ID
		});
	}else{
		$("#lblane").parent().remove();
	}
	if(SpeedVisible){
		var minSpeed = $("#speed1").dxNumberBox();
		var maxSpeed = $("#speed2").dxNumberBox();
	}else{
		$("#lbspeed1").parent().remove();
	}

	$("#numreg").dxSelectBox(
	{
		items: itemsNumReg,
		value: itemsNumReg[0]
	});
	//direction filter
	var itemsDirList = [DevExpress.localization.formatMessage("(All Directions)"), DevExpress.localization.formatMessage("Coming"), DevExpress.localization.formatMessage("No Direction"), DevExpress.localization.formatMessage("Going")];
	if (DEFINE_INTERFACE != "ZKTECO")
	{
		if(DirectionVisible){
			$("#dirlist").dxSelectBox(
			{
				items: itemsDirList,
				value: itemsDirList[0]
			});
		}else{
			$("#dirlist").parent().parent().remove();
		}
	}
	$("#medium-indicator").dxLoadIndicator(
	{
		height: 40,
		width: 40
	});
	$("#medium-indicator").hide();
	$("#export").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("ExportBut"),
		onClick: function()
		{
			var i = 1;
			var moreparams = "";
			var plate = $('#TxPlate').dxTextBox('instance').option('value');
			if(ListVisible)
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var i_dir_selected = 0;
			if (DEFINE_INTERFACE != "ZKTECO")
			{
				if(DirectionVisible){
					dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
					if (dir_selected == DevExpress.localization.formatMessage("Coming"))
					{
						i_dir_selected = 1;
					}
					else if (dir_selected == DevExpress.localization.formatMessage("Going"))
					{
						i_dir_selected = -1;
					}
				}
			}
			if (plate != "")
			{
				moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
				i++;
			}
			if (list != -2)
			{
				if(list!=undefined){
					moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
					i++;
				}
			}
			if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
			{
				moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
				i++;
			}
			if (debugoptions)
			{
				moreparams += "&debugoptions=1"
			}

			
				
			if(ColorVisible)
			{
				var colorValue = $("#color_list").dxSelectBox('instance').option('value')
				if ((colorValue >= 0) && (colorValue != null))
				{
					moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
					i++;
				}
			}
			if(MakeVisible)
			{
				var makerValue = $("#maker_list").dxSelectBox('instance').option('value')
				if ((makerValue >= 0) && (makerValue != null))
				{
					moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
					i++;
				}
			}
			if(ClassVisible)
			{
				var classValue = $("#class_list").dxSelectBox('instance').option('value')
				if ((classValue >= 0) && (classValue != null))
				{
					moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
					i++;
				}
			}
			if(LaneVisible){
				var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
				if (laneValue != ""){
					if(laneValue=="LANE")
						laneValue = "";
					moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
					i++;
				}
			}
			if(SpeedVisible){
				var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
				var speed2 = $("#speed2").dxNumberBox('instance').option('value');	

				if(speed1 > 0 && speed2 > 0){
					if(speed2 < speed1){
						DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						return;
					}	
					moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
					i++;
				}else{		
					if (speed1 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
						i++;
					}					
					if (speed2 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
						i++;
					}
				}
			}
			if(DEFINE_INTERFACE == "HANWHA"){
				moreparams = moreparams.replaceAll("&", "|");
			}
			

				
			var win = window.open(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportresults&table=nlresult&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&date=" + getStringNormalDate(new Date()) + "&" + sortby_data + localStorage.getItem("TOKEN"), '_blank');
			if (win)
			{
				//Browser has allowed it to be openedd
				win.focus();
			}
			else
			{
				//Browser has blocked it
				alert('Please allow popups for this website');
			}
		}
	});
	$("#FirstPage").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("First page"),
		onClick: function(data2)
		{
			if($('#FirstPage').attr("sortby") != undefined){
				sortby_data = $('#FirstPage').attr("sortby");
			}

			page_actual = 1;
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var i = 1;
			var moreparams = "";
			var plate = $('#TxPlate').dxTextBox('instance').option('value');
			if(ListVisible)
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var i_dir_selected = 0;
			if (DEFINE_INTERFACE != "ZKTECO")
			{
				if(DirectionVisible){
					dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
					if (dir_selected == DevExpress.localization.formatMessage("Coming"))
					{
						i_dir_selected = 1;
					}
					else if (dir_selected == DevExpress.localization.formatMessage("Going"))
					{
						i_dir_selected = -1;
					}
				}
			}

			$("#medium-indicator").show();

			if (plate != "")
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams = "|camp" + i + "=numberplate|comp" + i + "=like|value" + i + "=" + plate;
				else
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
				i++;
			}
			if (list != -2)
			{
				if(list!=undefined){
					if(DEFINE_INTERFACE == "HANWHA")
						moreparams += "|camp" + i + "=listid|comp" + i + "=like|value" + i + "=[" + list + "]";
					else
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
					i++;
				}
			}
			if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams += "|camp" + i + "=direction|comp" + i + "=equal|value" + i + "=" + i_dir_selected;
				else
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
				i++;
			}

			if(ColorVisible){
				var colorValue = $("#color_list").dxSelectBox('instance').option('value')
				if ((colorValue >= 0) && (colorValue != null))
				{
					moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
					i++;
				}
			}
			if(MakeVisible){
				var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
				if ((makerValue >= 0) && (makerValue != null))
				{
					moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
					i++;
				}
			}
			if(ClassVisible){
				var classValue = $("#class_list").dxSelectBox('instance').option('value')					
				if ((classValue >= 0) && (classValue != null))
				{
					moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
					i++;
				}
			}
			if(LaneVisible){
				var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
				if (laneValue != ""){
					if(laneValue=="LANE")
						laneValue = "";
					moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
					i++;
				}
			}
			if(SpeedVisible){
				var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
				var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
				if(speed1 > 0 && speed2 > 0){
					if(speed2 < speed1){
						DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						return;
					}		
					moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
					i++;
				}else{		
					if (speed1 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
						i++;
					}					
					if (speed2 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
						i++;
					}
				}
			}
			if(DEFINE_INTERFACE == "HANWHA"){
				moreparams = moreparams.replaceAll("&", "|");
			}

			
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>computerid=" + computerid + "|oper=select|table=nlresult|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "|maxvalues=" + num_regs + "|offset=" + ((page_actual - 1) * num_regs) + "|date=" + getStringNormalDate(new Date()) + "|" + sortby_data+"|adinfo=notvalue</Data>";	
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data =  response;
					try {  
					    data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
						$("#medium-indicator").hide();
					    return; 
					}
					console.log("Response search: "+JSON.stringify(num_registros_consulta));
					CheckTokenValidity(data);
					var dataGrid;
					if ($('#gridContainerReview').length == 0)
					{
						dataGrid = $('#gridContainer').dxDataGrid('instance');
					}
					else
					{
						dataGrid = $('#gridContainerReview').dxDataGrid('instance');
					}
					dataGrid.option("dataSource", data);
					$("#medium-indicator").hide();
				});
			}else{	
				$("#medium-indicator").show();

				$.ajax(
				{
					dataType: "json",
					async: false,
					url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlresult&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&offset=" + ((page_actual - 1) * num_regs) + "&date=" + getStringNormalDate(new Date()) + "&" + sortby_data + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid;
						if ($('#gridContainerReview').length == 0)
						{
							dataGrid = $('#gridContainer').dxDataGrid('instance');
						}
						else
						{
							dataGrid = $('#gridContainerReview').dxDataGrid('instance');
						}
						dataGrid.option("dataSource", data);
						$("#medium-indicator").hide();
					}
				});
			}
		}
	});
	$("#LastPage").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Last page"),
		onClick: function(data2)
		{
			page_actual = num_pages;
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var i = 1;
			var moreparams = "";
			var plate = $('#TxPlate').dxTextBox('instance').option('value');
			if(ListVisible)
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var i_dir_selected = 0;
			if (DEFINE_INTERFACE != "ZKTECO")
			{
				if(DirectionVisible){
					dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
					if (dir_selected == DevExpress.localization.formatMessage("Coming"))
					{
						i_dir_selected = 1;
					}
					else if (dir_selected == DevExpress.localization.formatMessage("Going"))
					{
						i_dir_selected = -1;
					}
				}
			}

			$("#medium-indicator").show();

			if (plate != "")
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams = "|camp" + i + "=numberplate|comp" + i + "=like|value" + i + "=" + plate;
				else
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
				i++;
			}
			if (list != -2)
			{
				if(list!=undefined){
					if(DEFINE_INTERFACE == "HANWHA")
						moreparams += "|camp" + i + "=listid|comp" + i + "=like|value" + i + "=[" + list + "]";
					else
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
					i++;
				}
			}
			if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams += "|camp" + i + "=direction|comp" + i + "=equal|value" + i + "=" + i_dir_selected;
				else
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
				i++;
			}
			
			if(ColorVisible)
			{
				var colorValue = $("#color_list").dxSelectBox('instance').option('value')
				if ((colorValue >= 0) && (colorValue != null))
				{
					moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
					i++;
				}
			}
			if(MakeVisible)
			{
				var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
				if ((makerValue >= 0) && (makerValue != null))
				{
					moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
					i++;
				}
			}
			if(ClassVisible)
			{
				var classValue = $("#class_list").dxSelectBox('instance').option('value')					
				if ((classValue >= 0) && (classValue != null))
				{
					moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
					i++;
				}
			}
			if(LaneVisible){
				var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
				if (laneValue != ""){
					if(laneValue=="LANE")
						laneValue = "";
					moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
					i++;
				}
			}
			if(SpeedVisible){
				var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
				var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
				if(speed1 > 0 && speed2 > 0){
					if(speed2 < speed1){
						DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						return;
					}		
					moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
					i++;
				}else{		
					if (speed1 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
						i++;
					}					
					if (speed2 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
						i++;
					}
				}
			}
			if(DEFINE_INTERFACE == "HANWHA"){
				moreparams = moreparams.replaceAll("&", "|");
			}
			
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>" + buildPageQueryByOffset(computerid, "nlresult", fdata1, fdata2, page_actual, num_regs, moreparams, sortby_data) + "|adinfo=notvalue</Data>";		
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data =  response;
					try {  
					    data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
						$("#medium-indicator").hide();
					    return; 
					}
					console.log("Response search: "+JSON.stringify(num_registros_consulta));
					CheckTokenValidity(data);
					var dataGrid;
					if ($('#gridContainerReview').length == 0)
					{
						dataGrid = $('#gridContainer').dxDataGrid('instance');
					}
					else
					{
						dataGrid = $('#gridContainerReview').dxDataGrid('instance');
					}
					dataGrid.option("dataSource", data);

					$("#medium-indicator").hide();
				});
			}else{
				$.ajax(
				{
					dataType: "json",
					async: false,
					url: pathcgi + "cgi-bin/vparcgi.cgi?" + buildPageQueryByOffset(computerid, "nlresult", fdata1, fdata2, page_actual, num_regs, moreparams, sortby_data)  + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid;
						if ($('#gridContainerReview').length == 0)
						{
							dataGrid = $('#gridContainer').dxDataGrid('instance');
						}
						else
						{
							dataGrid = $('#gridContainerReview').dxDataGrid('instance');
						}
						dataGrid.option("dataSource", data);

						$("#medium-indicator").hide();
					}
				});
			}
		}
	});
	$("#PageAnt").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("<< Before"),
		onClick:function(data2)
		{
			if (page_actual > 1)
			{
				page_actual--;
			}
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var i = 1;
			var moreparams = "";
			var plate = $('#TxPlate').dxTextBox('instance').option('value');
			if(ListVisible)
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var i_dir_selected = 0;
			if (DEFINE_INTERFACE != "ZKTECO")
			{
				if(DirectionVisible){
					dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
					if (dir_selected == DevExpress.localization.formatMessage("Coming"))
					{
						i_dir_selected = 1;
					}
					else if (dir_selected == DevExpress.localization.formatMessage("Going"))
					{
						i_dir_selected = -1;
					}
				}
			}

			$("#medium-indicator").show();

			if (plate != "")
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams = "|camp" + i + "=numberplate|comp" + i + "=like|value" + i + "=" + plate;
				else
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
				i++;
			}
			if (list != -2)
			{
				if(list!=undefined){
					if(DEFINE_INTERFACE == "HANWHA")
						moreparams += "|camp" + i + "=listid|comp" + i + "=like|value" + i + "=[" + list + "]";
					else
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
					i++;
				}
			}
			if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams += "|camp" + i + "=direction|comp" + i + "=equal|value" + i + "=" + i_dir_selected;
				else
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
				i++;
			}

			if(ColorVisible){
				var colorValue = $("#color_list").dxSelectBox('instance').option('value')
				if ((colorValue >= 0) && (colorValue != null))
				{
					moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
					i++;
				}
			}
			if(MakeVisible){
				var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
				if ((makerValue >= 0) && (makerValue != null))
				{
					moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
					i++;
				}
			}
			if(ClassVisible){
				var classValue = $("#class_list").dxSelectBox('instance').option('value')					
				if ((classValue >= 0) && (classValue != null))
				{
					moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
					i++;
				}
			}
			if(LaneVisible){
				var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
				if (laneValue != ""){
					if(laneValue=="LANE")
						laneValue = "";
					moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
					i++;
				}
			}
			if(SpeedVisible){
				var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
				var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
				if(speed1 > 0 && speed2 > 0){
					if(speed2 < speed1){
						DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						return;
					}		
					moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
					i++;
				}else{		
					if (speed1 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
						i++;
					}					
					if (speed2 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
						i++;
					}
				}
			}
			if(DEFINE_INTERFACE == "HANWHA"){
				moreparams = moreparams.replaceAll("&", "|");
			}

					
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>" + buildPageQueryByOffset(computerid, "nlresult", fdata1, fdata2, page_actual, num_regs, moreparams, sortby_data)  + "|adinfo=notvalue</Data>";
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data =  response;

					try {  
					    data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
						$("#medium-indicator").hide();
					    return; 
					}

					console.log("Response search: "+JSON.stringify(num_registros_consulta));
					CheckTokenValidity(data);
					var dataGrid;
					if ($('#gridContainerReview').length == 0)
					{
						dataGrid = $('#gridContainer').dxDataGrid('instance');
					}
					else
					{
						dataGrid = $('#gridContainerReview').dxDataGrid('instance');
					}
					dataGrid.option("dataSource", data);
					$("#medium-indicator").hide();
				});
			}else{	
				$.ajax(
				{
					dataType: "json",
					async: false,
					url: pathcgi + "cgi-bin/vparcgi.cgi?" + buildPageQueryByOffset(computerid, "nlresult", fdata1, fdata2, page_actual, num_regs, moreparams, sortby_data)  + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid;
						if ($('#gridContainerReview').length == 0)
						{
							dataGrid = $('#gridContainer').dxDataGrid('instance');
						}
						else
						{
							dataGrid = $('#gridContainerReview').dxDataGrid('instance');
						}
						dataGrid.option("dataSource", data);
						$("#medium-indicator").hide();
					}
				});
			}
		}
	});
	$("#PageSig").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Next >>"),
		onClick: function(data2)
		{
			if (page_actual < num_pages)
			{
				page_actual++;
			}
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var i = 1;
			var moreparams = "";
			var plate = $('#TxPlate').dxTextBox('instance').option('value');
			if(ListVisible)
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var i_dir_selected = 0;
			if (DEFINE_INTERFACE != "ZKTECO")
			{
				if(DirectionVisible){
					dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
					if (dir_selected == DevExpress.localization.formatMessage("Coming"))
					{
						i_dir_selected = 1;
					}
					else if (dir_selected == DevExpress.localization.formatMessage("Going"))
					{
						i_dir_selected = -1;
					}
				}
			}

			$("#medium-indicator").show();

			if (plate != "")
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams = "|camp" + i + "=numberplate|comp" + i + "=like|value" + i + "=" + plate;
				else
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
				i++;
			}
			if (list != -2)
			{
				if(list!=undefined){
					if(DEFINE_INTERFACE == "HANWHA")
						moreparams += "|camp" + i + "=listid|comp" + i + "=like|value" + i + "=[" + list + "]";
					else
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
					i++;
				}
			}
			if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
			{
				if(DEFINE_INTERFACE == "HANWHA")
					moreparams += "|camp" + i + "=direction|comp" + i + "=equal|value" + i + "=" + i_dir_selected;
				else
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
				i++;
			}

			if(ColorVisible)
			{
				var colorValue = $("#color_list").dxSelectBox('instance').option('value')
				if ((colorValue >= 0) && (colorValue != null))
				{
					moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
					i++;
				}
			}
			if(MakeVisible)
			{
				var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
				if ((makerValue >= 0) && (makerValue != null))
				{
					moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
					i++;
				}
			}
			if(ClassVisible)
			{
				var classValue = $("#class_list").dxSelectBox('instance').option('value')					
				if ((classValue >= 0) && (classValue != null))
				{
					moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
					i++;
				}
			}
			if(LaneVisible){
				var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
				if (laneValue != ""){
					if(laneValue=="LANE")
						laneValue = "";
					moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
					i++;
				}
			}
			if(SpeedVisible){
				var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
				var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
				if(speed1 > 0 && speed2 > 0){
					if(speed2 < speed1){
						DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						return;
					}		
					moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
					i++;
				}else{		
					if (speed1 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
						i++;
					}					
					if (speed2 > 0){
						moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
						i++;
					}
				}
			}
			if(DEFINE_INTERFACE == "HANWHA"){
				moreparams = moreparams.replaceAll("&", "|");
			}

									
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>" + buildPageQueryByOffset(computerid, "nlresult", fdata1, fdata2, page_actual, num_regs, moreparams, sortby_data)  + "|adinfo=notvalue</Data>";
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data =  response;
					try {  
					    data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
						$("#medium-indicator").hide();
					    return; 
					}
					console.log("Response search: "+JSON.stringify(num_registros_consulta));
					CheckTokenValidity(data);
					var dataGrid;
					if ($('#gridContainerReview').length == 0)
					{
						dataGrid = $('#gridContainer').dxDataGrid('instance');
					}
					else
					{
						dataGrid = $('#gridContainerReview').dxDataGrid('instance');
					}
					dataGrid.option("dataSource", data);
					$("#medium-indicator").hide();
				});
			}else{	
				$.ajax(
				{
					dataType: "json",
					async: false,
					url: pathcgi + "cgi-bin/vparcgi.cgi?" + buildPageQueryByOffset(computerid, "nlresult", fdata1, fdata2, page_actual, num_regs, moreparams, sortby_data)  + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid;
						if ($('#gridContainerReview').length == 0)
						{
							dataGrid = $('#gridContainer').dxDataGrid('instance');
						}
						else
						{
							dataGrid = $('#gridContainerReview').dxDataGrid('instance');
						}
						dataGrid.option("dataSource", data);
						$("#medium-indicator").hide();
					}
				});
			}
		}
	});
	$("#PageAnt").hide();
	$("#PageSig").hide();
	$("#paginitas").hide();
	$("#FirstPage").hide();
	$("#LastPage").hide();
	if (DEFINE_INTERFACE == "ZKTECO")
	{
		$("#export").hide();
	}
	var dir_visible = true;
	$("#icon-done_info").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Search"),
		onClick: function(data2)
		{
			if (fdata1.option('value') > fdata2.option('value'))
			{
				DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("The 'from date' can not be greater than  'to date'"));
			}else if(fdata1.option('value') == undefined || fdata1.option('value') == "" || fdata2.option('value') == undefined || fdata2.option('value') == ""){
				DevExpress.ui.dialog.alert("Invalid dates.");
			}
			else
			{

				getOrder();
				var date_now = new Date();
				var date_search = new Date(fdata2.option('value'));
				if(date_search > date_now){
					console.log("Date to use: " + date_now);
					actual_date = date_now;
				}else{
					console.log("Date to use: " + date_search);
					actual_date = date_search;
				}
				if(actual_date == "Invalid date"){
					DevExpress.ui.notify("Date must be selected.", "error", 1500);
					return;
				}
				var i = 1;
				var moreparams = "";
				var plate = $('#TxPlate').dxTextBox('instance').option('value');
				if(ListVisible)
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				if(DEFINE_INTERFACE == "HANWHA")
					num_regs = 5;
				else
					num_regs = $("#numreg").dxSelectBox('instance').option('value');
				var i_dir_selected = 0;
				var show_results = false;
				var json_parse = true;
				if (DEFINE_INTERFACE != "ZKTECO")
				{
					if(DirectionVisible){
						dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
						if (dir_selected == DevExpress.localization.formatMessage("Coming"))
						{
							i_dir_selected = 1;
						}
						else if (dir_selected == DevExpress.localization.formatMessage("Going"))
						{
							i_dir_selected = -1;
						}
					}
				}
				data2.component.option("text", DevExpress.localization.formatMessage("Searching"));
				$("#medium-indicator").show();
				if (plate != "")
				{
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
					i++;
				}
				console.log("list test: " + list);
				if (list != -2)
				{
					if(list!=undefined){
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
						i++;
					}
				}
				if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
				{
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
					i++;
				}
				$("#PageSig").hide();
				$("#PageAnt").hide();
				$("#paginitas").hide();
				$("#FirstPage").hide();
				$("#LastPage").hide();
				if (DEFINE_INTERFACE == "ZKTECO")
				{
					$("#export").hide();
				}
				if(ColorVisible){
					var colorValue = $("#color_list").dxSelectBox('instance').option('value')
					if ((colorValue >= 0) && (colorValue != null))
					{
						moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
						i++;
					}
				}
				if(MakeVisible){
					var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
					if ((makerValue >= 0) && (makerValue != null))
					{
						moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
						i++;
					}
				}
				if(ClassVisible){
					var classValue = $("#class_list").dxSelectBox('instance').option('value')					
					if ((classValue >= 0) && (classValue != null))
					{
						moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
						i++;
					}
				}
				if(LaneVisible){
					var laneValue = $("#lane_list").dxSelectBox('instance').option('value');
					if (laneValue != ""){
						if(laneValue=="LANE")
							laneValue = "";
						moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
						i++;
					}
				}
				if(SpeedVisible){
					var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
					var speed2 = $("#speed2").dxNumberBox('instance').option('value');
					if(speed1 > 0 && speed2 > 0){
						if(speed2 < speed1){
							DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							return;
						}	
						moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
						i++;
					}else{		
						if (speed1 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
							i++;
						}					
						if (speed2 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
							i++;
						}
					}
				}
				if(DEFINE_INTERFACE == "HANWHA"){
					moreparams = moreparams.replaceAll("&", "|");
				}

				if(DEFINE_INTERFACE == "HANWHA"){
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=count|table=nlresult|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "|date=" + getStringNormalDate(new Date())+"|adinfo=notvalue</Data>";	
					msg += "</GetSDK_APP_DATA>";
					console.log("Test msg consulta: " + msg);
					addToQueue(msg, function(response) {
						var data =  response;
						CheckTokenValidity(data);
						num_registros_consulta = data;
						console.log("Response search: "+JSON.stringify(num_registros_consulta));
						if (num_registros_consulta > 0)
						{
							var msg2 = "";
							msg2 += "<GetSDK_APP_DATA>";
							msg2 += "<AppName>NeuralEdge</AppName>";
							msg2 += "<Data>computerid=" + computerid + "|oper=select|table=nlresult|maxvalues=" + num_regs + "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "|date=" + getStringNormalDate(new Date()) + "|" + sortby_data+"|adinfo=notvalue</Data>";	
							msg2 += "</GetSDK_APP_DATA>";
							addToQueue(msg2, function(response) {
								var data2Res =  response;
								CheckTokenValidity(data2Res);
								var json_data;
								try {  
								    json_data = JSON.parse(data2Res); 
								    show_results = true;
								} catch (e) {  
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
									DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
								    console.log('invalid json'); 
								    return; 
								}
								console.log("search result: " + JSON.stringify(json_data));
								console.log("show results? " + show_results);
								data2.component.option("text", DevExpress.localization.formatMessage("Search"));
								$("#medium-indicator").hide();
								if (show_results)
								{
									var dataGrid;
									if ($('#gridContainerReview').length == 0)
									{
										dataGrid = $('#gridContainer').dxDataGrid('instance');
									}
									else
									{
										dataGrid = $('#gridContainerReview').dxDataGrid('instance');
									}
									dataGrid.option('paging.pageSize', num_regs);
									page_actual = 1;
									num_pages = Math.ceil(num_registros_consulta / num_regs);
									$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
									if (num_pages > 1)
									{
										$("#PageAnt").show();
										$("#PageSig").show();
										$("#paginitas").show();
										$("#FirstPage").show();
										$("#LastPage").show();
									}
									if (DEFINE_INTERFACE == "ZKTECO")
									{
										$("#export").show();
									}
									dataGrid.option("dataSource", json_data);
								}
							});
						}else{
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							var dataGrid;
							if ($('#gridContainerReview').length == 0)
							{
								dataGrid = $('#gridContainer').dxDataGrid('instance');
							}
							else
							{
								dataGrid = $('#gridContainerReview').dxDataGrid('instance');
							}
							dataGrid.option("dataSource", []);
						}
					});
				}else{
					$.ajax(
					{
						async: false,
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=count&table=nlresult&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&date=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						success: function(data)
						{
							CheckTokenValidity(data);
							num_registros_consulta = data;
						}
					});
				}
				if (num_registros_consulta > 0)
				{
					if(DEFINE_INTERFACE == "HANWHA"){
					}else{
						var url_data = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlresult&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&date=" + getStringNormalDate(new Date()) + "&" + sortby_data + localStorage.getItem("TOKEN");
						$.ajax(
						{
							dataType: "json",
							url: url_data,
							jsonp: false,
							timeout: 10000,
							cache: false,
							dataFilter: function(data, type)
							{
								CheckTokenValidity(data);
								try
								{
									console.log(JSON.parse(data));
								}
								catch (e)
								{
									data2.component.option("text", DevExpress.localization.formatMessage("Search"));
									$("#medium-indicator").hide();
									json_parse = false;
									if (DEFINE_INTERFACE == "ZKTECO")
									{
										confirm(DevExpress.localization.formatMessage("Cannot obtain the results"));
									}
									else
									{
										DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
										DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
									}
								}
								if (json_parse)
								{
									json_data = JSON.parse(data);
								}
							},
							success: function(data, text_status, query)
							{
								show_results = true;
							},
							error: function(query, error_text_status, error_thrown)
							{
								if (error_text_status == "parsererror")
								{
									show_results = true;
									repeat_idx = 0;
								}
								else
								{
									if (repeat_idx < 5)
									{
										repeatSearchRequest(url_data);
										repeat_idx = repeat_idx + 1;
									}
									else
									{
										repeat_idx = 0;
										DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
									}
								}
							},
							complete: function(query, text_status)
							{
								data2.component.option("text", DevExpress.localization.formatMessage("Search"));
								$("#medium-indicator").hide();
								if (show_results)
								{
									var dataGrid;
									if ($('#gridContainerReview').length == 0)
									{
										dataGrid = $('#gridContainer').dxDataGrid('instance');
									}
									else
									{
										dataGrid = $('#gridContainerReview').dxDataGrid('instance');
									}
									dataGrid.option('paging.pageSize', num_regs);
									page_actual = 1;
									num_pages = Math.ceil(num_registros_consulta / num_regs);
									$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
									if (num_pages > 1)
									{
										$("#PageAnt").show();
										$("#PageSig").show();
										$("#paginitas").show();
										$("#FirstPage").show();
										$("#LastPage").show();
									}
									if (DEFINE_INTERFACE == "ZKTECO")
									{
										$("#export").show();
									}
									dataGrid.option("dataSource", json_data);
								}
							}
						});
					}
				}
				else
				{
					data2.component.option("text", DevExpress.localization.formatMessage("Search"));
					$("#medium-indicator").hide();
					var dataGrid;
					if ($('#gridContainerReview').length == 0)
					{
						dataGrid = $('#gridContainer').dxDataGrid('instance');
					}
					else
					{
						dataGrid = $('#gridContainerReview').dxDataGrid('instance');
					}
					dataGrid.option("dataSource", []);
				}
			}
		}
	});
	var gridName = "#gridContainerReview";
	if ($(gridName).length == 0)
	{
		gridName = "#gridContainer";
	}
	if(DEFINE_INTERFACE!="HANWHA")
		loadGrid();
	function loadGrid(){
	$(gridName).dxDataGrid(
	{
		dataSource: results,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		hoverStateEnabled: true,
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		pager:
		{
			visible: false
		},
		onToolbarPreparing: function(e)
		{
			var dataGrid = e.component;
			if (DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "AXIS" || DEFINE_INTERFACE == "VICON" || DEFINE_INTERFACE == "VIVOTEK_CV25" || DEFINE_INTERFACE == "HANWHA")
			{
				return;
			}
			e.toolbarOptions.items.unshift(
			{
				location: "center",
				widget: "dxTextBox",
				width: 120,
				readOnly: true,
				template: function()
				{
					var div = $("<div/>");
					div.attr('id', 'paginitas');
					div.dxTextBox(
					{
						readOnly: true,
						width: 120,
						value: ""
					});
					div.hide();
					return div;
				}
			});
		},
		columns: [
		{
			dataField: "id",
			caption: "ID",
			width: 80,
			alignment: 'center',
			calculateSortValue: function (rowData) {
                return rowData.id;
            }
		},
		{
			dataField: "timestamp",
			dataType: "date",
			caption: DevExpress.localization.formatMessage("Time"),
			width: 180,
			alignment: 'center',
			format: "HH:mm:ss.SSS dd/MM/yyyy",
			calculateSortValue: function (rowData) {
                return rowData.timestamp;
            }
		},
		{
			dataField: "numberplate",
			width: 100,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("Plate"),
			calculateSortValue: function (rowData) {
                return rowData.numberplate;
            }
		},
		{
			dataField: "laneid",
			width: 80,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("Lane"),
			visible: LaneVisible, 
			cellTemplate: function(element, info)
			{
				if (info.text == 0){
					element.append("");
				}
				else{
					var name = "";
					for(var i = 0; i < lanenames.length; i++){
						if(info.text == lanenames[i].ID){
							name = lanenames[i].Name;
						}
					}
					element.append(name);
				}
			},
			calculateSortValue: function (rowData) {
                return rowData.laneid;
            }
		},
		{
			dataField: "direction",
			width: 120,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("Direction"),
			visible: DirectionVisible,
			cellTemplate: function(element, info)
			{
				if (info.text == 0)
				{
					element.append(DevExpress.localization.formatMessage("No Direction"));
				}
				else if (info.text == 1)
				{
					element.append(DevExpress.localization.formatMessage("Coming"));
				}
				else if (info.text == -1)
				{
					element.append(DevExpress.localization.formatMessage("Going"));
				}
			},
			calculateSortValue: function (rowData) {
                return rowData.direction;
            }
		},
		{
			dataField: "speed",
			width: 100,
			alignment: 'center',
			visible: SpeedVisible, 
			caption: DevExpress.localization.formatMessage("Speed"),
			calculateSortValue: function (rowData) {
                return parseFloat(rowData.speed);
            }
		},
		{
			dataField: "globalconfidence",
			width: 100,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("Conf."),
			visible: ConfVisible,
			calculateSortValue: function (rowData) {
                return parseFloat(rowData.globalconfidence);
            }
		},
		{
			dataField: "averagecharheight",
			width: 60,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("Height"),
			visible: HeightVisible,
			calculateSortValue: function (rowData) {
                return parseFloat(rowData.averagecharheight);
            }
		}, 
		{
			dataField: "country",
			width: 150,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("CountryState"),
			visible: CountryVisible,
			cellTemplate: function(element, info)
			{
				console.log(JSON.stringify(dict))
				element.append(dict[info.text]);
			},
			calculateSortValue: function (rowData) {
                return rowData.country;
            }
		},
		{
			dataField: "listid",
			width: 150,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("List"),
			visible: ListVisible,
			cellTemplate: function(element, info)
			{
				if (info.text != "[-1]")
				{
					var listastring = "";
					if (info.text.includes(";"))
					{
						var listas = info.text.split(";");
						$.each(listas, function(i, item)
						{
							listastring += dictlist[item] + ";";
						});
						listastring = listastring.slice(0, -1);
					}
					else
					{
						listastring = dictlist[info.text];
					}
					element.append(listastring);
				}
				else
				{
					element.append("");
				}
			},
			calculateSortValue: function (rowData) {
                return rowData.listid;
            }
		},
		{
			dataField: "veclass_str",
			width: 100,
			alignment: 'center',
			caption: function() {
				
				return getClassColorColumnName(ClassVisible, ColorVisible);
			},
			calculateCellValue: function(rowData) {
				return rowData.veclass_str.replace(/NLVEHICLE_CLASS_/g,'').toLowerCase() +"_"+ rowData.color_str.toLowerCase();
			},
			cellTemplate: function(element, info)
			{	
				element.css({textAlign: "center"});
				var tooltipText = info.text.split("_")[0]+" - "+info.text.split("_")[1];
				if(tooltipText == " - ")
					tooltipText="";
				element.append("<img title='"+tooltipText+"' src='" + getClassColorIcon(info.text, ClassVisible, ColorVisible) + "' height = '20' width='20'>");
			},
			visible: (ClassVisible || ColorVisible)
		},
		{
			dataField: "make_str",
			width: 100,
			alignment: 'center',
			caption: DevExpress.localization.formatMessage("Make"),
			visible: MakeVisible
		},
		{
			dataField: "imageretailpath",
			caption: DevExpress.localization.formatMessage("Image"),
			width: 150,
			alignment: 'center',
			cellTemplate: function(element, info)
			{
				if (info.text != "")
				{
					if(DEFINE_INTERFACE == "HANWHA"){
						var serverName	= window.location.host;
						var serverType = "http://";
						var imgPath = info.text.replace("/mnt/mmcblk0p1/opensdk/NeuralEdge/images/","/home/setup/opensdk/html/NeuralEdge/imagesres/")
						
						console.log("new image path: " + serverType + serverName + imgPath);
						var tmpImg = serverType + serverName + imgPath;
											
						element.append("<img id='icimg" + info.key + "' src='" + tmpImg+ "' height = '20' width='125'><div id='tooltip" + info.key + "'></div>")
					}else{
							element.append("<img id='icimg" + info.key + "' src='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getimage&path=" + info.text + localStorage.getItem("TOKEN") + "' height = '20' width='125'><div id='tooltip" + info.key + "'></div>")
					}
					if (info.row.data.imagepath != "")
					{
						CreateToolTip(info.key, info.row.data.evidences, info.row.data.imagepath, info.row.data.resultleft, info.row.data.resulttop, info.row.data.resultright, info.row.data.resultbottom, info.row.data.width, info.row.data.height);
					}
				}
				else
				{
					element.append(DevExpress.localization.formatMessage("No image"));
				}
			},
			calculateSortValue: function (rowData) {
				return rowData.imageretailpath;
			}
		},
		{
			dataField: "imagepath",
			caption: DevExpress.localization.formatMessage("Image"),
			width: 100,
			alignment: 'center',

			cellTemplate: function(element, info)
			{
				if (info.text != "")
				{
					if(DEFINE_INTERFACE == "HANWHA"){
						var serverName	= window.location.host;
						var serverType = "http://";
						var imgPath = info.text.replace("/mnt/mmcblk0p1/opensdk/NeuralEdge/images/","/home/setup/opensdk/html/NeuralEdge/imagesres/")
						
						console.log("new image path: " + serverType + serverName + imgPath);
						var tmpImg = serverType + serverName + imgPath;
											
						element.append("<a  href='"+tmpImg+"' download>LPR</a>")
						var i;
						for (i = 1; i <= info.row.data.evidences; i++)
						{
						    if((info.row.data.evidences == 1) && (existFile(info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg") == false))
							{
								element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + 2 + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + 2 + "</a>")
							}
							else
							{
								element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + i + "</a>")
							}
						}
					}else{
						element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text + localStorage.getItem("TOKEN") + "'>LPR</a>")
						var i;
						for (i = 1; i <= info.row.data.evidences; i++)
						{
						    if((info.row.data.evidences == 1) && (existFile(info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg") == false))
							{
								element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + 2 + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + 2 + "</a>")
							}
							else
							{
								element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + i + "</a>")
							}
						}
					}
				}
				else
				{
					element.append(DevExpress.localization.formatMessage("No image"));
				}
			},
			calculateSortValue: function (rowData) {
				return rowData.imagepath;
			}
		}],
		onRowPrepared: function(row)
		{
			var order ="";

			if($('#dx-col-1').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-1').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-1').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-1').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=id"); $("#FirstPage").trigger("click"); return false;');
			
			if($('#dx-col-2').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-2').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-2').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-2').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=timestamp"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-3').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-3').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-3').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-3').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=numberplate"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-4').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-4').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-4').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-4').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=laneid"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-5').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-5').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-5').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-5').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=direction"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-6').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-6').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-6').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-6').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=speed"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-7').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-7').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-7').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-7').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=globalconfidence"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-8').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-8').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-8').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-8').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=averagecharheight"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-9').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-9').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-9').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-9').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=country"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-10').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-10').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-10').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-10').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=listid"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-11').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-11').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-11').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-11').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=veclass"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-12').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-12').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-12').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-12').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=make"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-13').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-13').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-13').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-13').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=imageretailpath"); $("#FirstPage").trigger("click"); return false;');

			if($('#dx-col-14').attr('aria-sort') == "none")order = "sortasc";
			if($('#dx-col-14').attr('aria-sort') == "descending")order = "sortasc";
			if($('#dx-col-14').attr('aria-sort') == "ascending")order = "sortdesc";
			$('#dx-col-14').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=imagepath"); $("#FirstPage").trigger("click"); return false;');
				
			if (row.rowType == "data")
			{
				if(ListVisible){
					if(row.values.indexOf("[-1]") == -1)
								row.rowElement.addClass('Red');
				}
			}
		}
	});
}

	function repeatSearchRequest(data_url)
	{
		var show_results = false;
		var json_parse = true;
		$.ajax(
		{
			dataType: "json",
			url: data_url,
			jsonp: false,
			timeout: 10000,
			cache: false,
			dataFilter: function(data, type)
			{
				CheckTokenValidity(data);
				try
				{
					console.log(JSON.parse(data));
				}
				catch (e)
				{
					data2.component.option("text", DevExpress.localization.formatMessage("Search"));
					$("#medium-indicator").hide();
					json_parse = false;
					if (DEFINE_INTERFACE == "ZKTECO")
					{
						confirm(DevExpress.localization.formatMessage("Cannot obtain the results"));
					}
					else
					{
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					}
				}
				if (json_parse)
				{
					json_data = JSON.parse(data);
				}
			},
			success: function(data, text_status, query)
			{
				show_results = true;
			},
			error: function(query, error_text_status, error_thrown)
			{
				if (error_text_status == "parsererror")
				{
					show_results = true;
					repeat_idx = 0;
				}
				else
				{
					if (repeat_idx < 5)
					{
						repeatSearchRequest(data_url);
						repeat_idx = repeat_idx + 1;
					}
					else
					{
						repeat_idx = 0;
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
					}
				}
			},
			complete: function(query, text_status)
			{
				$("#medium-indicator").hide();
				if (show_results)
				{
					var dataGrid;
					if ($('#gridContainerReview').length == 0)
					{
						dataGrid = $('#gridContainer').dxDataGrid('instance');
					}
					else
					{
						dataGrid = $('#gridContainerReview').dxDataGrid('instance');
					}
					dataGrid.option('paging.pageSize', num_regs);
					page_actual = 1;
					num_pages = Math.ceil(num_registros_consulta / num_regs);
					$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
					if (num_pages > 1)
					{
						$("#PageAnt").show();
						$("#PageSig").show();
						$("#paginitas").show();
						$("#FirstPage").show();
						$("#LastPage").show();
					}
					if (DEFINE_INTERFACE == "ZKTECO")
					{
						$("#export").show();
					}
					dataGrid.option("dataSource", json_data);
				}
			}
		});
	}

	function getOrder(){
		sortby_data = "sortasc=id";

		if($('#dx-col-1').attr('aria-sort') == "descending")sortby_data = "sortdesc=id";
		if($('#dx-col-1').attr('aria-sort') == "ascending")sortby_data = "sortasc=id";

		if($('#dx-col-2').attr('aria-sort') == "descending")sortby_data = "sortdesc=timestamp";
		if($('#dx-col-2').attr('aria-sort') == "ascending")sortby_data = "sortasc=timestamp";

		if($('#dx-col-3').attr('aria-sort') == "descending")sortby_data = "sortdesc=numberplate";
		if($('#dx-col-3').attr('aria-sort') == "ascending")sortby_data = "sortasc=numberplate";

		if($('#dx-col-4').attr('aria-sort') == "descending")sortby_data = "sortdesc=laneid";
		if($('#dx-col-4').attr('aria-sort') == "ascending")sortby_data = "sortasc=laneid";

		if($('#dx-col-5').attr('aria-sort') == "descending")sortby_data = "sortdesc=direction";
		if($('#dx-col-5').attr('aria-sort') == "ascending")sortby_data = "sortasc=direction";

		if($('#dx-col-6').attr('aria-sort') == "descending")sortby_data = "sortdesc=speed";
		if($('#dx-col-6').attr('aria-sort') == "ascending")sortby_data = "sortasc=speed";

		if($('#dx-col-7').attr('aria-sort') == "descending")sortby_data = "sortdesc=globalconfidence";
		if($('#dx-col-7').attr('aria-sort') == "ascending")sortby_data = "sortasc=globalconfidence";

		if($('#dx-col-8').attr('aria-sort') == "descending")sortby_data = "sortdesc=averagecharheight";
		if($('#dx-col-8').attr('aria-sort') == "ascending")sortby_data = "sortasc=averagecharheight";

		if($('#dx-col-9').attr('aria-sort') == "descending")sortby_data = "sortdesc=country";
		if($('#dx-col-9').attr('aria-sort') == "ascending")sortby_data = "sortasc=country";

		if($('#dx-col-10').attr('aria-sort') == "descending")sortby_data = "sortdesc=listid";
		if($('#dx-col-10').attr('aria-sort') == "ascending")sortby_data = "sortasc=listid";

		if($('#dx-col-11').attr('aria-sort') == "descending")sortby_data = "sortdesc=veclass";
		if($('#dx-col-11').attr('aria-sort') == "ascending")sortby_data = "sortasc=veclass";

		if($('#dx-col-12').attr('aria-sort') == "descending")sortby_data = "sortdesc=make";
		if($('#dx-col-12').attr('aria-sort') == "ascending")sortby_data = "sortasc=make";

		if($('#dx-col-13').attr('aria-sort') == "descending")sortby_data = "sortdesc=imageretailpath";
		if($('#dx-col-13').attr('aria-sort') == "ascending")sortby_data = "sortasc=imageretailpath";

		if($('#dx-col-14').attr('aria-sort') == "descending")sortby_data = "sortdesc=imagepath";
		if($('#dx-col-14').attr('aria-sort') == "ascending")sortby_data = "sortasc=imagepath";
	}
});
