////////////////////////////
// LPR CONFIGURATION PAGE //
////////////////////////////

$(function()
{
	Init_translate();
	make_header("camconfiguration");
	set_rcpopup();
	var locations;
	var resx = 0;
	var resy = 0;
	var dict = {};
	var multioptdict = {};
	var ident = 0;
	var countries;
	var regions;
	var selected_region = 0;
	var countriesds;
	var countryelem;
	var cross_lista;
	var crossdatagrid;
	var crosslineediting = -1;
	var actdict = {};
	var resolutions;
	var mincharh;
	var resotext = [DevExpress.localization.formatMessage("Do not allow motorbikes"), DevExpress.localization.formatMessage("Allow motorbikes")];
	/*var modearray = [
	{
		"id": 1,
		"description": DevExpress.localization.formatMessage("Entering")
	},
	{
		"id": 2,
		"description": DevExpress.localization.formatMessage("Leaving")
	},
	{
		"id": 3,
		"description": DevExpress.localization.formatMessage("Both")
	}];*/
	
	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};
	
	String.prototype.insert = function(index, string)
	{
		if (index > 0)
			return this.substring(0, index) + string + this.substring(index, this.length);
		return string + this;
	};
	var loadPanel = $(".loadpanel").dxLoadPanel(
	{
		shadingColor: "rgba(0,0,0,0.4)",
		position:
		{
			of: "#tooplate_main"
		},
		visible: false,
		showIndicator: true,
		showPane: true,
		shading: true,
		message: DevExpress.localization.formatMessage("Restarting..."),
		closeOnOutsideClick: false
	}).dxLoadPanel("instance");
	var btroi;
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlregion&maxvalues=250&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			regions = data;
		}
	});
	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nllocation&maxvalues=250&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			locations = data;
		}
	});
	var locationsds = new DevExpress.data.DataSource(
	{
		store: locations,
		key: "id",
	});
	var regionds = new DevExpress.data.DataSource(
	{
		store: regions,
		key: "id",
	});
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getident" + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			ident = data;
		}
	});
	$("#restartserv").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Restart service"),
		onClick: function()
		{
			loadPanel.show();
			lp = loadPanel;
			restartapp();
		}
	});
	$("#restartdefault").dxButton(
	{
		type: "default",
		text: DevExpress.localization.formatMessage("Restart default configuration"),
		onClick: function()
		{
			var result = DevExpress.ui.dialog.confirm(DevExpress.localization.formatMessage("Are you sure to restart default configuration?"), DevExpress.localization.formatMessage("Default configuration"));
			result.done(function(dialogResult)
			{
				if (dialogResult)
				{
					$.ajax(
					{
						dataType: "json",
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=defaultcameraconfig" + localStorage.getItem("TOKEN"),
						async: false,
						success: function(data)
						{
							if (CHECK_USER)
							{
								if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
								{
									var urlCam = window.location.href;
									console.log(urlCam);
									urlCam = urlCam.split(":8090")[0] + ":80";
									if (confirm(data))
									{
										window.location.href = urlCam;
									}
									else
									{
										window.location.href = urlCam;
									}
								}
							}
						}
					});
                    resetLANES();
					location.reload();
				}
			});
		}
	});
	//$.getJSON(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfcamera&maxvalues=250&camp0=cameraid&comp0=minor&value0=2&d="+ getStringNormalDate(new Date())).done(function (data) {
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfcamera&maxvalues=250&camp0=cameraid&comp0=minor&value0=2&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='ROIheader' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Roi") + "hhhh</div> ");
			$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlROI'  ></div> ");
			$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='LH1' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Lanes") + "</div> ");
			$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlLANES'  ></div> ");
			$("#fiedlROI").hide();
			$("#fiedlLANES").hide();
			$("#LH1").click(function()
			{
				if ($("#LH1").hasClass("abierto"))
				{
					$(this).removeClass('abierto');
					$(this).addClass('cerrado');
					$("#fiedlLANES").hide();
				}
				else
				{
					$(this).addClass('abierto');
					$(this).removeClass('cerrado');
					$("#fiedlLANES").show();
				}
			});
			//First bucle to create checkbox and div
			$.each(data, function(i, item)
			{
				if (item.grouppar != "")
				{
					if (typeof dict[item.grouppar] === "undefined")
					{
						item.indexg = i;
						dict[item.grouppar] = i;
						var toadd = "<div class='dx-fieldset-header cerrado' id='group" + i + "' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage(item.grouppar) + "</div> ";
						toadd += "<div class='dx-fieldset' id= 'fiedl" + i + "'  ></div>";
						$(".content_wrapper").append(toadd);
						$("#fiedl" + i).hide();
						$("#group" + i).click(function()
						{
							if ($("#group" + i).hasClass("abierto"))
							{
								$(this).removeClass('abierto');
								$(this).addClass('cerrado');
								$("#fiedl" + i).hide();
								listplatesabierto = false;
							}
							else
							{
								$(this).addClass('abierto');
								$(this).removeClass('cerrado');
								$("#fiedl" + i).show();
								listplatesabierto = true;
							}
						});
					}
					else
					{
						item.indexg = dict[item.grouppar];
					}
				}
				else
				{
					item.indexg = -1;
				}
				if (item.id == 57)
				{
					if (item.name.includes("umresolution"))
					{
						var resopt = (item.value).split("x");
						resx = resopt[0];
						resy = resopt[1];
						resolutions = (item.options).split(";");
					}
				}
			});
			$.each(data, function(i, item)
			{
				if (item.visible == 1)
				{
					if (item.typepar == "int")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "'></div></div></div>");
						var valopt = (item.options).split(";");
						$("#elem" + i).dxNumberBox(
						{
							value: item.value,
							min: valopt[0],
							max: valopt[1],
							showSpinButtons: true,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							}
						});
					}
					else if (item.typepar == "multioption")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value' id='multioption" + i + "'></div></div>");
						var valopt = (item.options).split(";");
						var valvalue = (item.value).split(";");
						var options_disabled = false;
						if (item.name == "trigger_io_type") //disable trigger options
						{
							options_disabled = true;
						}
						multioptdict["multioption" + i] = [];
						$.each(valvalue, function(k, itemvalue)
						{
							multioptdict["multioption" + i].push(itemvalue);
						});
						$.each(valopt, function(j, itemoptions)
						{
							$("#multioption" + i).append("<div id='elem" + i + "-" + j + "' style='float: left;margin-right: 10px;' ></div>");
							$("#elem" + i + "-" + j).dxCheckBox(
							{
								value: item.value.includes(itemoptions),
								text: itemoptions,
								disabled: options_disabled,
								onValueChanged: function(e)
								{
									var newValue = e.value;
									if (newValue)
									{
										multioptdict["multioption" + i].push(e.element[0].textContent);
									}
									else
									{
										var index = multioptdict["multioption" + i].indexOf(e.element[0].textContent);
										if (index > -1)
										{
											multioptdict["multioption" + i].splice(index, 1);
										}
									}
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + multioptdict["multioption" + i].toString().replace(/,/g, ';') + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
										.done(function()
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
								}
							});
						});
					}
					else if (item.typepar == "nllocation")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item.text + "</div><div class='dx-field-value'><div id='location'></div></div></div>");
						$("#location").dxSelectBox(
						{
							dataSource: locationsds,
							valueExpr: "id",
							searchEnabled: true,
							value: parseInt(item.value, 10),
							displayExpr: "description",
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							}
						});
					}
					else if (item.typepar == "nlregion")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='region'></div></div></div>");
						$("#region").dxSelectBox(
						{
							dataSource: regionds,
							valueExpr: "id",
							searchEnabled: true,
							value: parseInt(item.value, 10),
							displayExpr: "description",
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								$.ajax(
								{
									dataType: "json",
									url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcountry&comp0=equal&camp0=regionid&value0=" + newValue + "&maxvalues=250" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
									async: false,
									success: function(data)
									{
										if (CHECK_USER)
										{
											if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
											{
												var urlCam = window.location.href;
												console.log(urlCam);
												urlCam = urlCam.split(":8090")[0] + ":80";
												if (confirm(data))
												{
													window.location.href = urlCam;
												}
												else
												{
													window.location.href = urlCam;
												}
											}
										}
										$("#country").dxTagBox("instance").option("dataSource", data);
										$("#country").dxTagBox("instance").reset();
									}
								});
								var jqxhr = $.ajax(
								{
									url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=2&camp1=value&value1=&camp2=computerid&value2=" + computerid + "&camp3=cameraid&value3=-1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
									async: false,
									success: function(data)
									{
										if (CHECK_USER)
										{
											if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
											{
												var urlCam = window.location.href;
												console.log(urlCam);
												urlCam = urlCam.split(":8090")[0] + ":80";
												if (confirm(data))
												{
													window.location.href = urlCam;
												}
												else
												{
													window.location.href = urlCam;
												}
											}
										}
										DevExpress.ui.notify("Data saved", "success", 600);
									}
								});
								var jqxhr = $.ajax(
								{
									url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=-1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
									async: false,
									success: function(data)
									{
										if (CHECK_USER)
										{
											if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
											{
												var urlCam = window.location.href;
												console.log(urlCam);
												urlCam = urlCam.split(":8090")[0] + ":80";
												if (confirm(data))
												{
													window.location.href = urlCam;
												}
												else
												{
													window.location.href = urlCam;
												}
											}
										}
										DevExpress.ui.notify("Data saved", "success", 600);
									}
								});
							}
						});
						selected_region = item.value;
						$.ajax(
						{
							dataType: "json",
							url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcountry&comp0=equal&camp0=regionid&value0=" + selected_region + "&maxvalues=250" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
							async: false,
							success: function(data)
							{
								if (CHECK_USER)
								{
									if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
									{
										var urlCam = window.location.href;
										console.log(urlCam);
										urlCam = urlCam.split(":8090")[0] + ":80";
										if (confirm(data))
										{
											window.location.href = urlCam;
										}
										else
										{
											window.location.href = urlCam;
										}
									}
								}
								countriesds = new DevExpress.data.DataSource(
								{
									store: data,
									key: "id",
								});
							}
						});
					}
					else if (item.typepar == "nlcountry")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='country'></div></div></div>");
						var valopt = (item.value).split(";");
						var valores = [];
						$.each(valopt, function(i, item)
						{
							valores.push(parseInt(item));
						});
						// Fix for bug #3314 regarding the presence of NaN in the list of countries
						if (valores.length >= 1)
						{
							if (isNaN(valores[0]))
							{
								valores = [];
							}
						}
						$("#country").dxTagBox(
						{
							dataSource: countriesds,
							valueExpr: "id",
							searchEnabled: true,
							value: valores,
							displayExpr: "description",
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								var counts = "";
								$.each(newValue, function(i, item)
								{
									counts += item + ";";
								});
								counts = counts.substring(0, counts.length - 1);
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + counts + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=-1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									})
							}
						});
					}
					if (item.typepar == "bool")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
						var isTrueSet = (item.value == 'true');
						$("#elem" + i).dxCheckBox(
						{
							value: isTrueSet,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							}
						});
					}
					if (item.typepar == "info")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).prepend(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
						var mh = 400;
						var mw = 600;
						if (item.help == "infoffcamera.html" || item.help == "infoexpertcamera-n.html" || item.help == "infoexpertcamera-o.html" || item.help == "infoexpertcamera-z.html")
						{
							mh = 700;
							mw = 600;
						}
						$("#elem" + i).dxButton(
						{
							icon: "help",
							type: "success",
							mode: "contained",
							onClick: function(e)
							{
								var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
									.done(function(data)
									{
										$("#popupinfo" + i).append(data);
										var poup = $("#popupinfo" + i).dxPopup(
										{
											showTitle: true,
											title: DevExpress.localization.formatMessage("Help"),
											visible: true,
											maxWidth: mw,
											maxHeight: mh,
											loseOnOutsideClick: true
										});
									});
							}
						});
					}
					if (item.typepar == "string")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
						var passmode = "Text";
						if (item.text == "Password:") passmode = "password";
						$("#elem" + i).dxTextBox(
						{
							value: item.value,
							mode: passmode,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								newValue = newValue.replace(/\\/g, '/');
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + encodeURIComponent(newValue) + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							}
						});
					}
					if (item.typepar == "option")
					{
						var valopt = (item.options).split(";");
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						var helpdiv = "";
						if (item.help != "")
						{
							helpdiv = "<div id='icon" + i + "'></div><div id='popup" + i + "' style='display:none' ></div> ";
						}
						var item_name = DevExpress.localization.formatMessage(item.text);
						$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item_name + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
						if (item.help != "")
						{
							var mh = 250;
							var mw = 500;
							if (item.help == "help_mode_camera.html")
							{
								mh = 400;
								mw = 800;
							}
							$("#icon" + i).dxButton(
							{
								icon: "help",
								type: "success",
								mode: "contained",
								onClick: function(e)
								{
									var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
										.done(function(data)
										{
											$("#popup" + i).append(data);
											var poup = $("#popup" + i).dxPopup(
											{
												showTitle: true,
												title: DevExpress.localization.formatMessage("Help"),
												visible: true,
												maxWidth: mw,
												maxHeight: mh,
												loseOnOutsideClick: true
											});
										});
								}
							});
						}
						var isTrueSet = (item.value == 'true');
						//if (item.text.includes("umresolution")) {
						//    var resopt = (item.value).split("x");
						//    resx = resopt[0];
						//    resy = resopt[1];
						//}
						var dict_translations = {};
						var current_val;
						if ((item.name == 'camposition') || (item.name == 'ff_filtermode'))
						{
							valopt.forEach(function(element, index)
							{
								dict_translations[DevExpress.localization.formatMessage(element)] = element;
								valopt[index] = DevExpress.localization.formatMessage(element);
							})
							current_val = DevExpress.localization.formatMessage(item.value);
						}
						else
						{
							valopt.forEach(function(element, index)
							{
								dict_translations[element] = element;
							})
							current_val = item.value
						}
						$("#elem" + i).dxRadioGroup(
						{
							items: valopt,
							value: current_val,
							layout: "horizontal",
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = dict_translations[e.value];
								//if (newValue.includes("x")) {
								//    var resopt = (newValue).split("x");
								//    resx = resopt[0];
								//    resy = resopt[1];
								//}
								// Event handling commands go here
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
								if (item.id == 4)
								{
									if (newValue == 'Do not allow motorbikes')
									{
										newValue = resolutions[0];
									}
									else
									{
										newValue = resolutions[1];
									}
									var resopt = newValue.split("x");
									resx = resopt[0];
									resy = resopt[1];
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=57&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
										.done(function()
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
								}
							}
						});
					}
					if (item.typepar == "roi")
					{
						var normalexper = "";
						if (item.indexg == -1)
						{
							normalexper = "#field";
						}
						else
						{
							normalexper = "#fiedl" + item.indexg;
						}
						$("#fiedlROI").append(" <div class='dx-field' id ='ROICANVAS'  ><div id='icon-done_info'></div><br><br><img src='./images/ROIGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvas' width='800' height='600' '></canvas><img id = 'mono' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
						$("#ROIheader").click(function()
						{
							if ($("#ROIheader").hasClass("abierto"))
							{
								$(this).removeClass('abierto');
								$(this).addClass('cerrado');
								$("#fiedlROI").hide();
							}
							else
							{
								$(this).addClass('abierto');
								$(this).removeClass('cerrado');
								$("#fiedlROI").show();
							}
						});
						var valopt = (item.value).split(";");
						var sroi = "";
						if (valopt[0] != 0 || valopt[1] != 0 || valopt[2] != 0 || valopt[3] != 0)
						{
							sroi = " (" + valopt[0] + ";" + valopt[1] + ";" + valopt[2] + ";" + valopt[3] + ")";
						}
						$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + sroi);
						btroi = $("#icon-done_info").dxButton(
						{
							type: "success",
							text: DevExpress.localization.formatMessage("Reset ROI"),
							onClick: function()
							{
								resetROI();
							}
						}).dxButton('instance');;
						var canvas = document.getElementById('canvas');
						var ctx = canvas.getContext('2d');
						var img = document.getElementById("mono");
						var tmpImg = new Image();
						tmpImg.src = $('#mono').attr('src');
						tmpImg.onload = function()
						{
							ctx.drawImage(img, 0, 0);
							var ppcX = parseFloat("0." + valopt[0]);
							var ppcY = parseFloat("0." + valopt[1]);
							var ppcwidth = parseFloat("0." + valopt[2]);
							var ppcheight = parseFloat("0." + valopt[3]);
							ctx.rect(ppcX * 800, ppcY * 600, ppcwidth * 800, ppcheight * 600);
							ctx.strokeStyle = 'red';
							ctx.lineWidth = 5;
							ctx.stroke();
						};
						//Variables
						var canvasx = $(canvas).offset().left;
						var canvasy = $(canvas).offset().top;
						var last_mousex = last_mousey = 0;
						var mousex = mousey = 0;
						var mousedown = false;
						//Mousedown
						$(canvas).on('mousedown', function(e)
						{
							last_mousex = e.offsetX;
							last_mousey = e.offsetY;
							mousedown = true;
						});
						//Mouseup
						$(canvas).on('mouseup', function(e)
						{
							mousedown = false;
							var initpointx,
								initpointy,
								endpointx,
								endpointy;
							mousex = e.offsetX;
							mousey = e.offsetY;
							if (mousex > last_mousex)
							{
								initpointx = last_mousex;
								endpointx = mousex;
							}
							else
							{
								initpointx = mousex;
								endpointx = last_mousex;
							}
							if (mousey > last_mousey)
							{
								initpointy = last_mousey;
								endpointy = mousey;
							}
							else
							{
								initpointy = mousey;
								endpointy = last_mousey;
							}
							var pointXReal = Math.round(initpointx * (resx / 800));
							var pointYReal = Math.round(initpointy * (resy / 600));
							var endpointXReal = Math.round(endpointx * (resx / 800));
							var endpointYReal = Math.round(endpointy * (resy / 600));
							if (pointXReal == endpointXReal || pointYReal == endpointYReal)
							{
								return;
							}
							if (pointXReal < 0)
							{
								pointXReal = 0;
							}
							if (pointYReal < 0)
							{
								pointYReal = 0;
							}
							var tpcx = (pointXReal / resx).toFixed(4);
							var tpcy = (pointYReal / resy).toFixed(4);
							var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
							var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);
							var tpcx_dec = (tpcx + "").split(".")[1];
							var tpcy_dec = (tpcy + "").split(".")[1];
							var tpcwidth_dec = (tpcwidth + "").split(".")[1];
							var tpcheigth_dec = (tpcheigth + "").split(".")[1];
							var roi = tpcx_dec + ";" + tpcy_dec + ";" + tpcwidth_dec + ";" + tpcheigth_dec;
							$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + " (" + roi + ")");
							var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + roi + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
								.done(function()
								{
									DevExpress.ui.notify("Data saved", "success", 600);
								})
								.fail(function()
								{
									DevExpress.ui.notify("Data saving error", "error", 600);
								});
						});
						//Mousemove
						$(canvas).on('mousemove', function(e)
						{
							mousex = e.offsetX;
							mousey = e.offsetY;
							if (mousedown)
							{
								ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
								ctx.beginPath();
								var width = mousex - last_mousex;
								var height = mousey - last_mousey;
								ctx.rect(last_mousex, last_mousey, width, height);
								ctx.strokeStyle = 'red';
								ctx.lineWidth = 5;
								ctx.stroke();
								var img = document.getElementById("mono");
								ctx.drawImage(img, 0, 0);
								ctx.stroke();
							}
						});
					}
					if (item.typepar == "nlcameralane")
					{
						$.ajax(
						{
							dataType: "json",
							url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcameralane&maxvalues=250&dcl=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
							async: false,
							success: function(data2)
							{
								if (CHECK_USER)
								{
									if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
									{
										var urlCam = window.location.href;
										console.log(urlCam);
										urlCam = urlCam.split(":8090")[0] + ":80";
										if (confirm(data))
										{
											window.location.href = urlCam;
										}
										else
										{
											window.location.href = urlCam;
										}
									}
								}
								var normalexper = "";
								if (item.indexg == -1)
								{
									normalexper = "#field";
								}
								else
								{
									normalexper = "#fiedl" + item.indexg;
								}
								$("#fiedlLANES").append(" <div class='dx-field' id ='LANECANVAS'  ><div id='ResetLan'></div><br><br><img src='./images/LANEGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvaslanes' width='800' height='600' ></canvas><img id = 'monolanes' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
								$("#ResetLan").dxButton(
								{
									type: "success",
									text: DevExpress.localization.formatMessage("Delete Lanes"),
									onClick: function()
									{
										resetLANES();
									}
								});
								var canvas2 = document.getElementById('canvaslanes');
								var ctx2 = canvas2.getContext('2d');
								var img2 = document.getElementById("monolanes");
								var tmpImg2 = new Image();
								tmpImg2.src = $('#monolanes').attr('src');
								tmpImg2.onload = function()
								{
									ctx2.drawImage(img2, 0, 0);
									if (data2.length > 0)
									{
										var p0;
										var p1;
										p0 = parseFloat(data2[0].lpoint00X / 10000) * 800;
										p1 = parseFloat(data2[0].lpoint01X / 10000) * 800;
										ctx2.moveTo(p0, 0);
										ctx2.lineTo(p1, 600);
										ctx2.strokeStyle = 'red';
										ctx2.lineWidth = 5;
										ctx2.font = "30px Arial";
										ctx2.fillStyle = "red";
										ctx2.textAlign = "left";
										ctx2.fillText("LANE1", 10, 25);
										ctx2.fillText("LANE2", 690, 25);
										$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + data2[0].lpoint00X + ";" + data2[0].lpoint01X + ";" + data2[0].lpoint01X + ";" + data2[0].lpoint01Y + ")");
									}
									ctx2.stroke();
								};
								//Variables
								var canvasx2 = $(canvas2).offset().left;
								var canvasy2 = $(canvas2).offset().top;
								var last_mouse2x = last_mousey2 = 0;
								var mousex2 = mousey2 = 0;
								var mousedown2 = false;
								//Mousedown
								$(canvas2).on('mousedown', function(e)
								{
									last_mousex2 = e.offsetX;
									last_mousey2 = e.offsetY;
									mousedown2 = true;
								});
								//Mouseup
								$(canvas2).on('mouseup', function(e)
								{
									mousedown2 = false;
									var initpointx,
										initpointy,
										endpointx,
										endpointy;
									var initpointx1,
										initpointy1,
										endpointx1,
										endpointy1;
									mousex2 = e.offsetX;
									mousey2 = e.offsetY;
									initpointx1 = last_mousex2;
									endpointx1 = mousex2;
									initpointy1 = last_mousey2;
									endpointy1 = mousey2;
									if (initpointx1 <= endpointx1)
									{
										initpointx = initpointx1;
										initpointy = initpointy1;
										endpointx = endpointx1;
										endpointy = endpointy1;
									}
									else
									{
										initpointx = endpointx1;
										initpointy = endpointy1;
										endpointx = initpointx1;
										endpointy = initpointy1;
									}
									if ((endpointx - initpointx) == 0)
									{
										return;
									}
									var pendiente = (endpointy - initpointy) / (endpointx - initpointx);
									var b = endpointy - (pendiente * endpointx);
									ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
									ctx2.beginPath();
									var x0 = (-b / pendiente);
									var x1 = (600 - b) / pendiente;
									ctx2.moveTo(x0, 0);
									ctx2.lineTo(x1, 600);
									ctx2.strokeStyle = 'red';
									ctx2.lineWidth = 5;
									ctx2.stroke();
									var img2 = document.getElementById("monolanes");
									ctx2.drawImage(img2, 0, 0);
									ctx2.font = "30px Arial";
									ctx2.fillStyle = "red";
									ctx2.textAlign = "left";
									ctx2.fillText("LANE1", 10, 25);
									ctx2.fillText("LANE2", 690, 25);
									ctx2.stroke();
									var pointXReal = Math.round(x0 * (resx / 800));
									var endpointXReal = Math.round(x1 * (resx / 800));
									var endpointYReal = resy;
									var ltpcx = (pointXReal / resx).toFixed(4);
									var ltpcendx = (endpointXReal / resx).toFixed(4);
									var ltpcendy = (endpointYReal / resy).toFixed(4);
									var ltpcx_dec = ltpcx * 10000
									var ltpcendx_dec = ltpcendx * 10000
									var ltpcendy_dec = ltpcendy * 10000
									var lanestr = (ltpcx_dec + ";0;" + ltpcendx_dec + ";" + ltpcendy_dec);
									$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + lanestr + ")");
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcameralane&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN")).done(function()
										{
											var urlinsert = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlcameralane&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
											urlinsert += "&camp3=reserve&value3=";
											urlinsert += "&camp4=cameraid&value4=1";
											urlinsert += "&camp5=computerid&value5=1";
											urlinsert += "&camp6=name&value6=LANE1";
											urlinsert += "&camp7=direction&value7=1";
											urlinsert += "&camp8=lpoint00X&value8=" + ltpcx_dec;
											urlinsert += "&camp9=lpoint00Y&value9=0";
											urlinsert += "&camp10=lpoint01X&value10=" + ltpcendx_dec;
											urlinsert += "&camp11=lpoint01Y&value11=" + ltpcendy_dec;
											urlinsert += "&camp12=lpoint10X&value12=0";
											urlinsert += "&camp13=lpoint10Y&value13=0";
											urlinsert += "&camp14=lpoint11X&value14=0";
											urlinsert += "&camp15=lpoint11Y&value15=0";
											urlinsert += "&camp16=occoming&value16=1";
											urlinsert += "&camp17=ocgoing&value17=1";
											urlinsert += "&camp18=enabled&value18=1";
											var jqxhr = $.ajax(
											{
												url: urlinsert,
												async: false
											});
											var urlinsert2 = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlcameralane&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
											urlinsert2 += "&camp3=reserve&value3=";
											urlinsert2 += "&camp4=cameraid&value4=1";
											urlinsert2 += "&camp5=computerid&value5=1";
											urlinsert2 += "&camp6=name&value6=LANE2";
											urlinsert2 += "&camp7=direction&value7=1";
											urlinsert2 += "&camp8=lpoint00X&value8=0";
											urlinsert2 += "&camp9=lpoint00Y&value9=0";
											urlinsert2 += "&camp10=lpoint01X&value10=0";
											urlinsert2 += "&camp11=lpoint01Y&value11=0";
											urlinsert2 += "&camp12=lpoint10X&value12=" + ltpcx_dec;
											urlinsert2 += "&camp13=lpoint10Y&value13=0";
											urlinsert2 += "&camp14=lpoint11X&value14=" + ltpcendx_dec;
											urlinsert2 += "&camp15=lpoint11Y&value15=" + ltpcendy_dec;
											urlinsert2 += "&camp16=occoming&value16=1";
											urlinsert2 += "&camp17=ocgoing&value17=1";
											urlinsert2 += "&camp18=enabled&value18=1";
											var jqxhr2 = $.ajax(
											{
												url: urlinsert2,
												async: false
											});
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
								});
								//Mousemove
								$(canvas2).on('mousemove', function(e)
								{
									mousex2 = e.offsetX;
									mousey2 = e.offsetY;
									if (mousedown2)
									{
										ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
										ctx2.beginPath();
										var width2 = mousex2 - last_mousex2;
										var height2 = mousey2 - last_mousey2;
										ctx2.moveTo(last_mousex2, last_mousey2);
										ctx2.lineTo(mousex2, mousey2);
										ctx2.strokeStyle = 'red';
										ctx2.lineWidth = 5;
										ctx2.stroke();
										var img2 = document.getElementById("monolanes");
										ctx2.drawImage(img2, 0, 0);
										ctx2.stroke();
									}
								});
							}
						});
					}
				}
			});
		}
	});

	function resetROI()
	{
		var canvas = document.getElementById('canvas');
		var ctx = canvas.getContext('2d');
		ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
		ctx.beginPath();
		ctx.stroke();
		var img = document.getElementById("mono");
		ctx.drawImage(img, 0, 0);
		ctx.stroke();
		var roi = "0;0;0;0";
		$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi"));
		var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=5&camp1=value&value1=" + roi + "&camp2=computerid&value2=" + computerid + "&camp3=cameraid&value3=1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
	}

	if (DEFINE_INTERFACE == "ZKTECO")
	{
		$("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
		" <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
		" 		<div id='crossdatagriddiv'></div>" +
		" <div id='crossdetaildiv' > " +
		" 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
		" 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
		" <div class='dx-field' id ='CROSSLINE'  > " +
		"<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
		"<br><br><br><div id='ressetcrossline'></div> " +
		"</div>" +
		"<div class='dx-field-value' style= ' width:auto' >" +
		"<br><canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
		"<br><br><br><div id='ressetcrossarea'></div> " +
		"</div>" +
		"<div class='dx-field-value' style='width:auto;margin-top: 0px;' >" +
		"<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"</div>" +
		"</div>" +
		"</div>" +
		" </div> ");
	}
	else
	{
		$("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
		" <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
		" 		<div id='crossdatagriddiv'></div>" +
		" <div id='crossdetaildiv' > " +
		" 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
		" 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
		" <div class='dx-field' id ='CROSSLINE'  > " +
		"<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
		"<br> <br><br><br><div id='ressetcrossline'></div> " +
		"</div>" +
		"<div class='dx-field-value' style= ' width:auto' >" +
		"<canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"<br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
		"<br> <br><br><br><div id='ressetcrossarea'></div> " +
		"</div>" +
		"<div class='dx-field-value' style='width:auto;margin-top: -125px;' >" +
		"<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"</div>" +
		"</div>" +
		"</div>" +
		" </div> ");
	}
	$("#fiedlCrossLine").hide();
	$("#crossdetaildiv").hide();
	$("#CrossLine").click(function()
	{
		if ($("#CrossLine").hasClass("abierto"))
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#fiedlCrossLine").hide();
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#fiedlCrossLine").show();
		}
	});
	$("#crossdet").click(function()
	{
		if ($("#crossdet").hasClass("abierto"))
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#fiedlcrossdetails").hide();
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#fiedlcrossdetails").show();
		}
	});
	crossdatagrid = $("#crossdatagriddiv").dxDataGrid(
	{
		dataSource: cross_lista,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		hoverStateEnabled: true,
		paging:
		{
			pageSize: 10
		},
		searchPanel:
		{
			visible: true,
			width: 240,
		},
		columns: [
			{
				dataField: "id",
				caption: DevExpress.localization.formatMessage("ID"),
				width: 50,
				allowEditing: false
			},
			{
				width: "30%",
				dataField: "name",
				caption: DevExpress.localization.formatMessage("Name"),
				validationRules: [
				{
					type: "required"
				}]
			},
			{
				width: "15%",
				dataField: "triggermode",
				caption: DevExpress.localization.formatMessage("Mode"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: [
						DevExpress.localization.formatMessage("Entering"),
						DevExpress.localization.formatMessage("Leaving"),
						DevExpress.localization.formatMessage("Both")
					]
					/*dataSource: modearray,
					displayExpr: "description",
					valueExpr: "id"*/
				}
			},
			/*{
                    dataField: "lineheight",
                    caption: DevExpress.localization.formatMessage("lineheight"),
				    dataType: "number",
                    width: "10%",
                    format: {
                        type: "decimal",
                        precision: 0
                    },
                    validationRules: [{
                        type: "required"
                    }]
                },*/
			{
				dataField: "pixelchange",
				caption: DevExpress.localization.formatMessage("Pixel Change"),
				dataType: "number",
				width: "10%",
				format:
				{
					type: "decimal",
					precision: 0
				},
				validationRules: [
				{
					type: "required"
				}]
			},
			{
				dataField: "minchangepc",
				caption: DevExpress.localization.formatMessage("Min. change pc"),
				dataType: "number",
				width: "10%",
				format:
				{
					type: "decimal",
					precision: 0
				},
				validationRules: [
				{
					type: "required"
				}]
			}
		],
		editing:
		{
			mode: "row",
			allowUpdating: true,
			allowDeleting: true,
			texts:
			{
				confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the cross line?")
			},
			allowAdding: true
		},
		selection:
		{
			mode: "single"
		},
		onSelectionChanged: function(selectedItems)
		{
			var data = selectedItems.selectedRowsData[0];
			if (data)
			{
				$("#crossdetaildiv").show();
				crosslineediting = data.id;
				loadcrosslinedetails(data.id);
			}
		},
		onRowUpdating: function(e)
		{
			var description;
			if (typeof e.newData.name !== 'undefined')
			{
				description = e.newData.name.replaceAll('"', '').replaceAll('\'', '');
			}
			else
			{
				description = e.oldData.name.replaceAll('"', '').replaceAll('\'', '');
			}
			var pixelchange;
			if (typeof e.newData.pixelchange !== 'undefined')
			{
				pixelchange = e.newData.pixelchange;
			}
			else
			{
				pixelchange = e.oldData.pixelchange;
			}
			/*var lineheight;
                if (typeof e.newData.lineheight !== 'undefined') {
                    lineheight = e.newData.lineheight;
                } else {
                    lineheight = e.oldData.lineheight;
				}*/
			var triggermode;
			if (typeof e.newData.triggermode !== 'undefined')
			{
				triggermode = convertTriggermodeToInt(e.newData.triggermode);
			}
			else
			{
				triggermode = convertTriggermodeToInt(e.oldData.triggermode);
			}
			var minchangepc;
			if (typeof e.newData.minchangepc !== 'undefined')
			{
				minchangepc = e.newData.minchangepc;
			}
			else
			{
				minchangepc = e.oldData.minchangepc;
			}
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + e.key +
				"&camp1=name&value1=" + description +
				"&camp2=computerid&value2=1" +
				"&camp3=cameraid&value3=1" +
				"&camp4=pixelchange&value4=" + pixelchange +
				//"&camp5=lineheight&value5="+lineheight+
				"&camp5=triggermode&value5=" + triggermode +
				"&camp6=minchangepc&value6=" + minchangepc +
				"&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
		},
		onRowInserting: function(e)
		{
			var triggermode = convertTriggermodeToInt(e.data.triggermode);
			var jqxhr = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insertcross&name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '') + "&triggermode=" + triggermode + "&pixelchange=" + e.data.pixelchange + "&minchangepc=" + e.data.minchangepc + /*"&lineheight=" + e.data.lineheight+*/ "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					data = data.replaceAll('\r', '').replaceAll('\n', '');
					DevExpress.ui.notify("Data saved", "success", 600);
					loadcrossline();
				}
			});
		},
		onRowRemoving: function(e)
		{
			var jqxhr2 = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcrossline&camp0=id&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"),
				async: false
			});
			loadcrossline();
			$("#crossdetaildiv").hide();
		}
	}).dxDataGrid("instance");

	function convertTriggermodeToInt(mode)
	{
		var value = 1;
		if (typeof mode !== 'undefined')
		{
			if (mode == DevExpress.localization.formatMessage("Entering"))
			{
				value = 1;
			}
			else if (mode == DevExpress.localization.formatMessage("Leaving"))
			{
				value = 2;
			}
			else if (mode == DevExpress.localization.formatMessage("Both"))
			{
				value = 3;
			}
		}
		return value;
	}
	function convertIntToTriggermode(value)
	{
		var mode = DevExpress.localization.formatMessage("Entering");
		if (value == 1)
		{
			mode = DevExpress.localization.formatMessage("Entering");
		}
		else if (value == 2)
		{
			mode = DevExpress.localization.formatMessage("Leaving");
		}
		else if (value == 3)
		{
			mode = DevExpress.localization.formatMessage("Both");
		}
		return mode;
	}
	function resetLANES()
	{
		var canvas2 = document.getElementById('canvaslanes');
		var ctx2 = canvas2.getContext('2d');
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		ctx2.stroke();
		var img2 = document.getElementById("monolanes");
		ctx2.drawImage(img2, 0, 0);
		ctx2.stroke();
		$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes"));
		var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcameralane" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
	}
	function loadcrossline()
	{
		var d = new Date();
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcrossline&maxvalues=20&sortdesc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				actdict = {};
				cross_lista = data;
				crossdatagrid.option("dataSource", cross_lista);
				$.each(data, function(i, item)
				{
					data[i].triggermode = convertIntToTriggermode(data[i].triggermode);
					actdict["cross" + item.id] = item;
				});
			}
		});
	};
	loadcrossline();
	var canvas2 = document.getElementById('canvascrossline');
	var ctx2 = canvas2.getContext('2d');
	var canvasx2 = $(canvas2).offset().left;
	var canvasy2 = $(canvas2).offset().top;
	var last_mousex2 = last_mousey2 = 0;
	var mousex2 = mousey2 = 0;
	var mousedown2 = false;
	//Mousedown
	$(canvas2).on('mousedown', function(e)
	{
		last_mousex2 = e.offsetX;
		last_mousey2 = e.offsetY;
		mousedown2 = true;
	});
	//Mouseup
	$(canvas2).on('mouseup', function(e)
	{
		mousedown2 = false;
		var initpointx,
			initpointy,
			endpointx,
			endpointy;
		var initpointx1,
			initpointy1,
			endpointx1,
			endpointy1;
		mousex2 = e.offsetX;
		mousey2 = e.offsetY;
		initpointx1 = last_mousex2;
		endpointx1 = mousex2;
		initpointy1 = last_mousey2;
		endpointy1 = mousey2;
		/*if (initpointx1 <= endpointx1) {*/
		initpointx = initpointx1;
		endpointx = endpointx1;
		initpointy = initpointy1;
		endpointy = endpointy1;
		/*} else {
	        initpointx = endpointx1;
			endpointx = initpointx1;
	     
	    }*/
		if ((endpointx - initpointx) == 0 || (endpointy - initpointy) == 0)
		{
			return;
		}
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		var img2 = document.getElementById("crosslineimg");
		ctx2.drawImage(img2, 0, 0);
		ctx2.moveTo(initpointx, last_mousey2);
		ctx2.lineTo(endpointx, mousey2);
		ctx2.strokeStyle = 'red';
		ctx2.lineWidth = 5;
		ctx2.stroke();
		var pointXReal = Math.round(last_mousex2 * (resx / 800));
		var pointYReal = Math.round(last_mousey2 * (resy / 600));
		var endpointXReal = Math.round(endpointx * (resx / 800));
		var endpointYReal = Math.round(endpointy * (resy / 600));;
		var ltpcx = (pointXReal / resx).toFixed(4);
		var ltpcy = (pointYReal / resy).toFixed(4);
		var ltpcendx = (endpointXReal / resx).toFixed(4);
		var ltpcendy = (endpointYReal / resy).toFixed(4);
		var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=lineY0&value1=" + ltpcy + "&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=lineX0&value4=" + ltpcx + "&camp5=lineY1&value5=" + ltpcendy + "&camp6=lineX1&value6=" + ltpcendx + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
		actdict["cross" + crosslineediting].lineY0 = ltpcy;
		actdict["cross" + crosslineediting].lineX0 = ltpcx;
		actdict["cross" + crosslineediting].lineY1 = ltpcendy;
		actdict["cross" + crosslineediting].lineX1 = ltpcendx;
	});
	//Mousemove
	$(canvas2).on('mousemove', function(e)
	{
		mousex2 = e.offsetX;
		mousey2 = e.offsetY;
		if (mousedown2)
		{
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			var width2 = mousex2 - last_mousex2;
			var height2 = mousey2 - last_mousey2;
			ctx2.moveTo(last_mousex2, last_mousey2);
			ctx2.lineTo(mousex2, mousey2);
			ctx2.strokeStyle = 'red';
			ctx2.lineWidth = 5;
			ctx2.stroke();
			var img2 = document.getElementById("crosslineimg");
			ctx2.drawImage(img2, 0, 0);
			ctx2.stroke();
		}
	});
	var canvas = document.getElementById('canvascrossarea');
	var ctx = canvas.getContext('2d');
	var canvasx = $(canvas).offset().left;
	var canvasy = $(canvas).offset().top;
	var last_mousex = last_mousey = 0;
	var mousex = mousey = 0;
	var mousedown = false;
	//Mousedown
	$(canvas).on('mousedown', function(e)
	{
		last_mousex = e.offsetX;
		last_mousey = e.offsetY;
		mousedown = true;
	});
	//Mouseup
	$(canvas).on('mouseup', function(e)
	{
		mousedown = false;
		var initpointx,
			initpointy,
			endpointx,
			endpointy;
		mousex = e.offsetX;
		mousey = e.offsetY;
		if (mousex > last_mousex)
		{
			initpointx = last_mousex;
			endpointx = mousex;
		}
		else
		{
			initpointx = mousex;
			endpointx = last_mousex;
		}
		if (mousey > last_mousey)
		{
			initpointy = last_mousey;
			endpointy = mousey;
		}
		else
		{
			initpointy = mousey;
			endpointy = last_mousey;
		}
		var pointXReal = Math.round(initpointx * (resx / 800));
		var pointYReal = Math.round(initpointy * (resy / 600));
		var endpointXReal = Math.round(endpointx * (resx / 800));
		var endpointYReal = Math.round(endpointy * (resy / 600));
		if (pointXReal == endpointXReal || pointYReal == endpointYReal)
		{
			return;
		}
		if (pointXReal < 0)
		{
			pointXReal = 0;
		}
		if (pointYReal < 0)
		{
			pointYReal = 0;
		}
		var tpcx = (pointXReal / resx).toFixed(4);
		var tpcy = (pointYReal / resy).toFixed(4);
		var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
		var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);
		var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=roi1&value1=" + tpcx + "&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=roi2&value4=" + tpcy + "&camp5=roi3&value5=" + tpcwidth + "&camp6=roi4&value6=" + tpcheigth + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
		actdict["cross" + crosslineediting].roi1 = tpcx;
		actdict["cross" + crosslineediting].roi2 = tpcy;
		actdict["cross" + crosslineediting].roi3 = tpcwidth;
		actdict["cross" + crosslineediting].roi4 = tpcheigth;
	});
	//Mousemove
	$(canvas).on('mousemove', function(e)
	{
		mousex = e.offsetX;
		mousey = e.offsetY;
		if (mousedown)
		{
			ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
			ctx.beginPath();
			var width = mousex - last_mousex;
			var height = mousey - last_mousey;
			ctx.rect(last_mousex, last_mousey, width, height);
			ctx.strokeStyle = 'red';
			ctx.lineWidth = 5;
			ctx.stroke();
			var img = document.getElementById("crossareaimg");
			ctx.drawImage(img, 0, 0);
			ctx.stroke();
		}
	});
	$("#ressetcrossline").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Delete line"),
		onClick: function()
		{
			resetLaneCross();
		}
	});
	$("#ressetcrossarea").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Delete area"),
		onClick: function()
		{
			resetLaneArea();
		}
	});

	function loadcrosslinedetails(idcross)
	{
		var cross = actdict["cross" + idcross];
		//Draw lane cross
		var canvas2 = document.getElementById('canvascrossline');
		var ctx2 = canvas2.getContext('2d');
		var img2 = document.getElementById("crosslineimg");
		var tmpImg2 = new Image();
		tmpImg2.src = $('#crosslineimg').attr('src');
		tmpImg2.onload = function()
		{
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			ctx2.stroke();
			ctx2.drawImage(img2, 0, 0);
			var ppcX = parseFloat(cross.lineX0);
			var ppcX2 = parseFloat(cross.lineX1);
			var ppcY = parseFloat(cross.lineY0);
			var ppcY2 = parseFloat(cross.lineY1);
			ctx2.moveTo(ppcX * 800, ppcY * 600);
			ctx2.lineTo(ppcX2 * 800, ppcY2 * 600);
			ctx2.strokeStyle = 'red';
			ctx2.lineWidth = 5;
			ctx2.stroke();
		};
		var canvas = document.getElementById('canvascrossarea');
		var ctx = canvas.getContext('2d');
		var imgrect = document.getElementById("crossareaimg");
		var tmpImgrect = new Image();
		tmpImgrect.src = $('#crossareaimg').attr('src');
		tmpImgrect.onload = function()
		{
			ctx.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx.beginPath();
			ctx.stroke();
			ctx.drawImage(imgrect, 0, 0);
			var ppcX = parseFloat(cross.roi1);
			var ppcY = parseFloat(cross.roi2);
			var ppcwidth = parseFloat(cross.roi3);
			var ppcheight = parseFloat(cross.roi4);
			ctx.rect(ppcX * 800, ppcY * 600, ppcwidth * 800, ppcheight * 600);
			ctx.strokeStyle = 'red';
			ctx.lineWidth = 5;
			ctx.stroke();
		};
	}

	function resetLaneCross()
	{
		var canvas2 = document.getElementById('canvascrossline');
		var ctx2 = canvas2.getContext('2d');
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		ctx2.stroke();
		var img2 = document.getElementById("crosslineimg");
		ctx2.drawImage(img2, 0, 0);
		ctx2.stroke();
		var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=lineY0&value1=0&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=lineX0&value4=0&camp5=lineY1&value5=0&camp6=lineX1&value6=0&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
		actdict["cross" + crosslineediting].lineY = 0;
		actdict["cross" + crosslineediting].lineXleft = 0;
		actdict["cross" + crosslineediting].lineXright = 0;
	}

	function resetLaneArea()
	{
		var canvas2 = document.getElementById('canvascrossarea');
		var ctx2 = canvas2.getContext('2d');
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		ctx2.stroke();
		var img2 = document.getElementById("crossareaimg");
		ctx2.drawImage(img2, 0, 0);
		ctx2.stroke();
		var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=roi1&value1=0&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=roi2&value4=0&camp5=roi3&value5=0&camp6=roi4&value6=0&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
		actdict["cross" + crosslineediting].roi1 = 0;
		actdict["cross" + crosslineediting].roi2 = 0;
		actdict["cross" + crosslineediting].roi3 = 0;
		actdict["cross" + crosslineediting].roi4 = 0;
	}
});
