////////////////
// LISTS PAGE //
////////////////

$(function()
{
	Init_translate();
	make_header("list");
	$("#listtypes").text(DevExpress.localization.formatMessage("List types"));
	$("#schedulertitle").text(DevExpress.localization.formatMessage("Scheduler"));
	$("#lactprop").text(DevExpress.localization.formatMessage("Action properties"));
	$("#lbExportprop").text(DevExpress.localization.formatMessage("Export properties"));
	$("#lbImportprop").text(DevExpress.localization.formatMessage("Import properties"));
	$("#minconflabel").text(DevExpress.localization.formatMessage('Minimum Confidence:'));
	$("#maxconflabel").text(DevExpress.localization.formatMessage('Maximum Confidence:'));
	$("#conditiontitle").text(DevExpress.localization.formatMessage('Action Conditions'));
	set_rcpopup();
	var id_lista = -1;
	var name_lista = "";
	var elem_listas;
	var listas;
	var actions_listas;
	var exports_listas;
	var imports_listas;
	var delete_list = false;
	var delete_action_list = false;
	var listypesabierto = true;
	var listplatesabierto = false;
	var listactionsabierto = false;
	var listexportsabierto = false;
	var listimportsabierto = false;
	var schedulerdivabierto = false;
	var conditiondivabierto = true;
	var idaction = 1;
	var idexport = 1;
	var optionactions = [];
	var optionexports = [];
	var optionimports = [];
	var actionlist;
	var exportlist;
	var importlist;
	var selectedaction;
	var selectedexport;
	var selectedimport;
	var actdict = {};
	var expdict = {};
	var impdict = {};
	var actdefaultdict = {};
	var expdefaultdict = {};
	var impdefaultdict = {};
	var acthelpdict = {};
	var myfile;
	var importlogs = "";
	var d2;

	function getimeCamera()
	{
		var dataCamara;
		$.ajax(
		{
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=gettime&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				if (CHECK_USER)
				{
					if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
					{
						var urlCam = window.location.href;
						console.log(urlCam);
						urlCam = urlCam.split(":8090")[0] + ":80";
						if (confirm(data))
						{
							window.location.href = urlCam;
						}
						else
						{
							window.location.href = urlCam;
						}
					}
				}
				dataCamara = new Date(data);
			}
		});
		return dataCamara;
	}

	//GET TIME
	$.ajax(
	{
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=gettime&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			d2 = new Date(data);
		}
	});
	
	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};
	
	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}
	
	var enabledarray = [
	{
		"id": 0,
		"description": DevExpress.localization.formatMessage("Disabled")
	},
	{
		"id": 1,
		"description": DevExpress.localization.formatMessage("Enabled")
	}];
	
	var enabledarrayexport = [
	{
		"id": 0,
		"description": DevExpress.localization.formatMessage("Disabled")
	},
	{
		"id": 1,
		"description": DevExpress.localization.formatMessage("Enabled")
	},
	{
		"id": 2,
		"description": DevExpress.localization.formatMessage("Enabled if change")
	}];
	
	var intervalarray = [
	{
		"id": "minute",
		"description": DevExpress.localization.formatMessage("Minute")
	},
	{
		"id": "minute3",
		"description": DevExpress.localization.formatMessage("3 minutes")
	},
	{
		"id": "minute5",
		"description": DevExpress.localization.formatMessage("5 minutes")
	},
	{
		"id": "minute10",
		"description": DevExpress.localization.formatMessage("10 minutes")
	},
	{
		"id": "minute15",
		"description": DevExpress.localization.formatMessage("15 minutes")
	},
	{
		"id": "minute30",
		"description": DevExpress.localization.formatMessage("30 minutes")
	},
	{
		"id": "hour",
		"description": DevExpress.localization.formatMessage("Hour")
	},
	{
		"id": "day",
		"description": DevExpress.localization.formatMessage("Day")
	},
	{
		"id": "week",
		"description": DevExpress.localization.formatMessage("Week")
	},
	{
		"id": "month",
		"description": DevExpress.localization.formatMessage("Month")
	}];
	$("#actions").hide();

	function getreservationscheduler(dia, mascara)
	{
		var $rsvns = [];
		var i = 0;
		var duracion = 0;
		var inicio = -1;
		for (i = 0; i < 24; i++)
		{
			//elemento con hora
			if (mascara.charAt(i) == '1')
			{
				if (inicio == -1)
				{
					inicio = i;
				}
				duracion++;
			}
			else
			{
				if (inicio != -1)
				{
					var $rsvn = $("<div></div>"),
						top = dia * 30,
						height = 30 + 1,
						left = inicio * 44,
						width = duracion * 44 + 1;
					$rsvn.addClass("reservation").addClass("reservation-final")
						.css(
						{
							top: top,
							height: height,
							left: left,
							width: width
						});
					$rsvns.push($rsvn);
					inicio = -1;
					duracion = 0;
				}
			}
		}
		if (mascara.charAt(23) == '1' && inicio != -1)
		{
			var $rsvn = $("<div></div>"),
				top = dia * 30,
				height = 30 + 1,
				left = inicio * 44,
				width = duracion * 44 + 1;
			$rsvn.addClass("reservation").addClass("reservation-final")
				.css(
				{
					top: top,
					height: height,
					left: left,
					width: width
				});
			$rsvns.push($rsvn);
		}
		return $rsvns;
	}

	function setbinddiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elemb" + columna + i + "' style='float:none;display: inline-block; ' ></div> <div id='elem" + columna + i + "' style='display: inline-block;' ><div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 250,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).text(selectedvalue);
		$("#elemb" + columna + i).dxButton(
		{
			text: DevExpress.localization.formatMessage("Bind"),
			type: "success",
			//text: "Bind", 
			onClick: function(e)
			{
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=pssbind&idaction=" + idaction + localStorage.getItem("TOKEN"))
					.done(function(data)
					{
						$("#elem" + columna + i).text(data);
					});
			}
		});
	}

	function setoptiondiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 250,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).dxRadioGroup(
		{
			items: valopt,
			value: selectedvalue,
			layout: "horizontal",
			onValueChanged: function(e)
			{
				var previousValue = e.previousValue;
				var newValue = e.value;
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=" + table + "&camp0=id&value0=" + idactexp + "&camp1=" + columna + "&value1=" + newValue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
					.done(function()
					{
						DevExpress.ui.notify("Data saved", "success", 600);
					})
					.fail(function()
					{
						DevExpress.ui.notify("Data saving error", "error", 600);
					});
			}
		});
	}

	function setintdiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block;' ></div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 250,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).dxNumberBox(
		{
			value: selectedvalue,
			min: valopt[0],
			max: valopt[1],
			showSpinButtons: true,
			onValueChanged: function(e)
			{
				var previousValue = e.previousValue;
				var newValue = e.value;
				if (newValue == null) newValue = e.previousValue;
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}
				// Event handling commands go here
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=" + table + "&camp0=id&value0=" + idactexp + "&camp1=" + columna + "&value1=" + newValue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
					.done(function()
					{
						DevExpress.ui.notify("Data saved", "success", 600);
					})
					.fail(function()
					{
						DevExpress.ui.notify("Data saving error", "error", 600);
					});
			}
		});
	}

	function setstringdiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block; width:92%' ></div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 250,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		var passmode = "Text";
		if (text == "Password:") passmode = "password";
		$("#elem" + columna + i).dxTextBox(
		{
			value: selectedvalue,
			mode: passmode,
			onValueChanged: function(e)
			{
				var newValue = e.value.replaceAll('"', '').replaceAll("'", '').replace(/\\/g, '/');
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}
				// Event handling commands go here
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=" + table + "&camp0=id&value0=" + idactexp + "&camp1=" + columna + "&value1=" + encodeURIComponent(newValue) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
					.done(function()
					{
						DevExpress.ui.notify("Data saved", "success", 600);
					})
					.fail(function()
					{
						DevExpress.ui.notify("Data saving error", "error", 600);
					});
			}
		});
	}

	function setfilediv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block; width:92%' ></div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 250,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).dxTextBox(
		{
			value: selectedvalue,
			onValueChanged: function(e)
			{
				var newValue = e.value.replaceAll('"', '').replaceAll("'", '').replace(/\\/g, '/').replace(/[=*+?^{}()|]/g, '');
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}
				// Event handling commands go here
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=" + table + "&camp0=id&value0=" + idactexp + "&camp1=" + columna + "&value1=" + encodeURIComponent(newValue) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
					.done(function()
					{
						DevExpress.ui.notify("Data saved", "success", 600);
					})
					.fail(function()
					{
						DevExpress.ui.notify("Data saving error", "error", 600);
					});
			}
		});
	}
	
	var vlists = $("#gridContainer").dxDataGrid(
	{
		dataSource: listas,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		hoverStateEnabled: true,
		paging:
		{
			pageSize: 10
		},
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		pager:
		{
			showPageSizeSelector: true,
			allowedPageSizes: [5, 10, 20],
			showInfo: true
		},
		columns: [
		{
			dataField: "id",
			caption: DevExpress.localization.formatMessage("ID"),
			width: 50,
			allowEditing: false
		},
		{
			dataField: "description",
			caption: DevExpress.localization.formatMessage("Name"),
			validationRules: [
			{
				type: "required"
			}]
		},
		{
			dataField: "levenshteindist",
			caption: DevExpress.localization.formatMessage("Levenshtein distance"),
			dataType: "number",
			width: 300,
			format:
			{
				type: "decimal",
				precision: 0
			},
			validationRules: [
			{
				type: "required"
			}]
		}],
		editing:
		{
			mode: "row",
			allowUpdating: true,
			allowDeleting: true,
			texts:
			{
				confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the list?")
			},
			allowAdding: true
		},
		"export":
		{
			enabled: true,
			allowExportSelectedData: false,
			printingEnabled: true,
		},
		selection:
		{
			mode: "single"
		},
		onSelectionChanged: function(selectedItems)
		{
			var data = selectedItems.selectedRowsData[0];
			if (data)
			{
				plates.filter(["listid", "=", data.id]);
				if (data.id == -1)
				{
					$("#plateslistdiv").hide();
					$("#imports").hide();
					$("#importsdiv").hide();
					$("#importsbuttons").hide();
				}
				else if (data.id == -2)
				{
					$("#plateslistdiv").hide();
					$("#imports").hide();
					$("#importsdiv").show();
					$("#importsbuttons").show();
				}
				else
				{
					$("#plateslistdiv").show();
					$("#imports").show();
					$("#importsdiv").show();
					$("#importsbuttons").show();
				}
				actions.deselectRows(idaction);
				id_lista = data.id;
				importbutton.option("uploadUrl", pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importlistblob&listid=" + id_lista + "&delete=" + delete_list + localStorage.getItem("TOKEN"));
				importactionbutton.option("uploadUrl", pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importlistactionblob&listid=" + id_lista + "&delete=" + delete_action_list + localStorage.getItem("TOKEN"));
				name_lista = data.description;
				loadelemslist(id_lista, name_lista, false);
				loadactions(id_lista, name_lista, false);
				loadexports(id_lista, name_lista, false);
				loadimports(id_lista, name_lista, false);
				$("#actions").hide();
				$("#exports").hide();
				$("#imports").hide();
			}
		},
		onRowUpdating: function(e)
		{
			var description;
			if (typeof e.newData.description !== 'undefined')
			{
				description = e.newData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			else
			{
				description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			var levenshteindist;
			if (typeof e.newData.levenshteindist !== 'undefined')
			{
				levenshteindist = e.newData.levenshteindist;
			}
			else
			{
				levenshteindist = e.oldData.levenshteindist;
			}
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nllist&camp0=id&value0=" + e.oldData.id + "&camp1=description&value1=" + description + "&camp2=levenshteindist&value2=" + levenshteindist + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
		},
		onRowInserting: function(e)
		{
			var jqxhr = $.ajax(
			{
			    url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nllist&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000&camp3=reserve&value3=&camp4=description&value4=" + e.data.description.replaceAll('"', '').replaceAll('\'', '') + "&camp5=levenshteindist&value5=" + e.data.levenshteindist + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
				    if (CHECK_USER) {
				        if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow")) {
				            var urlCam = window.location.href;
				            console.log(urlCam);
				            urlCam = urlCam.split(":8090")[0] + ":80";
				            if (confirm(data)) {
				                window.location.href = urlCam;
				            }
				            else {
				                window.location.href = urlCam;
				            }
				        }
				    }
				    loadlists();
				}
			});
		},
		onRowRemoving: function(e)
		{
			if (e.key < 0)
			{
				DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("This list can not be deleted"));
				e.component.cancelEditData();
				e.cancel = true;
			}
			else
			{
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nllist&camp0=id&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
				var jqxhr2 = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlelemlist&camp0=listid&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
				var jqxhr3 = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlaction&camp0=listid&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
				var jqxhr4 = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlexport&camp0=listid&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
				var jqxhr4 = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlimport&camp0=listid&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
				id_lista = -1;
				loadelemslist(id_lista, name_lista, true);
				loadactions(id_lista, name_lista, true);
				loadexports(id_lista, name_lista, true);
				loadimports(id_lista, name_lista, true);
				vlists.selectRows([-1]);
			}
		}
	}).dxDataGrid("instance");

	var plates = $("#gridContainer2").dxDataGrid(
	{
		dataSource: elem_listas,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		hoverStateEnabled: true,
		paging:
		{
			pageSize: 10
		},
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		pager:
		{
			showPageSizeSelector: true,
			allowedPageSizes: [5, 10, 20],
			showInfo: true
		},
		columns: [
		{
			dataField: "numberplate",
			caption: DevExpress.localization.formatMessage("Plate"),
			width: "15%"
		},
		{
			width: "10%",
			dataField: "description",
			caption: DevExpress.localization.formatMessage("Description")
		},
		{
			width: "20%",
			dataField: "timestamp",
			caption: DevExpress.localization.formatMessage("Insert Date"),
			dataType: "date",
			format: "dd/MM/yyyy HH:mm:ss",
			allowEditing: false
		},
		{
			width: "20%",
			dataField: "startvaliditydate",
			caption: DevExpress.localization.formatMessage("Start validity date"),
			dataType: "datetime",
			format: "dd/MM/yyyy HH:mm:ss",
			allowEditing: true,
		},
		{
			width: "20%",
			dataField: "endvaliditydate",
			caption: DevExpress.localization.formatMessage("End validity date"),
			dataType: "datetime",
			format: "dd/MM/yyyy HH:mm:ss",
			allowEditing: true,
		}],
		editing:
		{
			mode: "row",
			allowUpdating: true,
			allowDeleting: true,
			texts:
			{
				confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the plate from list?")
			},
			allowAdding: true
		},
		onRowValidating: function(e)
		{
			var startdate;
			var enddate;
			var plt;
			var rowIndex = plates.getRowIndexByKey(e.key)
			if (typeof e.newData.numberplate !== 'undefined')
			{
				plt = e.newData.numberplate;
			}
			//Check plate
			var jqxhr = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlelemlist&maxvalues=1&camp0=numberplate&value0=" + plt + "&comp0=equal&camp1=listid&comp1=equal&value1=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					if (data.length > 0)
					{
						e.isValid = false;
						plates.getCellElement(rowIndex, "numberplate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
						DevExpress.ui.notify("The plate already exist at list", "error", 1500);
					}
				}
			});
			LoadCurrentDate();
			if (typeof e.newData.startvaliditydate !== 'undefined')
			{
				startdate = new Date(e.newData.startvaliditydate);
			}
			else if (typeof e.oldData !== 'undefined' && typeof e.oldData.startvaliditydate == 'undefined')
			{
				startdate = new Date(e.oldData.startvaliditydate);
			}
			if (startdate !== 'undefined')
			{
				var nowdate = d2;
				//nowdate.setMinutes(nowdate.getMinutes() - 10);
				if (startdate < nowdate)
				{
					e.isValid = false;
					plates.getCellElement(rowIndex, "startvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
					DevExpress.ui.notify(DevExpress.localization.formatMessage("The start validity date can not be lower than actual date"), "error", 1500);
				}
			}
			if (typeof e.newData.endvaliditydate !== 'undefined')
			{
				enddate = new Date(e.newData.endvaliditydate);
			}
			else if (typeof e.oldData !== 'undefined' && typeof e.oldData.endvaliditydate == 'undefined')
			{
				enddate = new Date(e.oldData.endvaliditydate);
			}
			if (enddate !== 'undefined')
			{
				if (enddate < d2)
				{
					e.isValid = false;
					plates.getCellElement(rowIndex, "endvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
					DevExpress.ui.notify(DevExpress.localization.formatMessage("The end validity date can not be lower than actual date"), "error", 1500);
				}
			}
			if (enddate !== 'undefined' && startdate !== 'undefined')
			{
				if (enddate < startdate)
				{
					e.isValid = false;
					plates.getCellElement(rowIndex, "endvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
					plates.getCellElement(rowIndex, "startvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
					DevExpress.ui.notify(DevExpress.localization.formatMessage("The end validity date can not be lower than start validity date"), "error", 1500);
				}
			}
		},
		"export":
		{
			enabled: true,
			allowExportSelectedData: false,
			printingEnabled: true,
		},
		onRowUpdating: function(e)
		{
			var numberplate;
			var descritpion;
			var startdate;
			var enddate;
			if (typeof e.newData.numberplate !== 'undefined')
			{
				numberplate = e.newData.numberplate;
			}
			else
			{
				numberplate = e.oldData.numberplate;
			}
			if (typeof e.newData.description !== 'undefined')
			{
				description = e.newData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			else
			{
				description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			if (typeof e.newData.startvaliditydate !== 'undefined')
			{
				startdate = getStringNormalDate(new Date(e.newData.startvaliditydate));
			}
			else
			{
				startdate = getStringNormalDate(new Date(e.oldData.startvaliditydate));
			}
			if (typeof e.newData.endvaliditydate !== 'undefined')
			{
				enddate = getStringNormalDate(new Date(e.newData.endvaliditydate));
			}
			else
			{
				enddate = getStringNormalDate(new Date(e.oldData.endvaliditydate));
			}
			description = encodeURIComponent(description);
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlelemlist&camp0=id&value0=" + e.oldData.id + "&camp1=listid&value1=" + e.oldData.listid + "&camp2=numberplate&value2=" + numberplate.trim().toUpperCase() + "&camp3=description&value3=" + description + "&camp4=startvaliditydate&value4=" + startdate + "&camp5=endvaliditydate&value5=" + enddate + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
		},
		onRowInserting: function(e)
		{
			var insertdate = getStringNormalDate(getimeCamera());
			var starvaliditydate;
			var endvaliditydate;
			var descrip;
			LoadCurrentDate();
			if (typeof e.data.startvaliditydate !== 'undefined')
			{
				starvaliditydate = getStringNormalDate(new Date(e.data.startvaliditydate));
			}
			else
			{
				starvaliditydate = getStringNormalDate(d2);
			}
			if (typeof e.data.endvaliditydate !== 'undefined')
			{
				endvaliditydate = getStringNormalDate(new Date(e.data.endvaliditydate));
			}
			else
			{
				endvaliditydate = "3000-01-01T00:00:00.000";
			}
			if (typeof e.data.description !== 'undefined')
			{
				descrip = e.data.description.replaceAll('"', '').replaceAll('\'', '');
			}
			else
			{
				descrip = "";
			}
			descrip = encodeURIComponent(descrip);
			var jqxhr = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlelemlist&camp0=id&value0=-1&camp1=listid&value1=" + id_lista + "&camp2=numberplate&value2=" + e.data.numberplate.trim().toUpperCase() + "&camp3=description&value3=" + descrip + "&camp4=startvaliditydate&value4=" + starvaliditydate + "&camp5=endvaliditydate&value5=" + endvaliditydate + "&camp6=timestamp&value6=" + insertdate + "&camp7=estado&value7=0&camp8=sendserver&value8=0&camp9=dateserver&value9=" + insertdate + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					if (data == "Error en insert\r\n")
					{
						DevExpress.ui.notify("Error at insert", "error", 2000);
					}
				}
			});
			loadelemslist(id_lista, name_lista, true);
		},
		onRowRemoving: function(e)
		{
			var jqxhr = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlelemlist&camp0=id&comp0=equal&value0=" + e.key + "&camp1=listid&comp1=equal&value1=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
				}
			});
			loadelemslist(id_lista, name_lista, true);
		}
	}).dxDataGrid("instance");
	
	var actions = $("#gridContainer3").dxDataGrid(
	{
		dataSource: actions_listas,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		hoverStateEnabled: true,
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		columns: [
		{
			dataField: "id",
			caption: "ID",
			width: "10%",
			allowEditing: false
		},
		{
			width: "30%",
			dataField: "description",
			caption: DevExpress.localization.formatMessage("Description"),
			validationRules: [
			{
				type: "required"
			}]
		},
		{
			width: "20%",
			dataField: "actiontype",
			caption: DevExpress.localization.formatMessage("Action type"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: optionactions,
				displayExpr: "description",
				valueExpr: "id"
			}
		},
		{
			width: "20%",
			dataField: "enabled",
			caption: DevExpress.localization.formatMessage("Active"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: enabledarray,
				displayExpr: "description",
				valueExpr: "id"
			}
		}],
		editing:
		{
			mode: "row",
			allowUpdating: true,
			allowDeleting: true,
			texts:
			{
				confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the action from list?")
			},
			allowAdding: true
		},
		onRowUpdating: function(e)
		{
			var description;
			var active;
			var type;
			idaction = e.oldData.id;
			if (typeof e.newData.description !== 'undefined')
			{
				description = e.newData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			else
			{
				description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			if (typeof e.newData.enabled !== 'undefined')
			{
				active = e.newData.enabled;
			}
			else
			{
				active = e.oldData.enabled;
			}
			if (typeof e.newData.actiontype !== 'undefined')
			{
				type = e.newData.actiontype;
				//change groupbox to selected
				$.each(optionactions, function(i, item)
				{
					$("#" + item.id).hide();
				});
				$("#" + type).show();
				actdict["act" + idaction].actiontype = type;
				actdict["act" + idaction].host = actdefaultdict[type].host_default;
				actdict["act" + idaction].port = actdefaultdict[type].port_default;
				actdict["act" + idaction].param1 = actdefaultdict[type].param1_default;
				actdict["act" + idaction].param2 = actdefaultdict[type].param2_default;
				actdict["act" + idaction].param3 = actdefaultdict[type].param3_default;
				actdict["act" + idaction].param4 = actdefaultdict[type].param4_default;
				actdict["act" + idaction].param5 = actdefaultdict[type].param5_default;
				actdict["act" + idaction].param6 = actdefaultdict[type].param6_default;
				actdict["act" + idaction].param7 = actdefaultdict[type].param7_default;
				actdict["act" + idaction].param8 = actdefaultdict[type].param8_default;
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlaction&camp0=id&value0=" + idaction + "&camp1=host&value1=" + actdefaultdict[type].host_default + "&camp2=port&value2=" + actdefaultdict[type].port_default + "&camp3=param1&value3=" + actdefaultdict[type].param1_default + "&camp4=param2&value4=" + actdefaultdict[type].param2_default + "&camp5=actiontype&value5=" + type + "&camp6=param3&value6=" + actdefaultdict[type].param3_default + "&camp7=param4&value7=" + actdefaultdict[type].param4_default + "&camp8=param5&value8=" + actdefaultdict[type].param5_default + "&camp9=param6&value9=" + actdefaultdict[type].param6_default + "&camp10=param7&value10=" + actdefaultdict[type].param7_default + "&camp11=param8&value11=" + actdefaultdict[type].param8_default + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
			}
			else
			{
				type = e.oldData.actiontype;
			}
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlaction&camp0=id&value0=" + e.oldData.id + "&camp1=listid&value1=" + e.oldData.listid + "&camp2=description&value2=" + description + "&camp3=enabled&value3=" + active + "&camp4=actiontype&value4=" + type + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
		},
		onRowInserting: function(e)
		{
			var urlinsert = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlaction&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101T000000&loglevel=debug" + localStorage.getItem("TOKEN");
			urlinsert += "&camp3=reserve&value3=";
			urlinsert += "&camp4=initdate&value4=20000101T000000";
			urlinsert += "&camp5=enddate&value5=30000101T000000";
			urlinsert += "&camp6=sunday&value6=111111111111111111111111";
			urlinsert += "&camp7=monday&value7=111111111111111111111111";
			urlinsert += "&camp8=tuesday&value8=111111111111111111111111";
			urlinsert += "&camp9=wednesday&value9=111111111111111111111111";
			urlinsert += "&camp10=thursday&value10=111111111111111111111111";
			urlinsert += "&camp11=friday&value11=111111111111111111111111";
			urlinsert += "&camp12=saturday&value12=111111111111111111111111";
			urlinsert += "&camp13=listid&value13=" + id_lista;
			urlinsert += "&camp14=description&value14=" + e.data.description.replaceAll('"', '').replaceAll('\'', '');
			urlinsert += "&camp15=actiontype&value15=" + e.data.actiontype;
			urlinsert += "&camp16=host&value16=" + actdefaultdict[e.data.actiontype].host_default;
			urlinsert += "&camp17=port&value17=" + actdefaultdict[e.data.actiontype].port_default;
			urlinsert += "&camp18=param1&value18=" + actdefaultdict[e.data.actiontype].param1_default;
			urlinsert += "&camp19=param2&value19=" + actdefaultdict[e.data.actiontype].param2_default;
			urlinsert += "&camp20=param3&value20=" + actdefaultdict[e.data.actiontype].param3_default;
			urlinsert += "&camp21=param4&value21=" + actdefaultdict[e.data.actiontype].param4_default;
			urlinsert += "&camp22=param5&value22=" + actdefaultdict[e.data.actiontype].param5_default;
			urlinsert += "&camp23=param6&value23=" + actdefaultdict[e.data.actiontype].param6_default;
			urlinsert += "&camp24=param7&value24=" + actdefaultdict[e.data.actiontype].param7_default;
			urlinsert += "&camp25=param8&value25=" + actdefaultdict[e.data.actiontype].param8_default;
			urlinsert += "&camp26=enabled&value26=" + e.data.enabled;
			urlinsert += "&camp27=minconf&value27=0";
			urlinsert += "&camp28=maxconf&value28=100";
			var jqxhr = $.ajax(
			{
				url: urlinsert,
				async: false,
			});
			loadactions(id_lista, name_lista, true);
		},
		onRowRemoving: function(e)
		{
			$("#actions").hide();
			var jqxhr = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlaction&camp0=id&comp0=equal&value0=" + e.key + "&camp1=listid&comp1=equal&value1=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
				}
			});
			loadactions(id_lista, name_lista, true);
		},
		selection:
		{
			mode: "single"
		},
		onSelectionChanged: function(selectedItems)
		{
			var data = selectedItems.selectedRowsData[0];
			if (data)
			{
				idaction = data.id;
				selectedaction = actdict["act" + idaction];
				$("#actions").show();
				$.each(optionactions, function(i, item)
				{
					$("#" + item.id).hide();
				});

			    //mostrar conditiontitle
				$("#conditiontitle").show();
				$("#conditiondiv").show()

			    //load min and max conf fields:
				LoadConfidence(actdict["act" + idaction].minconf, actdict["act" + idaction].maxconf);

				$("#" + selectedaction.actiontype).show();
				$("#scheduler").find(".reservation").remove();
				var $rsvns = getreservationscheduler(0, selectedaction.sunday);
				for (i = 0; i < $rsvns.length; i++)
				{
					$(".rsvn-container").append($rsvns[i]);
				}
				var $rsvns1 = getreservationscheduler(1, selectedaction.monday);
				for (i = 0; i < $rsvns1.length; i++)
				{
					$(".rsvn-container").append($rsvns1[i]);
				}
				var $rsvns2 = getreservationscheduler(2, selectedaction.tuesday);
				for (i = 0; i < $rsvns2.length; i++)
				{
					$(".rsvn-container").append($rsvns2[i]);
				}
				var $rsvns3 = getreservationscheduler(3, selectedaction.wednesday);
				for (i = 0; i < $rsvns3.length; i++)
				{
					$(".rsvn-container").append($rsvns3[i]);
				}
				var $rsvns4 = getreservationscheduler(4, selectedaction.thursday);
				for (i = 0; i < $rsvns4.length; i++)
				{
					$(".rsvn-container").append($rsvns4[i]);
				}
				var $rsvns5 = getreservationscheduler(5, selectedaction.friday);
				for (i = 0; i < $rsvns5.length; i++)
				{
					$(".rsvn-container").append($rsvns5[i]);
				}
				var $rsvns6 = getreservationscheduler(6, selectedaction.saturday);
				for (i = 0; i < $rsvns6.length; i++)
				{
					$(".rsvn-container").append($rsvns6[i]);
				}
				if (selectedaction.actiontype == "SOCKET_CLIENT_ACTION")
				{
					$("#elemhost0").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport0").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam10").dxRadioGroup("instance").option("value", selectedaction.param1);
				}
				if (selectedaction.actiontype == "SOCKET_SERVER_ACTION")
				{
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport1").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam11").dxRadioGroup("instance").option("value", selectedaction.param1);
				}
				if (selectedaction.actiontype == "ONVIF_EVENT_ACTION")
				{
					$("#elemhost2").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport2").dxNumberBox("instance").option("value", selectedaction.port);
				}
				if (selectedaction.actiontype == "IO_ACTION")
				{
					$("#elemparam13").dxRadioGroup("instance").option("value", selectedaction.param1);
					if (selectedaction.param2 == "null") selectedaction.param2 = 1;
					$("#elemparam23").dxNumberBox("instance").option("value", selectedaction.param2);
					if (selectedaction.param3 == "null") selectedaction.param3 = 1;
					$("#elemparam33").dxNumberBox("instance").option("value", selectedaction.param3);
					if (DEFINE_INTERFACE == "VIVOTEK")
					{
						if (selectedaction.param4 == "null") selectedaction.param4 = 1;
						$("#elemparam43").dxNumberBox("instance").option("value", selectedaction.param4);
					}
				}
				if (selectedaction.actiontype == "FTP_ACTION")
				{
					$("#elemhost4").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport4").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam14").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam24").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam34").dxTextBox("instance").option("value", selectedaction.param3);
					$("#elemparam44").dxTextBox("instance").option("value", selectedaction.param4);
					$("#elemparam54").dxRadioGroup("instance").option("value", selectedaction.param5);
					$("#elemparam64").dxRadioGroup("instance").option("value", selectedaction.param6);
				}
				if (selectedaction.actiontype == "HTTP_ACTION")
				{
					$("#elemhost5").dxRadioGroup("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = "NONE";
					$("#elemport5").dxRadioGroup("instance").option("value", selectedaction.port);
					$("#elemparam15").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam25").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam35").dxTextBox("instance").option("value", selectedaction.param3);
					$("#elemparam45").dxTextBox("instance").option("value", selectedaction.param4);
					$("#elemparam55").dxTextBox("instance").option("value", selectedaction.param5);
				}
				if (selectedaction.actiontype == "MILESTONE")
				{
					$("#elemhost6").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport6").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam16").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam26").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam36").dxTextBox("instance").option("value", selectedaction.param3);
				}
				if (selectedaction.actiontype == "WIEGAND")
				{
					$("#elemhost7").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport7").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam17").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam27").dxRadioGroup("instance").option("value", selectedaction.param2);
				}
				if (selectedaction.actiontype == "VAST")
				{
					$("#elemhost8").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport8").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam18").dxRadioGroup("instance").option("value", selectedaction.param1);
				}
				if (selectedaction.actiontype == "TRIGGER_SERVER_ACTION")
				{
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport9").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam19").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam29").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam39").dxTextBox("instance").option("value", selectedaction.param3);
					$("#elemparam49").dxTextBox("instance").option("value", selectedaction.param4);
				}
				if (selectedaction.actiontype == "MEYPAR_SERVER_ACTION")
				{
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport10").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam110").dxNumberBox("instance").option("value", selectedaction.param1);
					$("#elemparam210").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam310").dxNumberBox("instance").option("value", selectedaction.param3);
				}
				if (selectedaction.actiontype == "WIEGAND_SOYAL_ACTION")
				{
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemhost11").dxTextBox("instance").option("value", selectedaction.host);
					$("#elemport11").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam111").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam211").dxRadioGroup("instance").option("value", selectedaction.param2);
				}
				if (selectedaction.actiontype == "FTP_JPG_MTT_ACTION")
				{
					$("#elemhost12").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport12").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam112").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam212").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam312").dxTextBox("instance").option("value", selectedaction.param3);
					$("#elemparam412").dxTextBox("instance").option("value", selectedaction.param4);
				}
				if (selectedaction.actiontype == "EMAIL_ACTION")
				{
					$("#elemhost13").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport13").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam113").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam213").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam313").dxTextBox("instance").option("value", selectedaction.param3);
					$("#elemparam413").dxTextBox("instance").option("value", selectedaction.param4);
					$("#elemparam513").dxTextBox("instance").option("value", selectedaction.param5);
					$("#elemparam613").dxTextBox("instance").option("value", selectedaction.param6);
					$("#elemparam713").dxTextBox("instance").option("value", selectedaction.param7);
				}
				if (selectedaction.actiontype == "FTP_JPG_MTTCL_ACTION")
				{
					$("#elemhost14").dxTextBox("instance").option("value", selectedaction.host);
					if (selectedaction.port == "null") selectedaction.port = 1;
					$("#elemport14").dxNumberBox("instance").option("value", selectedaction.port);
					$("#elemparam114").dxRadioGroup("instance").option("value", selectedaction.param1);
					$("#elemparam214").dxTextBox("instance").option("value", selectedaction.param2);
					$("#elemparam314").dxTextBox("instance").option("value", selectedaction.param3);
					$("#elemparam414").dxTextBox("instance").option("value", selectedaction.param4);
					$("#elemparam514").dxRadioGroup("instance").option("value", selectedaction.param5);
				}
				if (selectedaction.actiontype == "PROTOCOL_PSS_ACTION")
				{
				    $("#elemhost15").dxTextBox("instance").option("value", selectedaction.host);
				    if (selectedaction.port == "null") selectedaction.port = 1;
				    $("#elemport15").dxNumberBox("instance").option("value", selectedaction.port);
				    $("#elemparam115").dxTextBox("instance").option("value", selectedaction.param1);
				    $("#elemparam215").dxTextBox("instance").option("value", selectedaction.param2);
				    $("#elemparam315").text(selectedaction.param3);
				}
				if (selectedaction.actiontype == "ZKTECO_ACTION")
				{
				    $("#elemhost16").dxTextBox("instance").option("value", selectedaction.host);
				    if (selectedaction.port == "null") selectedaction.port = 1;
				    $("#elemport16").dxNumberBox("instance").option("value", selectedaction.port);
				}
            }
		},
	}).dxDataGrid("instance");

	var exports = $("#gridContainer4").dxDataGrid(
	{
		dataSource: exports_listas,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		hoverStateEnabled: true,
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		columns: [
		{
			dataField: "id",
			caption: DevExpress.localization.formatMessage("ID"),
			width: "5%",
			allowEditing: false
		},
		{
			width: "20%",
			dataField: "description",
			caption: DevExpress.localization.formatMessage("Description"),
			validationRules: [
			{
				type: "required"
			}]
		},
		{
			width: "20%",
			dataField: "exporttype",
			caption: DevExpress.localization.formatMessage("Export type"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: optionexports,
				displayExpr: "description",
				valueExpr: "id"
			}
		},
		{
			width: "20%",
			dataField: "interval",
			caption: DevExpress.localization.formatMessage("Interval"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: intervalarray,
				displayExpr: "description",
				valueExpr: "id"
			}
		},
		{
			width: "20%",
			dataField: "enabled",
			caption: DevExpress.localization.formatMessage("Active"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: enabledarrayexport,
				displayExpr: "description",
				valueExpr: "id"
			}
		}],
		editing:
		{
			mode: "row",
			allowUpdating: true,
			allowDeleting: true,
			texts:
			{
				confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the export from list?")
			},
			allowAdding: true
		},
		onRowUpdating: function(e)
		{
			var description;
			var active;
			var type;
			var interval;
			idexport = e.oldData.id;
			if (typeof e.newData.description !== 'undefined')
			{
				description = e.newData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			else
			{
				description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			if (typeof e.newData.enabled !== 'undefined')
			{
				active = e.newData.enabled;
			}
			else
			{
				active = e.oldData.enabled;
			}
			if (typeof e.newData.interval !== 'undefined')
			{
				interval = e.newData.interval;
			}
			else
			{
				interval = e.oldData.interval;
			}
			if (typeof e.newData.exporttype !== 'undefined')
			{
				type = e.newData.exporttype;
				//change groupbox to selected
				$.each(optionexports, function(i, item)
				{
					$("#" + item.id).hide();
				});
				$("#" + type).show();
				expdict["exp" + idexport].exporttype = type;
				expdict["exp" + idexport].host = expdefaultdict[type].host_default;
				expdict["exp" + idexport].port = expdefaultdict[type].port_default;
				expdict["exp" + idexport].param1 = expdefaultdict[type].param1_default;
				expdict["exp" + idexport].param2 = expdefaultdict[type].param2_default;
				expdict["exp" + idexport].param3 = expdefaultdict[type].param3_default;
				expdict["exp" + idexport].param4 = expdefaultdict[type].param4_default;
				expdict["exp" + idexport].param5 = expdefaultdict[type].param5_default;
				expdict["exp" + idexport].param6 = expdefaultdict[type].param6_default;
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlexport&camp0=id&value0=" + idexport + "&camp1=host&value1=" + expdefaultdict[type].host_default + "&camp2=port&value2=" + expdefaultdict[type].port_default + "&camp3=param1&value3=" + expdefaultdict[type].param1_default + "&camp4=param2&value4=" + expdefaultdict[type].param2_default + "&camp5=exporttype&value5=" + type + "&camp6=param3&value6=" + expdefaultdict[type].param3_default + "&camp7=param4&value7=" + expdefaultdict[type].param4_default + "&camp8=param5&value8=" + expdefaultdict[type].param5_default + "&camp9=param6&value9=" + expdefaultdict[type].param6_default + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
			}
			else
			{
				type = e.oldData.exporttype;
			}
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlexport&camp0=id&value0=" + e.oldData.id + "&camp1=listid&value1=" + e.oldData.listid + "&camp2=description&value2=" + description + "&camp3=enabled&value3=" + active + "&camp4=exporttype&value4=" + type + "&camp5=interval&value5=" + interval + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
		},
		onRowInserting: function(e)
		{
			var urlinsert = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlexport&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101T000000" + localStorage.getItem("TOKEN");
			urlinsert += "&camp3=reserve&value3=";
			urlinsert += "&camp4=initdate&value4=20000101T000000";
			urlinsert += "&camp5=enddate&value5=30000101T000000";
			urlinsert += "&camp6=interval&value6=" + e.data.interval;
			urlinsert += "&camp7=listid&value7=" + id_lista;
			urlinsert += "&camp8=description&value8=" + e.data.description.replaceAll('"', '').replaceAll('\'', '');
			urlinsert += "&camp9=exporttype&value9=" + e.data.exporttype;
			urlinsert += "&camp10=host&value10=" + expdefaultdict[e.data.exporttype].host_default;
			urlinsert += "&camp11=port&value11=" + expdefaultdict[e.data.exporttype].port_default;
			urlinsert += "&camp12=param1&value12=" + expdefaultdict[e.data.exporttype].param1_default;
			urlinsert += "&camp13=param2&value13=" + expdefaultdict[e.data.exporttype].param2_default;
			urlinsert += "&camp14=param3&value14=" + expdefaultdict[e.data.exporttype].param3_default;
			urlinsert += "&camp15=param4&value15=" + expdefaultdict[e.data.exporttype].param4_default;
			urlinsert += "&camp16=param5&value16=" + expdefaultdict[e.data.exporttype].param5_default;
			urlinsert += "&camp17=enabled&value17=" + e.data.enabled;
			urlinsert += "&camp18=param6&value18=" + expdefaultdict[e.data.exporttype].param6_default + "&dd" + getStringNormalDate(new Date());
			var jqxhr = $.ajax(
			{
				url: urlinsert,
				async: false,
			});
			loadexports(id_lista, name_lista, true);
		},
		onRowRemoving: function(e)
		{
			$("#exports").hide();
			var jqxhr = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlexport&camp0=id&comp0=equal&value0=" + e.key + "&camp1=listid&comp1=equal&value1=" + id_lista + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
				}
			});
			loadexports(id_lista, name_lista, true);
		},
		selection:
		{
			mode: "single"
		},
		onSelectionChanged: function(selectedItems)
		{
			var data = selectedItems.selectedRowsData[0];
			if (data)
			{
				idexport = data.id;
				selectedexport = expdict["exp" + idexport];
				$("#exports").show();
				$.each(optionexports, function(i, item)
				{
					$("#" + item.id).hide();
				});
				$("#" + selectedexport.exporttype).show();
				if (selectedexport.exporttype == "LOCAL_EXPORT")
				{
					$("#elemparam1100").dxRadioGroup("instance").option("value", selectedexport.param1);
					$("#elemparam2100").dxRadioGroup("instance").option("value", selectedexport.param2);
				}
				if (selectedexport.exporttype == "FTP_EXPORT")
				{
					$("#elemhost101").dxTextBox("instance").option("value", selectedexport.host);
					$("#elemport101").dxNumberBox("instance").option("value", selectedexport.port);
					$("#elemparam1101").dxRadioGroup("instance").option("value", selectedexport.param1);
					$("#elemparam2101").dxTextBox("instance").option("value", selectedexport.param2);
					$("#elemparam3101").dxTextBox("instance").option("value", selectedexport.param3);
					$("#elemparam4101").dxTextBox("instance").option("value", selectedexport.param4);
					$("#elemparam5101").dxRadioGroup("instance").option("value", selectedexport.param5);
					$("#elemparam6101").dxRadioGroup("instance").option("value", selectedexport.param6);
				}
				if (selectedexport.exporttype == "LOCAL_DATA_EXPORT")
				{
					$("#elemparam1102").dxRadioGroup("instance").option("value", selectedexport.param1);
				}
				if (selectedexport.exporttype == "FTP_DATA_EXPORT")
				{
					$("#elemhost103").dxTextBox("instance").option("value", selectedexport.host);
					$("#elemport103").dxNumberBox("instance").option("value", selectedexport.port);
					$("#elemparam1103").dxRadioGroup("instance").option("value", selectedexport.param1);
					$("#elemparam2103").dxTextBox("instance").option("value", selectedexport.param2);
					$("#elemparam3103").dxTextBox("instance").option("value", selectedexport.param3);
					$("#elemparam4103").dxTextBox("instance").option("value", selectedexport.param4);
					$("#elemparam5103").dxRadioGroup("instance").option("value", selectedexport.param5);
					$("#elemparam6103").dxRadioGroup("instance").option("value", selectedexport.param6);
				}
			}
		}
	}).dxDataGrid("instance");
	
	var imports = $("#gridContainer5").dxDataGrid(
	{
		dataSource: imports_listas,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		hoverStateEnabled: true,
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		columns: [
		{
			dataField: "id",
			caption: DevExpress.localization.formatMessage("ID"),
			width: "5%",
			allowEditing: false
		},
		{
			width: "20%",
			dataField: "description",
			caption: DevExpress.localization.formatMessage("Description"),
			validationRules: [
			{
				type: "required"
			}]
		},
		{
			width: "20%",
			dataField: "importtype",
			caption: DevExpress.localization.formatMessage("Import type"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: optionimports,
				displayExpr: "description",
				valueExpr: "id"
			}
		},
		{
			width: "20%",
			dataField: "interval",
			caption: DevExpress.localization.formatMessage("Interval"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: intervalarray,
				displayExpr: "description",
				valueExpr: "id"
			}
		},
		{
			width: "20%",
			dataField: "enabled",
			caption: DevExpress.localization.formatMessage("Active"),
			validationRules: [
			{
				type: "required"
			}],
			lookup:
			{
				dataSource: enabledarrayexport,
				displayExpr: "description",
				valueExpr: "id"
			}
		}],
		editing:
		{
			mode: "row",
			allowUpdating: true,
			allowDeleting: true,
			texts:
			{
				confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the import from list?")
			},
			allowAdding: true
		},
		onRowUpdating: function(e)
		{
			var description;
			var active;
			var type;
			var interval;
			idimport = e.oldData.id;
			if (typeof e.newData.description !== 'undefined')
			{
				description = e.newData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			else
			{
				description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '');
			}
			if (typeof e.newData.enabled !== 'undefined')
			{
				active = e.newData.enabled;
			}
			else
			{
				active = e.oldData.enabled;
			}
			if (typeof e.newData.interval !== 'undefined')
			{
				interval = e.newData.interval;
			}
			else
			{
				interval = e.oldData.interval;
			}
			if (typeof e.newData.importtype !== 'undefined')
			{
				type = e.newData.importtype;
				//change groupbox to selected
				$.each(optionimports, function(i, item)
				{
					$("#" + item.id).hide();
				});
				$("#" + type).show();
				impdict["imp" + idimport].importtype = type;
				impdict["imp" + idimport].host = impdefaultdict[type].host_default;
				impdict["imp" + idimport].port = impdefaultdict[type].port_default;
				impdict["imp" + idimport].param1 = impdefaultdict[type].param1_default;
				impdict["imp" + idimport].param2 = impdefaultdict[type].param2_default;
				impdict["imp" + idimport].param3 = impdefaultdict[type].param3_default;
				impdict["imp" + idimport].param4 = impdefaultdict[type].param4_default;
				impdict["imp" + idimport].param5 = impdefaultdict[type].param5_default;
				impdict["imp" + idimport].param6 = impdefaultdict[type].param6_default;
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlimport&camp0=id&value0=" + idimport + "&camp1=host&value1=" + impdefaultdict[type].host_default + "&camp2=port&value2=" + impdefaultdict[type].port_default + "&camp3=param1&value3=" + impdefaultdict[type].param1_default + "&camp4=param2&value4=" + impdefaultdict[type].param2_default + "&camp5=importtype&value5=" + type + "&camp6=param3&value6=" + impdefaultdict[type].param3_default + "&camp7=param4&value7=" + impdefaultdict[type].param4_default + "&camp8=param5&value8=" + impdefaultdict[type].param5_default + "&camp9=param6&value9=" + impdefaultdict[type].param6_default + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
			}
			else
			{
				type = e.oldData.importtype;
			}
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlimport&camp0=id&value0=" + e.oldData.id + "&camp1=listid&value1=" + e.oldData.listid + "&camp2=description&value2=" + description + "&camp3=enabled&value3=" + active + "&camp4=importtype&value4=" + type + "&camp5=interval&value5=" + interval + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
		},
		onRowInserting: function(e)
		{
			var urlinsert = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlimport&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101T000000" + localStorage.getItem("TOKEN");
			urlinsert += "&camp3=reserve&value3=";
			urlinsert += "&camp4=initdate&value4=20000101T000000";
			urlinsert += "&camp5=enddate&value5=30000101T000000";
			urlinsert += "&camp6=interval&value6=" + e.data.interval;
			urlinsert += "&camp7=listid&value7=" + id_lista;
			urlinsert += "&camp8=description&value8=" + e.data.description.replaceAll('"', '').replaceAll('\'', '');
			urlinsert += "&camp9=importtype&value9=" + e.data.importtype;
			urlinsert += "&camp10=host&value10=" + impdefaultdict[e.data.importtype].host_default;
			urlinsert += "&camp11=port&value11=" + impdefaultdict[e.data.importtype].port_default;
			urlinsert += "&camp12=param1&value12=" + impdefaultdict[e.data.importtype].param1_default;
			urlinsert += "&camp13=param2&value13=" + impdefaultdict[e.data.importtype].param2_default;
			urlinsert += "&camp14=param3&value14=" + impdefaultdict[e.data.importtype].param3_default;
			urlinsert += "&camp15=param4&value15=" + impdefaultdict[e.data.importtype].param4_default;
			urlinsert += "&camp16=param5&value16=" + impdefaultdict[e.data.importtype].param5_default;
			urlinsert += "&camp17=enabled&value17=" + e.data.enabled;
			urlinsert += "&camp18=param6&value18=" + impdefaultdict[e.data.importtype].param6_default + "&dd" + getStringNormalDate(new Date());
			var jqxhr = $.ajax(
			{
				url: urlinsert,
				async: false,
			});
			loadimports(id_lista, name_lista, true);
		},
		onRowRemoving: function(e)
		{
			$("#imports").hide();
			var jqxhr = $.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlimport&camp0=id&comp0=equal&value0=" + e.key + "&camp1=listid&comp1=equal&value1=" + id_lista + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
				}
			});
			loadimports(id_lista, name_lista, true);
		},
		selection:
		{
			mode: "single"
		},
		onSelectionChanged: function(selectedItems)
		{
			var data = selectedItems.selectedRowsData[0];
			if (data)
			{
				idimport = data.id;
				selectedimport = impdict["imp" + idimport];
				$("#imports").show();
				$.each(optionimports, function(i, item)
				{
					$("#" + item.id).hide();
				});
				$("#" + selectedimport.importtype).show();
				if (selectedimport.importtype == "FTP_DATA_IMPORT")
				{
					$("#elemhost200").dxTextBox("instance").option("value", selectedimport.host);
					$("#elemport200").dxNumberBox("instance").option("value", selectedimport.port);
					$("#elemparam1200").dxRadioGroup("instance").option("value", selectedimport.param1);
					$("#elemparam2200").dxTextBox("instance").option("value", selectedimport.param2);
					$("#elemparam3200").dxTextBox("instance").option("value", selectedimport.param3);
					$("#elemparam4200").dxTextBox("instance").option("value", selectedimport.param4);
					//porque no hay param5, pero aparece en la página???  Voy añadir ... ?
					$("#elemparam5200").dxRadioGroup("instance").option("value", selectedimport.param5);
					$("#elemparam6200").dxRadioGroup("instance").option("value", selectedimport.param6);
				}
				if (selectedimport.importtype == "SINCRO")
				{
					$("#elemhost201").dxTextBox("instance").option("value", selectedimport.host);
					$("#elemparam3201").dxTextBox("instance").option("value", selectedimport.param3);
					$("#elemparam4201").dxTextBox("instance").option("value", selectedimport.param4);
				}
			}
		}
	}).dxDataGrid("instance");
	
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getconfig&dd=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			//action types
			actionlist = data[2];
			$.each(data[2], function(i, item)
			{
				if (item.enabled == 1)
				{
					var action = {};
					action["id"] = item.actiontype;
					action["description"] = item.text;
					actdefaultdict[item.actiontype] = item;
					optionactions.push(action);
					var div = "<div class='dx-fieldset' id= '" + item.actiontype + "'  ></div>";
					//var div = "<div class='dx-fieldset' id= '" + item.actiontype + "'  ></div>";
					$("#actions").append(div);
					$("#" + item.actiontype).hide();
					$("#" + item.actiontype).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("Action Info") + "</div><div class='dx-field-value'><div id='iconinfo" + i + "' style='float: none;' ></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
					$("#iconinfo" + i).dxButton(
					{
						icon: "help",
						type: "success",
						mode: "contained",
						onClick: function(e)
						{
							var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
								.done(function(data)
								{
									$("#popupinfo" + i).append(data);
									var poup = $("#popupinfo" + i).dxPopup(
									{
										showTitle: true,
										title: DevExpress.localization.formatMessage("Help"),
										visible: true,
										maxWidth: 500,
										maxHeight: 700,
										loseOnOutsideClick: true
									});
								});
						}
					});
					
					if (item.host != "")
					{
						if (item.host_type == "option")
						{
							setoptiondiv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
						}
						if (item.host_type == "int")
						{
							setintdiv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
						}
						if (item.host_type == "string")
						{
							setstringdiv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
						}
						if (item.host_type == "file")
						{
							setfilediv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
						}
					}
					
					if (item.port != "")
					{
						if (item.port_type == "option")
						{
							setoptiondiv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
						}
						if (item.port_type == "int")
						{
							setintdiv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
						}
						if (item.port_type == "string")
						{
							setstringdiv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
						}
						if (item.port_type == "file")
						{
							setfilediv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
						}
					}
					
					if (item.param1 != "")
					{
						if (item.param1_type == "option")
						{
							setoptiondiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
						}
						if (item.param1_type == "int")
						{
							setintdiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
						}
						if (item.param1_type == "string")
						{
							setstringdiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
						}
						if (item.param1_type == "file")
						{
							setfilediv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
						}
						if (item.param1_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
						}
					}
					
					if (item.param2 != "")
					{
						if (item.param2_type == "option")
						{
							setoptiondiv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
						}
						if (item.param2_type == "int")
						{
							setintdiv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
						}
						if (item.param2_type == "string")
						{
							setstringdiv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
						}
						if (item.param2_type == "file")
						{
							setfilediv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
						}
						if (item.param2_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param2, i, "param2", item.param1_options, item.param1_default, "nlaction", item.param2_help)
						}
					}
					
					if (item.param3 != "")
					{
						if (item.param3_type == "option")
						{
							setoptiondiv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
						}
						if (item.param3_type == "int")
						{
							setintdiv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
						}
						if (item.param3_type == "string")
						{
							setstringdiv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
						}
						if (item.param3_type == "file")
						{
							setfilediv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
						}
						if (item.param3_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param3, i, "param3", item.param1_options, item.param1_default, "nlaction", item.param3_help)
						}
					}
					
					if (item.param4 != "")
					{
						if (item.param4_type == "option")
						{
							setoptiondiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
						}
						if (item.param4_type == "int")
						{
							setintdiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
						}
						if (item.param4_type == "string")
						{
							setstringdiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
						}
						if (item.param4_type == "file")
						{
							setfilediv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
						}
						if (item.param4_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param4, i, "param4", item.param1_options, item.param1_default, "nlaction", item.param4_help)
						}
					}
					
					if (item.param5 != "")
					{
						if (item.param5_type == "option")
						{
							setoptiondiv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
						}
						if (item.param5_type == "int")
						{
							setintdiv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
						}
						if (item.param5_type == "string")
						{
							setstringdiv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
						}
						if (item.param5_type == "file")
						{
							setfilediv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
						}
						if (item.param5_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param5, i, "param5", item.param1_options, item.param1_default, "nlaction", item.param5_help)
						}
					}
					
					if (item.param6 != "")
					{
						if (item.param6_type == "option")
						{
							setoptiondiv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
						}
						if (item.param6_type == "int")
						{
							setintdiv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
						}
						if (item.param6_type == "string")
						{
							setstringdiv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
						}
						if (item.param6_type == "file")
						{
							setfilediv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
						}
						if (item.param6_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param6, i, "param6", item.param1_options, item.param1_default, "nlaction", item.param6_help)
						}
					}
					
					if (item.param7 != "")
					{
						if (item.param7_type == "option")
						{
							setoptiondiv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
						}
						if (item.param7_type == "int")
						{
							setintdiv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
						}
						if (item.param7_type == "string")
						{
							setstringdiv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
						}
						if (item.param7_type == "file")
						{
							setfilediv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
						}
						if (item.param7_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param7, i, "param7", item.param1_options, item.param1_default, "nlaction", item.param7_help)
						}
					}
					
					if (item.param8 != "")
					{
						if (item.param8_type == "option")
						{
							setoptiondiv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
						}
						if (item.param8_type == "int")
						{
							setintdiv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
						}
						if (item.param8_type == "string")
						{
							setstringdiv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
						}
						if (item.param8_type == "file")
						{
							setfilediv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
						}
						if (item.param8_type == "buttonbind")
						{
							setbinddiv(item.actiontype, item.param8, i, "param8", item.param1_options, item.param1_default, "nlaction", item.param8_help)
						}
					}
				}
			});
			
			exportlist = data[3];
			$.each(data[3], function(i, item)
			{
				if (item.enabled == 1)
				{
					var action = {};
					action["id"] = item.exporttype;
					action["description"] = item.text;
					expdefaultdict[item.exporttype] = item;
					optionexports.push(action);
					var div = "<div class='dx-fieldset' id= '" + item.exporttype + "'  ></div>";
					//var div = "<div class='dx-fieldset' id= '" + item.actiontype + "'  ></div>";
					$("#exports").append(div);
					$("#" + item.exporttype).hide();
					$("#" + item.exporttype).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("Export Info") + "</div><div class='dx-field-value'><div id='iconinfo" + (i + 100) + "' style='float: none;' ></div><div id='popupinfo" + (i + 100) + "' style='display:none' ></div></div></div>");
					$("#iconinfo" + (i + 100)).dxButton(
					{
						icon: "help",
						type: "success",
						mode: "contained",
						onClick: function(e)
						{
							var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
								.done(function(data)
								{
									$("#popupinfo" + (i + 100)).append(data);
									var poup = $("#popupinfo" + (i + 100)).dxPopup(
									{
										showTitle: true,
										title: DevExpress.localization.formatMessage("Help"),
										visible: true,
										maxWidth: 500,
										maxHeight: 350,
										loseOnOutsideClick: true
									});
								});
						}
					});
					
					if (item.host != "")
					{
						if (item.host_type == "option")
						{
							setoptiondiv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
						}
						if (item.host_type == "int")
						{
							setintdiv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
						}
						if (item.host_type == "string")
						{
							setstringdiv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
						}
						if (item.host_type == "file")
						{
							setfilediv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
						}
					}
					
					if (item.port != "")
					{
						if (item.port_type == "option")
						{
							setoptiondiv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
						}
						if (item.port_type == "int")
						{
							setintdiv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
						}
						if (item.port_type == "string")
						{
							setstringdiv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
						}
						if (item.port_type == "file")
						{
							setfilediv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
						}
					}
					
					if (item.param1 != "")
					{
						if (item.param1_type == "option")
						{
							setoptiondiv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
						}
						if (item.param1_type == "int")
						{
							setintdiv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
						}
						if (item.param1_type == "string")
						{
							setstringdiv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
						}
						if (item.param1_type == "file")
						{
							setfilediv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
						}
					}
					
					if (item.param2 != "")
					{
						if (item.param2_type == "option")
						{
							setoptiondiv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
						}
						if (item.param2_type == "int")
						{
							setintdiv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
						}
						if (item.param2_type == "string")
						{
							setstringdiv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
						}
						if (item.param2_type == "file")
						{
							setfilediv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
						}
					}
					
					if (item.param3 != "")
					{
						if (item.param3_type == "option")
						{
							setoptiondiv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
						}
						if (item.param3_type == "int")
						{
							setintdiv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
						}
						if (item.param3_type == "string")
						{
							setstringdiv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
						}
						if (item.param3_type == "file")
						{
							setfilediv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
						}
					}
					
					if (item.param4 != "")
					{
						if (item.param4_type == "option")
						{
							setoptiondiv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
						}
						if (item.param4_type == "int")
						{
							setintdiv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
						}
						if (item.param4_type == "string")
						{
							setstringdiv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
						}
						if (item.param4_type == "file")
						{
							setfilediv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
						}
					}
					
					if (item.param5 != "")
					{
						if (item.param5_type == "option")
						{
							setoptiondiv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
						}
						if (item.param5_type == "int")
						{
							setintdiv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
						}
						if (item.param5_type == "string")
						{
							setstringdiv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
						}
						if (item.param5_type == "file")
						{
							setfilediv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
						}
					}
					
					if (item.param6 != "")
					{
						if (item.param6_type == "option")
						{
							setoptiondiv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
						}
						if (item.param6_type == "int")
						{
							setintdiv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
						}
						if (item.param6_type == "string")
						{
							setstringdiv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
						}
						if (item.param6_type == "file")
						{
							setfilediv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
						}
					}
				}
			});
			
			importlist = data[4];
			$.each(importlist, function(i, item)
			{
				if (item.enabled == 1)
				{
					var action = {};
					action["id"] = item.importtype;
					action["description"] = item.text;
					impdefaultdict[item.importtype] = item;
					optionimports.push(action);
					var div = "<div class='dx-fieldset' id= '" + item.importtype + "'  ></div>";
					$("#imports").append(div);
					$("#" + item.importtype).hide();
					$("#" + item.importtype).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("Import Info") + "</div><div class='dx-field-value'><div id='iconinfo" + (i + 200) + "' style='float: none;' ></div><div id='popupinfo" + (i + 200) + "' style='display:none' ></div></div></div>");
					$("#iconinfo" + (i + 200)).dxButton(
					{
						icon: "help",
						type: "success",
						mode: "contained",
						onClick: function(e)
						{
							var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
								.done(function(data)
								{
									$("#popupinfo" + (i + 200)).append(data);
									var poup = $("#popupinfo" + (i + 200)).dxPopup(
									{
										showTitle: true,
										title: DevExpress.localization.formatMessage("Help"),
										visible: true,
										maxWidth: 500,
										maxHeight: 350,
										loseOnOutsideClick: true
									});
								});
						}
					});
					
					if (item.host != "")
					{
						if (item.host_type == "option")
						{
							setoptiondiv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
						}
						if (item.host_type == "int")
						{
							setintdiv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
						}
						if (item.host_type == "string")
						{
							setstringdiv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
						}
						if (item.host_type == "file")
						{
							setfilediv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
						}
					}
					
					if (item.port != "")
					{
						if (item.port_type == "option")
						{
							setoptiondiv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
						}
						if (item.port_type == "int")
						{
							setintdiv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
						}
						if (item.port_type == "string")
						{
							setstringdiv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
						}
						if (item.port_type == "file")
						{
							setfilediv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
						}
					}
					
					if (item.param1 != "")
					{
						if (item.param1_type == "option")
						{
							setoptiondiv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
						}
						if (item.param1_type == "int")
						{
							setintdiv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
						}
						if (item.param1_type == "string")
						{
							setstringdiv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
						}
						if (item.param1_type == "file")
						{
							setfilediv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
						}
					}
					
					if (item.param2 != "")
					{
						if (item.param2_type == "option")
						{
							setoptiondiv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
						}
						if (item.param2_type == "int")
						{
							setintdiv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
						}
						if (item.param2_type == "string")
						{
							setstringdiv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
						}
						if (item.param2_type == "file")
						{
							setfilediv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
						}
					}
					
					if (item.param3 != "")
					{
						if (item.param3_type == "option")
						{
							setoptiondiv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
						}
						if (item.param3_type == "int")
						{
							setintdiv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
						}
						if (item.param3_type == "string")
						{
							setstringdiv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
						}
						if (item.param3_type == "file")
						{
							setfilediv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
						}
					}
					
					if (item.param4 != "")
					{
						if (item.param4_type == "option")
						{
							setoptiondiv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
						}
						if (item.param4_type == "int")
						{
							setintdiv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
						}
						if (item.param4_type == "string")
						{
							setstringdiv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
						}
						if (item.param4_type == "file")
						{
							setfilediv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
						}
					}
					
					if (item.param5 != "")
					{
						if (item.param5_type == "option")
						{
							setoptiondiv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
						}
						if (item.param5_type == "int")
						{
							setintdiv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
						}
						if (item.param5_type == "string")
						{
							setstringdiv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
						}
						if (item.param5_type == "file")
						{
							setfilediv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
						}
					}
					
					if (item.param6 != "")
					{
						if (item.param6_type == "option")
						{
							setoptiondiv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
						}
						if (item.param6_type == "int")
						{
							setintdiv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
						}
						if (item.param6_type == "string")
						{
							setstringdiv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
						}
						if (item.param6_type == "file")
						{
							setfilediv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
						}
					}
				}
			});
			listas = data[0];
			vlists.option("dataSource", listas);
			vlists.selectRows([-1]);
		}
	});
	
	loadelemslist(-1, "not in list", true);
	loadactions(-1, "not in list", true);
	loadexports(-1, "not in list", true);
	loadimports(-1, "not in list", true);
	$("#gridactionlist").hide();
	$("#gridexportlists").hide();
	$("#gridplateslist").hide();
	$("#gridimportlists").hide();
	$("#plateslistdiv").hide();
	$("#imports").hide();
	
	$("#listtypes").click(function()
	{
		if (listypesabierto)
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#gridlistytpes").hide();
			listypesabierto = false;
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#gridlistytpes").show();
			listypesabierto = true;
		}
	});
	
	$("#plateslist").click(function()
	{
		if (listplatesabierto)
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#gridplateslist").hide();
			listplatesabierto = false;
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#gridplateslist").show();
			listplatesabierto = true;
		}
	});
	
	$("#actionlist").click(function()
	{
		if (listactionsabierto)
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#gridactionlist").hide();
			listactionsabierto = false;
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#gridactionlist").show();
			listactionsabierto = true;
		}
	});
	
	$("#exportstitle").click(function()
	{
		if (listexportsabierto)
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#gridexportlists").hide();
			listexportsabierto = false;
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#gridexportlists").show();
			listexportsabierto = true;
		}
	});
	
	$("#importstitle").click(function()
	{
		if (listimportsabierto)
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#gridimportlists").hide();
			listimportsabierto = false;
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#gridimportlists").show();
			listimportsabierto = true;
		}
	});
	
	$("#schedulertitle").click(function()
	{
		if (schedulerdivabierto)
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#schedulerdiv").hide();
			schedulerdivabierto = false;
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#schedulerdiv").show();
			schedulerdivabierto = true;
		}
	});
	
	$("#conditiontitle").click(function()
	{
		if (conditiondivabierto)
		{
			$(this).removeClass('abierto');
			$(this).addClass('cerrado');
			$("#conditiondiv").hide();
			conditiondivabierto = false;
		}
		else
		{
			$(this).addClass('abierto');
			$(this).removeClass('cerrado');
			$("#conditiondiv").show();
			conditiondivabierto = true;
		}
	});

	// Array of sample items
	var Days = [DevExpress.localization.formatMessage('Sun'), DevExpress.localization.formatMessage('Mon'), DevExpress.localization.formatMessage('Tue'), DevExpress.localization.formatMessage('Wed'), DevExpress.localization.formatMessage('Thu'), DevExpress.localization.formatMessage('Fri'), DevExpress.localization.formatMessage('Sat')];
	
	// Initialize
	var sch = $("#scheduler").scheduler(
	{
		items: Days,
		startDate: new Date(),
		startTime: '00:00',
		endTime: '24:00',
		use24Hour: true,
		timeslotHeight: 30,
		timeslotWidth: 44
	});
	
	// Allows for reservation deletion
	$(document).on('click', ".reservation", function()
	{
		$(this).remove();
	});
	
	String.prototype.replaceAt = function(index, replacement)
	{
		return this.substr(0, index) + replacement + this.substr(index + replacement.length);
	}
		
	//initialise scheduler button
	$("#svcheduler").dxButton(
	{
		icon: "check",
		type: "success",
		text: DevExpress.localization.formatMessage("Save scheduler"),
		onClick: function()
		{
			var reservation = $(".reservation-final");
			var finalcal = ["000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000"];
			$.each(reservation, function(i, item)
			{
				var day = parseInt(item.style.top.slice(0, -2)) / 30;
				var starthour = parseInt(item.style.left.slice(0, -2)) / 44;
				var duration = (parseInt(item.style.width.slice(0, -2)) - 1) / 44;
				var i;
				for (i = 0; i < duration; i++)
				{
					finalcal[day] = finalcal[day].replaceAt(starthour + i, "1");
				}
			});
			var query = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlaction&camp0=id&value0=" + idaction + "&camp1=listid&value1=" + id_lista
			query += "&camp2=sunday&value2=" + finalcal[0];
			query += "&camp3=monday&value3=" + finalcal[1];
			query += "&camp4=tuesday&value4=" + finalcal[2];
			query += "&camp5=wednesday&value5=" + finalcal[3];
			query += "&camp6=thursday&value6=" + finalcal[4];
			query += "&camp7=friday&value7=" + finalcal[5];
			query += "&camp8=saturday&value8=" + finalcal[6] + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			actdict["act" + idaction].sunday = finalcal[0];
			actdict["act" + idaction].monday = finalcal[1];
			actdict["act" + idaction].tuesday = finalcal[2];
			actdict["act" + idaction].wednesday = finalcal[3];
			actdict["act" + idaction].thursday = finalcal[4];
			actdict["act" + idaction].friday = finalcal[5];
			actdict["act" + idaction].saturday = finalcal[6];
			var jqxhr = $.ajax(query)
				.done(function()
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				})
				.fail(function()
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				});
		}
	});
	
	var glogs = $("#log_import").dxTextArea(
	{
		value: "",
		readOnly: true,
		height: 100
	}).dxTextArea("instance");
	
	var importbutton = $("#Importbutton").dxFileUploader(
	{
		accept: "*.xml",
		multiple: false,
		value: [],
		width: "50%",
		uploadMode: "instantly",
		selectButtonText: DevExpress.localization.formatMessage("Select import XML/CSV file"),
		labelText: DevExpress.localization.formatMessage("or Drop import XML/CSV file here"),
		invalidFileExtensionMessage: "File type is not allowed",
		allowedFileExtensions: [".XML", ".CSV"],
		chunkSize: 200000,
		uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importlistblob&listid=" + id_lista + "&delete=" + delete_list + localStorage.getItem("TOKEN"),
		showFileList: false,
		onUploaded: function(data)
		{
			loadPanel.hide();
			DevExpress.ui.notify(data.request.responseText, "success", 1500);
			loadelemslist(id_lista, name_lista, true);
			loadlists();
		},
		onUploadError: function(e)
		{
			loadPanel.hide();
			DevExpress.ui.notify("Error uploading file", "error", 1000);
		},
		onUploadStarted: function(e)
		{
			loadPanel.show();
		}
	}).dxFileUploader("instance");
	
	var importactionbutton = $("#ImportActionsbutton").dxFileUploader(
	{
		accept: "*.xml",
		multiple: false,
		value: [],
		width: "50%",
		uploadMode: "instantly",
		selectButtonText: DevExpress.localization.formatMessage("Select import XML/CSV file"),
		labelText: DevExpress.localization.formatMessage("or Drop import XML/CSV file here"),
		invalidFileExtensionMessage: "File type is not allowed",
		allowedFileExtensions: [".XML", ".CSV"],
		chunkSize: 200000,
		uploadUrl: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importlistactionblob&listid=" + id_lista + "&delete=" + delete_action_list + localStorage.getItem("TOKEN"),
		showFileList: false,
		onUploaded: function(data)
		{
			loadPanel.hide();
			DevExpress.ui.notify(data.request.responseText, "success", 1500);
			loadactions(id_lista, name_lista, true);
			loadlists();
		},
		onUploadError: function(e)
		{
			loadPanel.hide();
			DevExpress.ui.notify("Error uploading file", "error", 1000);
		},
		onUploadStarted: function(e)
		{
			loadPanel.show();
		}
	}).dxFileUploader("instance");
	
	var deleteold = $("#deleteold").dxCheckBox(
	{
		value: false,
		width: "50%",
		text: DevExpress.localization.formatMessage("Delete the list elements at import"),
		onValueChanged: function(data)
		{
			delete_list = data.value;
			importbutton.option("uploadUrl", pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importlistblob&listid=" + id_lista + "&delete=" + delete_list + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
		}
	}).dxCheckBox("instance");
	
	var deleteoldaction = $("#deleteoldaction").dxCheckBox(
	{
		value: false,
		width: "50%",
		text: DevExpress.localization.formatMessage("Delete the list elements at import"),
		onValueChanged: function(data)
		{
			delete_action_list = data.value;
			importactionbutton.option("uploadUrl", pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=importlistactionblob&listid=" + id_lista + "&delete=" + delete_action_list + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
		}
	}).dxCheckBox("instance");

	function isValidDate(d)
	{
		return d instanceof Date && !isNaN(d);
	}
	
	$(".dx-fileuploader-input-wrapper .dx-button").css(
	{
		"background-color": "#5cb85c",
		"border-color": "transparent",
		"color": "#fff"
	});
	
	$(".dx-fileuploader-content > .dx-fileuploader-upload-button").css(
	{
		"background-color": "#5cb85c",
		"border-color": "transparent",
		"color": "#fff"
	});
	
	$(".dx-fileuploader-file-container .dx-button").css(
	{
		"background-color": "#5cb85c",
		"border-color": "transparent",
		"color": "#fff"
	});
	
	$("#ExportXML").dxButton(
	{
		text: DevExpress.localization.formatMessage("Export to XML file"),
		onClick: function()
		{
			window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportlist&format=XML&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
		}
	});
	
	$("#ExportCSV").dxButton(
	{
		text: DevExpress.localization.formatMessage("Export to CSV file"),
		onClick: function()
		{
			window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportlist&format=CSV&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
		}
	});
	
	$("#ExportActionsXML").dxButton(
	{
		text: DevExpress.localization.formatMessage("Export to XML file"),
		onClick: function()
		{
			window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportactionlist&format=XML&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
		}
	});
	
	$("#ExportActionsCSV").dxButton(
	{
		text: DevExpress.localization.formatMessage("Export to CSV file"),
		onClick: function()
		{
			window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportactionlist&format=CSV&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
		}
	});
	
	var loadPanel = $(".loadpanel").dxLoadPanel(
	{
		shadingColor: "rgba(0,0,0,0.4)",
		position:
		{
			of: "#gridplateslist"
		},
		visible: false,
		showIndicator: true,
		showPane: true,
		shading: true,
		closeOnOutsideClick: false
	}).dxLoadPanel("instance");
	
	//Loads
	function loadactions(id, name_lista, sincro)
	{
		var d = new Date();
		
		//esconder conditiondiv
		$("#conditiontitle").hide();
		$("#conditiondiv").hide();
		conditiondivabierto = true;
		
		$("#schedulertitle").removeClass('abierto');
		$("#schedulertitle").addClass('cerrado');
		$("#schedulertitle").show();
		$("#schedulerdiv").hide();
		schedulerdivabierto = false;
		
		$.ajax(
		{
		    dataType: "json",
		    async: sincro,
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlaction&camp0=listid&comp0=equal&value0=" + id + "&maxvalues=20&sortdesc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				if (CHECK_USER)
				{
					if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
					{
						var urlCam = window.location.href;
						console.log(urlCam);
						urlCam = urlCam.split(":8090")[0] + ":80";
						if (confirm(data))
						{
							window.location.href = urlCam;
						}
						else
						{
							window.location.href = urlCam;
						}
					}
				}
				actdict = {};
				actions_listas = data;
				$('#actionlist').text(DevExpress.localization.formatMessage('Action for the list') + ': ' + name_lista + " (" + actions_listas.length + ")");
				actions.option("dataSource", actions_listas);
				$.each(data, function(i, item)
				{
					actdict["act" + item.id] = item;
				});
			}
		});
	};

	function loadexports(id, name_lista, sincro)
	{
		var d = new Date();
		$.ajax(
		{
		    dataType: "json",
		    async: sincro,
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlexport&camp0=listid&comp0=equal&value0=" + id + "&maxvalues=20&sortdesc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				if (CHECK_USER)
				{
					if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
					{
						var urlCam = window.location.href;
						console.log(urlCam);
						urlCam = urlCam.split(":8090")[0] + ":80";
						if (confirm(data))
						{
							window.location.href = urlCam;
						}
						else
						{
							window.location.href = urlCam;
						}
					}
				}
				expdict = {};
				exports_listas = data;
				$('#exportstitle').text(DevExpress.localization.formatMessage('Exports for the list') + ': ' + name_lista + " (" + exports_listas.length + ")");
				exports.option("dataSource", exports_listas);
				$.each(data, function(i, item)
				{
					expdict["exp" + item.id] = item;
				});
			}
		});
	};

	function loadimports(id, name_lista, sincro)
	{
		var d = new Date();
		$.ajax(
		{
		    dataType: "json",
		    async: sincro,
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlimport&camp0=listid&comp0=equal&value0=" + id + "&maxvalues=20&sortdesc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				if (CHECK_USER)
				{
					if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
					{
						var urlCam = window.location.href;
						console.log(urlCam);
						urlCam = urlCam.split(":8090")[0] + ":80";
						if (confirm(data))
						{
							window.location.href = urlCam;
						}
						else
						{
							window.location.href = urlCam;
						}
					}
				}
				impdict = {};
				imports_listas = data;
				$('#importstitle').text(DevExpress.localization.formatMessage('Imports for the list') + ': ' + name_lista + " (" + imports_listas.length + ")");
				imports.option("dataSource", imports_listas);
				$.each(data, function(i, item)
				{
					impdict["imp" + item.id] = item;
				});
			}
		});
	};

	function loadelemslist(id, name_lista, sincro)
	{
		var d = new Date();
		//elementos listas
		$.ajax(
		{
		    dataType: "json",
		    async: sincro,
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlelemlist&camp0=listid&comp0=equal&value0=" + id + "&maxvalues=10000&sortdesc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				if (CHECK_USER)
				{
					if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
					{
						var urlCam = window.location.href;
						console.log(urlCam);
						urlCam = urlCam.split(":8090")[0] + ":80";
						if (confirm(data))
						{
							window.location.href = urlCam;
						}
						else
						{
							window.location.href = urlCam;
						}
					}
				}
				elem_listas = data;
				$('#plateslist').text(DevExpress.localization.formatMessage('List of the license plates') + ': ' + name_lista + " (" + elem_listas.length + ")");
				plates.option("dataSource", elem_listas);
			},
			error: function(req, status, err)
			{
				console.log('something went wrong', status, err);
			}
		});
	}

	function loadlists()
	{
		var d = new Date();
		//elementos listas
		$.ajax(
		{
		    dataType: "json",
		    async: false,
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nllist&maxvalues=50&sortasc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				if (CHECK_USER)
				{
					if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
					{
						var urlCam = window.location.href;
						console.log(urlCam);
						urlCam = urlCam.split(":8090")[0] + ":80";
						if (confirm(data))
						{
							window.location.href = urlCam;
						}
						else
						{
							window.location.href = urlCam;
						}
					}
				}
				vlists.option("dataSource", data);
			}
		});
	}
	
	function LoadCurrentDate()
	{
		$.ajax(
		{
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=gettime&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				if (CHECK_USER)
				{
					if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
					{
						var urlCam = window.location.href;
						console.log(urlCam);
						urlCam = urlCam.split(":8090")[0] + ":80";
						if (confirm(data))
						{
							window.location.href = urlCam;
						}
						else
						{
							window.location.href = urlCam;
						}
					}
				}
				d2 = new Date(data);
			}
		});
	}

	function LoadConfidence(currentminconf, currentmaxconf)
	{
		var actualmin = 0;
		var actualmax = 100;
		//initialise minconf field
		$("#elemminconf").dxNumberBox(
		{
			value: currentminconf,
			min: 0,
			max: 100,
			showSpinButtons: true,
			onValueChanged: function(e)
			{
				actualmin = e.value;
				if (actualmin <= actualmax)
				{
					var previousValue = e.previousValue;
					var newValue = e.value;
					if (newValue == null) newValue = e.previousValue;
					actdict["act" + idaction].minconf = newValue;
					var query = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlaction&camp0=id&value0=" + idaction + "&camp1=listid&value1=" + id_lista + "&camp2=minconf&value2=" + newValue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
					// Event handling commands go here
					var jqxhr = $.ajax(query)
						.done(function()
						{
							DevExpress.ui.notify("Data saved", "success", 600);
						})
						.fail(function()
						{
							DevExpress.ui.notify("Data saving error", "error", 600);
						});
				}
				else
				{
					e.value = e.previousValue;
					actualmin = e.previousValue;
					DevExpress.ui.notify(DevExpress.localization.formatMessage("Minimum Confidence shall be less or equal than Maximum Confidence"), "error", 1500);
				}
			}
		}).dxValidator(
		{
			validationRules: [{
				type: "custom",
				validationCallback: function(e)
				{
					actualmin = e.value;
					return ((actualmin <= actualmax) ? true : false);
				}
			}]
		});
	
		//initialise maxconf field
		$("#elemmaxconf").dxNumberBox(
		{
			value: currentmaxconf,
			min: 0,
			max: 100,
			showSpinButtons: true,
			onValueChanged: function(e)
			{
				actualmax = e.value;
				if (actualmin <= actualmax)
				{
					var previousValue = e.previousValue;
					var newValue = e.value;
					if (newValue == null) newValue = e.previousValue;
					actdict["act" + idaction].maxconf = newValue;
					var query = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlaction&camp0=id&value0=" + idaction + "&camp1=listid&value1=" + id_lista + "&camp2=maxconf&value2=" + newValue + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
					// Event handling commands go here
					var jqxhr = $.ajax(query)
						.done(function()
						{
							DevExpress.ui.notify("Data saved", "success", 600);
						})
						.fail(function()
						{
							DevExpress.ui.notify("Data saving error", "error", 600);
						});
				}
				else
				{
					e.value = e.previousValue;
					actualmax = e.previousValue;
					DevExpress.ui.notify(DevExpress.localization.formatMessage("Maximum Confidence shall be greater or equal than Minimum Confidence"), "error", 1500);
				}
			}
		}).dxValidator(
		{
			validationRules: [{
				type: "custom",
				validationCallback: function(e)
				{
					actualmax = e.value;
					return ((actualmin <= actualmax) ? true : false);
				}
			}]
		});
		actualmin = currentminconf;
		actualmax = currentmaxconf;
	}

	var loadPanel = $(".loadpanel").dxLoadPanel(
	{
		shadingColor: "rgba(0,0,0,0.4)",
		position:
		{
			of: "#importsdiv"
		},
		visible: false,
		showIndicator: true,
		showPane: true,
		shading: true,
		message: DevExpress.localization.formatMessage("Importing..."),
		closeOnOutsideClick: false
	}).dxLoadPanel("instance");
});
