#!/bin/sh
. /etc/functions.sh
IPTABLES="echo iptables"
IPTABLES=iptables
config_clear
CONFIG_APPEND=1
config_load network

fws=$(uci -q -P /var/state get firewall.core.loaded || echo 0)

[ "$fws" == "1" ] && {
	lock /var/lock/vtss_firewall
	logger -t firewall "Restart user's custom iptables rules"
	$IPTABLES -F input_wan 2>/dev/null
	$IPTABLES -F input_3gwan 2>/dev/null
	$IPTABLES -F input_lan 2>/dev/null
	$IPTABLES -F forwarding_lan 2>/dev/null
	$IPTABLES -F forwarding_wan 2>/dev/null
	$IPTABLES -F forwarding_3gwan 2>/dev/null
	$IPTABLES -F forwarding_rule 2>/dev/null
	$IPTABLES -F prerouting_wan -t nat 2>/dev/null
	$IPTABLES -F prerouting_3gwan -t nat 2>/dev/null
	$IPTABLES -F prerouting_rule -t nat 2>/dev/null
	$IPTABLES -F postrouting_rule -t nat 2>/dev/null
	$IPTABLES -D FORWARD -d 224.0.0.0/4 -j ACCEPT 2>/dev/null
	$IPTABLES -D FORWARD -i br-lan -o br-lan -j ACCEPT 2>/dev/null
	$IPTABLES -D INPUT -d 224.0.0.0/4 -j ACCEPT 2>/dev/null
	#zone_wan_ACCEPT
	#POSTROUTING
	. /etc/firewall.user
	lock -u /var/lock/vtss_firewall
} || {
	[ -f /tmp/initd.log ] && {
		start_num=`tail -n 1 /tmp/initd.log 2>/dev/null | cut -c12-13`
		if [ "$start_num" -gt "45" ]; then
			logger -t firewall "Restart firewall..."
			/etc/init.d/firewall restart
		fi
	}
}
unset CONFIG_APPEND
