#!/bin/sh

alert() {
	HOST=$(uci -q get system.@system[0].hostname)
	USERNAME=$(uci -q get system.@mail-alert[0].username)
	PASSWORD=$(uci -q get system.@mail-alert[0].password)
	SERVER=$(uci -q get system.@mail-alert[0].smtpserver)
	TO=$(uci -q get system.@mail-alert[0].mailto)
	FROM=$(uci -q get system.@mail-alert[0].mailfrom)
  	
	SBJ="Temperature Alert Notification"
	echo "$USER login $HOST on" `date` > /tmp/mail_body
	sendmail -w 30 -s "$SBJ" -U "$USERNAME" -P "$PASSWORD" -t "$TO" "$SERVER" "$FROM" /tmp/temper_mail_body
	
	rm /tmp/temper_mail_body
}

EN=$(uci -q get system.@mail-alert[0].enable)
MAILEN=$(uci -q get usb_temper.@usb_temper[0].mail_en)
if [ "$EN" == "1" ] && [ "$MAILEN" == "1" ]; then
	alert;
else
	exit;
fi