# Copyright (C) 2006 OpenWrt.org

function portstr(type, str) {
	gsub(/-/, ":", str)
	if (insmod_mport != 1) {
		print "insmod ipt_multiport >&- 2>&-"
		insmod_mport = 1
	}
	if (type == "src") return " -m multiport --sports " str
	else return " -m multiport --dports " str
}

function str2ipt(str) {
	str2data(str)
	_cmd = ""
	if (_l["src"] != "") _cmd = _cmd " -s " _l["src"]
	if (_l["dest"] != "") _cmd = _cmd " -d " _l["dest"]
	if (_l["proto"] != "") {
		_cmd = _cmd " -p " _l["proto"]
	}
	# scripts need to check for proto="" and emit two rules in that case
	if ((_l["proto"] == "") || (_l["proto"] == "tcp") || (_l["proto"] == "udp")) {
		if (_l["sport"] != "") _cmd = _cmd portstr("src", _l["sport"])
		if (_l["dport"] != "") _cmd = _cmd portstr("dest", _l["dport"])
	}
	if (_l["layer7"] != "") {
		if (insmod_l7 != 1) {
			print "insmod ipt_layer7 >&- 2>&-"
			insmod_l7 = 1
		}
		_cmd = _cmd " -m layer7 --l7proto " _l["layer7"]
	}
	return _cmd
}

function str2data(str) {
	delete _l
	_n = split(str, _o, "[\t ]")
	for (_i = 1; _i <= _n; _i++) {
		_n2 = split(_o[_i], _c, "=")
		if (_n2 == 2) _l[_c[1]] = _c[2]
	}
}

function bitcount(c) {
	c=and(rshift(c, 1),0x55555555)+and(c,0x55555555)
	c=and(rshift(c, 2),0x33333333)+and(c,0x33333333)
	c=and(rshift(c, 4),0x0f0f0f0f)+and(c,0x0f0f0f0f)
	c=and(rshift(c, 8),0x00ff00ff)+and(c,0x00ff00ff)
	c=and(rshift(c,16),0x0000ffff)+and(c,0x0000ffff)
	return c
}

function validate_netmask(nm) {
	return and(-nm,compl(nm))
}

function ip2int(ip) {
	for (ret=0,n=split(ip,a,"\."),x=1;x<=n;x++) ret=or(lshift(ret,8),a[x]) 
	return ret
}

function int2ip(ip,ret,x) {
	ret=and(ip,255)
	ip=rshift(ip,8)
	for(;x<3;ret=and(ip,255)"."ret,ip=rshift(ip,8),x++);
	return ret
}

function ipsplit(ip,ret) {
    n=split(ip,ret,"\.")
    if (n < 4) {
        missing = 4 - n
        for (i = 4; i > 0; i--) {
            if ((i - missing) > 0) {
                ret[i] = ret[i - missing]
            }
            else {
                ret[i] = 0
            }
        }
    }
}

function ipunsplit(ip) {
    ret=ip[1]
    for (i=2;i<=4;i++) ret=ret"."ip[i]
    return ret
}

function ipor(ip1,ip2,ip) {
    for (i=1;i<=4;i++) ip[i]=or(ip1[i],ip2[i])
    return ip
}

function ipand(ip1,ip2,ip) {
    for (i=1;i<=4;i++) ip[i]=and(ip1[i],ip2[i])
    return
}

function ipcompl(ip1,ip) {
    for (i=1;i<=4;i++) ip[i]=255-ip1[i]
    return
}

function ipadd(ip1, number, ip) {
    ip[4] = ip1[4] + number
    carry = int(ip[4]/256)
    ip[4] = ip[4]%256
    for (i=3;i>=1;i--) {
        ip[i] = ip1[i] + carry
        carry = int(ip[i]/256)
        ip[i] = ip[i]%256
    }
    return
}

function ipgt(ip1, ip2) {
    ret=0
    for (i=1;i<=4;i++) {
        if ( ret==0 ) {
            if (ip1[i] > ip2[i]) ret=1
        }
    }
    return ret
}
