#!/bin/sh 
. /etc/functions.sh
IPTABLES="echo iptables"
IPTABLES=iptables

# address mapping
set_addr_map()
{
	config_get EN_MAP	$1 enable
	config_get WIP_IDX $1 wan_ip_idx
	[ "$EN_MAP" == "1" -a "$WIP_IDX" != "0" ] && {		
		config_get PIP $1 priv_ip
		config_get PMASK $1 mask
		WIP=$(uci -q get wan_ip_alias.wa"$WIP_IDX".alias_ip || echo 0.0.0.0)
		EN_WIP=$(uci -q get wan_ip_alias.wa"$WIP_IDX".enable)
		if [ "$EN_WIP" = "1" -a "$WIP" != "0.0.0.0" ]; then
			config_get PROTO $1 protocol
			if [ "$PROTO" = "1" ]; then
				$IPTABLES -D zone_$3_nat -t nat -p tcp -o $2 ${PIP:+-s $PIP/$PMASK} -j SNAT --to-source $WIP 2>/dev/null
				$IPTABLES -I zone_$3_nat -t nat -p tcp -o $2 ${PIP:+-s $PIP/$PMASK} -j SNAT --to-source $WIP 2>/dev/null
			elif [ "$PROTO" = "2" ]; then
				$IPTABLES -D zone_$3_nat -t nat -p udp -o $2 ${PIP:+-s $PIP/$PMASK} -j SNAT --to-source $WIP 2>/dev/null
				$IPTABLES -I zone_$3_nat -t nat -p udp -o $2 ${PIP:+-s $PIP/$PMASK} -j SNAT --to-source $WIP 2>/dev/null			
			else
				$IPTABLES -D zone_$3_nat -t nat -o $2 ${PIP:+-s $PIP/$PMASK} -j SNAT --to-source $WIP 2>/dev/null
				$IPTABLES -I zone_$3_nat -t nat -o $2 ${PIP:+-s $PIP/$PMASK} -j SNAT --to-source $WIP 2>/dev/null
			fi
		fi
	}
}

src_ip=$(uci -q get network.lan.ipaddr)
src_mask=$(uci -q get network.lan.netmask)
ifname=$(uci -q get -P /var/state network.wan.ifname || echo br-wan)
$IPTABLES -F zone_wan_nat -t nat
$IPTABLES -A zone_wan_nat -t nat -o $ifname ${src_ip:+-s $src_ip/$src_mask} -j MASQUERADE 
config_load "addr_map"	
config_foreach set_addr_map addrmap $ifname wan
flush-ipconntrack 1 &