#include "stdhead.h"
#include "decline.h"
#include "clilib.h"
#include "parse.h"
#include "solicit.h"

struct DHCP_MESSAGE * create_decline_message (struct DHCP_MESSAGE * reply_message_ptr, char *interface_name)
{
    struct DHCP_MESSAGE * decline_message_ptr = (struct DHCP_MESSAGE *) malloc (sizeof (struct DHCP_MESSAGE));
    struct OPTIONS * options_ptr;
    struct DUID *duid_ptr;
    struct IA *ia_ptr;
    struct IA_ADDRESS *iaaddr_ptr;
    struct interface *interface_details;
    
    decline_message_ptr -> u_msg_type.msg_type = DECLINE;
    generate_trans_id (&decline_message_ptr -> u_trans_id.trans_id);

    interface_details = get_interface_details (interface_name);
    decline_message_ptr -> opt = add_client_id_option (interface_details);
    duid_ptr = (struct DUID *) decline_message_ptr -> opt -> opt_data;

    duid_ptr -> opt = copy_message_option (reply_message_ptr, OPTION_SERVERID);
    duid_ptr = (struct DUID *) duid_ptr -> opt -> opt_data;

    duid_ptr -> opt = copy_message_option (reply_message_ptr, OPTION_IA);
    ia_ptr = (struct IA *) duid_ptr -> opt -> opt_data;

    ia_ptr -> opt = copy_message_option (reply_message_ptr, OPTION_IAADDR);
    iaaddr_ptr = (struct IA_ADDRESS *) ia_ptr -> opt -> opt_data;
    iaaddr_ptr -> opt = 0;
    
    return decline_message_ptr;
}
