#include <linux/string.h>
#include <linux/kernel.h>
#include "lte_driver.h"
#include "lte_at_cmd.h"
#include "samsung_lte.h"
#include "os_shim.h"
#if SAMSUNG_LTE_SUPPORT == 1
extern void lte_send_ap_get_config(struct lte_modem_st * modem);

int samsung_lte_switch_to_modem(void *usb_dev)
{
	int act_count;
	int res;
	unsigned char buf[2];
	unsigned char chg_mode[31] = 
	{
        0x55, 0x53, 0x42, 0x43, 0x78, 0x56, 0x34, 0x12, 0x01, 0x00,
        0x00, 0x00, 0x80, 0x00, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00
	};

	//get status, this request is significant!!!!, without this, AT command can't get a response
	res = usb_control_in(usb_dev, 0, 0x80, 0, 0, buf, 2, 1000);
	if(res < 0)
	{
		printk("control pipe access failed in samsung_lte_switch_to_modem(), result = %d\n", res);
		return -1;
	}

	printk("[0x%02X 0x%02X]\n", buf[0], buf[1]);
	res = usb_bulk_msg_out(usb_dev, 0x06, chg_mode, sizeof(chg_mode), &act_count, 1000);
	if(res < 0)
	{
		printk("Samsung LTE change mode command failed, result = %d", res);
		return -1;
	}

	reset_device_no_modem_object(usb_dev);

    return 0;
}

void samsung_lte_rx_process(struct lte_modem_st * modem, char * buf, int len)
{
    char * p;
	int len1, l = 0;

	if(!draytek_hw()) return;

    if(len < 6) {
	    printk("WiMAX: short read\n");
	    return;
	}

    if(buf[0] == 0x57 && buf[1] == 0x50)
    {
		//P response
//		lte_dump_buffer(buf, len, "P RESPONSE"); 
    }
	else if(buf[0] == 0x57 && buf[1] == 0x43)
	{
		//C response
//		lte_dump_buffer(buf, len, "C RESPONSE"); 
	}
    else //buf[0] == 0x57 && buf[1] == 0x50
    {
        if(buf[0] == 0x57 && buf[1] == 0x44)
        {
            //start of packets, extract packets till the last one, the last one could be a complete packet or
            //a first part of a packet
            p = buf;
            len1 = len;
parse_buf:
            modem->seg1_len = 0; //assume no residue first

            while(len1 > 0)
            {
                if(p[0] == 0x57 && p[1] == 0x5A)
                {
					//ignore tailer
					len1 -= 6;
                    p += 6;
					//exit if we don't have at least 6 byte USB header
                    if(len1 < 6) return;
                }

                if(p[0] == 0x57 && p[1] == 0x44)
				{
					l = (unsigned char)p[2] + ((unsigned char)p[3] << 8) + 6;
					if(l < 20)
					{
						//must be something wrong, packet length is too short
 						printk("packet length too short [%d bytes]\n", l);
						lte_dump_buffer(p-10, 20, "");
						update_rx_drop_cnt(modem);
						return;
					}

					if(l > 1600)
					{
						//must be something wrong, packet length is too long
 						printk("packet length too long [%d bytes]\n", l);
						lte_dump_buffer(p-10, 20, "");
						update_rx_drop_cnt(modem);
						return;
					}
				}
				else
				{
 					printk("WiMAX: bad data packet header");
					lte_dump_buffer(p-10, 20, "");
					update_rx_drop_cnt(modem);
					return;
				}

                if(len1 < l)
                {
                    //we got a partial packet at the end of the buffer, save the packet till we received complete packet
                    memcpy(modem->seg_buf, p, len1);
                    modem->seg1_len = len1;
                    modem->seg2_len = l - len1;
                    return;
                }

				//remove 6 bytes samsung proprietary usb header then pass the complete packet to network layer
				lte_netif_rx(modem, p+6, l-6);
                len1 -= l;
                p += l;
            }
        }
        else //buf[0] == 0x57 && buf[1] == 0x44
        {
           //an incomplete IP packet in the beginning of the buffer 
 // 			LTE_PRINT(( LOG_INFO, "2'nd part of packet, len = %d\n", len));
			if(len >= modem->seg2_len)
            {
				//we can have a complete packet by concatenate 1'st part in packet_residue_buf and 2'nd part in this buffer
                memcpy(&modem->seg_buf[modem->seg1_len], buf, modem->seg2_len);

				//remove 6 bytes samsung proprietary usb header then pass the complete packet to network layer
				lte_netif_rx(modem, modem->seg_buf + 6, modem->seg1_len + modem->seg2_len - 6);
				
                //chack if other packets follow
                len1 = len - modem->seg2_len;
                p = &buf[modem->seg2_len];
                goto parse_buf;
            }
            else
            {
                //still can't have a complete packet in this transfer, keep collecting data
                memcpy(&modem->seg_buf[modem->seg1_len], buf, len);
                modem->seg1_len += len;
                modem->seg2_len -= len;
                return;
            }
        } //buf[0] == 0x57 && buf[1] == 0x44  
    } //buf[0] == 0x57 && buf[1] == 0x50
    return;
}

static void samsung_config_rx_buf(struct lte_modem_st * modem)
{
	modem->rx_buf_size = 16 * 1024; 
	modem->act_rx_buf_count = 16;
	modem->rx_head_room = 0;
	modem->rx_use_dma_buf = 1;

#if LTE_USE_PRE_ALLOC_TX_BUF == 1
	modem->tx_buf_size = 1600; 
	modem->act_tx_buf_count = modem->tx_buf_left = 128;
#endif//LTE_USE_PRE_ALLOC_TX_BUF == 1
}

int init_samsumg_lte(struct lte_modem_st * modem)
{
    int act_count, i;
    unsigned char syncBuf[100];
    unsigned char p_cmd_1[12] = 
    {
        0x57, 0x50, 0x04, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
        0x00, 0x00
    };

	check_draytek_hw();
	if(!draytek_hw()) return -1;

	modem->data_out_pipe	= os_usb_sndbulkpipe(modem->usb_dev, 2);
	modem->data_in_pipe		= os_usb_rcvbulkpipe(modem->usb_dev, 1);
 	modem->at_cmd_pipe 		= os_usb_sndbulkpipe(modem->usb_dev, 4);
	modem->at_rsp_pipe		= os_usb_rcvbulkpipe(modem->usb_dev, 3);

	//modem methods
	modem->rx_process = samsung_lte_rx_process;
	modem->tx_process = samsung_lte_tx_process;
    modem->timer_exe = samsung_lte_timer;
	modem->config_rx_buf = samsung_config_rx_buf;
	modem->get_config = samsung_get_config;
	modem->report_info = samsung_report_info;

	//P command 1
	if(usb_bulk_msg_out(modem->usb_dev, 2, p_cmd_1, sizeof(p_cmd_1), &act_count, 1000) < 0)
	{
		printk("P command 1 failed\n");
		return -1;
	}

	//P response 1
	if(usb_bulk_msg_in(modem->usb_dev, 1, syncBuf, sizeof(syncBuf), &act_count, 1000) < 0)
	{
		printk("P response 1 failed\n");
		return -1;
	}

    lte_update_mac(modem, (char*) &syncBuf[10]);
	memcpy(modem->bssid, (char*) &syncBuf[10], 6); 
	modem->bssid[5] += 1;

//	lte_dump_buffer(syncBuf, act_count, "P RESPONSE 1\n");

	//P command 2
	p_cmd_1[7] = 0x02; p_cmd_1[9] = 0xF4; //modidy p commnad into p command 2

	if(usb_bulk_msg_out(modem->usb_dev, 2, p_cmd_1, sizeof(p_cmd_1), &act_count, 1000) < 0)
	{
		printk("P command 2 failed\n");
		return -1;
	}

	//P response 2
	if(usb_bulk_msg_in(modem->usb_dev, 1, syncBuf, sizeof(syncBuf), &act_count, 1000) < 0)
	{
		printk("P response 2 failed\n");
		return -1;
	}

//	lte_dump_buffer(syncBuf, act_count, "P RESPONSE 2\n");
	if(send_at_cmd_rsp_sync(modem, "ATE1\r", syncBuf, sizeof(syncBuf)) < 0) return -1;
	if(start_at_rsp_rx(modem) < 0) return -1;

	if(send_at_cmd_sync(modem, "AT+VERSNAME=1,0\r") < 0) return -1;
	i = string_found("+VERSNAME:1", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
    if( i >= 0) 
	{
		zero_terminate(&modem->at_rsp_buf[i]);
		strcpy(modem->sw_ver, &modem->at_rsp_buf[i + 12]);
		printk("Software version = %s\n", modem->sw_ver);
    }

	//get hardware version
	if(send_at_cmd_sync(modem, "AT+VERSNAME=1,1\r") < 0) return -1;
	i = string_found("+VERSNAME:1", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
    if( i >= 0) 
	{
		zero_terminate(&modem->at_rsp_buf[i]);
		strcpy(modem->hw_ver, &modem->at_rsp_buf[i + 12]);
		printk("Hardware version = %s\n", modem->hw_ver);
	}

	printk("Samsung B3730 modem initialized successfully\n");

	return 0;
}


static unsigned char p_cmd_3[] =
{
    0x57, 0x50, 0x04, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,	
    0xFF, 0x00	
};


static int disconnect_link_if_needed(struct lte_modem_st * modem)
{
	if(send_at_cmd_sync(modem, "AT+CGACT?\r") < 0) return -1;
	if(modem->attach_status == 1)
	{
		if(send_at_cmd_sync(modem, "AT+CGACT=0,1\r") < 0) return -1;
	}

	if(send_at_cmd_sync(modem, "AT+CGATT?\r") < 0) return -1; 
	if(modem->attach_status == 1)
	{
		//detach from network, if it is attached
		if(send_at_cmd_sync(modem, "AT+CGATT=0\r") < 0) return -1; 
	}

	if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH=0\r") < 0) return -1;	
	return 0;
}

static int samsumg_lte_connect_4G(struct lte_modem_st * modem)
{
	int i, act_count;
 	char buf[40];

#if 0
    if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH?\r") < 0) return -1;
    if(modem->changeallpath == 1)
    {
		//in 3G mode
		if(send_at_cmd_sync(modem, "AT+CGACT?\r") < 0) return -1;
		if(modem->attach_status == 1)
		{
			if(send_at_cmd_sync(modem, "AT+CGACT=0,1\r") < 0) return -1;
		}
    }
	else
	{
		//in 4G mode
		if(send_at_cmd_sync(modem, "AT+CGATT?\r") < 0) return -1; 
		if(modem->attach_status == 1)
		{
			//detach from network, if it is attached
			if(send_at_cmd_sync(modem, "AT+CGATT=0\r") < 0) return -1; 
		}
	}
#else
	if(disconnect_link_if_needed(modem) < 0) return -1;
#endif

    //command echo on
    if(send_at_cmd_sync(modem, "ATE1\r") < 0) return -1;

    //select character set
    if(send_at_cmd_sync(modem, "AT+CSCS=\"UCS2\"\r") < 0) return -1;


    //set verbose error code
    if(send_at_cmd_sync(modem, "AT+CMEE=2\r") < 0) return -1;

    if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH?\r") < 0) return -1;
    if(modem->changeallpath == 1)
    {
		if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH=0\r") < 0) return -1;
    }

    //get software version
	if(strlen(modem->sw_ver) == 0)
	{
		if(send_at_cmd_sync(modem, "AT+VERSNAME=1,0\r") < 0) return -1;
		i = string_found("+VERSNAME:1", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
        if( i >= 0) 
		{
			zero_terminate(&modem->at_rsp_buf[i]);
			strcpy(modem->sw_ver, &modem->at_rsp_buf[i + 12]);
			lte_send_ap_sw_ver(modem);
        }

		//get hardware version
		if(send_at_cmd_sync(modem, "AT+VERSNAME=1,1\r") < 0) return -1;
		i = string_found("+VERSNAME:1", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
        if( i >= 0) 
		{
			zero_terminate(&modem->at_rsp_buf[i]);
			strcpy(modem->hw_ver, &modem->at_rsp_buf[i + 12]);
   			lte_send_ap_hw_ver(modem);
	    }
	}

    //enable network registration and location information unsolicited result code
    if(send_at_cmd_sync(modem, "AT+CGREG=2\r") < 0) return -1;

    //select manufacturers defined functionality level 5, second parameter is optional, if it is 1, modem will be reset
    if(send_at_cmd_sync(modem, "AT+CFUN=5\r") < 0) return -1;

	check_sim_card(modem);
    //select mode
    // AT+MODESELECT= n
    // n = 2, LTE 
    //   = 3, multi- mode
    //   = 4, 2G
    //   = 5, 3G
	if(modem->network_mode == ONLY_4G)
	{
		if(send_at_cmd_sync(modem, "AT+MODESELECT=2\r") < 0) return -1;
	}
	else
	{
		if(send_at_cmd_sync(modem, "AT+MODESELECT=3\r") < 0) return -1;
	}

	if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH=0\r") < 0) return -1;

	if(modem->network_mode == ONLY_4G){
		goto attach;
	}

	i = 5;
	while(i > 0)
	{
		i--;
		if(send_at_cmd_sync(modem, "AT+NWSTATEIND?\r") < 0) return -1;
		if(modem->state >= 3) goto attach;
	}

	return 100; //no signal

attach:

    if(send_at_cmd_sync(modem, "AT+COPSNAME\r") < 0) return -1; 
    
    //query PDP context status
    if(send_at_cmd_sync(modem, "AT+CGACT?\r") < 0) return -1; 

    //attach to network
    if(send_at_cmd_sync(modem, "AT+CGATT=1\r") < 0) return -1; 
	return 0;
}


static int samsumg_lte_connect_3G(struct lte_modem_st * modem)
{
	int i, act_count;
	char buf[40];


#if 0
	if(modem->network_mode == ONLY_3G || modem->network_mode == ONLY_2G )
	{
		if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH?\r") < 0) return -1;
		if(modem->changeallpath == 1)
		{
			//in 3G mode
			if(send_at_cmd_sync(modem, "AT+CGACT?\r") < 0) return -1;
			if(modem->attach_status == 1)
			{
				if(send_at_cmd_sync(modem, "AT+CGACT=0,1\r") < 0) return -1;
			}
		}
		else
		{
			//in 4G mode
			if(send_at_cmd_sync(modem, "AT+CGATT?\r") < 0) return -1; 
			if(modem->attach_status == 1)
			{
				//detach from network, if it is attached
				if(send_at_cmd_sync(modem, "AT+CGATT=0\r") < 0) return -1; 
			}
		}

		if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH=0\r") < 0) return -1;
#else
	if(1)
	{
		if(disconnect_link_if_needed(modem) < 0) return -1;
#endif
		//get software version
		if(strlen(modem->sw_ver) == 0)
		{
			if(send_at_cmd_sync(modem, "AT+VERSNAME=1,0\r") < 0) return -1;
			i = string_found("+VERSNAME:1", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
			if( i >= 0) 
			{
				zero_terminate(&modem->at_rsp_buf[i]);
				strcpy(modem->sw_ver, &modem->at_rsp_buf[i + 12]);
				lte_send_ap_sw_ver(modem);
			}

			//get hardware version
			if(send_at_cmd_sync(modem, "AT+VERSNAME=1,1\r") < 0) return -1;
			i = string_found("+VERSNAME:1", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
			if( i >= 0) 
			{
				zero_terminate(&modem->at_rsp_buf[i]);
				strcpy(modem->hw_ver, &modem->at_rsp_buf[i + 12]);
   				lte_send_ap_hw_ver(modem);
			}
		}		
		
		if(send_at_cmd_sync(modem, "AT+CMEE=2\r") < 0) return -1;
		if(send_at_cmd_sync(modem, "AT+CGREG=2\r") < 0) return -1;
		if(send_at_cmd_sync(modem, "AT+CFUN=5\r") < 0) return -1;
		switch(modem->network_mode)
		{
		case ONLY_3G:
			if(send_at_cmd_sync(modem, "AT+MODESELECT=5\r") < 0) return -1;	
			break;

		case ONLY_2G:
			if(send_at_cmd_sync(modem, "AT+MODESELECT=4\r") < 0) return -1;	
			break;

		default:
			printk("should not go to here in samsumg_lte_connect_3G()\n");

		}
	}

	if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH=1\r") < 0) return -1;
//	if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH=0\r") < 0) return -1;

    if(send_at_cmd_sync(modem, "AT+CHANGEALLPATH?\r") < 0) return -1;

   //command echo on
	if(send_at_cmd_sync(modem, "ATE1\r") < 0) return -1;

    //select character set
    if(send_at_cmd_sync(modem, "AT+CSCS=\"UCS2\"\r") < 0) return -1;

    //set verbose error code
    if(send_at_cmd_sync(modem, "AT+CMEE=2\r") < 0) return -1;

	if(modem->network_mode == ONLY_3G || modem->network_mode == ONLY_2G )
	{
		if(send_at_cmd_sync(modem, "AT+CREG=2\r") < 0) return -1;
		if(send_at_cmd_sync(modem, "AT+CREG=2\r") < 0) return -1;
    }
	
	//enable network registration and location information unsolicited result code
    if(send_at_cmd_sync(modem, "AT+CGREG=2\r") < 0) return -1;

	if(modem->network_mode == ONLY_3G || modem->network_mode == ONLY_2G )
	{
		if(send_at_cmd_sync(modem, "AT+CFUN=6\r") < 0) return -1;
	}

	check_sim_card(modem);
goto attach; //fchien try
	i = 20;
	while(i > 0)
	{
		i--;
		if(send_at_cmd_sync(modem, "AT+NWSTATEIND?\r") < 0) return -1;
		if(modem->state >= 3) goto attach;
	}

	return 100; //no signal

attach:
    //get ISP information
    if(send_at_cmd_sync(modem, "AT+COPSNAME\r") < 0) return -1; 
    
 	sprintf(buf, "AT+CGDCONT=1,\"IP\",\"%s\"\r", modem->apn); 
    if(send_at_cmd_sync(modem, buf) < 0) return -1; 

    if(send_at_cmd_sync(modem, "AT+CGACT=1,1\r") < 0) return -1; 

    //query PDP context status
    if(send_at_cmd_sync(modem, "AT+CGACT?\r") < 0) return -1; 

	return 0;
}


void samsung_get_config(struct lte_modem_st * modem)
{
	lte_send_ap_get_config(modem);
}

void samsung_report_info(struct lte_modem_st * modem)
{
	lte_send_ap_modem_connected(modem);
   	lte_send_ap_sw_ver(modem);
   	lte_send_ap_hw_ver(modem);
	lte_send_ap_mac(modem);
	lte_send_ap_bssid(modem);
}

void samsung_lte_timer(struct lte_modem_st * modem)
{
	int ret, act_count, i;
	char cmd_buf[20];

	if(!draytek_hw) return 0;

	if((modem->counter % 2) == 0)
	{

//		LTE_PRINT(("I am alive\n"));	
	}

	if(modem->keep_alive_timer > 0)
	{
		modem->keep_alive_timer--;
		if(modem->keep_alive_timer == 0)
		{
			//timeout
			LTE_PRINT(("Keep alive timer timeout\n"));
			//link down
			lte_link_down(modem);
			modem->connect_timer = 2;
		}
	}

	if((modem->counter % 10) == 0)
	{
//		send_at_cmd_sync(modem, "AT\r");
	}

    if(modem->connect_timer > 0)
	{
		LTE_PRINT(("LTE connect timer = %d\n", modem->connect_timer));
		modem->connect_timer--;
		if(modem->connect_timer == 0)
		{
			modem->state = 0;
			if(modem->network_mode != ONLY_3G && modem->network_mode != ONLY_2G )
			{
				LTE_PRINT(("Start 4G connection\n"));
				modem->in_handshake = 1;
				ret = samsumg_lte_connect_4G(modem);
				modem->in_handshake = 0;
				if(ret < 0) return;
#if 0 //test, simulate 4G link up
    modem->state = 6;
	lte_link_up(modem);
	return;
#endif
				if(ret == 100)
				{
					LTE_PRINT(("No 4G signal\n"));
					if(modem->network_mode == ONLY_4G)
					{
						reset_device(modem);
						return;
					}
					goto try_3g;
				}

				i = 50;
				while( i > 0)
				{
					if(modem->link_up)
					{
						LTE_PRINT(("4G connected successfully!\n"));
						return;
					}
					lte_delay_ms(100);
					i--;
				}


try_3g:
				LTE_PRINT(("No 4G signal available, start to try 3G connection\n"));
            }

			if(modem->network_mode != ONLY_4G)
			{
				LTE_PRINT(("Start 3G/2G connection\n"));
				modem->in_handshake = 1;
				ret = samsumg_lte_connect_3G(modem);
				modem->in_handshake = 0;
				if(ret < 0) return;
				if(ret == 100)
				{
					LTE_PRINT(("No 3G/2G signal\n"));
					goto reset_modem;
				}

				i = 50;
				while( i > 0)
				{
					if(modem->link_up)
					{
						LTE_PRINT(("3G/2G connected successfully!\n"));
						return;
					}
					lte_delay_ms(100);
					i--;
				}
			}
reset_modem:
			reset_device(modem);
		}//if(modem->connect_timer == 0)

    }//if(modem->connect_timer > 0)
	return;
}

static void fill_samsung_lte_header(char *buf, int len)
{
	buf[0] = 0x57;
	buf[1] = 0x44;
	buf[2] = len & 0xff;
	buf[3] = (len >> 8) & 0xff;

    //ethernet type code
    buf[4] = buf[18];
    buf[5] = buf[19];
    return;
}

int samsung_lte_tx_process(struct lte_modem_st * modem, char * tx_data, char * out_buf, int * len)
{
	int i, padding_len;

	if(!draytek_hw()) return -1;

    if(!modem->link_up) 
	{
		return -1;
	}

	memcpy(out_buf + 6, tx_data, *len);

	//we already reserve 6 bytes header space at the beginning of the buffer
	fill_samsung_lte_header(out_buf, *len);
	*len += 6;

	//packet must have a length of 4's multiple
	padding_len = (4 - (*len & 3)) & 3;
	for(i =0; i< padding_len; i++) out_buf[*len + i] = 0;
    *len += padding_len;
    if((*len & 3) != 0) printk("Data Packet not a multiple of 4 bytes !!!!!!!!!!\n");

	return 0;
}
#endif //SAMSUNG_LTE_SUPPORT == 1
