#!/bin/sh

# Define Bridge Interface
# Preexisting on OpenWRT
br="br-lan"

# Define list of TAP interfaces to be bridged,
# for example tap="tap0 tap1 tap2".
tap="tap0"
check_tap=$(ifconfig | grep tap0)

[ "$check_tap" == "" ] || {
	echo "ifconfig tap0 already exist !"
	exit 1
}

# Build tap devices
for t in $tap; do
    openvpn --mktun --dev $t
done

# Add TAP interfaces to OpenWRT bridge

for t in $tap; do
    brctl addif $br $t
done

#Configure bridged interfaces
for t in $tap; do
    ifconfig $t 0.0.0.0 promisc up
done
