#!/bin/sh
#
# Copyright (C) 2007 OpenWrt.org
#
# $Id: adm5120.sh 9069 2007-09-29 14:27:54Z juhosg $
#

board_name=""
status_led=""
sys_mtd_part=""

adm5120_detect() {
	board_name=$(awk 'BEGIN{FS="[ \t]+:[ \t]"} /system type/ {print $2}' /proc/cpuinfo)

	case "$board_name" in
	"Cellvision"*)
		status_led="status"
		sys_mtd_part="firmware"
		;;
	"Compex"*)
		status_led="diag"
		case "$board_name" in
		*-WRT)
			sys_mtd_part="trx"
			;;
		*)
			sys_mtd_part="partition1"
			;;
		esac
		;;
	"Edimax"*)
		status_led="power"
		sys_mtd_part="firmware"
		;;
	"Infineon"*)
		sys_mtd_part="firmware"
		;;
	"Mikrotik"*)
		status_led="power"
		;;
	"ZyXEL"*)
		status_led="power"
		sys_mtd_part="trx"
		;;
	*)
		;;
	esac
}

adm5120_detect
