/*
 *  Generic AR71xx machine setup
 *
 *  Copyright (C) 2008 Gabor Juhos <juhosg@openwrt.org>
 *  Copyright (C) 2008 Imre Kaloz <kaloz@openwrt.org>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 2 as published
 *  by the Free Software Foundation.
 */

#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/spi/spi.h>
#include <linux/spi/flash.h>

#include <asm/mips_machine.h>
#include <asm/mach-ar71xx/ar71xx.h>
#include <asm/mach-ar71xx/pci.h>
#include <asm/mach-ar71xx/platform.h>

static struct spi_board_info ar71xx_generic_spi_info[] = {
	{
		.bus_num	= 0,
		.chip_select	= 0,
		.max_speed_hz	= 25000000,
		.modalias	= "m25p80",
	}
};

static struct ar71xx_pci_irq ar71xx_generic_pci_irqs[] __initdata = {
	{
		.slot	= 0,
		.pin	= 1,
		.irq	= AR71XX_PCI_IRQ_DEV0,
	}, {
		.slot	= 1,
		.pin	= 1,
		.irq	= AR71XX_PCI_IRQ_DEV1,
	}, {
		.slot	= 2,
		.pin	= 1,
		.irq	= AR71XX_PCI_IRQ_DEV2,
	}
};

static void __init ar71xx_generic_init(void)
{
	ar71xx_add_device_spi(NULL, ar71xx_generic_spi_info,
				ARRAY_SIZE(ar71xx_generic_spi_info));

	ar71xx_add_device_mdio(0xffe0ffff);
	ar71xx_add_device_eth(0, PHY_INTERFACE_MODE_MII, 0x000f0000);
	ar71xx_add_device_eth(1, PHY_INTERFACE_MODE_RMII, 0x00100000);

	ar71xx_add_device_usb();

	ar71xx_pci_init(ARRAY_SIZE(ar71xx_generic_pci_irqs),
			ar71xx_generic_pci_irqs);
}

MIPS_MACHINE(MACH_AR71XX_GENERIC, "Generic AR71xx board", ar71xx_generic_init);
