#!/bin/sh

default_btn_led() {
TMP_FILE=/tmp/default_button_time
while [ -e $TMP_FILE ]
do
	logger "default button is pressed..."
	sleep 1
	if [ -e $TMP_FILE ]; then
		START=$(cat /tmp/default_button_time)
		END=$(date +%s)
		DIFF=$(($END - $START))
		if [ "$DIFF" -ge "5" ]; then
			logger " release the default button to start factory default and reboot "
			cnt=0
			while [ -e $TMP_FILE ] 
			do
				cnt=$(($cnt+1))
				if [ $cnt -ge 200 ]; then
					echo toggle > /proc/gpio/LED0
					cnt=0
				fi
			done
		fi
	else
		logger " $TMP_FILE not found "
	fi
done
}

act_led() {
	while [ 1 ]
	do
		sleep 1
		echo toggle > /proc/gpio/LED0

		if [ -f /proc/net/ipsec_spi ]; then
			vpn=$(cat /proc/net/ipsec_spi)
		fi
		pptp=$(last | grep -E  "ppp..*still logged in" 2>/dev/null)
	    vpdrv=$(lsmod | grep vpdrv)
        if [ -n "$vpn" -o -n "$pptp" ]; then
        	if [ -z "$vpdrv" ]; then
            	echo on > /proc/gpio/LED4
            fi
        else
        	if [ -z "$vpdrv" ]; then
            	echo off > /proc/gpio/LED4
            fi
        fi
		
		uptime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		if [ $((uptime & 31)) == "0" ]; then
			wifi=$(uci -q -P /var/state get network.wifi_device 2>/dev/null)
			radio=$(uci get wireless.ra0.radio 2>/dev/null)
			if [ "$wifi" == "1" -a "$radio" == "1" ]; then
				ssid=$(iwconfig ra0 2>/dev/null | grep "ESSID" | awk 'FS="[\"]+" {printf $2}')
				cfg_ssid=$(uci get wireless.@wifi-iface[0].ssid 2>/dev/null)
				if [ "$cfg_ssid" != "$ssid" ]; then
					logger "wifi SSID error: $ssid ; restart wifi now..."
					wifi up &
				fi
			fi
		fi
	done
}

get_wps_status() {
	WPSing=1
	if [ ! -f /tmp/wps0.log ]; then
		dmesg > /tmp/wps0.log
	fi
	
	iwpriv ra0 set Debug=3
	iwpriv ra0 set Console=1
	iwpriv ra0 set WscStatus=0
	dmesg > /tmp/wps1.log
	diff -u -s /tmp/wps0.log /tmp/wps1.log > /tmp/wps_diff.log
	if cat /tmp/wps_diff.log | grep "are identical"; then
		iwpriv ra0 set WscStatus=0
		return $WPSing
	fi
	if cat /tmp/wps_diff.log | grep -E "^\+IF.*\(WscStatus=34\)"; then
        WPSing=0	# configured
	fi
	if cat /tmp/wps_diff.log | grep -E "^\+IF.*\(WscStatus=1\)"; then
        WPSing=0	# idle
	fi
	if cat /tmp/wps_diff.log | grep -E "^\+IF.*\(WscStatus=0\)"; then
        WPSing=0	# not used
	fi
	
	iwpriv ra0 set Debug=0
	iwpriv ra0 set Console=0
	rm /tmp/wps0.log
	rm /tmp/wps1.log
	rm /tmp/wps_diff.log 
	return $WPSing
}

wps_btn_led() {
	WPS_stop=$(($(date +%s)+122))
	touch /tmp/wpsing.tmp	# wps is running...
	while [ 1 ]
	do
		usleep 200000
		echo toggle > /proc/gpio/LED7

		# check wps status: if not act return;
		if ( get_wps_status ); then
			echo on > /proc/gpio/LED7
			iwpriv ra0 set Debug=0
			iwpriv ra0 set Console=0
			rm /tmp/wpsing.tmp
			return;
		fi

		if [ "$(date +%s)" -ge "$WPS_stop" ]; then
			echo on > /proc/gpio/LED7
			iwpriv ra0 set Debug=0
			iwpriv ra0 set Console=0
			rm /tmp/wpsing.tmp
			return;
		fi
	done
}

case "$1" in
	default) default_btn_led;;
	act) act_led;;
	wps) wps_btn_led;;
	*) logger "vigor LED control";;
esac
