#!/bin/sh

alert() {
	HOST=$(uci get system.@system[0].hostname)
	USERNAME=$(uci get system.@mail-alert[0].username)
	PASSWORD=$(uci get system.@mail-alert[0].password)
	SERVER=$(uci get system.@mail-alert[0].smtpserver)
	TO=$(uci get system.@mail-alert[0].mailto)
	FROM=$(uci get system.@mail-alert[0].mailfrom)
  	
	SBJ="$HOST alert - user login messages"
	
	if [ "$LOGINNAME" == "" ]; then
		echo "$USER login $HOST on" `date` > /tmp/mail_body
	else
		echo "$LOGINNAME login $HOST on" `date`" from web" > /tmp/mail_body
	fi
	
	sendmail -w 30 -s "$SBJ" -U "$USERNAME" -P "$PASSWORD" -t "$TO" "$SERVER" "$FROM" /tmp/mail_body
	
	rm /tmp/mail_body
}

LOGINNAME=$1
EN=$(uci get system.@mail-alert[0].enable)
FLAG=$(uci get system.@mail-alert[0].flag)
if [ $EN == "1" ] && [ $FLAG == "1" ]; then
	alert;
else
	exit;
fi


