#!/bin/bash

#Global count variable for counting lines output.
count=0
filename="/etc/config/switch/grocx_wifi_mac_table"


# test filename and file exists
if [ ! -f "$filename" ];
then
  exit 1
fi

# loop through input file
while read inputline;
do
  if [ $count == "0" ]; then
    ftype=$inputline
  elif [ $count == "1" ]; then
    inputline=`echo $inputline | sed 's/-/:/g'`
    mac="$inputline"
  else
    inputline=`echo $inputline | sed 's/-/:/g'`
    mac="$mac;$inputline"
  fi
  let count=count+1 
done < "$filename"

# call ralink cli 
if ifconfig | grep -q ra0; then
    if [ $ftype == "1" ]; then
        iwpriv ra0 set AccessPolicy=1
    else
        iwpriv ra0 set AccessPolicy=2
    fi    
#iwpriv ra0 set AccessControlList=$mac

	# for ralink driver 1.1.8 or later
	iwpriv ra0 set ACLClearAll=1
	iwpriv ra0 set ACLAddEntry=$mac	
fi

if ifconfig | grep -q ra_r0; then
if [ $ftype == "1" ]; then
    iwpriv ra_r0 set AccessPolicy=1
else
    iwpriv ra_r0 set AccessPolicy=2
fi   
iwpriv ra_r0 set AccessControlList=$mac
fi