set_3g_led() {
	grep WRT54G3G /proc/diag/model >/dev/null || return 0
	echo "$1" > /proc/diag/led/3g_green
	echo "$2" > /proc/diag/led/3g_blue
	echo "$3" > /proc/diag/led/3g_blink
}

scan_3g() {
	local device

	scan_ppp "$@"
	config_get device "$1" device

	# try to figure out the device if it's invalid
	[ -n "$device" -a -e "$device" ] || {
		for device in /dev/ttyUSB0 /dev/ttyUSB1 /dev/ttyUSB2 /dev/tts/2 /dev/usb/tts/0 /dev/noz0; do
			[ -e "$device" ] && {
				config_set "$1" device "$device"
				break
			}
		done
	}

	# enable 3G with the 3G button by default
	config_get button "$1" button
	[ -z "$button" ] && {
		config_set "$1" button 1
	}
}

stop_interface_3g() {
	#set_3g_led 0 0 0
	killall gcom >/dev/null 2>/dev/null
}

setup_interface_3g() {
	local iface="$1"
	local config="$2"
	local chat="/etc/chatscripts/3g.chat"
	
	config_get device "$config" device
	config_get maxwait "$config" maxwait
	maxwait=${maxwait:-20}
	while [ ! -e "$device" -a $maxwait -gt 0 ];do # wait for driver loading to catch up
		maxwait=$(($maxwait - 1))
		sleep 1
	done

	for module in slhc ppp_generic ppp_async; do
		/sbin/insmod $module 2>&- >&-
	done

	config_get apn "$config" apn
	config_get service "$config" service
	config_get pincode "$config" pincode
	config_get mtu "$config" mtu

	config_get init_string1 "$config" init_string1
	config_get init_string2 "$config" init_string2
	config_get dial_string "$config" dial_string
	export -n -- "HSDPA_INIT_STRING1=${init_string1:-"AT&F"}"
	export -n -- "HSDPA_INIT_STRING2=${init_string2:-"ATE0V1X1&D2&C1S0=0"}"
	export -n -- "HSDPA_DIAL_STRING=${dial_string:-"ATD*99***1#"}"
	#logger "====> apn=$apn, pincode=$pincode, init_string1=$init_string1"
	
	#set_3g_led 1 0 1
	
	# check whether it's 56k service :
	if [ "$SERVICE_TYPE_56K" == "1" ]; then
		chat="/etc/chatscripts/56k.chat"
	fi

	# figure out hardware specific commands for the card
	case "$service" in
		cdma|evdo) chat="/etc/chatscripts/evdo.chat";;
	*)
		cardinfo=$(gcom -d "$device" -s /etc/gcom/getcardinfo.gcom)
		if echo "$cardinfo" | grep Novatel; then
			case "$service" in
				umts_only) CODE=2;;
				gprs_only) CODE=1;;
				*) CODE=0;;
			esac
			mode="AT\$NWRAT=${CODE},2"
		elif echo "$cardinfo" | grep Option; then
			case "$service" in
				umts_only) CODE=1;;
				gprs_only) CODE=0;;
				*) CODE=3;;
			esac
			mode="AT_OPSYS=${CODE}"
		fi
		# Don't assume Option to be default as it breaks with Huawei Cards/Sticks
		
		PINCODE="$pincode" gcom -d "$device" -s /etc/gcom/setpin.gcom || {
			echo "$config(3g): Please check your SIM card and PIN code setting."
			#set_3g_led 0 0 0
			#return 1
			ERR=1
		}
		
		test -z "$mode" || {
			logger "mode = $mode......................"
			MODE="$mode" gcom -d "$device" -s /etc/gcom/setmode.gcom
		}

		# fanny : for web display information
		SIG=$(gcom -d $device sig | grep Signal)
		logger "SIG=$SIG"	
		rm -f /var/state/3g>/dev/null
		echo "==3G Card Info== :">/var/state/3g
		echo "$cardinfo">>/var/state/3g
		echo "==3G Signal Strength== :">>/var/state/3g
		echo "$SIG">>/var/state/3g
		if [ "$ERR" == "1" ]; then
			echo "==3G Error== :">>/var/state/3g
			echo "Please check your SIM card and PIN code setting.">>/var/state/3g
			if [ "$SERVICE_TYPE_56K" != "1" ]; then
				return 1
			fi
		fi
		
		# fanny : If you are here, there must be 3G device exist.
		INUSE=$(uci -q -P /var/state get network.wan.3gdev)
		if [ "$INUSE" == "" ]; then
			uci -q -P /var/state set network.wan.3gdev=xxxx/xxxx/x
		fi
	esac
	#set_3g_led 1 0 0

	#fanny test
        scan_ppp "$config"
        config_get ifname "$config" ifname
        #echo "config=$config"
        set_interface_ifname "$config" "$ifname"
	#################################################

	config_set "$config" "connect" "${apn:+USE_APN=$apn }/usr/sbin/chat -t5 -v -E -f $chat"
	start_pppd "$config" \
		noaccomp \
		nopcomp \
		novj \
		nobsdcomp \
		noauth \
		lock \
		crtscts \
		${mtu:+mtu $mtu mru $mtu} \
		115200 "$device"
}
