#!/bin/sh
append DRIVERS "rt3070sta"

read_rt3070sta_var() {
CFG_FILE=/etc/Wireless/RT3070STA/rt3070sta.dat
APD=rt3070staapd
CHIPID=148f3070
RT_TYPE=rt3070sta
RT_DRIVER=rt3070sta
RT_IFNAME=ra_sta
}

modify_rt3070sta_ralink_cfgfile() {
set -x
	read_rt3070sta_var
	local str=$(cat $CFG_FILE | grep "$1=")
	sed 's/'"$str"'/'"$1=$2"'/' $CFG_FILE > /tmp/cfg.dat
	cp /tmp/cfg.dat $CFG_FILE
set +x
}

scan_rt3070sta() {

	set -x
	logger "=================== SCAN ====================="
    set +x
	return

    ################## NO USE ##############################
	local device="$1"
	local wds
	local adhoc sta ap
	config_get vifs "$device" vifs
	for vif in $vifs; do
	
		config_get ifname "$vif" ifname
		config_set "$vif" ifname "${ifname:-ra0}"
		
		config_get mode "$vif" mode
		case "$mode" in
			sta)
				append $mode "$vif"
			;;
			*) echo "$device($vif): Invalid mode, ignored."; continue;;
		esac
	done
	config_set "$device" vifs "${ap:+$ap }${adhoc:+$adhoc }${ahdemo:+$ahdemo }${sta:+$sta }${wds:+$wds }"
}

disable_rt3070sta() (
set -x
logger "=================== DISABLE ====================="
	read_rt3070sta_var

	local device="$1"

#	killall $APD    #fchien: what is this application for

	set_wifi_down "$device"
	include /lib/network
	ifconfig $RT_IFNAME down
	return 0
set +x
)

enable_rt3070sta() {
set -x
logger "====================== ENABLE ===================="
	read_rt3070sta_var
	local device="$1"
	config_get channel "$device" channel
	config_get vifs "$device" vifs
	config_get radio "$device" radio
	config_get mode "$device" mode
	config_get region "$device" region

	local first=1
	for vif in $vifs; do
		local up=0
		if [ -f /var/state/wireless ]; then
			up=$(uci get /var/state/wireless.$vif.up)
			up="${up:-0}"
		fi

		config_get enc "$vif" encryption
		config_get wpamode "$vif" wpamode
		config_get wpa_crypto "$vif" wpa_crypto
		config_get ssid "$vif" ssid
		config_get disabled "$vif" disabled
		config_get drivermode "$vif" mode
		config_get hidden "$vif" hidden
		
		ifname=$RT_IFNAME
		
		config_set "$vif" ifname "$ifname"

		case "$mode" in
			11bgn)
				modify_rt3070sta_ralink_cfgfile "CountryRegion" "$region"
				modify_rt3070sta_ralink_cfgfile "WirelessMode" "9"
			;;
			11an)
				modify_rt3070sta_ralink_cfgfile "CountryRegionABand" "$region"
				modify_rt3070sta_ralink_cfgfile "WirelessMode" "8"
			;;
		esac

		
#       something must be done before interface up 
		case "$enc" in
			WPA|wpa|WPA2|wpa2|WPA1WPA2|wpa1wpa2)
				config_get wpa_crypto "$vif" wpa_crypto
				config_get key "$vif" key
				config_get server "$vif" server
				config_get port "$vif" port
				config_get timeout "$vif" timeout
			;;
		esac

		if [ $radio == "0" ]; then
			return 0;
        fi
        
		ifconfig "$ifname" up


		case "$enc" in
			NONE|none)
				modify_rt3070sta_ralink_cfgfile "AuthMode" "OPEN"
				modify_rt3070sta_ralink_cfgfile "EncrypType" "NONE"
				modify_rt3070sta_ralink_cfgfile "SSID" "$ssid"
				iwpriv "$ifname" set AuthMode=OPEN
				iwpriv "$ifname" set EncrypType=NONE
				iwpriv "$ifname" set SSID=$ssid
			    ;;

			WEP|wep)
				config_get wepauth "$vif" wepauth

				case "$wepauth" in
					OPEN|open) 
                               modify_rt3070sta_ralink_cfgfile "AuthMode" "OPEN"
                               iwpriv "$ifname" set AuthMode=OPEN
                               ;;

				    SHARED|shared) 
                               modify_rt3070sta_ralink_cfgfile "AuthMode" "SHARED"
                               iwpriv "$ifname" set AuthMode=SHARED
                               ;;
				esac

                modify_rt3070sta_ralink_cfgfile "EncrypType" "WEP"
				iwpriv "$ifname" set EncrypType=WEP

				for idx in 1 2 3 4; do
					config_get key "$vif" "key${idx}"
					config_get keytype "$vif" "key${idx}type"
					key="${key:-1}"
                    modify_rt3070sta_ralink_cfgfile "Key${idx}Str" "$key"
                    modify_rt3070sta_ralink_cfgfile "Key${idx}Type" "key${idx}type"
					iwpriv "$ifname" set "Key$idx"=$key
				done

				config_get key "$vif" key
				key="${key:-1}"

				case "$key" in
					[1234]) 
                            modify_rt3070sta_ralink_cfgfile "DefaultKeyID" "$key"
                            iwpriv "$ifname" set DefaultKeyID=$key
                            ;;
					*) 
                            modify_rt3070sta_ralink_cfgfile "DefaultKeyID" "1"
                            iwpriv "$ifname" set DefaultKeyID=1
                            ;;
				esac

                modify_rt3070sta_ralink_cfgfile "SSID" "$ssid"
				iwpriv "$ifname" set SSID=$ssid
			;;

			PSK|psk|PSK2|psk2|PSKPSK2|pskpsk2|PSK_AUTO|psk_auto)

				config_get wpa_crypto "$vif" wpa_crypto
				config_get key "$vif" key

				case "$enc" in
					PSK|psk)	
								modify_rt3070sta_ralink_cfgfile "AuthMode" "WPAPSK"
                                iwpriv "$ifname" set AuthMode=WPAPSK
                                ;;

					PSK2|psk2)	
								modify_rt3070sta_ralink_cfgfile "AuthMode" "WPA2PSK"
                                iwpriv "$ifname" set AuthMode=WPA2PSK
                                ;;

					PSKPSK2|pskpsk2|PSK_AUTO|psk_auto)	
                                iwpriv "$ifname" set AuthMode=WPAPSKWPA2PSK
                                if [ $? == '0' ]; then
								    modify_rt3070sta_ralink_cfgfile "AuthMode" "WPAPSKWPA2PSK"
                                fi
                                ;;
				esac
				
				case "$wpa_crypto" in
					TKIP|tkip)
						modify_rt3070sta_ralink_cfgfile "EncrypType" "TKIP"
						modify_rt3070sta_ralink_cfgfile "WPAPSK" "$key"
						modify_rt3070sta_ralink_cfgfile "DefaultKeyID" "2"
						modify_rt3070sta_ralink_cfgfile "SSID" "$ssid"
						iwpriv "$ifname" set EncrypType=TKIP
						iwpriv "$ifname" set WPAPSK="$key"
						iwpriv "$ifname" set DefaultKeyID=2
						iwpriv "$ifname" set SSID=$ssid
 					;;

					AES|aes)
						modify_rt3070sta_ralink_cfgfile "EncrypType" "AES"
						modify_rt3070sta_ralink_cfgfile "WPAPSK" "$key"
						modify_rt3070sta_ralink_cfgfile "DefaultKeyID" "2"
						modify_rt3070sta_ralink_cfgfile "SSID" "$ssid"
						iwpriv "$ifname" set EncrypType=AES
						iwpriv "$ifname" set WPAPSK="$key"
						iwpriv "$ifname" set DefaultKeyID=2
						iwpriv "$ifname" set SSID=$ssid
					;;

				esac
			;;

			WPA|wpa|WPA2|wpa2|WPA1WPA2|wpa1wpa2)

#  fchien: no iwpriv support for AuthMode=WPA or AuthMode=WPA2 ??????
				case "$enc" in
					WPA|wpa)    
						      modify_rt3070sta_ralink_cfgfile "AuthMode" "WPAPSK"
                              iwpriv "$ifname" set AuthMode=WPAPSK
                              ;;

					WPA2|wpa2)  
						      modify_rt3070sta_ralink_cfgfile "AuthMode" "WPA2PSK"
                              iwpriv "$ifname" set AuthMode=WPA2PSK
                              ;;
				esac

				case "$wpa_crypto" in
					TKIP|tkip) 
                               iwpriv "$ifname" set EncrypType=TKIP
                               ;;

					AES|aes) 
                               iwpriv "$ifname" set EncrypType=AES
                               ;;
				esac

#				/usr/sbin/$APD #fchien: what is this application for

				modify_rt3070sta_ralink_cfgfile "SSID" "$ssid"
				iwpriv "$ifname" set SSID=$ssid
			;;
		esac


#	iwpriv "$ifname" set SSID="$ssid"
		
	if [ $up == "0" ]; then
		set_wifi_up "$vif" "$ifname"
	fi

	if [ $radio == "0" ]; then
		echo off > /proc/gpio/LED1
	else
		echo on > /proc/gpio/LED1
	fi
	
	first=0
	done

set +x
}

detect_rt3070sta() {
set -x
     logger "====================== DETECT ====================="
	echo off > /proc/gpio/LED1
	read_rt3070sta_var

	local devid
	devid=$(cat /proc/bus/usb/devices)
#	echo "$devid" | grep -q rt3070sta || return
	config_get type $RT_IFNAME type
	[ "$type" = $RT_TYPE ] && return
	uci set network.lan.type=wan 
	uci commit network
		cat <<EOF
config wifi-device  $RT_IFNAME
	option type     $RT_TYPE
	option channel  11
	option radio    1
	option mode     11bgn
	option region   0
	option disabled 0
config wifi-iface
	option device	$RT_IFNAME
	option network	wan
	option mode	sta
	option ssid	    fchien
	option hidden	0
	option encryption none
EOF
set +x
}
