#ifndef _RATE_LIMIT_H_
#define _RATE_LIMIT_H_

#include <linux/types.h>

enum {
	RATE_LIMIT_DIRECTION_TX = 0,
	RATE_LIMIT_DIRECTION_RX,
	RATE_LIMIT_DIRECTION_MAX
};

struct rate_limit_info_t {
	u_int32_t max_rate;
	u_int32_t timestamp;
	u_int32_t byte_count;
};

#define TRAFFIC_HISTORY_ENTRY_COUNT 360
#define TRAFFIC_HISTORY_INTERVAL 30000 //5 minutes

struct traffic_history_t {
	int head;
	u_int32_t timestamp;
	int current_byte_count;
	int value[TRAFFIC_HISTORY_ENTRY_COUNT];
};

struct rate_statistics_t {
	u_int32_t current_rate;
	struct traffic_history_t traffic_history;
};
#if 0
struct data_monitor_t {
	u_int32_t ip;
	u_int32_t timestamp[RATE_LIMIT_DIRECTION_MAX];
	u_int32_t current_rate[RATE_LIMIT_DIRECTION_MAX];
	u_int32_t block_expire_time;
};
#endif
#define MAX_RATE_LIMIT_BY_IP_ITEM 768

struct rate_limit_by_IP {
	u_int32_t ip;
	struct rate_limit_info_t info[RATE_LIMIT_DIRECTION_MAX];
	struct rate_statistics_t rate_statistics[RATE_LIMIT_DIRECTION_MAX];
	u_int32_t block_expire_time;
	struct rate_limit_by_IP *next;
};

#define MAX_RATE_LIMIT_RANGE_ITEM 10

struct rate_limit_range {
	u_int32_t start_ip;
	u_int32_t end_ip;
	u_int32_t max_rate;	
};

struct rate_limit_head {
	struct rate_limit_by_IP *ptr;
};

#define DEFAULT_BLOCK_SECONDS 30000 //5 minutes

#define INI_DEFAULT_TX_RATE 5000
#define INI_DEFAULT_RX_RATE 5000

struct rate_limit_data {
	int enable;
	int default_tx;
	int default_rx;
	struct rate_limit_range range_tx[MAX_RATE_LIMIT_RANGE_ITEM];
	struct rate_limit_range range_rx[MAX_RATE_LIMIT_RANGE_ITEM];
};
struct data_monitor_t {
	u_int32_t ip;
	u_int32_t timestamp[RATE_LIMIT_DIRECTION_MAX];
	u_int32_t current_rate[RATE_LIMIT_DIRECTION_MAX];
	u_int32_t block_expire_time;
	u_int32_t max_rate[RATE_LIMIT_DIRECTION_MAX];;
};
struct rate_monitor_data {
	int enable;
	int data_num;
	struct data_monitor_t data[MAX_RATE_LIMIT_BY_IP_ITEM];
};
#endif

