#include <linux/module.h>
#include <linux/kernel.h>

int ip_bind_mac_mode;

void (*set_session_limit_default_from_arch)(int max_session) = NULL;
void (*set_session_limit_range_from_arch)(int index, u_int32_t start_ip, u_int32_t end_ip, u_int32_t max_session) = NULL;
void (*enable_session_limit_from_arch)(int enable) = NULL;
void (*set_rate_limit_default_from_arch)(int tx, int rx) = NULL;
void (*set_rate_limit_range_from_arch)(int index, int direction, u_int32_t start_ip, u_int32_t end_ip, u_int32_t max_rate) = NULL;
void (*enable_rate_limit_from_arch)(int enable) = NULL;
void (*get_session_limit_data_out)(int cmd, void *dataOut) = NULL;
void (*get_rate_limit_data_out)(int cmd, void *dataOut) = NULL;
void (*set_rate_limit_block_from_arch)(u_int32_t ip, int block) = NULL;
void (*set_cgi_info_from_arch)(int net, u_int32_t ipaddr, u_int32_t netmask) = NULL;
void (*set_cgi_info_session_from_arch)(u_int32_t ipaddr, u_int32_t netmask) = NULL;

EXPORT_SYMBOL(set_session_limit_default_from_arch);
EXPORT_SYMBOL(set_session_limit_range_from_arch);
EXPORT_SYMBOL(enable_session_limit_from_arch);
EXPORT_SYMBOL(set_rate_limit_default_from_arch);
EXPORT_SYMBOL(set_rate_limit_range_from_arch);
EXPORT_SYMBOL(enable_rate_limit_from_arch);
EXPORT_SYMBOL(get_session_limit_data_out);
EXPORT_SYMBOL(set_rate_limit_block_from_arch);
EXPORT_SYMBOL(get_rate_limit_data_out);
EXPORT_SYMBOL(set_cgi_info_from_arch);
EXPORT_SYMBOL(set_cgi_info_session_from_arch);

asmlinkage long sys_ipbindmac(unsigned __user mode, int option, void *param, int parameter_num)
{
	u_int32_t *p1;
	int *p2;
	if (option == 0)
		ip_bind_mac_mode = mode;

	switch (option) {
	case 1:
		if (set_session_limit_default_from_arch)
			set_session_limit_default_from_arch(parameter_num);
		break;
	case 2:
		if (set_session_limit_range_from_arch)
			if (param != NULL) {
				p1 = (u_int32_t *)param;
				set_session_limit_range_from_arch(parameter_num, p1[0], p1[1], p1[2]);
			}
		break;
	case 3:
		if (enable_session_limit_from_arch)
			enable_session_limit_from_arch(parameter_num);
		break;
	case 4:
		if (set_rate_limit_default_from_arch)
			if (param != NULL) {
				p2 = (int *)param;
				set_rate_limit_default_from_arch(p2[0], p2[1]);
			}
		break;
	case 5:
		if (set_rate_limit_range_from_arch)
			if (param != NULL) {
				p1 = (u_int32_t *)param;
				set_rate_limit_range_from_arch(parameter_num, (int)p1[0], p1[1], p1[2], p1[3]);
			}
		break;
	case 6:
		if (enable_rate_limit_from_arch)
			enable_rate_limit_from_arch(parameter_num);
		break;
	case 7:
		if (get_session_limit_data_out)
			get_session_limit_data_out(parameter_num, param);
		break;
	case 8:
		if (get_rate_limit_data_out)
			get_rate_limit_data_out(parameter_num, param);
		break;
	case 9: 
		if (set_rate_limit_block_from_arch)
			if (param != NULL) {
				p1 = (u_int32_t *)param;
				set_rate_limit_block_from_arch(p1[0], parameter_num);
			}
		break;
	case 10: 
		if (set_cgi_info_from_arch) {
			if (param != NULL) {
				p1 = (u_int32_t *)param;
				set_cgi_info_from_arch(-1, p1[0], p1[1]);
				set_cgi_info_session_from_arch(p1[0], p1[1]);
			} else {
				set_cgi_info_from_arch(parameter_num, 0, 0);
			}
		}
		break;
	}
	return 0;
}


EXPORT_SYMBOL_GPL(ip_bind_mac_mode);

