# 
# Copyright (C) 2006 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#

ifeq ($(NF_KMOD),1)
P_V4:=ipv4/netfilter/
P_XT:=netfilter/
endif

IPT_CONNTRACK-m :=
IPT_CONNTRACK-$(CONFIG_NF_CONNTRACK) += $(P_XT)ipt_conntrack
IPT_CONNTRACK-$(CONFIG_NETFILTER_XT_MATCH_CONNBYTES) += $(P_XT)xt_connbytes
IPT_CONNTRACK-$(CONFIG_NETFILTER_XT_MATCH_CONNMARK) += $(P_XT)xt_connmark
IPT_CONNTRACK-$(CONFIG_NETFILTER_XT_MATCH_CONNTRACK) += $(P_XT)ipt_conntrack
IPT_CONNTRACK-$(CONFIG_NETFILTER_XT_MATCH_HELPER) += $(P_XT)xt_helper
IPT_CONNTRACK-$(CONFIG_NETFILTER_XT_MATCH_STATE) += $(P_XT)xt_state


IPT_EXTRA-m :=
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_LIMIT) += $(P_XT)ipt_limit
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_COMMENT) += $(P_XT)ipt_comment
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_CHAOS) += $(P_XT)ipt_CHAOS
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_CLASSIFY) += $(P_XT)ipt_CLASSIFY
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_CONNMARK) += $(P_XT)ipt_CONNMARK
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_DELUDE) += $(P_XT)ipt_DELUDE
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_DSCP) += $(P_XT)ipt_DSCP
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_MARK) += $(P_XT)ipt_MARK
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_NFQUEUE) += $(P_XT)ipt_NFQUEUE
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_NFLOG) += $(P_XT)ipt_NFLOG
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_NOTRACK) += $(P_XT)ipt_NOTRACK
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_SECMARK) += $(P_XT)ipt_SECMARK
IPT_EXTRA-$(CONFIG_NETFILTER_XT_TARGET_CONNSECMARK) += $(P_XT)ipt_CONNSECMARK
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_PORTSCAN) += $(P_XT)ipt_portscan
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_PKTTYPE) += $(P_XT)ipt_pkttype
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_QUOTA) += $(P_XT)ipt_quota
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_REALM) += $(P_XT)ipt_realm
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_SCTP) += $(P_XT)ipt_sctp
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_STATISTIC) += $(P_XT)ipt_statistic
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_STRING) += $(P_XT)ipt_string
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_PHYSDEV) += $(P_XT)ipt_physdev
IPT_EXTRA-$(CONFIG_NETFILTER_XT_MATCH_HASHLIMIT) += $(P_XT)ipt_hashlimit
IPT_EXTRA-$(CONFIG_IP_NF_MATCH_RECENT) += $(P_V4)ipt_recent
IPT_EXTRA-$(CONFIG_IP_NF_TARGET_REJECT) += $(P_V4)ipt_REJECT
IPT_EXTRA-$(CONFIG_IP_NF_TARGET_NETMAP) += $(P_V4)ipt_NETMAP
IPT_EXTRA-$(CONFIG_IP_NF_TARGET_SAME) += $(P_V4)ipt_SAME
IPT_EXTRA-$(CONFIG_IP_NF_TARGET_LOG) += $(P_V4)ipt_LOG
IPT_EXTRA-$(CONFIG_IP_NF_TARGET_CLUSTERIP) += $(P_V4)ipt_CLUSTERIP

IPT_FILTER-m :=
IPT_FILTER-$(CONFIG_IP_NF_MATCH_IPP2P) += $(P_V4)ipt_ipp2p
IPT_FILTER-$(CONFIG_IP_NF_MATCH_LAYER7) += $(P_V4)ipt_layer7


IPT_IMQ-m :=
IPT_IMQ-$(CONFIG_IP_NF_TARGET_IMQ) += $(P_V4)ipt_IMQ

IPT_IPOPT-m :=
IPT_IPOPT-$(CONFIG_NETFILTER_XT_TARGET_TCPMSS) += $(P_XT)ipt_TCPMSS
IPT_IPOPT-$(CONFIG_NETFILTER_XT_MATCH_DCCP) += $(P_XT)ipt_dccp
IPT_IPOPT-$(CONFIG_NETFILTER_XT_MATCH_DSCP) += $(P_XT)ipt_dscp
IPT_IPOPT-$(CONFIG_NETFILTER_XT_MATCH_LENGTH) += $(P_XT)ipt_length
IPT_IPOPT-$(CONFIG_NETFILTER_XT_MATCH_MAC) += $(P_XT)ipt_mac
IPT_IPOPT-$(CONFIG_NETFILTER_XT_MATCH_MARK) += $(P_XT)ipt_mark
IPT_IPOPT-$(CONFIG_NETFILTER_XT_MATCH_MULTIPORT) += $(P_XT)ipt_multiport
IPT_IPOPT-$(CONFIG_NETFILTER_XT_MATCH_TCPMSS) += $(P_XT)ipt_tcpmss
IPT_IPOPT-$(CONFIG_IP_NF_MATCH_OWNER) += $(P_V4)ipt_owner
IPT_IPOPT-$(CONFIG_IP_NF_MATCH_TOS) += $(P_V4)ipt_tos
IPT_IPOPT-$(CONFIG_IP_NF_MATCH_ECN) += $(P_V4)ipt_ecn
IPT_IPOPT-$(CONFIG_IP_NF_MATCH_TTL) += $(P_V4)ipt_ttl
IPT_IPOPT-$(CONFIG_IP_NF_MATCH_ADDRTYPE) += $(P_V4)ipt_addrtype
IPT_IPOPT-$(CONFIG_IP_NF_TARGET_TOS) += $(P_V4)ipt_TOS
IPT_IPOPT-$(CONFIG_IP_NF_TARGET_ECN) += $(P_V4)ipt_ECN
IPT_IPOPT-$(CONFIG_IP_NF_TARGET_TTL) += $(P_V4)ipt_TTL

IPT_IPSEC-m :=
IPT_IPSEC-$(CONFIG_NETFILTER_XT_MATCH_ESP) += $(P_XT)ipt_esp
IPT_IPSEC-$(CONFIG_NETFILTER_XT_MATCH_POLICY) += $(P_XT)ipt_policy
IPT_IPSEC-$(CONFIG_IP_NF_MATCH_AH) += $(P_V4)ipt_ah

IPT_IPSET-m :=
IPT_IPSET-$(CONFIG_IP_NF_TARGET_SET) += $(P_V4)ipt_SET
IPT_IPSET-$(CONFIG_IP_NF_SET) += $(P_V4)ipt_set

IPT_NAT-m :=
IPT_NAT-$(CONFIG_NF_NAT) += $(P_V4)ipt_DNAT
IPT_NAT-$(CONFIG_NF_NAT) += $(P_V4)ipt_SNAT
IPT_NAT-$(CONFIG_IP_NF_TARGET_MASQUERADE) += $(P_V4)ipt_MASQUERADE
IPT_NAT-$(CONFIG_IP_NF_TARGET_REDIRECT) += $(P_V4)ipt_REDIRECT

IPT_NAT_DEFAULT-m :=
IPT_NAT_EXTRA-m := 
IPT_QUEUE-m :=

IPT_ULOG-m :=
IPT_ULOG-$(CONFIG_IP_NF_TARGET_ULOG) += $(P_V4)ipt_ULOG

IPT_IPRANGE-m :=
IPT_IPRANGE-$(CONFIG_IP_NF_MATCH_IPRANGE) += $(P_V4)ipt_iprange

IPT_NETLINK-m :=
IPT_NETLINK-$(CONFIG_NETFILTER_NETLINK) += $(P_XT)nfnetlink
IPT_NETLINK-$(CONFIG_NETFILTER_NETLINK_QUEUE) += $(P_XT)nfnetlink_queue
IPT_NETLINK-$(CONFIG_NETFILTER_NETLINK_LOG) += $(P_XT)nfnetlink_log
IPT_NETLINK-$(CONFIG_IP_NF_CONNTRACK_NETLINK) += $(P_V4)ip_conntrack_netlink

#IPT_BUILTIN := $(P_V4)xt_standard
#IPT_BUILTIN += $(P_V4)ipt_icmp $(P_V4)xt_tcp $(P_V4)xt_udp
IPT_BUILTIN := 
IPT_BUILTIN += $(IPT_CONNTRACK-y)
IPT_BUILTIN += $(IPT_EXTRA-y)
IPT_BUILTIN += $(IPT_FILTER-y)
IPT_BUILTIN += $(IPT_IMQ-y)
IPT_BUILTIN += $(IPT_IPOPT-y)
IPT_BUILTIN += $(IPT_IPSEC-y)
IPT_BUILTIN += $(IPT_IPSET-y)
IPT_BUILTIN += $(IPT_NAT-y)
IPT_BUILTIN += $(IPT_ULOG-y)
IPT_BUILTIN += $(IPT_NETLINK-y)
