#!/bin/sh
inspect=$1
pkt=$2

[ -z "$inspect" -o -z "$pkt" ] && {
	echo "fpp [inspection] [packets]"
	return 1
}

[ -f /etc/config/fpp_policy ] || {
	echo "config 'policy' 'general'" > /etc/config/fpp_policy
	echo "	option inspect 1" >> /etc/config/fpp_policy
	echo "option pkt 8" >> /etc/config/fpp_policy
}

## inspect only 0, 1
[ "$inspect" = "0" ] || inspect="1"

uci set fpp_policy.general.inspect=$inspect
uci set fpp_policy.general.pkt=$pkt
uci commit fpp_policy

echo "Set inspection : $(uci get fpp_policy.general.inspect)"
echo "Set packets    : $(uci get fpp_policy.general.pkt)"
/etc/init.d/fpp_policy apply
return 0
