#!/bin/sh
. /etc/functions.sh

do_check_dnsmasq(){
	#check if dnsmasq crash, restart it 
	ps aux |grep -v "grep dnsmasq" |grep "dnsmasq" >/dev/null 2>/dev/null
	if [ "$?" != "0" ] ;then
		echo "(`date`):Find dnsmasq crash, do restart!" >/dev/console
		logger -p 152.5 "Find dnsmasq crash, do restart!"
		/etc/init.d/dnsmasq restart &
	fi
}

### check VPN mail alert
pid_mailtest=`ps | grep mailtest | grep -q -v grep && echo 1 || echo 0`
if [ "$pid_mailtest" == "0" ]; then
	/etc/mailtest.sh vpn_send &
fi

### kill old state pppd that blocks new pptp connection dialup
[ -d /tmp/pptp_l2l_pid ] && {
		for name_pid in $(ls /tmp/pptp_l2l_pid/* 2>&-); do (
			pname=$(cat $name_pid | awk '{print $1}')
			[ -f /tmp/status_PPTP_data/$pname ] && continue # the old state pppd can dialup new connection, skip ...
			[ -f $name_pid ] &&  /etc/init.d/pptp_l2l_dout tunnel_restart $(cat $name_pid)
		); done
		rm -rf /tmp/pptp_l2l_pid
}

#restart klogd if it disappear
ps | grep "klogd -c1" | grep -v grep >/dev/null 2>/dev/null
[ "$?" = "0" ] || {
	echo "(`date`):Find klogd crash, do restart!" >/dev/console
	logger -p 152.5 "Find klogd crash, do restart!"
	klogd -c1
}

#restart dnsmasq if it disappear
do_check_dnsmasq

#restart syslogd if logger is stuck
en_syslog=$(uci -q get syslogd.syslogd.status)
if [ "$en_syslog" != "disable" ]; then
	LOGGER_MAX_CNT=10
	cnt_log=$(ps | grep logger | grep -v grep -c)
	[ $cnt_log -ge $LOGGER_MAX_CNT ] && {
		logger "logger_syslog_test" &
		sleep 2
		cnt_log=$(ps | grep "logger_syslog_test" | grep -v grep -c)
		[ "$cnt_log" == "0" ] || {
			echo "(`date`):Find logger stuck. Do syslogd restart!" > /dev/console
			/etc/init.d/syslog restart
		}
	}

	#restart syslogd if it disappear
	ps | grep "syslogd" | grep -v grep >/dev/null 2>/dev/null
	[ "$?" = "0" ] || {
		echo "(`date`):Can't not find syslogd. Do syslogd restart!" > /dev/console
		logger -p 152.5 "Can't not find syslogd. Do syslogd restart!"
		/etc/init.d/syslog restart
	}
fi

#check syslog process
cur=$(date +%s)
mod=$(date -r /tmp/status_system_interface +%s || echo 0)
diff=$(($cur - $mod))
if [ "$diff" -gt "60" ]; then
	cp /tmp/jsonstatus.txt /tmp/jsonstatus.log
	cp /tmp/status_system_interface /tmp/status_system_interface.log	
	echo "(`date`): Timeout!!! Restart syslog...($cur , $mod)" > /dev/console
	logger -p 152.5 "Timeout!!! Restart syslog...($cur , $mod)"
	killall -9 syslog
	/sbin/syslog > /dev/null &		# restart syslog
fi


#restart lighttpd if disappeared
#chk_http=$(ps | grep "lighttpd -f" | grep -v grep -c)
#[ "$chk_http" = "0" ] && {
#	echo "(`date`):Lighttpd crash, do restart!" >/dev/console
#	logger -p 152.5 "lighttpd crash, do restart!"
#	/etc/init.d/lighttpd restart
#}

#restart lighttpd if VmRSS exceeeds 20000(about 9%)
#lighttpd_pid=`pidof lighttpd`
#[ -n "$lighttpd_pid" ] && {
#	vmrss_tmp=`cat /proc/$lighttpd_pid/status |grep VmRSS`
#	vmrss=`echo $vmrss_tmp |cut -d ' ' -f 2`
#	[ $vmrss -gt 20000 ] && {
#		echo "(`date`):Lighttpd VmRSS($vmrss kb) is over limit, do restart!" >/dev/console
#		logger -p 152.5 "Lighttpd VmRSS($vmrss kb) is over limit, do restart!"
#		/etc/init.d/lighttpd restart
#	}
#}

#delete default route in main route table that should not happen
d_route=`/sbin/route -n |awk '{print $1}' |grep "^0.0.0.0$"`
[ -z "$d_route" ] || {
	echo "(`date`):Found default route in route main table, remove it!" >/dev/console
	/sbin/route -n del 0.0.0.0 2>/dev/null
	/sbin/route -n del default 2>/dev/null
}

#check web portal polling port "54321" status  
web_portal_pid=$(ps | grep "ubf_polling_d" | grep -v grep)

if [ "$web_portal_pid" != "" ]; then
	portal_socket_port=$(netstat -tunl | grep 54321)
	if [ -z "$portal_socket_port" ]; then
		kill -SIGUSR1 `pidof ubf_polling_d`
		logger "portal polling's(ubf_polling_d) port '54321' restart"
	fi
fi
#########

#if /data/rrd/SYS.rrd not exist (at first) ,copy .rrd
if [ ! -e "/data/rrd/SYS.rrd" ] && [ -e "/var/lib/rrdcollect/rrd/SYS.rrd" ]; then
	cp -r /var/lib/rrdcollect/rrd /data
fi
#if rrd file error (size == 0),copy backup rrd file or rebuild rrd file
if [ ! -s "/var/lib/rrdcollect/rrd/SYS.rrd" ];then
	if [ -s "/data/rrd/SYS.rrd" ];then
		cp -r /data/rrd /var/lib/rrdcollect/
	else
		/usr/bin/rrd.sh init
	fi
fi
#backup rrd file (traffic graph data) when (/var/...) is newer than (/data/...)
if [ /var/lib/rrdcollect/rrd/SYS.rrd -nt /data/rrd/SYS.rrd ] && [ -e "/var/lib/rrdcollect/rrd/SYS.rrd" ]; then
	if [ -s "/var/lib/rrdcollect/rrd/SYS.rrd" ];then
		cp -r /var/lib/rrdcollect/rrd /data
	fi
fi

###################################################
#syslog email alert
syslog_mail_enable=$(uci filter config_notify syslog enable)

if [ "$syslog_mail_enable" != "" ];then
	SYSLOG_MAIL=/tmp/syslog_mail
	LINE_LIMMIT=1000

	#get syslog mail alert buffer line count
	file_line=$(wc -l $SYSLOG_MAIL | awk -F ' ' '{print $1}')
	
	#get last send syslog mail time
	time_interval="0"
	if [ -f /tmp/syslog_mail_time_stamp ];then
		time_now=$(date +%s)
		time_last=$(cat /tmp/syslog_mail_time_stamp)
		time_interval=$(($time_now-$time_last))
	fi
	
	#if "mail buffer full" or "no send syslog mail more than 1 day"
	if [ "$file_line" -gt "$LINE_LIMMIT" ] || [ "$time_interval" -gt "86400" ];then
		/etc/init.d/sms_config send_syslog_mail
	fi
fi
#syslog email alert
###################################################
#restart evcpe if evcpe crash
used_mem=$(ps | awk '/\evcpe/ {print $3}')
pid=$(ps | awk '/\evcpe/ {print $1}')
status=$(uci get cwmp.tr069.status)

if [ "$used_mem" -gt "6000" ];then

	kill -9 $pid 2>/dev/null >/dev/null

	if [ "$status" = "enable" ];then 
		#/usr/bin/evcpe start -m /etc/evcpe/tr098_model.xml -d /etc/evcpe/tr098_data.xml 1>/dev/null 2>/dev/null &
		logger "evcpe memory too high,restart evcpe(tr069)"
		/etc/init.d/cwmp restart
	fi
elif [ "$pid" = "" ];then
        if [ "$status" = "enable" ];then
		        logger "evcpe crash ,restart evcpe(tr069)"
                /etc/init.d/cwmp restart
        fi
fi
############################# 
let "tm = (( `date +%s` & 255 ))"
[ "$tm" -gt "60" ] || {
	mkdir -p /data/d_dataflow
	for file in /tmp/d_dataflow/*
	do
		fname=`basename $file`
		if [ ! -f "/data/d_dataflow/$fname" -o $file -nt "/data/d_dataflow/$fname" ]; then
		  #  "File 1 is newer than file 2"
		  test -s $file && cp $file /data/d_dataflow || (rm $file; rm /data/d_dataflow/$fname)
		fi
	done
}

############################# 
#reset device information if data disappears
model=`json -f /var/status_system_interface get system.model`
[ -n "$model" ] || /etc/init.d/set_system_version boot

speed=`json -f /var/status_system_interface get switch_wan.wan1.speed`
[ -n "$speed" ] || /etc/init.d/rtk8366_port boot

#############################
#check ipsec profiles which is enabled but is not in whack
bootpid=$(pidof ipsec_booting_program)
plutopid=$(pidof pluto)
if [ "$bootpid" == "" ] && [ "$plutopid" != "" ]; then
	ipsec_time_now=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
	if [ -f /tmp/ipsec_policy_check_all_profiles ];then
		ipsec_time_last=$(cat /tmp/ipsec_policy_check_all_profiles)
	else
		ipsec_time_last=0
	fi
	ipsec_time_interval=$(($ipsec_time_now-$ipsec_time_last))
	# 3 minutes
	if [ "$ipsec_time_interval" -gt "179" ];then
		echo "$ipsec_time_now" > /tmp/ipsec_policy_check_all_profiles
		ipsec whack --dumpname
		/sbin/ipsec_booting_program ipsec_policy check
	fi
fi

#############################
#check if remote host ip of domain name changed
/etc/init.d/ipsec_policy dns_check &

#############################
# USB WAN send to keepalive
for usbif in usb1 usb2
do
	usb_up=$(json get network.$usbif.connection)
	if [ "$usb_up" == "up" ]; then
		usb_proto=$(json get network.$usbif.proto)
		if [ "$usb_proto" == "4g" ]; then
			usbdns=$(json get network.$usbif.dns)
			usbaddr=$(json get network.$usbif.ipaddr)
			if [ "$usbdns" != "" ]; then
				for dnsaddr in $usbdns
				do
					ping $dnsaddr -I $usbaddr -c 1 -q -s 16 &
				done
			fi
			ping 8.8.8.8 -I $usbaddr -c 1 -q -s 16 &
		fi
	fi
done

#restart conn_detection if disappeared 
if [ -f "/var/run/conn_dect.pid" ]; then
		conndect_pid=`cat /var/run/conn_dect.pid 2>/dev/null`
		cmd_line=`cat /proc/$conndect_pid/cmdline 2>/dev/null`
		echo "$cmd_line" | grep "^/bin/sh/sbin/conn_dect$" >/dev/null 2>/dev/null
		if [ "$?" != "0" ] ;then		
			echo "network($$):connection detection pid error, restart conn_dect" >/dev/console
			rm -f /var/run/conn_dect.pid
			nohup /sbin/conn_dect &> /dev/null &
		fi
else
		echo "network($$):start connection detection" >/dev/console
		nohup /sbin/conn_dect &> /dev/null &
fi
