#!/bin/sh
host=$1
src_if=$2

[ -z "$host" ] && {
	echo "ping [host] [src_if]"
	return 1
}

if   [ "$src_if" = "unspecified" ]; then
	src_ip=
else
	src_ip=`json get network.$src_if.ipaddr`
	connection=`json get network.$src_if.connection`
	[ -z "$src_ip" -o "$connection" = "down" ] && {
		echo "$src_if is not available."
		echo "Send ICMP ping packet done."
		return 1
	}
fi

/bin/ping -c 5 ${src_ip:+-I $src_ip} $host
echo "Send ICMP ECHO_REQUEST packets done."
return 0
