#!/bin/sh

host=$1
src_if=$2
count=$3
ping_size=$4
quiet=$5
quiet_flag=""

[ -z "$host" ] && {
	echo "ping6 [host] [src_if] [count] [ping_size] [quiet]"
	return 1
}

if   [ "$src_if" = "unspecified" ]; then
	src_ip=
else
	src_ip=`json get network.$src_if.ip6addr`
	connectio6=`json get network.$src_if.connectio6`
	[ -z "$src_ip" -o "$connectio6" = "down" ] && {
		echo "$src_if is not available."
		echo "Send ICMP ping packet done."
		return 1
	}
	src_ip=${src_ip%%/*}
fi

[ "$count" ] || count=5

if [ "$quiet" == "true" ]; then
	quiet_flag=1
fi

/usr/bin/ping6 -c $count ${ping_size:+-s $ping_size} ${src_ip:+-I $src_ip} ${quiet_flag:+-q} $host
echo "Send ICMP ECHO_REQUEST packets done."
return 0