#!/bin/sh

# Command:
# /etc/route_down_drop.sh [call from] [route table id] [action]
# It should be called from 10-status

# Usage:
# This command will set up iptables rule in (WAN_DOWN_BLOCK) chain to maintain packets which prepare to send to the specific route.
# If a route is going to be DOWN, this script will add a drop rule for any packets which are assgined to this route table id
# If a route is going to be UP, this script will remove the drop rule for this route table id
# [call from]: for debug use, which help to trace who call here
# [route table id]: it should be a route table id, check json show policy_rt for table mapping information
# [action]: UP or DOWN or CLEAN

#see get_route_table_id
SCRIPT_LOCK="/tmp/web_apply_lock/route_down_drop"
MAX_TABLE_COUNT=100
IPTABLES="iptables"
TABLE="mangle"
ROUTE_DOWN_DROP="ROUTE_DOWN_DROP"
CALL_FROM=$1
TABLE_ID=$2
ACTION=$3
IFACE=$4
[ "$#" -ge 3 ] || {
	echo "[route_down_drop.sh]:call from ${CALL_FROM}, require at least 3 arguments:[call from] [route table id] [action]" >/dev/console
	exit 1
}

#For assure, check current connection status before setting rules
lock $SCRIPT_LOCK
echo "[route_down_drop.sh]:call from ${CALL_FROM}:IFACE=$IFACE, TABLE_ID=$TABLE_ID, ACTION=$ACTION" >/dev/console
conn_status=`json get network.${IFACE}.connection`
#hex_rt=$(printf "%x" $TABLE_ID)
if [ "$ACTION" = "DOWN"  ] ;then
	[ "$conn_status" = "down" ] && {
		#prevent down->down duplication
		#echo "[route_down_drop.sh]:call from [$1], rt_id=$2 is $3, add DROP rule to ROUTE_DOWN_DROP chain" >/dev/console
		$IPTABLES -t $TABLE -D $ROUTE_DOWN_DROP -o wan-$IFACE -m mset ! --set lan_net_set dst ! --set exception_subnet_set dst ! --set exception_subnet_gre_set dst -j DROP 2>/dev/null
		$IPTABLES -t $TABLE -D $ROUTE_DOWN_DROP -m mset ! --set lan_net_set dst ! --set exception_subnet_set dst ! --set exception_subnet_gre_set dst -m mark --mark $TABLE_ID/0x7F -j DROP 2>/dev/null
		$IPTABLES -t $TABLE -A $ROUTE_DOWN_DROP -o wan-$IFACE -m mset ! --set lan_net_set dst ! --set exception_subnet_set dst ! --set exception_subnet_gre_set dst -j DROP 2>/dev/null
		$IPTABLES -t $TABLE -A $ROUTE_DOWN_DROP -m mset ! --set lan_net_set dst ! --set exception_subnet_set dst ! --set exception_subnet_gre_set dst -m mark --mark $TABLE_ID/0x7F -j DROP 2>/dev/null
	}
elif [ "$ACTION" = "UP"  ] ;then
	[ "$conn_status" = "up" ] && {
		#echo "[route_down_drop.sh]:call from [$1], rt_id=$2 is $3, remove DROP rule from ROUTE_DOWN_DROP chain" >/dev/console
		$IPTABLES -t $TABLE -D $ROUTE_DOWN_DROP -o wan-$IFACE -m mset ! --set lan_net_set dst ! --set exception_subnet_set dst ! --set exception_subnet_gre_set dst -j DROP 2>/dev/null
		$IPTABLES -t $TABLE -D $ROUTE_DOWN_DROP -m mset ! --set lan_net_set dst ! --set exception_subnet_set dst ! --set exception_subnet_gre_set dst -m mark --mark $TABLE_ID/0x7F -j DROP 2>/dev/null
	}
elif [ "$ACTION" = "CLEAN"  ] ;then
	#echo "[route_down_drop.sh]:call from [$1], rt_id=$2, clean DROP rule from ROUTE_DOWN_DROP chain" >/dev/console
	$IPTABLES -t $TABLE -D $ROUTE_DOWN_DROP -m mset ! --set lan_net_set dst ! --set exception_subnet_set dst ! --set exception_subnet_gre_set dst -m mark --mark $TABLE_ID/0x7F -j DROP 2>/dev/null
fi
lock -u $SCRIPT_LOCK
