#!/bin/ash
interface=$1
output=$2
model=$(head -n 1 /etc/version)
switch_model=$(/sbin/mtd fw_printenv 1|grep switch_model|awk -F = '{print $2}')
model_v3900() {
	echo STATUS >  /tmp/ss
	echo $interface >>  /tmp/ss
	
	if [ "$output" = "json" ]; then
		echo true >>  /tmp/ss
		cat /tmp/ss > /proc/rtk8366
		status=$(cat /proc/rtk8366) 
	else
		echo false >>  /tmp/ss
		cat /tmp/ss > /proc/rtk8366
		cat /proc/rtk8366
	fi
	
	if [ "$output" = "json" ]; then
	SFP_DEC=$(echo $(mmiotool -r 0x28000000)| awk -F ": " '{print $2}'|cut -c 1-3) ##fiber SFP detection
	  if [ "$interface" = "lan" ]; then
	   dec=$((($SFP_DEC&0x4)>>2))	  	   
      else
       dec=$((($SFP_DEC&0x8)>>3))	   
      fi 	   
		for g_status in $status;do
			rt=$(echo $g_status  | awk -F. ' { print $1 " " $2 " " $3 " " $4}')
			set -- $rt
			port=$1
			 [ "$interface" = "lan" -a "$port" = "LAN1" ] && {
			  port="LAN_Port_1"
			 } 
			 [ "$interface" = "lan" -a "$port" = "LAN2" ] && {
			  port="LAN_Port_2"
			 } 
			 [ "$interface" = "lan" -a "$port" = "LAN3" ] && {
			  port="LAN_SFP"
			 } 
            if [ "$interface" = "lan" -a "$port" = "LAN_SFP" -a "$dec" -eq "1" ]; then
             link="Down(SFP module disconnected)"
            elif [ "$interface" = "wan" -a "$port" = "WAN5" -a "$dec" -eq "1" ]; then 			
			 link="Down(SFP module disconnected)"
			else
             link=$2
			 if [ "$port" = "WAN5" -a "$link" = "Down" ]; then
			  link="Down(SFP module connected)"
			 elif [ "$port" = "LAN_SFP" -a "$link" = "Down" ]; then
			  link="Down(SFP module connected)"
			 else
			  link=$2
			 fi 
            fi
			speed=$3
			duplex=$4
			
			if [ "$link" = "Up" ];then			
			    json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="$speed" duplex="$duplex"
			else
           		json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="" duplex=""
            fi				
		done
	fi
}

model_v2960() {
    /sbin/switch_queue_sender STATUS ALL
	if [ "$interface" = "lan" ] ; then
		for n in 1 2 3 4; do
			json show  switch_lan.lan$n  -f /var/status_system_interface | sed 's/switch_lan.//g' | sed 's/lan/LAN/g' | tr '.' ' ' | tr '=' ':'  
			echo ""	   
		done	 	 
	fi  
	if [ "$interface" = "wan" ] ; then
		for n in 1 2; do
			json show  switch_wan.wan$n  -f /var/status_system_interface | sed 's/switch_wan.//g' | sed 's/wan/WAN/g' | tr '.' ' ' | tr '=' ':'  
			echo ""	   
		done	 
	fi  
}
model_v300B() {
    /sbin/switch_queue_sender STATUS ALL
	if [ "$interface" = "lan" ] ; then
		for n in 1 2; do
			json show  switch_lan.lan$n  -f /var/status_system_interface | sed 's/switch_lan.//g' | sed 's/lan/LAN/g' | tr '.' ' ' | tr '=' ':'  
			echo ""	
		done	   
	fi  
	if [ "$interface" = "wan" ] ; then
		for n in 1 2 3 4; do
          json show  switch_wan.wan$n  -f /var/status_system_interface | sed 's/switch_wan.//g' | sed 's/wan/WAN/g' | tr '.' ' ' | tr '=' ':'  
	      echo ""	   
		done	 
	fi  
}
model_atheros_v3900() { 
    /sbin/switch_queue_sender STATUS ALL
	if [ "$interface" = "lan" ] ; then
		for n in 1 2 3; do
			json show  switch_lan.lan$n  -f /var/status_system_interface | sed 's/switch_lan.//g' | sed 's/lan/LAN/g' | tr '.' ' ' | tr '=' ':'  
			echo ""	   
		done	 
	fi  
	if [ "$interface" = "wan" ] ; then
      	
		for n in 1 2 3 4 5; do
			json show  switch_wan.wan$n  -f /var/status_system_interface | sed 's/switch_wan.//g' | sed 's/wan/WAN/g' | tr '.' ' ' | tr '=' ':'  
			echo ""	   
		done
	fi  
	
}

if [ "$interface" == "" ]; then
	echo wan or lan
	exit 1
fi



if [ "$model" = "Vigor2960" -o "$model" = "Vigor2960F" ];then
    model_v2960
elif [ "$model" = "Vigor300B" ];then
    model_v300B	
elif [ "$model" = "Vigor3900" -a "$switch_model" -eq "1" ];then
     model_atheros_v3900
else
    model_v3900
fi	
