#!/bin/sh

myPath="/tmp/mail_alert/outbox"
LOCKFILE="/tmp/mail_alert_timer.lock"

if [ ! -x "$myPath" ]; then
	mkdir $myPath -p
	#echo "create folder"
fi 

mkdir $LOCKFILE 2>/dev/null || {
	echo "mail_alert_timer already running ... " > /dev/console
	exit 0
}

get_file_to_send(){
	for file in ` ls $1 `
	do
		if [ -d $1"/"$file ]; then
			get_file_to_send $1"/"$file
		else
			local path=$1"/"$file
			local name=$file
			echo "file=$file"
			fulldir="$myPath/$file"
			readfile=`cat $fulldir`
			echo "readfile=$readfile"
			p1=$(echo $readfile | awk 'FS="[##<<##>>##]+" {printf $1}')
			p2=$(echo $readfile | awk 'FS="[##<<##>>##]+" {printf $2}')
			p3=$(echo $readfile | awk 'FS="[##<<##>>##]+" {printf $3}')
			
			now=$(date +%s)
			file_time=$(date -r $fulldir +%s)
			secs=$(expr "$now" - "$file_time" )
			
			day_limit=$(uci get config_mail.main.daylimit)
			secs_limit=$((${day_limit:-7} * 86400))

			if [ "$secs" -gt "$secs_limit" ]; then
				if [ "$p3" == "99" ];then
					rm -f /tmp/mail_alert/$p2
					rm -f /tmp/mail_alert/$p2.tar.gz
				fi
				rm -f $fulldir
				logger "Remove mail alert file:$file"
			else
				sh /sbin/mail_alert_updater.sh "$p1" "$p2" "$p3" "$fulldir" >/dev/console
			fi
		fi
	done
}

get_file_to_send $myPath
rmdir $LOCKFILE 2>/dev/null