#!/bin/sh
. /sbin/sms_functions.sh

retrieve_prog="wget -O - ";

ip_regex="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"

NEWLINE_IFS='
'
profile_id=$1
#echo "profile_id="$profile_id

SMS_PROFILE=$(uci -q get config_sms_alert.$profile_id.sms_profile)

service_id=$SMS_PROFILE

if [ -z "$service_id" ]; then
	#echo "ERRROR: You must specify a service id (the section name in the /etc/config/ddns file) to initialize dynamic DNS."
	exit 1
fi

time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')

service_name=$(uci -q get config_sms.$SMS_PROFILE.service_name)

case "$service_name" in
	"kotsms" )
		update_url="http://202.39.48.216/kotsmsapi-1.php?username=[USERNAME]&password=[PASSWORD]&dstaddr=[DEST]&smbody=[MSG]"
		echo "update_url=$update_url"
		;;
	"smscity" )
		update_url="http://api.smscity.com/gateway/sms.php?username=[USERNAME]&password=[PASSWORD]&destination=[DEST]&body=[MSG]&sender=smscity&reference=268431687"
		;;
	"textmarketer" )
		update_url="http://www.textmarketer.biz/gateway/?username=[USERNAME]&password=[PASSWORD]&number=[DEST]&message=[MSG]&orig=Draytek&option="
		;;
	"twsms" )
		update_url="http://api.twsms.com/send_sms.php?username=[USERNAME]&password=[PASSWORD]&mobile=[DEST]&message=[MSG]&type=now&encoding=unicode"
		;;
	"messagebird" )
		update_url="http://api.messagebird.com/api/sms?username=[USERNAME]&password=[PASSWORD]&destination=[DEST]&body=[MSG]&sender=Messagebird&responsetype=XML&reference=123456789"
		;;
	"bulksms" )
		update_url="http://www.bulksms.com/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"bulksms_uk" )
		update_url="http://www.bulksms.co.uk/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"bulksms_za" )
		update_url="http://bulksms.2way.co.za:5567/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"bulksms_es" )
		update_url="http://bulksms.com.es:5567/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"bulksms_us" )
		update_url="http://usa.bulksms.com:5567/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"bulksms_de" )
		update_url="http://bulksms.de:5567/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"lusosms" )
		update_url="http://www.lusosms.com/enviar_sms_get.php?username=[USERNAME]&password=[PASSWORD]&origem=[DEST]&destino=[DEST]&mensagem=[MSG]"
		;;		
	"hinetsms" )
		USERNAME=$(uci -q get config_sms.$SMS_PROFILE.username)
		PASSWORD=$(uci -q get config_sms.$SMS_PROFILE.password)
		DEST=$(uci -q get config_sms_alert.$profile_id.recip)
		MSG=$2
		execute="/bin/hinet_sms '202.39.54.130' '$USERNAME' '$PASSWORD' '$DEST' '$MSG'"
		$execute
		if [ "$?" -eq "0" ]; then
			logger -p 160.5 "send sms alert success."
		else
			echo "$time|$service_id|$execute" > $SMS_ALERT_LOG
			logger -p 160.5 "send sms alert failed."
		fi
		;;
	* )
		#default
		return 0
		;;
esac

#kill old process if it exists & set new pid file
if [ -d /var/run/sms ]
then
	#if process is already running, stop it
	if [ -e "/var/run/sms/$service_id.pid" ]
	then
		old_pid=$(cat /var/run/sms/$service_id.pid)
		test_match=$(ps | grep "^[\t ]*$old_pid")
		verbose_echo "old process id (if it exists) = \"$test_match\""
		if [ -n  "$test_match" ]
		then
			kill $old_pid
		fi
	fi

else
	#make dir since it doesn't exist
	mkdir /var/run/sms
fi
echo $$ > /var/run/sms/$service_id.pid

#determine when the last update was
interval=$(uci -q get config_sms.$SMS_PROFILE.interval)
echo "interval="$interval
current_time=$(monotonic_time)
echo "current_time="$current_time

last_update=$(( $current_time - $interval ))
echo "last_update1="$last_update
if [ -e "/var/run/sms/$service_id.update" ]
then
	last_update=$(cat /var/run/sms/$service_id.update)
fi
echo "last_update2="$last_update
time_since_update=$(( $current_time - ($last_update) ))
echo "time_since_update="$time_since_update

if [ $time_since_update -lt $interval ]
then
	#echo "less then interval"
	return 0;
fi

#quota
quota=$(uci -q get config_sms.$SMS_PROFILE.quota)
#echo "quota="$quota
if [ $quota -le 0 ]
then
	return 0
fi

USERNAME=$(uci -q get config_sms.$SMS_PROFILE.username)
final_url=$(echo $update_url | sed s/"\[USERNAME\]"/"$USERNAME"/g)

PASSWORD=$(uci -q get config_sms.$SMS_PROFILE.password)
final_url=$(echo $final_url | sed s/"\[PASSWORD\]"/"$PASSWORD"/g)

DEST=$(uci -q get config_sms_alert.$profile_id.recip)

final_url=$(echo $final_url | sed s/"\[DEST\]"/"$DEST"/g)

MSG=$2
final_url=$(echo $final_url | sed s/"\[MSG\]"/"$MSG"/g)

#$retrieve_prog "$final_url"

count=0
MAXTRY=3

while [ "$count" -le "$MAXTRY" ]
do
	#here we actually connect, and perform the update
	update_output=$( $retrieve_prog "$final_url" )

	echo $update_output > /tmp/sms_tmp
	#cat /tmp/sms_tmp
	if [ "$update_output" ]; then
		res=$( grep -c "\<200 Successful\>" /tmp/sms_tmp )
		if [ $res -gt 0 ]; then
			ddnslog -P "`date +%X-%x` Update Successful... ##"
		fi

		res=$( grep -c "\<Failed Update\>" /tmp/sms_tmp )
		if [ $res -gt 0 ]; then
			ddnslog -P "`date +%X-%x` Update Successful... ##"
		fi
		
		echo "rm outbox $3"
		rm -f $3

		#echo "output"
		quota=`expr $quota - 1`
		echo "quota="$quota
		uci -q set config_sms.$SMS_PROFILE.quota="$quota"
		uci commit config_sms

		echo "wget success..."
		break
	fi

	# wget fail....
	count=$(($count+1))
	sleep 10
	echo "wget fail...retry: $count"
done

echo "Update Output:"
echo "$update_output"
echo ""

echo "$current_time" > "/var/run/sms/$service_id.update"
return 0