#!/bin/sh

# Command:
# /usr/sbin/iprule_idx.sh [key]

# Usage:
# This script defines the ip rule index

# Parameters:
# [key]	: policy | pptp_to | lb | iface | ipsec_lb | ipsec | pptp | default

KEY=$1
[ "$KEY" ] || KEY="invalid"

#0:		local
#32766:	main
#32767:	default

case $KEY in
	"policy1")
		echo 32000
		;;
	"policy2")
		echo 35000
		;;
	"pptp_to")
		echo 37000
		#if change, check src_dir/draytek/pptp_l2l_din_booting_program.c
		;;
	"pptp")
		echo 39000
		;;
	"ipsec_lb")
		echo 44000
		#if change, check src_dir/openswan/programs/pluto/connections.h
		;;
	"ipsec")
		echo 46000
		;;
	"policy3")
		echo 49000
		;;
	"policy")
		echo 49000
		;;
	"lb")
		echo 50000
		;;
	"iface")
		echo 52000
		;;
	"policy4")
		echo 55000
		;;
	"default")
		echo 60000
		;;
	"ubfv6")
		echo 99998
		;;
	*)
		echo 99999
		;;
esac
return