#!/bin/sh
ip_url="http://www.trackip.net/ip http://checkip.dyndns.com/"
ip_regex="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"
ips=""

get_current_ip()
{
	current_ip='';
	
	for addr in $ip_url
	do
		if [ -z "$current_ip" ]
		then
			url_host=$(echo $addr | awk -F '/' '{print $3}') 
			url_ips=$(echo -e $( echo $(nslookup "$url_host" 2>/dev/null) | grep -o "Name:.*" | sed 's/ /\\n/g') | grep -o "$ip_regex")
			gw_ip=$(json get network.$1.gateway | grep -o "$ip_regex")

			for ip_url_ip in $url_ips
			do
				[ "$ip_url_ip" ] && flush_subnet=${ip_url_ip}/32 || flush_subnet=
				/usr/sbin/flush_route_cache.sh "get_internet_ip.sh#1" all $flush_subnet
				#ip route flush cache
				route add "$ip_url_ip" gw "$gw_ip" dev wan-"$1" 2>/dev/null
				/usr/sbin/flush_route_cache.sh "get_internet_ip.sh#2" all $flush_subnet
				#ip route flush cache
			done
			
			current_ip=$(echo $( wget -O - $addr 2>/dev/null) | grep -o "$ip_regex")
			for ip_url_ip in $url_ips
			do
				route del "$ip_url_ip" gw "$gw_ip" dev wan-"$1" 2>/dev/null
			done

			#/usr/sbin/flush_route_cache.sh "get_internet_ip.sh#3"
			#ip route flush cache
		fi

	done
	
	echo "$current_ip"
}

get_current_ip $1

