#!/bin/sh
append DRIVERS "rt2860"
#DEBUG=echo

scan_rt2860() {
	local device="$1"
}


disable_rt2860() (
	local device="$1"

	ifconfig "$device" down

	return 0
)

enable_rt2860() {
#for device in ra0 iface1 iface2 iface3; do
for i in 0 1 2 3; do
case $i in
0) 
dev=ra$i
device=ra$i
;;
*)
dev=iface$i
device=ra$i
;;
esac
#	config_get disabled "${device}" disabled
	config_get disabled "${dev}" disabled
	if [ "$disabled" = "0" ]; then

		disable_rt2860 "$device"
	
#		config_get ipaddr "$device" ipaddr
		config_get ipaddr "$dev" ipaddr
		if [ -n "$ipaddr" ]; then
			$DEBUG ifconfig "$device" $ipaddr
		fi
	
#		config_get netmask "$device" netmask
		config_get netmask "$dev" netmask
		if [ -n "$netmask" ]; then
			$DEBUG ifconfig "$device" netmask $netmask
		fi
	
		ifconfig "$device" up
	
		config_get fr_threshold "advance" fr_threshold
		$DEBUG iwpriv "$device" set FragThreshold="$fr_threshold"
		
		config_get rts_threshold "advance" rts_threshold
		$DEBUG iwpriv "$device" set RTSThreshold="$rts_threshold"
	
#		config_get wmm "$device" wmm
		config_get wmm "$dev" wmm
		$DEBUG iwpriv "$device" set WmmCapable="$wmm"
	
#		config_get ssid "$device" ssid
		config_get ssid "$dev" ssid
		$DEBUG iwpriv "$device" set SSID="$ssid"
	
#		config_get channel "$device" channel
		config_get channel "$dev" channel
		$DEBUG iwpriv "$device" set Channel="$channel"
	
#		config_get_bool hidden "$device" hidden 0
		config_get_bool hidden "$dev" hidden 0
		$DEBUG iwpriv "$device" set HideSSID="$hidden"
	
#		config_get rate "$device" rate
		config_get rate "$dev" rate
		$DEBUG iwpriv "$device" set BasicRate="$rate"
	
#		config_get mode "$device" mode
		config_get mode "$dev" mode
		case "$mode" in
		11bg)
			$DEBUG iwpriv "$device" set WirelessMode=0
			;;
	
		11b)
			$DEBUG iwpriv "$device" set WirelessMode=1
			;;
	
		11a)
			$DEBUG iwpriv "$device" set WirelessMode=2
			;;
	
		11g)
			$DEBUG iwpriv "$device" set WirelessMode=4
			;;
	
		11n)
			$DEBUG iwpriv "$device" set WirelessMode=6
			;;
	
		11gn)
			$DEBUG iwpriv "$device" set WirelessMode=7
			;;
	
		11an)
			$DEBUG iwpriv "$device" set WirelessMode=8
			;;
	
		*|11bgn)
			$DEBUG iwpriv "$device" set WirelessMode=9
			;;
		esac
	
		case "$mode" in
		*n)
#			config_get channel_width "$device" channel_width
			config_get channel_width "$dev" channel_width
			case "$channel_width" in
			20)
				$DEBUG iwpriv "$device" set HtBw=0
				;;

			*|40)
				$DEBUG iwpriv "$device" set HtBw=1
				;;
			esac
	
#			config_get channel_ext "$device" channel_ext
			config_get channel_ext "$dev" channel_ext
			case "$channel_ext" in
			0)
				$DEBUG iwpriv "$device" set HtExtcha=0
				;;
	
			*|1)
				$DEBUG iwpriv "$device" set HtExtcha=1
				;;
			esac
	
			;;
	
		*)
			;;
		esac
	
#		config_get enc "$device" encryption
		config_get auth "$dev" auth
		config_get enc "$dev" encryption
		case "$auth" in
		open|shared)
			case "$enc" in
			WEP|wep)
				case "$auth" in
				open)
					$DEBUG iwpriv "$device" set AuthMode=OPEN 
					;;
				shared)
					$DEBUG iwpriv "$device" set AuthMode=SHARED 
					;;
				esac
				$DEBUG iwpriv "$device" set EncrypType=WEP
				$DEBUG iwpriv "$device" set IEEE8021X=0
				for idx in 1 2 3 4; do
					config_get key "$dev" "key${idx}"
					$DEBUG iwpriv "$device" set Key${idx}="$key"
				done
				config_get key "$dev" key
				key="${key:-1}"
				case "$key" in
				[1234])
					$DEBUG iwpriv "$device" set DefaultKeyID="$key"
					;;
				*)
					$DEBUG iwpriv "$device" set Key1="$key"
					$DEBUG iwpriv "$device" set DefaultKeyID=1
					;;
				esac
				$DEBUG iwpriv "$device" set SSID="$ssid"
				;;
			*|none|NONE)
				$DEBUG iwpriv "$device" set AuthMode=OPEN
				$DEBUG iwpriv "$device" set EncrypType=NONE
				$DEBUG iwpriv "$device" set IEEE8021X=0
				$DEBUG iwpriv "$device" set SSID="$ssid"
				;;
			esac ;;
		wpa|WPA|wpapsk|WPAPSK)
			$DEBUG iwpriv "$device" set AuthMode=WPAPSK
			case "$enc" in
			tkip|TKIP) 
				$DEBUG iwpriv "$device" set EncrypType=TKIP 
				;;
			aes|AES) 
				$DEBUG iwpriv "$device" set EncrypType=AES
				;;
			esac
			$DEBUG iwpriv "$device" set IEEE8021X=0
			$DEBUG iwpriv "$device" set SSID="$ssid"
			config_get key "$dev" "key"
			$DEBUG iwpriv "$device" set WPAPSK="$key"
			$DEBUG iwpriv "$device" set SSID="$ssid"
			;;
		wpa2|WPA2|wpa2psk|WPA2PSK)
			$DEBUG iwpriv "$device" set AuthMode=WPA2PSK
			case "$enc" in
			tkip|TKIP) 
				$DEBUG iwpriv "$device" set EncrypType=TKIP 
				;;
			aes|AES) 
				$DEBUG iwpriv "$device" set EncrypType=AES 
				;;
			esac
			$DEBUG iwpriv "$device" set IEEE8021X=0
			$DEBUG iwpriv "$device" set SSID="$ssid"
			config_get key "$dev" "key"
			$DEBUG iwpriv "$device" set WPAPSK="$key"
			$DEBUG iwpriv "$device" set SSID="$ssid"
			;;
		esac
#		case "$enc" in
#		WEP|wep)
#			iwpriv "$device" set AuthMode=OPEN
#			iwpriv "$device" set EncrypType=WEP
#			iwpriv "$device" set IEEE8021X=0
#	
#			for idx in 1 2 3 4; do
##				config_get key "$device" "key${idx}"
#				config_get key "$dev" "key${idx}"
#				iwpriv "$device" set Key${idx}="$key"
#			done
#	
##			config_get key "$device" key
#			config_get key "$dev" key
#			key="${key:-1}"
#			case "$key" in
#			[1234])
#				iwpriv "$device" set DefaultKeyID="$key"
#				;;
#			*)
#				iwpriv "$device" set Key1="$key"
#				iwpriv "$device" set DefaultKeyID=1
#				;;
#			esac
#	
#			iwpriv "$device" set SSID="$ssid"
#	
#			;;
#	
#		PSK|psk|WPA|wpa)
#			iwpriv "$device" set AuthMode=WPAPSK
#			iwpriv "$device" set EncrypType=TKIPAES
#			iwpriv "$device" set IEEE8021X=0
#	
#			iwpriv "$device" set SSID="$ssid"
#	
##			config_get key "$device" "key"
#			config_get key "$dev" "key"
#			iwpriv "$device" set WPAPSK="$key"
#	
#			iwpriv "$device" set SSID="$ssid"
#	
#			;;
#	
#		PSK2|psk2|WPA2|wpa2)
#			iwpriv "$device" set AuthMode=WPA2PSK
#			iwpriv "$device" set EncrypType=TKIPAES
#			iwpriv "$device" set IEEE8021X=0
#	
#			iwpriv "$device" set SSID="$ssid"
#	
##			config_get key "$device" "key"
#			config_get key "$dev" "key"
#			iwpriv "$device" set WPAPSK="$key"
#	
#			iwpriv "$device" set SSID="$ssid"
#	
#			;;
#	
#		*|open|OPEN)
#			iwpriv "$device" set AuthMode=OPEN
#			iwpriv "$device" set EncrypType=NONE
#			iwpriv "$device" set IEEE8021X=0
#			iwpriv "$device" set SSID="$ssid"
#	
#			;;
#		esac
	fi
done
}


detect_rt2860() {
	[ "$(cat /proc/bus/pci/devices | grep -e 18140601 -e 18140681 -e 18140701 -e 18140781 )" = "" ] && return

	cd /sys/class/net

	for dev in $(ls -d ra* 2>&-); do
		uci set wireless.${dev}.type=rt2860
		uci commit wireless
	done

	found=`uci get wireless.general.found`
	if [ "$found" = "0" ] ; then
		cd /sys/class/net
		ls -d ra* 2>&-
		if [ "$?" = "0" ] ; then
			echo "Ralink card found"
			uci set wireless.general.found=1
			uci set wireless.general.type=ra0
			uci set wireless.general.card=1
			uci commit wireless
		else
			uci set wireless.general.card=0
			uci commit wireless
		fi
	fi
}
