#!/bin/sh
ifname=$1
vip=$2
ha_profile=$3
GLOBAL_LOCK="/tmp/ucarp/ha-down_AS_lock"

#spin-lock to wait ha-up_AS.sh completed
enter_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
while true; do
	if [ -f /tmp/ucarp/ha_up_lock_AS_${ha_profile} ] ;then
		logger -p 152.5 "[High Availability] ha-down_AS($ha_profile)($$): Found ha_up_lock_AS_$ha_profile, wait..."
		BREAK_LOCK_INTV=30
		nowtime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		DIFF=$(($nowtime - $enter_time))
		if [ $DIFF -le $BREAK_LOCK_INTV ] ;then
			sleep 5
			continue
		else
			logger -p 152.5 "[High Availability] ha-down_AS($ha_profile)($$): over $BREAK_LOCK_INTV secs, Break ha_up_lock_AS"
			rm -f /tmp/ucarp/ha_up_lock_AS_${ha_profile} 2>/dev/null
		fi
	else
		break
	fi
done

#create my lock
[ -f /tmp/ucarp/ha_down_lock_AS_$ha_profile ] && return
touch /tmp/ucarp/ha_down_lock_AS_$ha_profile
#logger -p 152.5 "[High Availability] ha-down_AS($ha_profile)($$): create my script lock"

iface=`uci get ucarp_as.$ha_profile.lan`
#Remove VIP on this HA LAN
mask=`uci get network.$iface.static_netmask`
/usr/sbin/ip addr del $vip/$mask dev $ifname 2> /dev/null >/dev/null
#remove VIP from Ipset:ip_lanX for user management dst bypassing
ipset -D ip_$iface $vip

##### update state to backup
json set ucarp.${ha_profile} state=backup
uci set ucarp_as.${ha_profile}.ha_profile_status=Backup

##### Do not stop wan_port_polling_AS, because maybe other master state are using it

##### stop master-polling_AS
master_poll_PID=`cat /var/run/ucarp/${ha_profile}_ASmaster.pid`
kill $master_poll_PID 2>/dev/null
rm -f /tmp/HA_rebind_$master_poll_PID
rm -f /var/run/ucarp/${ha_profile}_ASmaster.pid
logger -p 152.5 "[High Availability] ha-down_AS($ha_profile)($$): stop master-polling_AS process"

##### G38957: Disable the HA LAN's DHCP Service
json set ucarp.$iface dhcp_state=down
logger -p 152.5 "[High Availability] ha-down_AS($ha_profile)($$): disable $iface dhcp service"
/etc/init.d/dhcpd apply

##### G49223: stop LAN pppoe server
/etc/init.d/pppoe_server stop
##### Send signal of "DevChange" to ubf_polling_d
web_portal_status=`uci get general_conf.base.status`
[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1

#Send garp of the HA LAN's primary IP
macaddr=`uci get network.$iface.macaddr`
static_ipaddr=`uci get network.$iface.static_ipaddr`
arping -b -c 1 -i lan-$iface -S $macaddr $static_ipaddr > /dev/null

#release script lock
rm -f /tmp/ucarp/ha_down_lock_AS_$ha_profile
#logger -p 152.5 "[High Availability] ha-down_AS($ha_profile)($$): script done, remove my script lock"
