#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "firewall"

! empty "$FORM_clear" && {
FORM_type=""
FORM_service=""
FORM_wan=""
FORM_wanip=""
FORM_local=""
FORM_localip=""
FORM_time=""
FORM_target=""
}

! empty "$FORM_new_rule" && {
        SAVED=1
	case $FORM_wan in
	0) wan_req="required";;
	1) FORM_wanip="0.0.0.0";;
	esac
	case $FORM_local in
	0) local_req="required";;
	1) FORM_localip="0.0.0.0";;
	esac
validate <<EOF
ip|FORM_wanip|@TR<<WAN IP>>|$wan_req|$FORM_wanip
ip|FORM_localip|@TR<<Local IP>>|$local_req|$FORM_localip
EOF
        equal "$?" 0 && {
        NextRulePos=`uci get firewall.general.NextRulePos`
        ruleid=`uci get firewall.general.rules_count`
        ruleid=`expr $ruleid + 1`
	uci_add firewall firewall rule$ruleid
	uci_set firewall rule$ruleid StatusEnable "1"
	uci_set firewall rule$ruleid CurPos "$NextRulePos"
	uci_set firewall rule$ruleid type "$FORM_type"
	uci_set firewall rule$ruleid service "$FORM_service"
	uci_set firewall rule$ruleid wan "$FORM_wan"
	uci_set firewall rule$ruleid wan_ip "$FORM_wanip"
	uci_set firewall rule$ruleid local "$FORM_local"
	uci_set firewall rule$ruleid local_ip "$FORM_localip"
	uci_set firewall rule$ruleid time "$FORM_time"
	uci_set firewall rule$ruleid target "$FORM_target"
	uci_set firewall general rules_count "$ruleid"

        ruleid=`uci get firewall_new.general_new.rules_count`
        ruleid=`expr $ruleid + 1`
	uci_add firewall_new firewall rule_new$ruleid
	uci_set firewall_new rule_new$ruleid new_rule "1"
	uci_set firewall_new rule_new$ruleid CurPos "$NextRulePos"
	uci_set firewall_new rule_new$ruleid type "$FORM_type"
	uci_set firewall_new rule_new$ruleid service "$FORM_service"
	uci_set firewall_new rule_new$ruleid wan "$FORM_wan"
	uci_set firewall_new rule_new$ruleid wan_ip "$FORM_wanip"
	uci_set firewall_new rule_new$ruleid local "$FORM_local"
	uci_set firewall_new rule_new$ruleid local_ip "$FORM_localip"
	uci_set firewall_new rule_new$ruleid time "$FORM_time"
	uci_set firewall_new rule_new$ruleid target "$FORM_target"
	uci_set firewall_new general_new rules_count "$ruleid"

        NextRulePos=`expr $NextRulePos + 1`
	uci_set firewall general NextRulePos "$NextRulePos"
	}
}

! empty "$FORM_display_rule" && {
	ruleid=$FORM_display_rule
	FORM_status_enable=${type:-$(uci get firewall.rule$ruleid.StatusEnable)}
	FORM_type=${type:-$(uci get firewall.rule$ruleid.type)}
	FORM_service=${service:-$(uci get firewall.rule$ruleid.service)}
	FORM_wan=${wan:-$(uci get firewall.rule$ruleid.wan)}
	FORM_wanip=${wanip:-$(uci get firewall.rule$ruleid.wan_ip)}
	FORM_local=${local:-$(uci get firewall.rule$ruleid.local)}
	FORM_localip=${localip:-$(uci get firewall.rule$ruleid.local_ip)}
	FORM_time=${time:-$(uci get firewall.rule$ruleid.time)}
	FORM_target=${target:-$(uci get firewall.rule$ruleid.target)}
}

! empty "$FORM_apply_fw_policy" && {
    
   count=`uci get firewall.general.rules_count`
   i=1
   while [ $i -le "$count" ]
   do
     eval checkboxvar="\$FORM_pol_status_$i"
     if [ -n "$checkboxvar" ] ; then
      oldstatus=`uci get firewall."rule$i".StatusEnable` 
      if [ "$oldstatus" = "0" ] ; then
        uci_set firewall "rule$i" StatusEnable "1"

        type=`uci get firewall.rule$i.type`
        service=`uci get firewall.rule$i.service`
        wan=`uci get firewall.rule$i.wan`
        wanip=`uci get firewall.rule$i.wan_ip`
        local=`uci get firewall.rule$i.local`
        localip=`uci get firewall.rule$i.local_ip`
        time=`uci get firewall.rule$i.time`
        target=`uci get firewall.rule$i.target`
        CurPos=`uci get firewall.rule$i.CurPos`

        ruleid=`uci get firewall_new.general_new.rules_count`
        ruleid=`expr $ruleid + 1`
	uci_add firewall_new firewall rule_new$ruleid
	uci_set firewall_new rule_new$ruleid insert_rule "1"
	uci_set firewall_new rule_new$ruleid type "$type"
	uci_set firewall_new rule_new$ruleid service "$service"
	uci_set firewall_new rule_new$ruleid wan "$wan"
	uci_set firewall_new rule_new$ruleid wan_ip "$wanip"
	uci_set firewall_new rule_new$ruleid local "$local"
	uci_set firewall_new rule_new$ruleid local_ip "$localip"
	uci_set firewall_new rule_new$ruleid time "$time"
	uci_set firewall_new rule_new$ruleid target "$target"
	uci_set firewall_new rule_new$ruleid CurPos "$CurPos"
	uci_set firewall_new general_new rules_count "$ruleid"
########### Increment Current Position by 1 in all next rules and NextRulePos by 1 #######
        ruleid=`expr $i + 1`
        while [ $ruleid -le $count ]
        do
          CurPos=`uci get firewall.rule$ruleid.CurPos`
          uci_set firewall rule$ruleid CurPos `expr $CurPos + 1`
          ruleid=`expr $ruleid + 1`
        done
        NextRulePos=`uci get firewall.general.NextRulePos`
        NextRulePos=`expr $NextRulePos + 1`
	uci_set firewall general NextRulePos "$NextRulePos"
      fi
     else
      oldstatus=`uci get firewall."rule$i".StatusEnable` 
      if [ "$oldstatus" = "1" ] ; then
        uci_set firewall "rule$i" StatusEnable "0"
        CurPos=`uci get firewall.rule$i.CurPos`

        ruleid=`uci get firewall_new.general_new.rules_count`
        ruleid=`expr $ruleid + 1`
	uci_add firewall_new firewall rule_new$ruleid
	uci_set firewall_new rule_new$ruleid delete_rule "1"
	uci_set firewall_new rule_new$ruleid CurPos "$CurPos"
	uci_set firewall_new general_new rules_count "$ruleid"
########### Decrement Current Position by 1 in all next rules and NextRulePos by 1 #######
        ruleid=`expr $i + 1`
        while [ $ruleid -le $count ]
        do
          CurPos=`uci get firewall.rule$ruleid.CurPos`
          uci_set firewall rule$ruleid CurPos `expr $CurPos - 1`
          ruleid=`expr $ruleid + 1`
        done
        NextRulePos=`uci get firewall.general.NextRulePos`
        NextRulePos=`expr $NextRulePos - 1`
	uci_set firewall general NextRulePos "$NextRulePos"
      fi
     fi
     i=`expr $i + 1`
   done
}

! empty "$FORM_save_rule" && {
        SAVED=1
	case $FORM_wan in
	0) wan_req="required";;
	1) FORM_wanip="0.0.0.0";;
	esac
	case $FORM_local in
	0) local_req="required";;
	1) FORM_localip="0.0.0.0";;
	esac
validate <<EOF
ip|FORM_wanip|@TR<<WAN IP>>|$wan_req|$FORM_wanip
ip|FORM_localip|@TR<<Local IP>>|$local_req|$FORM_localip
EOF
	equal "$?" 0 && {
        status=`uci get firewall.rule$FORM_ruleid.StatusEnable`
	uci_set firewall rule$FORM_ruleid type "$FORM_type"
	uci_set firewall rule$FORM_ruleid service "$FORM_service"
	uci_set firewall rule$FORM_ruleid wan "$FORM_wan"
	uci_set firewall rule$FORM_ruleid wan_ip "$FORM_wanip"
	uci_set firewall rule$FORM_ruleid local "$FORM_local"
	uci_set firewall rule$FORM_ruleid local_ip "$FORM_localip"
	uci_set firewall rule$FORM_ruleid time "$FORM_time"
	uci_set firewall rule$FORM_ruleid target "$FORM_target"
        if [ "$status" = "1" ] ; then
          ruleid=`uci get firewall_new.general_new.rules_count`
          ruleid=`expr $ruleid + 1`
          CurPos=`uci get firewall.rule$FORM_ruleid.CurPos`
	  uci_add firewall_new firewall rule_new$ruleid
	  uci_set firewall_new rule_new$ruleid edit_rule "1"
#	  uci_set firewall_new rule_new$ruleid ruleid "$CurPos"
	  uci_set firewall_new rule_new$ruleid CurPos "$CurPos"
	  uci_set firewall_new rule_new$ruleid type "$FORM_type"
	  uci_set firewall_new rule_new$ruleid service "$FORM_service"
	  uci_set firewall_new rule_new$ruleid wan "$FORM_wan"
	  uci_set firewall_new rule_new$ruleid wan_ip "$FORM_wanip"
	  uci_set firewall_new rule_new$ruleid local "$FORM_local"
	  uci_set firewall_new rule_new$ruleid local_ip "$FORM_localip"
	  uci_set firewall_new rule_new$ruleid time "$FORM_time"
	  uci_set firewall_new rule_new$ruleid target "$FORM_target"
	  uci_set firewall_new general_new rules_count "$ruleid"
        fi
	}
}

! empty "$FORM_delete" && {
	rulecount=`uci get firewall.general.rules_count`
	ruleid=$FORM_delete
        status=`uci get firewall.rule$ruleid.StatusEnable`
        DelRuleCurPos=`uci get firewall.rule$ruleid.CurPos`
	uci_remove firewall rule$ruleid
	while [ $ruleid -lt $rulecount ]
	do
	uci_rename firewall rule`expr $ruleid + 1` rule$ruleid
	ruleid=`expr $ruleid + 1`
	done
        rulecount=`expr $rulecount - 1`
	uci_set firewall general rules_count "$rulecount"
        if [ "$status" = "1" ] ; then
          NextRulePos=`uci get firewall.general.NextRulePos`
          NextRulePos=`expr $NextRulePos - 1`
	  uci_set firewall general NextRulePos "$NextRulePos"

	  ruleid=$FORM_delete
          while [ $ruleid -le $rulecount ]
          do
            CurPos=`uci get firewall.rule$ruleid.CurPos`
            uci_set firewall rule$ruleid CurPos `expr $CurPos - 1`
            ruleid=`expr $ruleid + 1`
          done
          ruleid=`uci get firewall_new.general_new.rules_count`
          ruleid=`expr $ruleid + 1`
	  uci_add firewall_new firewall rule_new$ruleid
	  uci_set firewall_new rule_new$ruleid delete_rule "1"
	  uci_set firewall_new rule_new$ruleid CurPos "$DelRuleCurPos"
	  uci_set firewall_new general_new rules_count "$ruleid"
        fi
}

#####################################################################
header "Firewall" "Firewall-Rules" "@TR<<Firewall Rules>>" 'onLoad=modechange(this);'
#####################################################################
cat <<EOF
<script type="text/javascript" src="/webif.js "></script>
<script type="text/javascript">
<!--
function modechange()
{
	var v;

	v = isset('wan', '0');
	set_visible('wanip', v);
	v = isset('local', '0');
	set_visible('localip', v);

	hide('save');
	show('save');
}
-->
</script>
EOF

wan=`uci get bridge.general.wan`
equal $wan 1 && {
display_form << EOF
string|<h3>WAN is part of bridge.</h3>
EOF
}

! equal $wan 1 && {

servicecount=`uci get firewall.general.service_count`
i=1
while [ $i -le $servicecount ]
do
name=`uci get firewall.service$i.name`
services="$services
option|service$i|$name"
i=`expr $i + 1`
done

#schedulecount=`uci get firewall.general.schedule_count`
#i=1
#while [ $i -le $schedulecount ]
#do
#name=`uci get firewall.schedule$i.name`
#times="$times
#option|schedule$i|$name"
#i=`expr $i + 1`
#done

count=`uci get firewall.general.rules_count`
echo "<th colspan=\"11\"><h3>" Inbound Rules: "</h3></th>"
echo "<form name=\"apply_fw_policy\" action=\"/cgi-bin/webif/firewall-rules.sh\" enctype=\"multipart/form-data\" method=\"post\">"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Service</th><th>WAN IP</th><th>Local IP</th><th>Target</th><th>Schedule</th><th style=\"text-align: center;\">Status</th><th style=\"text-align: center;\">Actions</th></tr>"
if [ $count = 0 ]; then
  echo "<tr class=\"tr_bg\"><td colspan=\"7\">There are no inbound rules</td></tr>"
fi
i=1
while [ $i -le $count ]
do
type=`uci get firewall.rule$i.type`
if [ "$type" = "in" ]; then
  service=`uci get firewall.rule$i.service`
  case $service in
    any) servicename=any;;
    *) servicename=`uci get firewall.$service.name`;;
  esac
  wanip=`uci get firewall.rule$i.wan_ip`
  localip=`uci get firewall.rule$i.local_ip`
  target=`uci get firewall.rule$i.target`
  time=`uci get firewall.rule$i.time`
  PolStatus=`uci get firewall.rule$i.StatusEnable`
  if [ "$PolStatus" = "1" ] ; then
    status="yes"
  else
    status=""
  fi
  echo "<tr class=\"tr_bg\"><td>$servicename</td><td>$wanip</td><td>$localip</td><td>$target</td><td>$time</td><td style=\"text-align: center;\"><input id="pol_status_yes_$i" type="checkbox" name="pol_status_$i" value="$status" checked=""  /></td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_rule=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
fi
i=`expr $i + 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div><br>"

echo "<th colspan=\"11\"><h3>" Outbound Rules: "</h3></th>"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Service</th><th>WAN IP</th><th>Local IP</th><th>Target</th><th>Schedule</th><th style=\"text-align: center;\">Status</th><th style=\"text-align: center;\">Actions</th></tr>"
if [ $count = 0 ]; then
  echo "<tr class=\"tr_bg\"><td colspan=\"7\">There are no outbound rules</td></tr>"
fi
i=1
while [ $i -le $count ]
do
type=`uci get firewall.rule$i.type`
if [ "$type" = "out" ]; then
  service=`uci get firewall.rule$i.service`
  case $service in
    any) servicename=any;;
    *) servicename=`uci get firewall.$service.name`;;
  esac
  wanip=`uci get firewall.rule$i.wan_ip`
  localip=`uci get firewall.rule$i.local_ip`
  target=`uci get firewall.rule$i.target`
  time=`uci get firewall.rule$i.time`
  PolStatus=`uci get firewall.rule$i.StatusEnable`
  if [ "$PolStatus" = "1" ] ; then
    status="yes"
  else
    status=""
  fi
  echo "<tr class=\"tr_bg\"><td>$servicename</td><td>$wanip</td><td>$localip</td><td>$target</td><td>$time</td><td style=\"text-align: center;\"><input id="pol_status_yes_$i" type="checkbox" name="pol_status_$i" value="$status" checked=""  /><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_rule=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
fi
i=`expr $i + 1`
done
echo "<tr id=\"spacer1\"><td colspan=\"2\"><br><input name=\"apply_fw_policy\" value=\"Save\" type=\"submit\"></td></tr>"
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div></form><br>"

empty "$FORM_display_rule" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<New Rule>>
formtag_begin|new_rule|$SCRIPT_NAME
field|@TR<<Type>>
select|type|$FORM_type
option|in|@TR<<Inbound>>
option|out|@TR<<Outbound>>
field|@TR<<Service>>
select|service|$FORM_service
option|any|@TR<<Any>>
$services
field|@TR<<WAN IP>>
select|wan|$FORM_wan
option|1|@TR<<Any>>
option|0|@TR<<Specify>>
field|@TR<<IP Address>>|wanip|hidden
text|wanip|$FORM_wanip
field|@TR<<Local IP>>
select|local|$FORM_local
option|1|@TR<<Any>>
option|0|@TR<<Specify>>
field|@TR<<IP Address>>|localip|hidden
text|localip|$FORM_localip
field|@TR<<Schedule>>
select|time|$FORM_time
option|always|@TR<<Always>>
$times
field|@TR<<Target>>
select|target|$FORM_target
option|ACCEPT|@TR<<Accept>>
option|DROP|@TR<<Drop>>
field||spacer1
string|<br />
submit|new_rule|@TR<<Add>>
submit|clear|@TR<<Clear>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_rule" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Rule $FORM_display_rule>>
formtag_begin|save_rule|$SCRIPT_NAME
field|@TR<<Rule ID>>
text|ruleid|$FORM_display_rule|||readonly
field|@TR<<Type>>
select|type|$FORM_type
option|in|@TR<<Inbound>>
option|out|@TR<<Outbound>>
field|@TR<<Service>>
select|service|$FORM_service
option|any|@TR<<Any>>
$services
field|@TR<<WAN IP>>
select|wan|$FORM_wan
option|1|@TR<<Any>>
option|0|@TR<<Specify>>
field|@TR<<IP Address>>|wanip|hidden
text|wanip|$FORM_wanip
field|@TR<<Local IP>>
select|local|$FORM_local
option|1|@TR<<Any>>
option|0|@TR<<Specify>>
field|@TR<<IP Address>>|localip|hidden
text|localip|$FORM_localip
field|@TR<<Schedule>>
select|time|$FORM_time
option|always|@TR<<Always>>
$times
field|@TR<<Target>>
select|target|$FORM_target
option|ACCEPT|@TR<<Accept>>
option|DROP|@TR<<Drop>>
field||spacer1
string|<br />
submit|save_rule|@TR<<Save>>
reset||@TR<<Reset>>
formtag_end
end_form
EOF
}

}

footer ?>

<!--
##WEBIF:name:Firewall:500:Firewall-Rules
-->
