#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "qos"

! empty "$FORM_new_flow" && {
	SAVED=1
validate <<EOF
EOF
	equal "$?" 0 && {
	count=`uci get qos.general.flow_count`
	count=`expr $count + 1`
	uci_add qos qos flow$count
	uci_set qos flow$count name "$FORM_name"
	uci_set qos flow$count src "$FORM_src"
	uci_set qos flow$count dst "$FORM_dst"
	uci_set qos flow$count proto "$FORM_proto"
	if [ "$FORM_proto" = "any" ];then
	uci_set qos flow$count sport ""
	uci_set qos flow$count dport ""
	else
	uci_set qos flow$count sport "$FORM_sport"
	uci_set qos flow$count dport "$FORM_dport"
	fi
	uci_set qos flow$count queue "$FORM_queue"
	uci_set qos general flow_count "$count"
	config_set flow$count name "$FORM_name"
	config_set flow$count src "$FORM_src"
	config_set flow$count dst "$FORM_dst"
	config_set flow$count proto "$FORM_proto"
	config_set flow$count sport "$FORM_sport"
	config_set flow$count dport "$FORM_dport"
	config_set flow$count queue "$FORM_queue"
	FORM_name=""
	FORM_src=""
	FORM_dst=""
	FORM_proto=""
	FORM_sport=""
	FORM_dport=""
	FORM_queue=""
	}
}

! empty "$FORM_display_flow" && {
	flow=$FORM_display_flow
#	FORM_name=${name:-$(uci get qos.flow$flow.name)}
#	FORM_src=${src:-$(uci get qos.flow$flow.src)}
#	FORM_dst=${dst:-$(uci get qos.flow$flow.dst)}
#	FORM_proto=${proto:-$(uci get qos.flow$flow.proto)}
#	FORM_sport=${sport:-$(uci get qos.flow$flow.sport)}
#	FORM_dport=${dport:-$(uci get qos.flow$flow.dport)}
#	FORM_queue=${queue:-$(uci get qos.flow$flow.queue)}
	config_get FORM_name flow$flow name
	config_get FORM_src flow$flow src
	config_get FORM_dst flow$flow dst
	config_get FORM_proto flow$flow proto
	config_get FORM_sport flow$flow sport
	config_get FORM_dport flow$flow dport
	config_get FORM_queue flow$flow queue
}

! empty "$FORM_save_flow" && {
	SAVED=1
validate <<EOF
EOF
	equal "$?" 0 && {
	count=$FORM_flow
	uci_set qos flow$count name "$FORM_name"
	uci_set qos flow$count src "$FORM_src"
	uci_set qos flow$count dst "$FORM_dst"
	uci_set qos flow$count proto "$FORM_proto"
	if [ "$FORM_proto" = "any" ];then
	uci_set qos flow$count sport ""
	uci_set qos flow$count dport ""
	else
	uci_set qos flow$count sport "$FORM_sport"
	uci_set qos flow$count dport "$FORM_dport"
	fi
	uci_set qos flow$count queue "$FORM_queue"
	config_set flow$count name "$FORM_name"
	config_set flow$count src "$FORM_src"
	config_set flow$count dst "$FORM_dst"
	config_set flow$count proto "$FORM_proto"
	config_set flow$count sport "$FORM_sport"
	config_set flow$count dport "$FORM_dport"
	config_set flow$count queue "$FORM_queue"
	FORM_name=""
	FORM_src=""
	FORM_dst=""
	FORM_proto=""
	FORM_sport=""
	FORM_dport=""
	FORM_queue=""
	}
}

! empty "$FORM_delete" && {
count=`uci get qos.general.flow_count`
flowid=$FORM_delete
uci_remove qos flow$flowid
while [ $flowid -le $count ]
do
uci_rename qos flow`expr $flowid + 1` flow$flowid
flowid=`expr $flowid + 1`
done
uci_set qos general flow_count `expr $count - 1`
}

#####################################################################
header "QoS" "Flow Configuration" "@TR<<Flow Configuration>>" ' onload="modechange()" '
#####################################################################

cat <<EOF
<script type="text/javascript" src="/webif.js "></script>
<script type="text/javascript">
<!--
function modechange()
{
	var v;
	v = (isset('proto', 'tcp') || isset('proto', 'udp'));
	set_visible('sport', v);
	set_visible('dport', v);

	hide('save');
	show('save');
}
-->
</script>
EOF


flow_count=`uci get qos.general.flow_count`

echo "<div class=\"settings\">"
echo "<th colspan=\"11\"><h3><strong>" Traffic Flows: "</strong></h3></th>"
echo "<div class=\"settings-content-inner\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Name</th><th>Src IP</th><th>Dst IP</th><th>Protocol</th><th>Sport</th><th>Dport</th><th>Queue</th><th style=\"text-align: center;\">Actions</th></tr>"
i=1
if [ "$flow_count" = 0 ]; then
  echo "<tr class=\"tr_bg\"><td colspan=\"8\">There are no traffic flows</td></tr>"
fi
while [ $i -le $flow_count ]
do
#name=`uci get qos.flow$i.name`
#src=`uci get qos.flow$i.src`
#dst=`uci get qos.flow$i.dst`
#proto=`uci get qos.flow$i.proto`
#sport=`uci get qos.flow$i.sport`
#dport=`uci get qos.flow$i.dport`
#queue=`uci get qos.flow$i.queue`
config_get name flow$i name
config_get src flow$i src
config_get dst flow$i dst
config_get proto flow$i proto
config_get sport flow$i sport
config_get dport flow$i dport
config_get queue flow$i queue
echo "<tr class=\"tr_bg\"><td>$name</td><td>$src</td><td>$dst</td><td>$proto</td><td>$sport</td><td>$dport</td><td>$queue</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_flow=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
i=`expr $i + 1`
done
echo "</tbody></table></div><div class=\"clearfix\">&nbsp;</div></div><br>"

empty "$FORM_display_flow" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<New Flow>>
formtag_begin|new_flow|$SCRIPT_NAME
field|@TR<<Name>>
text|name|$FORM_name
field|@TR<<Src IP>>
text|src|$FORM_src
field|@TR<<Dst IP>>
text|dst|$FORM_dst
field|@TR<<Protocol>>
select|proto|$FORM_proto
option|any|@TR<<any>>
option|tcp|@TR<<tcp>>
option|udp|@TR<<udp>>
field|@TR<<Sport>>|sport|hidden
text|sport|$FORM_sport
field|@TR<<Dport>>|dport|hidden
text|dport|$FORM_dport
field|@TR<<Queue>>
select|queue|$FORM_queue
option|0|@TR<<0>>
option|1|@TR<<1>>
option|2|@TR<<2>>
option|3|@TR<<3>>
option|4|@TR<<4>>
option|5|@TR<<5>>
option|6|@TR<<6>>
option|7|@TR<<7>>
field||spacer1
string|<br />
submit|new_flow|@TR<<Add>>
reset||@TR<<Clear>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_flow" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Flow $FORM_display_flow>>
formtag_begin|save_flow|$SCRIPT_NAME
field|@TR<<Flow ID>>
text|flow|$FORM_display_flow|||readonly
field|@TR<<Name>>
text|name|$FORM_name
field|@TR<<Src IP>>
text|src|$FORM_src
field|@TR<<Dst IP>>
text|dst|$FORM_dst
field|@TR<<Protocol>>
select|proto|$FORM_proto
option|any|@TR<<any>>
option|tcp|@TR<<tcp>>
option|udp|@TR<<udp>>
field|@TR<<Sport>>|sport|hidden
text|sport|$FORM_sport
field|@TR<<Dport>>|dport|hidden
text|dport|$FORM_dport
field|@TR<<Queue>>
select|queue|$FORM_queue
option|0|@TR<<0>>
option|1|@TR<<1>>
option|2|@TR<<2>>
option|3|@TR<<3>>
option|4|@TR<<4>>
option|5|@TR<<5>>
option|6|@TR<<6>>
option|7|@TR<<7>>
field||spacer1
string|<br />
submit|save_flow|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

footer ?>

<!--
##WEBIF:name:QoS:100:Flow Configuration
-->
