/*
 * Copyright (C) 2006 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __M8326XG_H
#define __M8326XG_H

/*
 * High Level Configuration Options
 */
#define CONFIG_M8326XG       1

#define CFG_CLK	CFG_CLK_650_187_375
//#define CFG_CLK CFG_CLK_650_200_200

#define ADJ2_MIN_VAL     90
#define ADJ2_MAX_VAL    150

#define ADJ2_MIN_ACCEPTED_RANGE     20    /* adj2_val1: error */
#define ADJ2_ACCEPTED_RANGE         25    /* adj2_val2: warning */

#define ADJ1_MIN_VAL     1
#define ADJ1_MAX_VAL    80

#define ADJ1_MIN_ACCEPTED_WINDOW    18     /* adj1_val1: ignore */
#define ADJ1_ACCEPTED_WINDOW        23     /* adj1_val2: warning */

// DDR Configs

//DENALI CONFIGRATION FOR BOARD CONFIG #1
#define DENALI_CTL_00_VAL_CFG1   0x0100000101010101LL
#define DENALI_CTL_01_VAL_CFG1   0x0100010001000000LL
#define DENALI_CTL_02_VAL_CFG1   0x0200000000010100LL
#define DENALI_CTL_03_VAL_CFG1   0x0202020202020202LL

#define DENALI_CTL_05_VAL_CFG1   0x0003010500020001LL
#define DENALI_CTL_06_VAL_CFG1   0x0A0A040300030400LL
#define DENALI_CTL_07_VAL_CFG1   0x000000050000020ALL
#define DENALI_CTL_08_VAL_CFG1   0x6400003F3F150212LL
#define DENALI_CTL_09_VAL_CFG1   0x0000640064006400LL

#define DENALI_CTL_11_VAL_CFG1   0x0000003100000000LL
#define DENALI_CTL_12_VAL_CFG1   0x0000000000001200LL
#define DENALI_CTL_13_VAL_CFG1   0x0010001000100010LL
#define DENALI_CTL_14_VAL_CFG1   0x0010001000100010LL
#define DENALI_CTL_15_VAL_CFG1   0x0B60000000000000LL
#define DENALI_CTL_16_VAL_CFG1   0x0000000066530000LL
#define DENALI_CTL_17_VAL_CFG1   0x0000010000000000LL
#define DENALI_CTL_18_VAL_CFG1   0x0600010000000000LL
#define DENALI_CTL_19_VAL_CFG1   0x00003400C8050B00LL
#define DENALI_CTL_20_VAL_CFG1   0x0000010125B400C8LL
#define DENALI_CTL_21_VAL_CFG1   0x0202020100000101LL
#define DENALI_CTL_22_VAL_CFG1   0x0000020007000002LL

#define DENALI_CTL_24_VAL_CFG1   0x0000000200970000LL
#define DENALI_CTL_25_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_26_VAL_CFG1   0x9400593794005937LL
#define DENALI_CTL_27_VAL_CFG1   DENALI_CTL_26_VAL_CFG1
#define DENALI_CTL_28_VAL_CFG1   0x07C0040107C00401LL
#define DENALI_CTL_29_VAL_CFG1   DENALI_CTL_28_VAL_CFG1
#define DENALI_CTL_30_VAL_CFG1   0x0000000000000005LL
#define DENALI_CTL_31_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_32_VAL_CFG1   0x0c02000000000000LL
#define DENALI_CTL_33_VAL_CFG1   0x0000000000000004LL
#define DENALI_CTL_34_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_35_VAL_CFG1   0x0078787878050000LL
#define DENALI_CTL_36_VAL_CFG1   0x0000000000000004LL
#define DENALI_CTL_37_VAL_CFG1   0x0A52000000040200LL
#define DENALI_CTL_38_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_39_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_40_VAL_CFG1   0x00000000000000c8LL
#define DENALI_CTL_41_VAL_CFG1   0x0020138100201381LL
#define DENALI_CTL_42_VAL_CFG1   DENALI_CTL_41_VAL_CFG1
#define DENALI_CTL_43_VAL_CFG1   0x0000130000001300LL
#define DENALI_CTL_44_VAL_CFG1   DENALI_CTL_43_VAL_CFG1
#define DENALI_CTL_45_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_46_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_47_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_48_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_49_VAL_CFG1   0x0000000000000050LL
#define DENALI_CTL_50_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_51_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_52_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_53_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_54_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_55_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_56_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_57_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_58_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_59_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_60_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_61_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_62_VAL_CFG1   0x0000000000000000LL

#define DENALI_CTL_66_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_67_VAL_CFG1   0x0000000000000000LL
#define DENALI_CTL_68_VAL_CFG1   0x0000000002000000LL
#define DENALI_CTL_69_VAL_CFG1   0x00000003e8050000LL


//DENALI CONFIGRATION FOR BOARD CONFIG #2
#define DENALI_CTL_00_VAL_CFG2   0x0100000101010101LL
#define DENALI_CTL_01_VAL_CFG2   0x0100010001000000LL
#define DENALI_CTL_02_VAL_CFG2   0x0200000000010100LL
#define DENALI_CTL_03_VAL_CFG2   0x0202020202020202LL
// #define DENALI_CTL_04_VAL_CFG2
#define DENALI_CTL_05_VAL_CFG2   0x0003010400020001LL
#define DENALI_CTL_06_VAL_CFG2   0x080A030200020300LL
#define DENALI_CTL_07_VAL_CFG2   0x0000000300000207LL
#define DENALI_CTL_08_VAL_CFG2   0x6400003F3F0C020ALL
#define DENALI_CTL_09_VAL_CFG2   0x0000640064006400LL
// #define DENALI_CTL_10_VAL_CFG2
#define DENALI_CTL_11_VAL_CFG2   0x0000001A00000000LL
#define DENALI_CTL_12_VAL_CFG2   0x0000000000000A00LL
#define DENALI_CTL_13_VAL_CFG2   0x0010001000100010LL
#define DENALI_CTL_14_VAL_CFG2   0x0010001000100010LL
#define DENALI_CTL_15_VAL_CFG2   0x0604000000000000LL
#define DENALI_CTL_16_VAL_CFG2   0x0000000036380000LL
#define DENALI_CTL_17_VAL_CFG2   0x0000010000000000LL
#define DENALI_CTL_18_VAL_CFG2   0x0400010000000000LL
#define DENALI_CTL_19_VAL_CFG2   0x00001C00C8030600LL
#define DENALI_CTL_20_VAL_CFG2   0x000001009C4000C8LL
#define DENALI_CTL_21_VAL_CFG2   0x0303030100000101LL
#define DENALI_CTL_22_VAL_CFG2   0x0000020007000003LL
// #define DENALI_CTL_23_VAL_CFG2
#define DENALI_CTL_24_VAL_CFG2   0x0000000200510000LL
#define DENALI_CTL_25_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_26_VAL_CFG2   0x9440492794404927LL
#define DENALI_CTL_27_VAL_CFG2   DENALI_CTL_26_VAL_CFG2
#define DENALI_CTL_28_VAL_CFG2   0x07C0040107C00401LL
#define DENALI_CTL_29_VAL_CFG2   DENALI_CTL_28_VAL_CFG2
#define DENALI_CTL_30_VAL_CFG2   0x0000000000000005LL
#define DENALI_CTL_31_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_32_VAL_CFG2   0x0c02000000000000LL
#define DENALI_CTL_33_VAL_CFG2   0x0000000000000004LL
#define DENALI_CTL_34_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_35_VAL_CFG2   0x0046464646030000LL
#define DENALI_CTL_36_VAL_CFG2   0x0000000000000004LL
#define DENALI_CTL_37_VAL_CFG2   0x0642000000040200LL
#define DENALI_CTL_38_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_39_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_40_VAL_CFG2   0x00000000000000c8LL
#define DENALI_CTL_41_VAL_CFG2   0x003B37EF003B37EFLL
#define DENALI_CTL_42_VAL_CFG2   DENALI_CTL_41_VAL_CFG2
#define DENALI_CTL_43_VAL_CFG2   0x0000370000003700LL
#define DENALI_CTL_44_VAL_CFG2   DENALI_CTL_43_VAL_CFG2
#define DENALI_CTL_45_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_46_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_47_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_48_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_49_VAL_CFG2   0x0000000000000050LL
#define DENALI_CTL_50_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_51_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_52_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_53_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_54_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_55_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_56_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_57_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_58_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_59_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_60_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_61_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_62_VAL_CFG2   0x0000000000000000LL
// #define DENALI_CTL_63_VAL_CFG2
// #define DENALI_CTL_64_VAL_CFG2
// #define DENALI_CTL_65_VAL_CFG2
#define DENALI_CTL_66_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_67_VAL_CFG2   0x0000000000000000LL
#define DENALI_CTL_68_VAL_CFG2   0x0000000002000000LL
#define DENALI_CTL_69_VAL_CFG2   0x00000003e8050000LL

#endif /* __M8326XG_H */
