/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.presets;

import com.sun.tools.visualvm.profiling.presets.ProfilerCPUSettings;
import com.sun.tools.visualvm.profiling.presets.ProfilerPreset;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class ProfilerCPUPanel
extends JPanel {
    private JLabel rootClassesLabel;
    private TextAreaComponent rootsArea;
    private JCheckBox runnablesCheckBox;
    private JRadioButton inclFilterRadioButton;
    private JRadioButton exclFilterRadioButton;
    private TextAreaComponent filtersArea;
    private final Runnable validator;
    private boolean rootsValid = true;
    private boolean filtersValid = true;
    private boolean internalChange;

    public ProfilerCPUPanel() {
        this((Runnable)null, false);
    }

    ProfilerCPUPanel(Runnable validator, boolean mnemonics) {
        this.validator = validator;
        this.initComponents(mnemonics);
    }

    public ProfilingSettings getSettings() {
        ProfilingSettings settings = ProfilingSettingsPresets.createCPUPreset();
        settings.setInstrScheme(1);
        String instrFilterString = this.getFilterValue();
        SimpleFilter instrFilter = instrFilterString.isEmpty() || "*".equals(instrFilterString) ? SimpleFilter.NO_FILTER : new SimpleFilter(instrFilterString, this.inclFilterRadioButton.isSelected() ? 2 : 1, instrFilterString);
        settings.setSelectedInstrumentationFilter((Object)instrFilter);
        String[] rootValues = this.getRootValue().split(",");
        ClientUtils.SourceCodeSelection[] roots = rootValues.length == 1 && rootValues[0].isEmpty() ? new ClientUtils.SourceCodeSelection[]{} : new ClientUtils.SourceCodeSelection[rootValues.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = new ClientUtils.SourceCodeSelection(rootValues[i], "*", null);
        }
        settings.setInstrumentationRootMethods(roots);
        settings.setInstrumentSpawnedThreads(this.runnablesCheckBox.isSelected());
        return settings;
    }

    public boolean settingsValid() {
        return this.rootsValid && this.filtersValid;
    }

    public void loadFromPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        this.internalChange = true;
        this.rootsArea.getTextArea().setText(preset.getRootsP());
        this.runnablesCheckBox.setSelected(preset.getRunnablesP());
        this.inclFilterRadioButton.setSelected(!preset.getFilterModeP());
        this.exclFilterRadioButton.setSelected(preset.getFilterModeP());
        this.filtersArea.getTextArea().setText(preset.getFilterP());
        this.internalChange = false;
    }

    public void saveToPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        preset.setRootsP(this.rootsArea.getTextArea().getText());
        preset.setRunnablesP(this.runnablesCheckBox.isSelected());
        preset.setFilterModeP(this.exclFilterRadioButton.isSelected());
        preset.setFilterP(this.filtersArea.getTextArea().getText());
    }

    public abstract void settingsChanged();

    private void syncUI() {
        if (this.internalChange) {
            return;
        }
        this.settingsChanged();
    }

    private void checkRootValidity() {
        this.rootsValid = this.isRootValueValid();
        this.rootsArea.getTextArea().setForeground(this.rootsValid ? UIManager.getColor("TextArea.foreground") : Color.RED);
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public boolean isRootValueValid() {
        String[] rootParts = FilterUtils.getSeparateFilters((String)this.getRootValue());
        for (int i = 0; i < rootParts.length; ++i) {
            if (FilterUtils.isValidProfilerFilter((String)rootParts[i])) continue;
            if (rootParts[i].endsWith("**")) {
                if (FilterUtils.isValidProfilerFilter((String)rootParts[i].substring(0, rootParts[i].length() - 1))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private String getRootValue() {
        StringBuilder convertedValue = new StringBuilder();
        String[] rootValues = this.getRootsValues();
        for (int i = 0; i < rootValues.length; ++i) {
            String filterValue = rootValues[i].trim();
            if (i != rootValues.length - 1 && !filterValue.endsWith(",")) {
                filterValue = filterValue + ",";
            }
            convertedValue.append(filterValue);
        }
        return convertedValue.toString();
    }

    private String[] getRootsValues() {
        return this.rootsArea.getTextArea().getText().split("\\n");
    }

    private void checkFilterValidity() {
        this.filtersValid = this.isFilterValueValid();
        this.filtersArea.getTextArea().setForeground(this.filtersValid ? UIManager.getColor("TextArea.foreground") : Color.RED);
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public boolean isFilterValueValid() {
        String[] filterParts = FilterUtils.getSeparateFilters((String)this.getFilterValue());
        for (int i = 0; i < filterParts.length; ++i) {
            if (FilterUtils.isValidProfilerFilter((String)filterParts[i])) continue;
            return false;
        }
        return true;
    }

    private String getFilterValue() {
        StringBuilder convertedValue = new StringBuilder();
        String[] filterValues = this.getFilterValues();
        for (int i = 0; i < filterValues.length; ++i) {
            String filterValue = filterValues[i].trim();
            if (i != filterValues.length - 1 && !filterValue.endsWith(",")) {
                filterValue = filterValue + ", ";
            }
            convertedValue.append(filterValue);
        }
        return convertedValue.toString();
    }

    private String[] getFilterValues() {
        return this.filtersArea.getTextArea().getText().split("\\n");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void initComponents(boolean mnemonics) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        ButtonGroup filterRadiosGroup = new ButtonGroup();
        this.rootClassesLabel = new JLabel();
        ProfilerCPUPanel.setText(this.rootClassesLabel, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Root_Classes"), mnemonics);
        Dimension d = this.rootClassesLabel.getPreferredSize();
        JRadioButton refRadion = new JRadioButton(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Root_Classes"));
        refRadion.setBorder(this.rootClassesLabel.getBorder());
        d.height = Math.max(d.height, refRadion.getPreferredSize().height);
        this.rootClassesLabel.setPreferredSize(d);
        this.rootClassesLabel.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Root_Classes"));
        this.rootClassesLabel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.add((Component)this.rootClassesLabel, constraints);
        this.rootsArea = ProfilerCPUPanel.createTextArea(2);
        this.rootClassesLabel.setLabelFor(this.rootsArea.getTextArea());
        this.rootsArea.getTextArea().setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Root_Classes"));
        this.rootsArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkRootValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkRootValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkRootValidity();
                ProfilerCPUPanel.this.syncUI();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.65;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 7, 10);
        this.add((Component)this.rootsArea, constraints);
        this.runnablesCheckBox = new JCheckBox(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerCPUPanel.this.syncUI();
            }
        };
        ProfilerCPUPanel.setText(this.runnablesCheckBox, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Profile_Runnables"), mnemonics);
        this.runnablesCheckBox.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_New_Runnables"));
        this.runnablesCheckBox.setOpaque(false);
        this.runnablesCheckBox.setBorder(this.rootClassesLabel.getBorder());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.runnablesCheckBox, constraints);
        this.inclFilterRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerCPUPanel.this.syncUI();
            }
        };
        ProfilerCPUPanel.setText(this.inclFilterRadioButton, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Profile_Incl"), mnemonics);
        this.inclFilterRadioButton.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Inclusive_Filter"));
        this.inclFilterRadioButton.setOpaque(false);
        this.inclFilterRadioButton.setBorder(this.rootClassesLabel.getBorder());
        filterRadiosGroup.add(this.inclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 5, 5);
        this.add((Component)this.inclFilterRadioButton, constraints);
        this.exclFilterRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerCPUPanel.this.syncUI();
            }
        };
        ProfilerCPUPanel.setText(this.exclFilterRadioButton, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Profile_Excl"), mnemonics);
        this.exclFilterRadioButton.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Exclusive_Filter"));
        this.exclFilterRadioButton.setOpaque(false);
        this.exclFilterRadioButton.setBorder(this.rootClassesLabel.getBorder());
        filterRadiosGroup.add(this.exclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.exclFilterRadioButton, constraints);
        this.filtersArea = ProfilerCPUPanel.createTextArea(2);
        this.filtersArea.getTextArea().setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Instrumentation_Filter"));
        this.filtersArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkFilterValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkFilterValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkFilterValidity();
                ProfilerCPUPanel.this.syncUI();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weighty = 0.35;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.filtersArea, constraints);
    }

    private static void setText(JLabel l, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((JLabel)l, (String)text);
        } else {
            l.setText(text.replace("&", ""));
        }
    }

    private static void setText(AbstractButton b, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((AbstractButton)b, (String)text);
        } else {
            b.setText(text.replace("&", ""));
        }
    }

    private static TextAreaComponent createTextArea(int rows) {
        final JTextArea rootsArea = new JTextArea();
        rootsArea.setFont(new Font("Monospaced", 0, UIManager.getFont("Label.font").getSize()));
        TextAreaComponent rootsAreaScrollPane = new TextAreaComponent(rootsArea, 20, 30){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                rootsArea.setEnabled(enabled);
            }
        };
        rootsAreaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JTextArea referenceArea = new JTextArea("X");
        referenceArea.setFont(rootsArea.getFont());
        referenceArea.setRows(rows);
        Insets insets = rootsAreaScrollPane.getInsets();
        rootsAreaScrollPane.setPreferredSize(new Dimension(1, referenceArea.getPreferredSize().height + (insets != null ? insets.top + insets.bottom : 0)));
        return rootsAreaScrollPane;
    }

    private static class TextAreaComponent
    extends JScrollPane {
        public TextAreaComponent(JTextArea textArea, int vPolicy, int hPolicy) {
            super(textArea, vPolicy, hPolicy);
        }

        public JTextArea getTextArea() {
            return (JTextArea)this.getViewport().getView();
        }
    }
}

