/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.server.ClassBytesLoader;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerCalibrator;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUSampledInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.HeapDump;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.CalibrationDataResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.DefiningLoaderResponse;
import org.netbeans.lib.profiler.wireprotocol.DumpResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;
import org.netbeans.lib.profiler.wireprotocol.GetDefiningClassLoaderCommand;
import org.netbeans.lib.profiler.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.netbeans.lib.profiler.wireprotocol.InitiateInstrumentationCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.SetChangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.TakeHeapDumpCommand;
import org.netbeans.lib.profiler.wireprotocol.VMPropertiesResponse;
import org.netbeans.lib.profiler.wireprotocol.WireIO;

public class ProfilerServer
extends Thread
implements CommonConstants {
    private static ResourceBundle messages;
    private static String ENTER_TO_SHUTDOWN_MSG;
    private static String MAIN_CLASS_NOT_PUBLIC_MSG;
    private static String INCORRECT_MAIN_MODIFIERS_MSG;
    private static String UNEXPECTED_EXCEPTION_MSG;
    private static String ELAPSED_TIME_MSG;
    private static String CONNECTION_MSG;
    private static String WAITING_ON_PORT_MSG;
    private static String WAITING_ON_PORT_TIMEOUT_MSG;
    private static String CONNECTION_EXCEPTION_MSG;
    private static String CONNECTION_TIMEOUT_MSG;
    private static String AGENT_ERROR_MSG;
    private static String CONNECTION_INTERRUPTED_MSG;
    private static String COMMAND_EXCEPTION_MSG;
    private static String RESPONSE_EXCEPTION_MSG;
    private static String CONNECTION_CLOSED_MSG;
    private static String INCORRECT_AGENT_ID_MSG;
    private static String THREAD_EXCEPTION_MSG;
    private static String THREAD_WAIT_EXCEPTION_MSG;
    private static String LOCAL_SESSION_MSG;
    private static String REMOTE_SESSION_MSG;
    public static final int ATTACH_DYNAMIC = 0;
    public static final int ATTACH_DIRECT = 1;
    private static volatile boolean profilerInterfaceInitialized;
    private static volatile boolean connectionOpen;
    private static volatile boolean connectionFailed;
    private static volatile boolean detachCommandReceived;
    private static ProfilerServer profilerServer;
    private static ProfilingSessionStatus status;
    private static volatile boolean startTargetApp;
    private static volatile boolean targetAppMainThreadComplete;
    private static volatile Exception startupException;
    private static Object targetAppRunningLock;
    private static Thread mainThread;
    private static SeparateCmdExecutionThread separateCmdExecutionThread;
    private static ShutdownWaitThread shutdownWaitThread;
    static Object execInSeparateThreadLock;
    static int execInSeparateThreadOpCode;
    private static volatile boolean preemptExit;
    private static boolean shutdownOK;
    private static final Object shutdownLock;
    private static final Object resultsNotifiedLock;
    private static boolean resultsNotified;
    private static boolean resourcesInitialized;
    private static String _fullJFluidPath;
    private static int _portNo;
    private static int _activateCode;
    private static int _timeOut;
    private static Response lastResponse;
    private static Object responseLock;
    private ObjectInputStream socketIn;
    private ObjectOutputStream socketOut;
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private WireIO wireIO;
    private boolean dynamic;
    private int agentId = -1;
    private int serverPort;
    private int serverTimeout = 0;
    static /* synthetic */ Class array$Ljava$lang$String;

    private ProfilerServer(int n, boolean bl, int n2) {
        super("*** Profiler Agent Communication Thread");
        this.setPriority(10);
        this.serverPort = n;
        ThreadInfo.addProfilerServerThread(this);
        this.dynamic = bl;
        if (!bl) {
            this.serverTimeout = n2;
        }
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Response getLastResponse() {
        Response response;
        Object object = responseLock;
        synchronized (object) {
            if (lastResponse == null) {
                boolean bl = false;
                do {
                    try {
                        responseLock.wait();
                        bl = false;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                } while (bl);
                if (lastResponse == null) {
                    System.out.println("Profiler Agent Error: lastResponse == null - internal error?");
                }
            }
            response = lastResponse;
            lastResponse = null;
        }
        return response;
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    public static ProfilingSessionStatus getProfilingSessionStatus() {
        return status;
    }

    public static boolean isTargetAppMainThreadComplete() {
        return targetAppMainThreadComplete;
    }

    public static void activate(String string, int n, int n2) {
        ProfilerServer.activate(string, n, n2, 0);
    }

    public static void activate(String string, int n, int n2, int n3) {
        try {
            _fullJFluidPath = string;
            _portNo = n;
            _timeOut = n3;
            _activateCode = n2;
            ProfilerServer.initLocalizedResources();
            if (n2 == 0) {
                new AttachDynamicThread(n2).start();
            } else {
                ProfilerServer.doActivate(n2);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Profiler initialization failed due to:");
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        mainThread = Thread.currentThread();
        try {
            _fullJFluidPath = new File(stringArray[0]).getParentFile().getParentFile().getParentFile().getAbsolutePath();
        }
        catch (Exception exception) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer, cannot resolve library directory\n" + exception.getMessage());
        }
        ProfilerServer.initLocalizedResources();
        ProfilerServer.initInternals();
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            ProfilerServer.internalError("illegal port number specified: " + stringArray[1]);
        }
        int n2 = 2;
        int n3 = 0;
        try {
            n3 = Integer.parseInt(stringArray[2]);
            n2 = 3;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n4 = stringArray.length - (n2 + 1);
        String[] stringArray2 = new String[n4];
        System.arraycopy(stringArray, n2 + 1, stringArray2, 0, n4);
        profilerServer = new ProfilerServer(n, true, n3);
        profilerServer.start();
        while (!connectionOpen && !connectionFailed) {
            ProfilerServer.delay(50);
        }
        if (connectionFailed) {
            preemptExit = false;
            System.exit(-1);
        }
        ProfilerInterface.setProfilerServer(profilerServer);
        ProfilerServer.initSupportingFunctionality(false);
        while (!startTargetApp) {
            ProfilerServer.delay(100);
        }
        ProfilerServer.runTargetApp(stringArray[n2], stringArray2);
        targetAppMainThreadComplete = true;
        if (startupException != null) {
            Object object = targetAppRunningLock;
            synchronized (object) {
                targetAppRunningLock.notify();
            }
        }
        ProfilerServer.delay(300);
        while (Threads.targetAppThreadsExist()) {
            ProfilerServer.delay(300);
        }
        ProfilerServer.status.targetAppRunning = false;
        ProfilerInterface.disableProfilerHooks();
        profilerServer.sendSimpleCmdToClient(18);
        ProfilerServer.waitForShutdownOK();
        ProfilerServer.forcedShutdown();
    }

    public void setRemoteProfiling(boolean bl) {
        ProfilerServer.status.remoteProfiling = bl;
        if (bl) {
            System.out.println(REMOTE_SESSION_MSG);
            ClassBytesLoader.preloadClasses();
        } else {
            System.out.println(LOCAL_SESSION_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyClientOnResultsAvailability() {
        if (!connectionOpen) {
            return;
        }
        if (profilerServer == null) {
            return;
        }
        Object object = resultsNotifiedLock;
        synchronized (object) {
            if (resultsNotified) {
                return;
            }
            resultsNotified = true;
            profilerServer.sendSimpleCmdToClient(38);
        }
    }

    public static void requestClientResetResults() {
        ProfilerInterface.resetProfilerCollectors();
        ProfilerCalibrator.resetInternalStatsCollectors();
    }

    public static void requestClientTakeSnapshot() {
        if (profilerServer == null) {
            return;
        }
        profilerServer.sendSimpleCmdToClient(39);
    }

    public boolean getAndCheckLastResponse() {
        Response response = ProfilerServer.getLastResponse();
        return response.isOK();
    }

    public void run() {
        if (this.connectToClient()) {
            while (!profilerInterfaceInitialized) {
                ProfilerServer.delay(50);
            }
            this.listenToClient();
        } else {
            preemptExit = false;
        }
    }

    public void sendClassLoaderUnloadingCommand() {
        this.sendSimpleCmdToClient(36);
        ProfilerServer.getLastResponse();
    }

    public synchronized void sendComplexCmdToClient(Command command) {
        block2: {
            try {
                this.wireIO.sendComplexCommand(command);
            }
            catch (IOException iOException) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(iOException);
            }
        }
    }

    public synchronized void sendComplexResponseToClient(Response response) {
        block2: {
            try {
                this.wireIO.sendComplexResponse(response);
            }
            catch (IOException iOException) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(iOException);
            }
        }
    }

    public boolean sendEventBufferDumpedCommand(int n, byte[] byArray, int n2) {
        EventBufferDumpedCommand eventBufferDumpedCommand = new EventBufferDumpedCommand(n, byArray, n2);
        this.sendComplexCmdToClient(eventBufferDumpedCommand);
        Response response = ProfilerServer.getLastResponse();
        return response.isOK();
    }

    public synchronized void sendSimpleCmdToClient(int n) {
        block2: {
            try {
                this.wireIO.sendSimpleCommand(n);
            }
            catch (IOException iOException) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(iOException);
            }
        }
    }

    public synchronized void sendSimpleResponseToClient(boolean bl, String string) {
        block2: {
            try {
                this.wireIO.sendSimpleResponse(bl, string);
            }
            catch (IOException iOException) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(iOException);
            }
        }
    }

    static ResourceBundle getProfilerServerResourceBundle() {
        if (messages != null) {
            return messages;
        }
        if (_fullJFluidPath != null) {
            try {
                messages = ProfilerServer.getProfilerServerResourceBundle(_fullJFluidPath);
            }
            catch (Exception exception) {
                System.err.println("Profiler Server: Problem with customized initializing localized messages...\n" + exception.getMessage());
            }
        }
        if (messages != null) {
            return messages;
        }
        try {
            messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.server.Bundle");
        }
        catch (Exception exception) {
            System.err.println("Profiler Server: Problem with default initializing localized messages...\n" + exception.getMessage());
        }
        return messages;
    }

    static void initLocalizedResources() {
        if (resourcesInitialized) {
            return;
        }
        messages = ProfilerServer.getProfilerServerResourceBundle();
        if (messages != null) {
            ENTER_TO_SHUTDOWN_MSG = messages.getString("ProfilerServer_EnterToShutdownMsg");
            MAIN_CLASS_NOT_PUBLIC_MSG = messages.getString("ProfilerServer_MainClassNotPublicMsg");
            INCORRECT_MAIN_MODIFIERS_MSG = messages.getString("ProfilerServer_IncorrectMainModifiersMsg");
            UNEXPECTED_EXCEPTION_MSG = messages.getString("ProfilerServer_UnexpectedExceptionMsg");
            ELAPSED_TIME_MSG = messages.getString("ProfilerServer_ElapsedTimeMsg");
            CONNECTION_MSG = messages.getString("ProfilerServer_ConnectionMsg");
            WAITING_ON_PORT_MSG = messages.getString("ProfilerServer_WaitingOnPortMsg");
            WAITING_ON_PORT_TIMEOUT_MSG = messages.getString("ProfilerServer_WaitingOnPortTimeoutMsg");
            CONNECTION_EXCEPTION_MSG = messages.getString("ProfilerServer_ConnectionExceptionMsg");
            CONNECTION_TIMEOUT_MSG = messages.getString("ProfilerServer_ConnectionTimeoutMsg");
            AGENT_ERROR_MSG = messages.getString("ProfilerServer_AgentErrorMsg");
            CONNECTION_INTERRUPTED_MSG = messages.getString("ProfilerServer_ConnectionInterruptedMsg");
            COMMAND_EXCEPTION_MSG = messages.getString("ProfilerServer_CommandExceptionMsg");
            RESPONSE_EXCEPTION_MSG = messages.getString("ProfilerServer_ResponseExceptionMsg");
            CONNECTION_CLOSED_MSG = messages.getString("ProfilerServer_ConnectionClosedMsg");
            INCORRECT_AGENT_ID_MSG = messages.getString("ProfilerServer_IncorrectAgentIdMsg");
            THREAD_EXCEPTION_MSG = messages.getString("ProfilerServer_ThreadExceptionMsg");
            THREAD_WAIT_EXCEPTION_MSG = messages.getString("ProfilerServer_ThreadWaitExceptionMsg");
            LOCAL_SESSION_MSG = messages.getString("ProfilerServer_LocalSessionMsg");
            REMOTE_SESSION_MSG = messages.getString("ProfilerServer_RemoteSessionMsg");
            resourcesInitialized = true;
        }
    }

    static void loadNativeLibrary(String string, boolean bl) {
        String string2 = Platform.getAgentNativeLibFullName(string, bl, null, -1);
        System.load(string2);
    }

    static boolean startProfilingPointsActive() {
        if (status != null) {
            return ProfilerServer.status.startProfilingPointsActive;
        }
        return false;
    }

    private static File getInfoFile(int n) throws IOException {
        String string = Platform.getProfilerUserDir();
        return new File(string + File.separator + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setShutdownOK() {
        Object object = shutdownLock;
        synchronized (object) {
            shutdownOK = true;
            shutdownLock.notifyAll();
        }
    }

    private static void cleanupOnShutdown() {
        Monitors.shutdown();
        ProfilerInterface.disableProfilerHooks();
        ProfilerRuntimeCPU.enableProfiling(false);
        connectionOpen = false;
        profilerServer.sendSimpleCmdToClient(19);
        profilerServer.closeConnection();
        profilerServer.stopSeparateCmdExecutionThread();
    }

    private static void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void doActivate(int n) {
        ProfilerInterface.disableProfilerHooks();
        ProfilerServer.initInternals();
        profilerServer = new ProfilerServer(_portNo, n == 0, _timeOut);
        profilerServer.start();
        while (!connectionOpen && !connectionFailed) {
            ProfilerServer.delay(100);
        }
        if (connectionFailed) {
            if (n == 1) {
                System.exit(-1);
            } else {
                return;
            }
        }
        ProfilerInterface.setProfilerServer(profilerServer);
        ProfilerServer.initSupportingFunctionality(true);
        if (_activateCode == 1) {
            while (ProfilerInterface.getCurrentInstrType() == 0 && !ProfilerServer.status.targetAppRunning) {
                ProfilerServer.delay(200);
            }
            ProfilerServer.delay(100);
        }
        ProfilerServer.status.targetAppRunning = true;
    }

    private static void forcedShutdown() {
        ProfilerServer.cleanupOnShutdown();
        preemptExit = false;
        System.exit(-1);
    }

    private static void initInternals() {
        shutdownWaitThread = new ShutdownWaitThread();
        Runtime.getRuntime().addShutdownHook(shutdownWaitThread);
        profilerInterfaceInitialized = false;
        connectionOpen = false;
        connectionFailed = false;
        detachCommandReceived = false;
        profilerServer = null;
        status = null;
        startTargetApp = false;
        startupException = null;
        targetAppRunningLock = new Object();
        execInSeparateThreadLock = new Object();
        try {
            Class.forName("java.net.SocketException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("java.util.AbstractList$Itr");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ThreadInfo.clearProfilerServerThreads();
    }

    private static void initSupportingFunctionality(boolean bl) {
        status = new ProfilingSessionStatus();
        ProfilerServer.status.runningInAttachedMode = bl;
        ProfilerServer.status.targetJDKVersionString = Platform.getJDKVersionString();
        Monitors.initialize();
        profilerServer.initSeparateCmdExecutionThread();
        ThreadInfo.addProfilerServerThread(shutdownWaitThread);
        ProfilerInterface.initProfilerInterface(status, bl ? profilerServer : Thread.currentThread());
        profilerInterfaceInitialized = true;
    }

    private static void pressEnterToShutDown() {
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(ENTER_TO_SHUTDOWN_MSG);
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static void runTargetApp(String var0, String[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForShutdownOK() {
        Object object = shutdownLock;
        synchronized (object) {
            while (!shutdownOK && !Thread.interrupted()) {
                try {
                    shutdownLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Thread.yield();
            }
            if (shutdownOK) {
                return;
            }
        }
        System.err.println("ProfilerServer hasn't shut down cleanly. Terminated.");
    }

    private int getAgentId() {
        if (this.agentId == -1) {
            String string = System.getProperty("nbprofiler.agentid");
            if (string != null) {
                try {
                    this.agentId = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(MessageFormat.format(INCORRECT_AGENT_ID_MSG, string));
                }
            }
            if (this.agentId == -1) {
                this.agentId = (int)(Math.random() * 2.147483648E9);
            }
        }
        return this.agentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLastResponse(Response response) {
        Object object = responseLock;
        synchronized (object) {
            lastResponse = response;
            try {
                responseLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                ProfilerServer.internalError("IllegalMonitorState in ProfilerServer.setLastResponse()");
            }
        }
    }

    private static String getLocalizedJFluidServerJar(String string) {
        File file;
        String string2 = null;
        String string3 = string.replace('\\', '/');
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if (!(file = new File(string3)).exists() || !file.isDirectory()) {
            return null;
        }
        String string4 = string3 + "locale/";
        File file2 = new File(string4);
        if (file2.exists() && file2.isDirectory() && (string2 = ProfilerServer.getLocalizedJFluidServerJarInDir(string4)) != null) {
            return string2;
        }
        string2 = ProfilerServer.getLocalizedJFluidServerJarInDir(string3);
        return string2;
    }

    private static String getLocalizedJFluidServerJarInDir(String string) {
        LocaleIterator localeIterator = new LocaleIterator(Locale.getDefault());
        while (localeIterator.hasNext()) {
            String string2 = string + "jfluid-server" + localeIterator.next() + ".jar";
            File file = new File(string2);
            if (!file.exists() || !file.isFile()) continue;
            return string2;
        }
        return null;
    }

    private static ResourceBundle getProfilerServerResourceBundle(String string) {
        ResourceBundle resourceBundle = null;
        if (string == null) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer, cannot find path to Profiler libraries");
        }
        String string2 = ProfilerServer.getLocalizedJFluidServerJar(string);
        if (string2 == null) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer, cannot find localized jfluid-server.jar");
        }
        try {
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            String string3 = "jar:file:" + string2 + "!/";
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new URL(string3)});
            resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.server.Bundle", Locale.getDefault(), uRLClassLoader);
        }
        catch (Exception exception) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer\n" + exception.getMessage());
        }
        if (resourceBundle == null) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer");
        }
        return resourceBundle;
    }

    private synchronized void closeConnection() {
        connectionOpen = false;
        ProfilerServer.status.targetAppRunning = false;
        this.removeInfoFile();
        try {
            this.socketOut.close();
            this.socketIn.close();
            this.clientSocket.close();
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ProfilerServer.status.runningInAttachedMode) {
            System.out.println(CONNECTION_CLOSED_MSG);
        }
        preemptExit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connectToClient() {
        try {
            if (this.serverTimeout == 0) {
                System.out.println(MessageFormat.format(WAITING_ON_PORT_MSG, "" + this.serverPort, "10"));
            } else {
                System.out.println(MessageFormat.format(WAITING_ON_PORT_TIMEOUT_MSG, "" + this.serverPort, "" + this.serverTimeout, "10"));
            }
            this.serverSocket = new ServerSocket(this.serverPort);
            this.serverSocket.setSoTimeout(this.serverTimeout * 1000);
            this.createInfoFile();
            this.clientSocket = this.serverSocket.accept();
            this.clientSocket.setTcpNoDelay(true);
            this.socketIn = new ObjectInputStream(this.clientSocket.getInputStream());
            this.socketOut = new ObjectOutputStream(this.clientSocket.getOutputStream());
            this.wireIO = new WireIO(this.socketOut, this.socketIn);
            connectionOpen = true;
            System.out.println(CONNECTION_MSG);
            return true;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.err.println(CONNECTION_TIMEOUT_MSG);
            connectionFailed = true;
            return false;
        }
        catch (IOException iOException) {
            System.err.println(MessageFormat.format(CONNECTION_EXCEPTION_MSG, iOException));
            connectionFailed = true;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInfoFile() {
        FilterOutputStream filterOutputStream = null;
        try {
            File file = ProfilerServer.getInfoFile(this.serverPort);
            file.createNewFile();
            file.deleteOnExit();
            Properties properties = new Properties();
            properties.setProperty("dynamic", Boolean.toString(this.dynamic));
            properties.setProperty("working.dir", System.getProperty("user.dir"));
            properties.setProperty("agent.id", Integer.toString(this.getAgentId()));
            properties.setProperty("java.version", System.getProperty("java.version"));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            properties.store(filterOutputStream, "");
            filterOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(MessageFormat.format(AGENT_ERROR_MSG, iOException.getMessage()));
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateThread(int n) {
        Object object = execInSeparateThreadLock;
        synchronized (object) {
            execInSeparateThreadOpCode = n;
            try {
                execInSeparateThreadLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                System.err.println(THREAD_EXCEPTION_MSG);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClientCommand(Command command) {
        if (command.getType() == 2) {
            if (ProfilerServer.status.runningInAttachedMode) {
                ProfilerServer.status.targetAppRunning = true;
                this.sendSimpleResponseToClient(true, null);
                return;
            }
            class MyThread
            extends Thread {
                MyThread() {
                    ThreadInfo.addProfilerServerThread(this);
                    this.setName("*** Profiler Agent Special Execution Thread 4");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = targetAppRunningLock;
                    synchronized (object) {
                        startTargetApp = true;
                        try {
                            targetAppRunningLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            ProfilerServer.internalError("START_TARGET_APP");
                        }
                    }
                    if (startupException != null) {
                        ProfilerServer.this.sendSimpleResponseToClient(false, startupException.toString());
                    } else {
                        ProfilerServer.this.sendSimpleResponseToClient(true, null);
                    }
                    ThreadInfo.removeProfilerServerThread(this);
                }
            }
            new MyThread().start();
            return;
        }
        switch (command.getType()) {
            case 32: {
                this.sendComplexResponseToClient(Monitors.getMonitoredNumbers());
                break;
            }
            case 13: {
                Object object = resultsNotifiedLock;
                synchronized (object) {
                    resultsNotified = false;
                }
                try {
                    ProfilerInterface.initiateInstrumentation((InitiateInstrumentationCommand)command, ProfilerServer.status.targetAppRunning);
                    this.sendSimpleResponseToClient(true, null);
                }
                catch (Exception exception) {
                    this.sendSimpleResponseToClient(false, exception.getMessage());
                }
                break;
            }
            case 7: {
                class InstrumentMethodGroupThread
                extends Thread {
                    final InstrumentMethodGroupCommand methodGroupCmd;
                    String exceptionString;

                    InstrumentMethodGroupThread(InstrumentMethodGroupCommand instrumentMethodGroupCommand) {
                        ThreadInfo.addProfilerServerThread(this);
                        this.setName("*** Profiler Agent Special Execution Thread 8");
                        this.methodGroupCmd = instrumentMethodGroupCommand;
                    }

                    public void run() {
                        try {
                            ProfilerInterface.instrumentMethods(this.methodGroupCmd);
                        }
                        catch (Exception exception) {
                            this.exceptionString = exception.getLocalizedMessage();
                        }
                        ThreadInfo.removeProfilerServerThread(this);
                    }
                }
                InstrumentMethodGroupThread instrumentMethodGroupThread = new InstrumentMethodGroupThread((InstrumentMethodGroupCommand)command);
                instrumentMethodGroupThread.start();
                while (instrumentMethodGroupThread.isAlive()) {
                    ProfilerServer.delay(2000);
                    this.sendSimpleCmdToClient(43);
                }
                if (instrumentMethodGroupThread.exceptionString != null) {
                    this.sendSimpleResponseToClient(false, instrumentMethodGroupThread.exceptionString);
                    break;
                }
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 1: {
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 4: {
                SetChangeableInstrParamsCommand setChangeableInstrParamsCommand = (SetChangeableInstrParamsCommand)command;
                ProfilerRuntimeCPU.setNProfiledThreadsLimit(setChangeableInstrParamsCommand.getNProfiledThreadsLimit());
                ProfilerRuntimeCPUSampledInstr.setSamplingInterval(setChangeableInstrParamsCommand.getSamplingInterval());
                ProfilerRuntimeMemory.setSamplingInterval((short)setChangeableInstrParamsCommand.getObjAllocStackSamplingInterval());
                ProfilerRuntimeMemory.setSamplingDepth(setChangeableInstrParamsCommand.getObjAllocStackSamplingDepth());
                ProfilerRuntimeObjLiveness.setRunGCOnGetResults(setChangeableInstrParamsCommand.getRunGCOnGetResultsInMemoryProfiling());
                Classes.setWaitTrackingEnabled((boolean)setChangeableInstrParamsCommand.getWaitTrackingEnabled());
                Classes.setSleepTrackingEnabled((boolean)setChangeableInstrParamsCommand.getSleepTrackingEnabled());
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 5: {
                SetUnchangeableInstrParamsCommand setUnchangeableInstrParamsCommand = (SetUnchangeableInstrParamsCommand)command;
                ProfilerRuntimeCPU.setTimerTypes(setUnchangeableInstrParamsCommand.getAbsoluteTimerOn(), setUnchangeableInstrParamsCommand.getThreadCPUTimerOn());
                ProfilerServer.status.instrScheme = setUnchangeableInstrParamsCommand.getInstrScheme();
                ProfilerRuntimeCPUCodeRegion.setCPUResBufSize(setUnchangeableInstrParamsCommand.getCodeRegionCPUResBufSize());
                ProfilerRuntimeCPU.enableFirstTimeMethodInvoke(ProfilerServer.status.instrScheme != 3);
                this.setRemoteProfiling(setUnchangeableInstrParamsCommand.getRemoteProfiling());
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 6: {
                this.sendSimpleResponseToClient(ProfilerInterface.cpuResultsExist(), null);
                break;
            }
            case 27: 
            case 40: {
                this.executeInSeparateThread(command.getType());
                break;
            }
            case 8: {
                this.sendComplexResponseToClient(ProfilerInterface.getCodeRegionCPUResults());
                break;
            }
            case 30: {
                this.sendComplexResponseToClient(ProfilerInterface.getObjectAllocationResults());
                break;
            }
            case 31: {
                GetMethodNamesForJMethodIdsCommand getMethodNamesForJMethodIdsCommand = (GetMethodNamesForJMethodIdsCommand)command;
                this.sendComplexResponseToClient(ProfilerInterface.getMethodNamesForJMethodIds(getMethodNamesForJMethodIdsCommand.getMethodIds()));
                break;
            }
            case 29: {
                Object object = resultsNotifiedLock;
                synchronized (object) {
                    resultsNotified = false;
                }
                this.executeInSeparateThread(command.getType());
                break;
            }
            case 9: {
                ProfilerInterface.deactivateInjectedCode();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 16: {
                this.sendComplexResponseToClient(ProfilerInterface.getCurrentThreadLivenessStatus());
                break;
            }
            case 10: {
                ProfilerInterface.suspendTargetApp();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 11: {
                ProfilerInterface.resumeTargetApp();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 12: {
                if (ProfilerInterface.getCurrentInstrType() != 0) {
                    ProfilerInterface.deactivateInjectedCode();
                }
                this.sendSimpleResponseToClient(true, null);
                this.closeConnection();
                preemptExit = false;
                this.doExit();
                break;
            }
            case 15: {
                ProfilerServer.setShutdownOK();
                break;
            }
            case 20: {
                ProfilerInterface.setInstrumentReflection(true);
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 21: {
                ProfilerInterface.setInstrumentReflection(false);
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 33: {
                GC.runGC();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 35: {
                GetDefiningClassLoaderCommand getDefiningClassLoaderCommand = (GetDefiningClassLoaderCommand)command;
                int n = ClassLoaderManager.getDefiningLoaderForClass(getDefiningClassLoaderCommand.getClassName(), getDefiningClassLoaderCommand.getClassLoaderId());
                DefiningLoaderResponse definingLoaderResponse = new DefiningLoaderResponse(n);
                this.sendComplexResponseToClient(definingLoaderResponse);
                break;
            }
            case 28: {
                ProfilerServer.status.jvmArguments = Threads.getJVMArguments();
                ProfilerServer.status.javaCommand = Threads.getJavaCommand();
                VMPropertiesResponse vMPropertiesResponse = new VMPropertiesResponse(Platform.getJavaVersionString(), System.getProperty("java.class.path"), System.getProperty("java.ext.dirs"), System.getProperty("sun.boot.class.path"), System.getProperty("user.dir"), ProfilerServer.status.jvmArguments, ProfilerServer.status.javaCommand, System.getProperty("os.name"), Runtime.getRuntime().maxMemory(), System.currentTimeMillis(), Timers.getCurrentTimeInCounts(), this.getAgentId());
                this.sendComplexResponseToClient(vMPropertiesResponse);
                break;
            }
            case 37: {
                int n = CalibrationDataFileIO.readSavedCalibrationData(status);
                if (n == 0) {
                    CalibrationDataResponse calibrationDataResponse = new CalibrationDataResponse(ProfilerServer.status.methodEntryExitCallTime, ProfilerServer.status.methodEntryExitInnerTime, ProfilerServer.status.methodEntryExitOuterTime, ProfilerServer.status.timerCountsInSecond);
                    profilerServer.sendComplexResponseToClient(calibrationDataResponse);
                    break;
                }
                this.sendSimpleResponseToClient(false, CalibrationDataFileIO.getErrorMessage());
                break;
            }
            case 34: {
                ProfilerCalibrator.init(status);
                ProfilerCalibrator.measureBCIOverhead(false);
                CalibrationDataResponse calibrationDataResponse = new CalibrationDataResponse(ProfilerServer.status.methodEntryExitCallTime, ProfilerServer.status.methodEntryExitInnerTime, ProfilerServer.status.methodEntryExitOuterTime, ProfilerServer.status.timerCountsInSecond);
                profilerServer.sendComplexResponseToClient(calibrationDataResponse);
                break;
            }
            case 24: {
                ProfilerCalibrator.init(status);
                this.sendComplexResponseToClient(ProfilerCalibrator.getInternalStats());
                break;
            }
            case 25: {
                ProfilerInterface.deactivateInjectedCode();
                ProfilerInterface.disableProfilerHooks();
                ProfilerInterface.clearProfilerDataStructures();
                this.stopSeparateCmdExecutionThread();
                Monitors.shutdown();
                ThreadInfo.clearProfilerServerThreads();
                detachCommandReceived = true;
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 41: {
                TakeHeapDumpCommand takeHeapDumpCommand = (TakeHeapDumpCommand)command;
                String string = HeapDump.takeHeapDump((Platform.getJDKVersionNumber() == 2 ? 1 : 0) != 0, (String)takeHeapDumpCommand.getOutputFile());
                this.sendSimpleResponseToClient(string == null, string);
            }
        }
    }

    private void doExit() {
        try {
            ClassLoader classLoader;
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.openide.util.Lookup");
            Method method = clazz.getMethod("getDefault", new Class[0]);
            Method method2 = clazz.getMethod("lookup", Class.class);
            Object object = method.invoke(clazz, new Object[0]);
            if (object != null && (classLoader = (ClassLoader)method2.invoke(object, (Object[])new Class[]{ClassLoader.class})) != null) {
                Class<?> clazz2 = classLoader.loadClass("org.openide.LifecycleManager");
                Method method3 = clazz2.getMethod("getDefault", new Class[0]);
                Method method4 = clazz2.getMethod("exit", new Class[0]);
                Object object2 = method3.invoke(clazz2, new Object[0]);
                method4.invoke(object2, new Object[0]);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(-1);
    }

    private void handleIOExceptionOnSend(IOException iOException) {
        System.err.println(MessageFormat.format(RESPONSE_EXCEPTION_MSG, iOException));
        iOException.printStackTrace(System.err);
        this.closeConnection();
    }

    private void initSeparateCmdExecutionThread() {
        separateCmdExecutionThread = new SeparateCmdExecutionThread();
        separateCmdExecutionThread.start();
    }

    private static void internalError(String string) {
        ProfilerServer.internalError(string, true);
    }

    private static void internalError(String string, boolean bl) {
        System.err.println("Profiler Engine Error: " + string);
        if (bl) {
            preemptExit = false;
            System.exit(-1);
        }
    }

    private void listenToClient() {
        while (connectionOpen && !detachCommandReceived) {
            try {
                Object object = this.wireIO.receiveCommandOrResponse();
                if (object == null) {
                    System.err.println(CONNECTION_INTERRUPTED_MSG);
                    break;
                }
                if (object instanceof Command) {
                    this.handleClientCommand((Command)object);
                    continue;
                }
                ProfilerServer.setLastResponse((Response)object);
            }
            catch (IOException iOException) {
                if (!connectionOpen || detachCommandReceived) break;
                System.err.println(MessageFormat.format(COMMAND_EXCEPTION_MSG, iOException));
                break;
            }
        }
        this.closeConnection();
    }

    private void removeInfoFile() {
        try {
            ProfilerServer.getInfoFile(this.serverPort).delete();
        }
        catch (IOException iOException) {
            System.err.println(MessageFormat.format(AGENT_ERROR_MSG, iOException.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSeparateCmdExecutionThread() {
        separateCmdExecutionThread.terminate();
        Object object = execInSeparateThreadLock;
        synchronized (object) {
            try {
                execInSeparateThreadLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ String access$600() {
        return THREAD_WAIT_EXCEPTION_MSG;
    }

    static {
        ENTER_TO_SHUTDOWN_MSG = "Press ENTER to shut down the target JVM...";
        MAIN_CLASS_NOT_PUBLIC_MSG = "Main class {0} is not public.\nProfiler can not start it";
        INCORRECT_MAIN_MODIFIERS_MSG = "Method {0}.main(String args[]) has incorrect modifiers";
        UNEXPECTED_EXCEPTION_MSG = "Target application threw an unexpected exception: {0}";
        ELAPSED_TIME_MSG = "Main application thread elapsed time: {0} ms.";
        CONNECTION_MSG = "Profiler Agent: Established connection with the tool";
        WAITING_ON_PORT_MSG = "Profiler Agent: Waiting for connection on port {0} (Protocol version: {1})";
        WAITING_ON_PORT_TIMEOUT_MSG = "Profiler Agent: Waiting for connection on port {0}, timeout {1} seconds (Protocol version: {2})";
        CONNECTION_EXCEPTION_MSG = "Profiler Agent Error: Exception when trying to establish connection with client:\n{0}";
        CONNECTION_TIMEOUT_MSG = "Profiler Agent Error: Timed out trying to establish connection with client";
        AGENT_ERROR_MSG = "Profiler Agent Error: {0}";
        CONNECTION_INTERRUPTED_MSG = "Profiler Agent Error: Connection with client interrupted";
        COMMAND_EXCEPTION_MSG = "Profiler Agent Error: Exception when handling command from client:\n{0}";
        RESPONSE_EXCEPTION_MSG = "Profiler Agent Error: Exception when trying to send response or command to client:\n{0}";
        CONNECTION_CLOSED_MSG = "Profiler Agent: Connection with agent closed";
        INCORRECT_AGENT_ID_MSG = "Profiler Agent Warning: Wrong agentId specified: {0}";
        THREAD_EXCEPTION_MSG = "Profiler Agent Error: Exception in executeInSeparateThread()";
        THREAD_WAIT_EXCEPTION_MSG = "Profiler Agent Error: Exception in wait in SeparateCmdExecutionThread";
        LOCAL_SESSION_MSG = "Profiler Agent: Local accelerated session";
        REMOTE_SESSION_MSG = "Profiler Agent: Standard session";
        preemptExit = true;
        shutdownOK = false;
        shutdownLock = new Object();
        resultsNotifiedLock = new Object();
        resultsNotified = false;
        resourcesInitialized = false;
        _timeOut = 0;
        responseLock = new Object();
    }

    private class SeparateCmdExecutionThread
    extends Thread {
        private volatile boolean stopped = false;

        public SeparateCmdExecutionThread() {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 6");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            var1_1 = ProfilerServer.execInSeparateThreadLock;
            // MONITORENTER : var1_1
            block13: while (true) {
                try {
                    ProfilerServer.execInSeparateThreadLock.wait();
                }
                catch (InterruptedException var2_3) {
                    System.err.println(ProfilerServer.access$600());
                }
                if (this.stopped) {
                    // MONITOREXIT : var1_1
                    return;
                }
                var2_2 = ProfilerServer.execInSeparateThreadOpCode;
                switch (var2_2) {
                    case 27: 
                    case 40: {
                        var3_4 = ProfilerRuntimeCPU.getAbsTimeStampInCollectedFormat();
                        var5_5 = false;
                        if (ProfilerRuntime.eventBuffer == null || ProfilerRuntime.sendingBuffer) ** GOTO lbl29
                        var6_6 /* !! */  = ProfilerRuntime.eventBuffer;
                        // MONITORENTER : org.netbeans.lib.profiler.server.ProfilerRuntime.eventBuffer
                        var5_5 = ProfilerInterface.serialClientOperationsLock.beginTrans(true, true);
                        if (var5_5) {
                            try {
                                ProfilerInterface.dumpExistingResults(var2_2 == 40);
                            }
                            finally {
                                ProfilerInterface.serialClientOperationsLock.endTrans();
                            }
                        }
                        // MONITOREXIT : var6_6 /* !! */ 
lbl29:
                        // 2 sources

                        var6_6 /* !! */  = (byte[])new DumpResultsResponse(var5_5, var3_4);
                        ProfilerServer.this.sendComplexResponseToClient((Response)var6_6 /* !! */ );
                        break;
                    }
                    case 29: {
                        ProfilerServer.requestClientResetResults();
                        ProfilerServer.this.sendSimpleResponseToClient(true, null);
                        continue block13;
                    }
                }
            }
        }

        public void terminate() {
            this.stopped = true;
        }
    }

    private static class ShutdownWaitThread
    extends Thread {
        public ShutdownWaitThread() {
            this.setName("*** Profiler Agent Special Execution Thread 7");
        }

        public void run() {
            if (preemptExit && connectionOpen) {
                profilerServer.sendSimpleCmdToClient(18);
                ProfilerServer.waitForShutdownOK();
                ProfilerServer.cleanupOnShutdown();
            }
        }
    }

    private static class LocaleIterator
    implements Iterator {
        private Locale initLocale;
        private Locale locale;
        private String branding;
        private String current;
        private boolean defaultInProgress = false;
        private boolean empty = false;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = null;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String string = this.branding == null ? this.current : this.branding + this.current;
            int n = this.current.lastIndexOf(95);
            if (n == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (n == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, n);
            }
            return string;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int n = this.branding.lastIndexOf(95);
                this.branding = n == 0 ? null : this.branding.substring(0, n);
                this.empty = false;
            } else {
                this.current = null;
            }
        }
    }

    private static class AttachDynamicThread
    extends Thread {
        private int activateCode;

        AttachDynamicThread(int n) {
            this.setName("*** Profiler Agent Special Execution Thread 5");
            this.activateCode = n;
        }

        public void run() {
            try {
                ProfilerServer.doActivate(this.activateCode);
            }
            catch (Throwable throwable) {
                System.err.println("Profiler dynamic attach initialization failed due to:");
                throwable.printStackTrace();
            }
        }
    }
}

