/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import java.util.List;
import sun.jvm.hotspot.debugger.MachineDescriptionIntelX86;
import sun.jvm.hotspot.debugger.ProcessInfo;
import sun.jvm.hotspot.debugger.win32.Win32DebuggerLocal;

public class TestDebugger {
    private static void usage() {
        System.out.println("usage: java TestDebugger [pid]");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                TestDebugger.usage();
            }
            int pid = 0;
            try {
                pid = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                TestDebugger.usage();
            }
            Win32DebuggerLocal debugger = new Win32DebuggerLocal(new MachineDescriptionIntelX86(), true);
            System.err.println("Process list: ");
            List processes = debugger.getProcessList();
            for (ProcessInfo info : processes) {
                System.err.println(info.getPid() + " " + info.getName());
            }
            System.err.println("Trying to attach...");
            debugger.attach(pid);
            System.err.println("Attach succeeded.");
            System.err.println("Trying to detach...");
            if (!debugger.detach()) {
                System.err.println("ERROR: detach failed.");
                System.exit(0);
            }
            System.err.println("Detach succeeded.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

