/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public abstract class ClassInfo
extends BaseClassInfo
implements JavaClassConstants,
CommonConstants {
    String packageName;
    String superName;
    char[] cpoolRefsToClassIdx;
    String[] cpoolRefsToClassName;
    String[][] cpoolRefsToMethodClassNameAndSig;
    char[] cpoolRefsToMethodIdx;
    int[] exceptionTableStartOffsets;
    String[] interfaces;
    char[] lineNumberTablesLengths;
    int[] lineNumberTablesOffsets;
    int localVaribaleTableCPindex;
    char[] localVariableTablesLengths;
    int[] localVariableTablesOffsets;
    int localVaribaleTypeTableCPindex;
    char[] localVariableTypeTablesLengths;
    int[] localVariableTypeTablesOffsets;
    int stackMapTableCPindex;
    char[] stackMapTablesLengths;
    int[] stackMapTablesOffsets;
    char[] methodAccessFlags;
    char[] methodBytecodesLengths;
    int[] methodBytecodesOffsets;
    int[] methodInfoLengths;
    int[] methodInfoOffsets;
    String[] methodNames;
    String[] methodSignatures;
    String[] nestedClassNames;
    int majorVersion;
    int classIndex;
    char accessFlags;
    int attrsStartOfs;
    int cpoolStartOfs;
    int fieldsStartOfs;
    int intermediateDataStartOfs;
    int methodsStartOfs;
    int origCPoolCount;
    private LineNumberTables lineNumberTables;
    private LocalVariableTables localVariableTables;
    private LocalVariableTypeTables localVariableTypeTables;
    private StackMapTables stackMapTables;

    protected ClassInfo(String string, int n) {
        super(string, n);
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    ClassInfo(byte[] byArray) throws ClassFormatError {
        super("", 0);
        try {
            new ClassFileParser().parseClassFile(byArray, this);
        }
        catch (ClassFileParser.ClassFileReadException classFileReadException) {
            throw new ClassFormatError(classFileReadException.getMessage());
        }
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.accessFlags);
    }

    public int getExceptionTableStartOffsetInMethodInfo(int n) {
        return this.exceptionTableStartOffsets[n];
    }

    public int getExceptionTableCount(int n) {
        int n2 = this.getExceptionTableStartOffsetInMethodInfo(n);
        byte[] byArray = this.getMethodInfo(n);
        return ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
    }

    public int getLocalVariableTableStartOffsetInMethodInfo(int n) {
        return this.localVariableTablesOffsets[n];
    }

    public int getLocalVariableTypeTableStartOffsetInMethodInfo(int n) {
        return this.localVariableTypeTablesOffsets[n];
    }

    public int getStackMapTableStartOffsetInMethodInfo(int n) {
        return this.stackMapTablesOffsets[n];
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    public LineNumberTables getLineNumberTables() {
        this.initLineNumberTables();
        return this.lineNumberTables;
    }

    public LocalVariableTables getLocalVariableTables() {
        this.initLocalVariableTables();
        return this.localVariableTables;
    }

    public LocalVariableTypeTables getLocalVariableTypeTables() {
        this.initLocalVariableTypeTables();
        return this.localVariableTypeTables;
    }

    public StackMapTables getStackMapTables() {
        this.initStackMapTables();
        return this.stackMapTables;
    }

    public boolean isMethodAbstract(int n) {
        return Modifier.isAbstract(this.methodAccessFlags[n]);
    }

    public byte[] getMethodBytecode(int n) {
        try {
            byte[] byArray = this.getClassFileBytes();
            byte[] byArray2 = new byte[this.methodBytecodesLengths[n]];
            System.arraycopy(byArray, this.methodInfoOffsets[n] + this.methodBytecodesOffsets[n], byArray2, 0, this.methodBytecodesLengths[n]);
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public int getMethodBytecodeOffsetInMethodInfo(int n) {
        return this.methodBytecodesOffsets[n];
    }

    public int getMethodBytecodesLength(int n) {
        return this.methodBytecodesLengths[n];
    }

    public boolean isMethodFinal(int n) {
        return Modifier.isFinal(this.methodAccessFlags[n]);
    }

    public int getMethodIndex(String string, String string2) {
        for (int i = 0; i < this.methodNames.length; ++i) {
            if (this.methodNames[i] != string || this.methodSignatures[i] != string2) continue;
            return i;
        }
        return -1;
    }

    public byte[] getMethodInfo(int n) {
        try {
            byte[] byArray = this.getClassFileBytes();
            byte[] byArray2 = new byte[this.methodInfoLengths[n]];
            System.arraycopy(byArray, this.methodInfoOffsets[n], byArray2, 0, this.methodInfoLengths[n]);
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public int getMethodInfoLength(int n) {
        return this.methodInfoLengths[n];
    }

    public String getMethodName(int n) {
        return this.methodNames[n];
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public boolean isMethodNative(int n) {
        return Modifier.isNative(this.methodAccessFlags[n]);
    }

    public boolean isMethodPrivate(int n) {
        return Modifier.isPrivate(this.methodAccessFlags[n]);
    }

    public boolean isMethodProtected(int n) {
        return Modifier.isProtected(this.methodAccessFlags[n]);
    }

    public boolean isMethodPublic(int n) {
        return Modifier.isPublic(this.methodAccessFlags[n]);
    }

    public String getMethodSignature(int n) {
        return this.methodSignatures[n];
    }

    public String[] getMethodSignatures() {
        return this.methodSignatures;
    }

    public boolean isMethodStatic(int n) {
        return Modifier.isStatic(this.methodAccessFlags[n]);
    }

    public int[] getMinAndMaxLinesForMethod(int n) {
        this.initLineNumberTables();
        return this.lineNumberTables.getMinAndMaxLinesForMethod(n);
    }

    public String[] getNestedClassNames() {
        return this.nestedClassNames;
    }

    public int getOrigAttrsStartOfs() {
        return this.attrsStartOfs;
    }

    public int getOrigCPoolCount() {
        return this.origCPoolCount;
    }

    public int getOrigCPoolStartOfs() {
        return this.cpoolStartOfs;
    }

    public int getOrigFieldsStartOfs() {
        return this.fieldsStartOfs;
    }

    public int getOrigIntermediateDataStartOfs() {
        return this.intermediateDataStartOfs;
    }

    public int getOrigMethodsStartOfs() {
        return this.methodsStartOfs;
    }

    public String getRefClassName(int n) {
        for (int i = 0; i < this.cpoolRefsToClassIdx.length; ++i) {
            if (this.cpoolRefsToClassIdx[i] != n) continue;
            return this.cpoolRefsToClassName[i];
        }
        return null;
    }

    public int getCPIndexOfClass(String string) {
        int n = -1;
        for (int i = 0; i < this.cpoolRefsToClassName.length; ++i) {
            if (!this.cpoolRefsToClassName[i].equals(string)) continue;
            n = this.cpoolRefsToClassIdx[i];
        }
        return n;
    }

    public String[] getRefMethodsClassNameAndSig(int n) {
        for (int i = 0; i < this.cpoolRefsToMethodIdx.length; ++i) {
            if (this.cpoolRefsToMethodIdx[i] != n) continue;
            return this.cpoolRefsToMethodClassNameAndSig[i];
        }
        return null;
    }

    public String getSuperclassName() {
        return this.superName;
    }

    public int bciForMethodAndLineNo(int n, int n2) {
        this.initLineNumberTables();
        return this.lineNumberTables.bciForLineNo(n, n2);
    }

    public int checkIfAtGoTo(int n, int n2) {
        byte[] byArray = this.getMethodBytecode(n);
        int n3 = byArray[n2] & 0xFF;
        if (n3 != 167 && n3 != 200) {
            return n2;
        }
        return ClassInfo.findPreviousBCI(byArray, n2);
    }

    public boolean containsMethod(String string, String string2) {
        return this.getMethodIndex(string, string2) != -1;
    }

    public static int findPreviousBCI(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        block4: while (n3 < n) {
            n2 = n3;
            int n4 = byArray[n3] & 0xFF;
            if (n4 == 196) {
                n4 = byArray[n3 + 1] & 0xFF;
                if (n4 >= 21 && n4 <= 25 || n4 >= 54 && n4 <= 58 || n4 == 169) {
                    n3 += 4;
                    continue;
                }
                if (n4 == 132) {
                    n3 += 6;
                    continue;
                }
                ++n3;
                continue;
            }
            switch (n4) {
                case 170: {
                    int n5 = n3 + 1 + 3 & 0xFFFFFFFC;
                    long l = ClassInfo.intAt(byArray, n5, 0);
                    long l2 = ClassInfo.intAt(byArray, n5, 1);
                    long l3 = ClassInfo.intAt(byArray, n5, 2);
                    n3 = (n5 += 12) + (int)(l3 - l2 + 1L << 2);
                    continue block4;
                }
                case 171: {
                    int n5 = n3 + 1 + 3 & 0xFFFFFFFC;
                    long l = ClassInfo.intAt(byArray, n5, 0);
                    int n6 = (int)ClassInfo.intAt(byArray, n5, 1);
                    int n7 = n6 * 2;
                    n3 = (n5 += 8) + (n7 << 2);
                    continue block4;
                }
            }
            n3 += opc_length[n4];
        }
        return n2;
    }

    public int lineNoForMethodAndBci(int n, int n2) {
        this.initLineNumberTables();
        return this.lineNumberTables.lineNoForBci(n, n2);
    }

    public int[] methodIdxAndBestBCIForLineNo(int n) {
        int n2;
        int n3;
        this.initLineNumberTables();
        if (!this.lineNumberTables.hasTable()) {
            return new int[]{-2, -2};
        }
        int n4 = this.methodNames.length;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.methodNames[n3] == "<init>" || this.methodNames[n3] == "<clinit>" || (n2 = this.lineNumberTables.bciForLineNo(n3, n)) == -1) continue;
            return new int[]{n3, n2};
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.methodNames[n3] != "<init>" && this.methodNames[n3] != "<clinit>" || (n2 = this.lineNumberTables.bciForLineNo(n3, n)) == -1) continue;
            return new int[]{n3, n2};
        }
        return new int[]{-1, -1};
    }

    public int overridesVirtualMethod(ClassInfo classInfo, int n) {
        int n2 = this.getMethodIndex(classInfo.methodNames[n], classInfo.methodSignatures[n]);
        if (n2 == -1) {
            return -1;
        }
        if (classInfo.isMethodPublic(n) || classInfo.isMethodProtected(n)) {
            return n2;
        }
        if (classInfo.packageName == this.packageName) {
            return n2;
        }
        return -1;
    }

    protected abstract byte[] getClassFileBytes() throws IOException, ClassNotFoundException;

    protected static String getPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n).intern();
    }

    static long intAt(byte[] byArray, int n, int n2) {
        int n3 = n + (n2 << 2);
        return byArray[n3] << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
    }

    static void putU2(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    static int getU2(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    private synchronized void initLineNumberTables() {
        if (this.lineNumberTables == null) {
            this.lineNumberTables = new LineNumberTables(this);
        }
    }

    private synchronized void initLocalVariableTables() {
        if (this.localVariableTables == null) {
            this.localVariableTables = new LocalVariableTables(this);
        }
    }

    private synchronized void initLocalVariableTypeTables() {
        if (this.localVariableTypeTables == null) {
            this.localVariableTypeTables = new LocalVariableTypeTables(this);
        }
    }

    private synchronized void initStackMapTables() {
        if (this.stackMapTables == null) {
            this.stackMapTables = new StackMapTables();
        }
    }

    static class FullStackMapFrame
    extends StackMapFrame {
        int[] localsCPIdx;
        int[] stacksCPIdx;

        FullStackMapFrame(int n, int[] nArray, int[] nArray2) {
            super(StackMapFrame.FrameType.FULL_FRAME, n, nArray2.length * 3 + (nArray.length > 0 && nArray[0] == 0 ? nArray.length : 3 * nArray.length));
            this.localsCPIdx = nArray;
            this.stacksCPIdx = nArray2;
        }

        @Override
        void writeFrame(byte[] byArray, int n) {
            int n2;
            byArray[n++] = -1;
            ClassInfo.putU2(byArray, n, this.storedOffsetDelta);
            ClassInfo.putU2(byArray, n += 2, this.localsCPIdx.length);
            n += 2;
            for (n2 = 0; n2 < this.localsCPIdx.length; ++n2) {
                int n3 = this.localsCPIdx[n2];
                if (n3 == 0) {
                    byArray[n++] = 0;
                    continue;
                }
                byArray[n++] = 7;
                ClassInfo.putU2(byArray, n, n3);
                n += 2;
            }
            ClassInfo.putU2(byArray, n, this.stacksCPIdx.length);
            n += 2;
            for (n2 = 0; n2 < this.stacksCPIdx.length; ++n2) {
                byArray[n++] = 7;
                ClassInfo.putU2(byArray, n, this.stacksCPIdx[n2]);
                n += 2;
            }
        }
    }

    static class StackMapFrame {
        FrameType frameType;
        int storedOffsetDelta;
        int size;
        boolean modified;
        boolean frameModified;
        boolean uninitializedListModified;
        List<Integer> uninitializedList;

        StackMapFrame(FrameType frameType, int n, int n2) {
            this.frameType = frameType;
            this.storedOffsetDelta = n - 1;
            this.size = frameType.size() + n2;
        }

        StackMapFrame(byte[] byArray, int n) {
            int n2 = byArray[n++] & 0xFF;
            if (n2 <= 63) {
                this.frameType = FrameType.SAME;
                this.storedOffsetDelta = n2;
            } else if (n2 <= 127) {
                this.frameType = FrameType.SAME_LOCALS_1_STACK_ITEM;
                this.storedOffsetDelta = n2 - 64;
                this.size = this.getVerificationTypeInfoSize(byArray[n]);
                this.storeUninitializedVariableInfo(byArray, n, 0);
            } else {
                if (n2 <= 246) {
                    throw new IllegalArgumentException("Type: " + n2);
                }
                if (n2 == 247) {
                    this.frameType = FrameType.SAME_LOCALS_1_STACK_ITEM_EXTENDED;
                    this.storedOffsetDelta = ClassInfo.getU2(byArray, n);
                    this.size = this.getVerificationTypeInfoSize(byArray[n += 2]);
                    this.storeUninitializedVariableInfo(byArray, n, 0);
                } else if (n2 <= 250) {
                    this.frameType = FrameType.CHOP;
                    this.storedOffsetDelta = ClassInfo.getU2(byArray, n);
                } else if (n2 == 251) {
                    this.frameType = FrameType.SAME_FRAME_EXTENDED;
                    this.storedOffsetDelta = ClassInfo.getU2(byArray, n);
                } else if (n2 <= 254) {
                    this.frameType = FrameType.APPEND;
                    this.storedOffsetDelta = ClassInfo.getU2(byArray, n);
                    n += 2;
                    int n3 = n2 - 251;
                    for (int i = 0; i < n3; ++i) {
                        int n4 = this.getVerificationTypeInfoSize(byArray[n]);
                        this.size += n4;
                        this.storeUninitializedVariableInfo(byArray, n, i);
                        n += n4;
                    }
                } else if (n2 == 255) {
                    int n5;
                    int n6;
                    this.frameType = FrameType.FULL_FRAME;
                    this.storedOffsetDelta = ClassInfo.getU2(byArray, n);
                    int n7 = ClassInfo.getU2(byArray, n += 2);
                    n += 2;
                    for (n6 = 0; n6 < n7; ++n6) {
                        n5 = this.getVerificationTypeInfoSize(byArray[n]);
                        this.size += n5;
                        this.storeUninitializedVariableInfo(byArray, n, n6);
                        n += n5;
                    }
                    n6 = ClassInfo.getU2(byArray, n);
                    n += 2;
                    for (n5 = 0; n5 < n6; ++n5) {
                        int n8 = this.getVerificationTypeInfoSize(byArray[n]);
                        this.size += n8;
                        this.storeUninitializedVariableInfo(byArray, n, n7 + n5);
                        n += n8;
                    }
                } else {
                    throw new IllegalArgumentException("Type: " + n2);
                }
            }
            this.size += this.frameType.size();
        }

        int getSize() {
            return this.size;
        }

        void setFrameType(FrameType frameType) {
            int n = frameType.size() - this.frameType.size();
            this.frameType = frameType;
            this.size += n;
            this.frameModified = true;
        }

        private int getVerificationTypeInfoSize(byte by) {
            switch (by) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return 1;
                }
                case 7: 
                case 8: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Type " + by);
        }

        public String toString() {
            return "StackMapFrame " + (Object)((Object)this.frameType) + " offsetDelta " + this.getOffsetDelta() + " size " + this.getSize();
        }

        private int getOffsetDelta() {
            return this.storedOffsetDelta + 1;
        }

        private void setOffsetDelta(int n) {
            this.storedOffsetDelta = n - 1;
            this.modified = true;
        }

        private void updateUnitilializedList(int n, int n2) {
            if (this.uninitializedList != null) {
                for (int i = 0; i < this.uninitializedList.size(); ++i) {
                    int n3;
                    Integer n4 = this.uninitializedList.get(i);
                    if (n4 == null || (n3 = n4.intValue()) <= n) continue;
                    this.uninitializedList.set(i, n3 + n2);
                    this.uninitializedListModified = true;
                }
            }
        }

        private void storeUninitializedVariableInfo(byte[] byArray, int n, int n2) {
            byte by;
            if ((by = byArray[n++]) == 8) {
                if (this.uninitializedList == null) {
                    this.uninitializedList = new ArrayList<Integer>();
                }
                while (this.uninitializedList.size() < n2 + 1) {
                    this.uninitializedList.add(null);
                }
                this.uninitializedList.set(n2, ClassInfo.getU2(byArray, n));
            }
        }

        void writeFrame(byte[] byArray, int n) {
            if (this.modified) {
                if (this.frameModified) {
                    switch (this.frameType) {
                        case SAME_LOCALS_1_STACK_ITEM_EXTENDED: {
                            byArray[n] = -9;
                            break;
                        }
                        case SAME_FRAME_EXTENDED: {
                            byArray[n] = -5;
                        }
                    }
                }
                switch (this.frameType) {
                    case SAME: {
                        byArray[n] = (byte)(this.storedOffsetDelta & 0x3F);
                        break;
                    }
                    case SAME_LOCALS_1_STACK_ITEM: {
                        byArray[n] = (byte)(64 + (this.storedOffsetDelta & 0x3F));
                        break;
                    }
                    case SAME_LOCALS_1_STACK_ITEM_EXTENDED: 
                    case SAME_FRAME_EXTENDED: 
                    case CHOP: 
                    case APPEND: 
                    case FULL_FRAME: {
                        ClassInfo.putU2(byArray, n + 1, this.storedOffsetDelta);
                    }
                }
            }
            if (this.uninitializedListModified) {
                switch (this.frameType) {
                    case SAME_LOCALS_1_STACK_ITEM: {
                        ClassInfo.putU2(byArray, n + 2, this.uninitializedList.get(0));
                        break;
                    }
                    case SAME_LOCALS_1_STACK_ITEM_EXTENDED: {
                        ClassInfo.putU2(byArray, n + 3, this.uninitializedList.get(0));
                        break;
                    }
                    case APPEND: {
                        int n2 = n + 3;
                        for (Integer n3 : this.uninitializedList) {
                            byte by = byArray[n2];
                            int n4 = this.getVerificationTypeInfoSize(by);
                            if (by == 8) {
                                ClassInfo.putU2(byArray, n2 + 1, n3);
                            }
                            n2 += n4;
                        }
                        break;
                    }
                    case FULL_FRAME: {
                        int n5;
                        int n6;
                        int n7 = n + 3;
                        int n8 = ClassInfo.getU2(byArray, n7);
                        n7 += 2;
                        for (n6 = 0; n6 < n8; ++n6) {
                            n5 = byArray[n7];
                            int by = this.getVerificationTypeInfoSize((byte)n5);
                            if (n5 == 8) {
                                ClassInfo.putU2(byArray, n7 + 1, this.uninitializedList.get(n6));
                            }
                            n7 += by;
                        }
                        n6 = ClassInfo.getU2(byArray, n7);
                        n7 += 2;
                        for (n5 = 0; n5 < n6; ++n5) {
                            byte by = byArray[n7];
                            int n2 = this.getVerificationTypeInfoSize(by);
                            if (by == 8) {
                                ClassInfo.putU2(byArray, n7 + 1, this.uninitializedList.get(n8 + n5));
                            }
                            n7 += n2;
                        }
                        break;
                    }
                }
            }
        }

        static enum FrameType {
            SAME(1),
            SAME_LOCALS_1_STACK_ITEM(1),
            SAME_LOCALS_1_STACK_ITEM_EXTENDED(3),
            CHOP(3),
            SAME_FRAME_EXTENDED(3),
            APPEND(3),
            FULL_FRAME(7);

            private int frameSize;

            int size() {
                return this.frameSize;
            }

            private FrameType(int n2) {
                this.frameSize = n2;
            }
        }
    }

    public class StackMapTables {
        private StackMapFrame[][] frames;
        private byte[][] framesBytes;
        private boolean hasTable;

        StackMapTables() {
            byte[] byArray = null;
            try {
                byArray = ClassInfo.this.getClassFileBytes();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            int n = ClassInfo.this.getMethodNames().length;
            this.frames = new StackMapFrame[n][];
            this.framesBytes = new byte[n][];
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                int n4 = ClassInfo.this.stackMapTablesLengths[i];
                if (n4 == 0) continue;
                int n5 = n3 = ClassInfo.this.methodInfoOffsets[i] + ClassInfo.this.stackMapTablesOffsets[i];
                this.frames[i] = new StackMapFrame[n4];
                StackMapFrame[] stackMapFrameArray = this.frames[i];
                for (n2 = 0; n2 < n4; ++n2) {
                    stackMapFrameArray[n2] = new StackMapFrame(byArray, n5);
                    n5 += stackMapFrameArray[n2].getSize();
                }
                n2 = n5 - n3;
                this.framesBytes[i] = new byte[n2 + n4 + 2 * (StackMapFrame.FrameType.FULL_FRAME.size() + 6)];
                System.arraycopy(byArray, n3, this.framesBytes[i], 0, n2);
                this.hasTable = true;
            }
        }

        public boolean hasTable() {
            return this.hasTable;
        }

        public void updateTable(int n, int n2, int n3) {
            StackMapFrame[] stackMapFrameArray;
            if (this.hasTable() && (stackMapFrameArray = this.frames[n3]) != null) {
                int n4 = -1;
                boolean bl = false;
                for (StackMapFrame stackMapFrame : stackMapFrameArray) {
                    int n5 = stackMapFrame.getOffsetDelta();
                    if (!bl && (n4 += n5) > n) {
                        this.setOffsetDelta(n3, stackMapFrame, n5 + n2);
                        bl = true;
                    }
                    stackMapFrame.updateUnitilializedList(n, n2);
                }
            }
        }

        public int getNumberOfFrames(int n) {
            StackMapFrame[] stackMapFrameArray = this.frames[n];
            if (stackMapFrameArray != null) {
                return stackMapFrameArray.length;
            }
            return 0;
        }

        public byte[] getAttributeHeader(int n) {
            byte[] byArray = new byte[8];
            ClassInfo.putU2(byArray, 0, ClassInfo.this.stackMapTableCPindex);
            return byArray;
        }

        public byte[] writeTable(int n) {
            StackMapFrame[] stackMapFrameArray = this.frames[n];
            byte[] byArray = this.framesBytes[n];
            if (stackMapFrameArray != null) {
                int n2 = 0;
                for (StackMapFrame stackMapFrame : stackMapFrameArray) {
                    stackMapFrame.writeFrame(byArray, n2);
                    n2 += stackMapFrame.getSize();
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
            return null;
        }

        void addFullStackMapFrameEntry(int n, int n2, int[] nArray, int[] nArray2) {
            StackMapFrame[] stackMapFrameArray = this.frames[n];
            if (stackMapFrameArray != null) {
                int n3 = -1;
                for (StackMapFrame stackMapFrame : stackMapFrameArray) {
                    n3 += stackMapFrame.getOffsetDelta();
                }
                this.frames[n] = new StackMapFrame[stackMapFrameArray.length + 1];
                StackMapFrame[] stackMapFrameArray2 = this.frames[n];
                System.arraycopy(stackMapFrameArray, 0, stackMapFrameArray2, 0, stackMapFrameArray.length);
                stackMapFrameArray2[stackMapFrameArray.length] = new FullStackMapFrame(n2 - n3, nArray, nArray2);
            } else {
                this.frames[n] = new StackMapFrame[1];
                StackMapFrame[] stackMapFrameArray3 = this.frames[n];
                stackMapFrameArray3[0] = new FullStackMapFrame(n2 + 1, nArray, nArray2);
                this.framesBytes[n] = new byte[stackMapFrameArray3[0].getSize()];
                this.hasTable = true;
            }
        }

        private void setOffsetDelta(int n, StackMapFrame stackMapFrame, int n2) {
            StackMapFrame.FrameType frameType = stackMapFrame.frameType;
            if (frameType.equals((Object)StackMapFrame.FrameType.SAME) && n2 > 63) {
                this.extendFrame(n, stackMapFrame, 2);
                stackMapFrame.setFrameType(StackMapFrame.FrameType.SAME_FRAME_EXTENDED);
            }
            if (frameType.equals((Object)StackMapFrame.FrameType.SAME_LOCALS_1_STACK_ITEM) && n2 > 63) {
                this.extendFrame(n, stackMapFrame, 2);
                stackMapFrame.setFrameType(StackMapFrame.FrameType.SAME_LOCALS_1_STACK_ITEM_EXTENDED);
            }
            stackMapFrame.setOffsetDelta(n2);
        }

        private void extendFrame(int n, StackMapFrame stackMapFrame, int n2) {
            StackMapFrame[] stackMapFrameArray = this.frames[n];
            byte[] byArray = this.framesBytes[n];
            int n3 = 0;
            for (StackMapFrame stackMapFrame2 : stackMapFrameArray) {
                if (stackMapFrame2 == stackMapFrame) break;
                n3 += stackMapFrame2.getSize();
            }
            System.arraycopy(byArray, n3, byArray, n3 + n2, byArray.length - n3 - n2);
        }
    }

    public static class LocalVariableTypeTables
    extends LocalVariableTables {
        LocalVariableTypeTables(ClassInfo classInfo) {
            super(classInfo, classInfo.localVariableTypeTablesOffsets, classInfo.localVariableTypeTablesLengths);
        }
    }

    public static class LocalVariableTables {
        public static int ATTR_SIZE = 10;
        private char[][] lengths;
        private char[][] startPCs;
        private boolean hasTable;

        LocalVariableTables(ClassInfo classInfo) {
            this(classInfo, classInfo.localVariableTablesOffsets, classInfo.localVariableTablesLengths);
        }

        private LocalVariableTables(ClassInfo classInfo, int[] nArray, char[] cArray) {
            byte[] byArray = null;
            try {
                byArray = classInfo.getClassFileBytes();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            int n = classInfo.getMethodNames().length;
            this.startPCs = new char[n][];
            this.lengths = new char[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = cArray[i];
                if (n2 == 0) continue;
                int n3 = classInfo.methodInfoOffsets[i] + nArray[i];
                this.startPCs[i] = new char[n2];
                char[] cArray2 = this.startPCs[i];
                this.lengths[i] = new char[n2];
                char[] cArray3 = this.lengths[i];
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = n3;
                    cArray2[n4] = (char)(((byArray[n5++] & 0xFF) << 8) + (byArray[n5++] & 0xFF));
                    cArray3[n4] = (char)(((byArray[n5++] & 0xFF) << 8) + (byArray[n5++] & 0xFF));
                    ++n4;
                    n3 += ATTR_SIZE;
                }
                this.hasTable = true;
            }
        }

        char[][] getStartPCs() {
            return this.startPCs;
        }

        char[][] getLengts() {
            return this.lengths;
        }

        public boolean hasTable() {
            return this.hasTable;
        }

        public void updateTable(int n, int n2, int n3) {
            if (this.hasTable()) {
                char[] cArray = this.getStartPCs()[n3];
                char[] cArray2 = this.getLengts()[n3];
                if (cArray != null) {
                    for (int i = 0; i < cArray.length; ++i) {
                        char c = cArray[i];
                        if (c >= n) {
                            cArray[i] = (char)(c + n2);
                            continue;
                        }
                        char c2 = cArray2[i];
                        if (c + c2 <= n) continue;
                        cArray2[i] = (char)(c2 + n2);
                    }
                }
            }
        }

        public void writeTable(byte[] byArray, int n, int n2) {
            char[] cArray = this.getStartPCs()[n2];
            char[] cArray2 = this.getLengts()[n2];
            if (cArray != null) {
                int n3 = 0;
                while (n3 < cArray.length) {
                    ClassInfo.putU2(byArray, n, cArray[n3]);
                    ClassInfo.putU2(byArray, n + 2, cArray2[n3]);
                    ++n3;
                    n += ATTR_SIZE;
                }
            }
        }
    }

    public static class LineNumberTables {
        private char[][] lineNumbers;
        private char[][] startPCs;
        private boolean hasTable;

        LineNumberTables(ClassInfo classInfo) {
            byte[] byArray = null;
            try {
                byArray = classInfo.getClassFileBytes();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            int n = classInfo.getMethodNames().length;
            this.startPCs = new char[n][];
            this.lineNumbers = new char[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = classInfo.methodInfoOffsets[i] + classInfo.lineNumberTablesOffsets[i];
                if (n2 == -1) continue;
                this.hasTable = true;
                int n3 = classInfo.lineNumberTablesLengths[i];
                this.startPCs[i] = new char[n3];
                char[] cArray = this.startPCs[i];
                this.lineNumbers[i] = new char[n3];
                char[] cArray2 = this.lineNumbers[i];
                for (int j = 0; j < n3; ++j) {
                    cArray[j] = (char)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    cArray2[j] = (char)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                }
            }
        }

        public char[][] getStartPCs() {
            return this.startPCs;
        }

        int[] getMinAndMaxLinesForMethod(int n) {
            int[] nArray = new int[2];
            if (this.startPCs[n] == null) {
                nArray[1] = -1;
                nArray[0] = -1;
                return nArray;
            }
            nArray[0] = 10000000;
            nArray[1] = -10000000;
            char[] cArray = this.lineNumbers[n];
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] < nArray[0]) {
                    nArray[0] = cArray[i];
                }
                if (cArray[i] <= nArray[1]) continue;
                nArray[1] = cArray[i];
            }
            return nArray;
        }

        int bciForLineNo(int n, int n2) {
            char c;
            char[] cArray = this.startPCs[n];
            if (cArray == null) {
                return -1;
            }
            int n3 = cArray.length;
            char[] cArray2 = this.lineNumbers[n];
            int n4 = 100000000;
            int n5 = 100000000;
            int n6 = 0;
            int n7 = -1;
            int c2 = 100000000;
            for (int i = 0; i < n3; ++i) {
                char c3;
                n7 = cArray2[i];
                if (n7 > n6) {
                    n6 = n7;
                }
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n7 == n2) {
                    c = cArray[i];
                    break;
                }
                if (n7 <= n2 || n7 > n5 || cArray[i] >= c3) continue;
                c3 = cArray[i];
                n5 = n7;
            }
            if (n7 == n2 || n2 >= n4 && n2 <= n6) {
                return c;
            }
            return -1;
        }

        int lineNoForBci(int n, int n2) {
            char[] cArray = this.startPCs[n];
            if (cArray == null) {
                return -1;
            }
            int n3 = cArray.length;
            char[] cArray2 = this.lineNumbers[n];
            int n4 = -1;
            for (int i = 0; i < n3 && cArray[i] <= n2; ++i) {
                n4 = cArray2[i];
            }
            return n4;
        }

        private boolean hasTable() {
            return this.hasTable;
        }
    }
}

