/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

class CacheObject {
    private static final DateFormat df = DateFormat.getDateInstance();
    private static final String[] JNLP_COLUMN_KEYS = new String[]{"jnlp.viewer.app.column", "jnlp.viewer.vendor.column", "jnlp.viewer.type.column", "jnlp.viewer.date.column", "jnlp.viewer.size.column", "jnlp.viewer.status.column"};
    private static final String[] RES_COLUMN_KEYS = new String[]{"res.viewer.name.column", "res.viewer.url.column", "res.viewer.modified.column", "res.viewer.expired.column", "res.viewer.version.column", "res.viewer.size.column"};
    private static final String[] DEL_COLUMN_KEYS = new String[]{"del.viewer.app.column", "del.viewer.url.column"};
    private static String[][] keys = new String[][]{JNLP_COLUMN_KEYS, RES_COLUMN_KEYS, DEL_COLUMN_KEYS};
    private static TLabel titleLabel;
    private static TLabel vendorLabel;
    private static TLabel typeLabel;
    private static TLabel[] dateLabel;
    private static TLabel sizeLabel;
    private static TLabel statusLabel;
    private static TLabel versionLabel;
    private static TLabel urlLabel;
    private static ImageIcon onlineIcon;
    private static ImageIcon offlineIcon;
    private static ImageIcon noLaunchIcon;
    private static ImageIcon java32;
    private static ImageIcon jnlp24;
    private static ImageIcon jar24;
    private static ImageIcon class24;
    private static ImageIcon image24;
    private static ImageIcon other24;
    private final int tableType;
    private final CacheEntry cacheEntry;
    private final AbstractTableModel tableModel;
    private int objectType = -1;
    public static final int TYPE_DELETED = 0;
    public static final int TYPE_JNLP = 1;
    public static final int TYPE_JAR = 2;
    public static final int TYPE_CLASS = 3;
    public static final int TYPE_IMAGE = 4;
    public static final int TYPE_OTHER = 5;
    private static HashMap imageMap;
    private String deletedTitleString;
    private String deletedUrlString;
    private final int VIEWER_ICON_SIZE = 24;
    private String titleString = null;
    private ImageIcon icon = null;
    private String nameString = null;
    private String vendorString = null;
    private String typeString = null;
    private Date[] date = new Date[3];
    private String[] dateString = new String[3];
    private long theSize = 0L;
    private String sizeString = null;
    static Font plainFont;
    static Font boldFont;
    private int statusInt = -1;
    private ImageIcon statusIcon = null;
    private String statusText = "";
    private static final float[] dash;
    private static final BasicStroke _dashed;
    LaunchDesc _ld = null;
    LocalApplicationProperties _lap = null;
    private String versionString = null;
    static /* synthetic */ Class class$com$sun$deploy$resources$ResourceManager;
    static /* synthetic */ Class class$javax$swing$JLabel;

    public CacheObject(CacheEntry cacheEntry, AbstractTableModel abstractTableModel, int n) {
        this.tableType = n;
        this.cacheEntry = cacheEntry;
        this.tableModel = abstractTableModel;
        if (titleLabel == null) {
            titleLabel = new TLabel(2);
            vendorLabel = new TLabel(2);
            typeLabel = new TLabel(0);
            for (int i = 0; i < 3; ++i) {
                CacheObject.dateLabel[i] = new TLabel(4);
            }
            sizeLabel = new TLabel(4);
            statusLabel = new TLabel(0);
            versionLabel = new TLabel(0);
            urlLabel = new TLabel(2);
            java32 = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/java32.png"));
            jnlp24 = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/jnlp24.png"));
            jar24 = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/jar24.png"));
            class24 = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/class24.png"));
            image24 = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/image24.png"));
            other24 = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/other24.png"));
            onlineIcon = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/connect24.png"));
            offlineIcon = new ViewerIcon(0, (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/disconnect24.png"));
            noLaunchIcon = null;
        }
    }

    public int getObjectType() {
        if (this.objectType < 0) {
            this.objectType = 5;
            if (this.tableType == 0) {
                this.objectType = 1;
            } else if (this.tableType == 2) {
                this.objectType = 0;
            } else {
                this.getNameString();
                if (this.nameString.endsWith("jnlp")) {
                    this.objectType = 1;
                } else if (this.nameString.endsWith("jar") || this.nameString.endsWith("zip")) {
                    this.objectType = 2;
                } else if (this.nameString.endsWith("class")) {
                    this.objectType = 3;
                } else if (this.nameString.endsWith("jpg") || this.nameString.endsWith("gif") || this.nameString.endsWith("png") || this.nameString.endsWith("ico")) {
                    this.objectType = 4;
                }
            }
        }
        return this.objectType;
    }

    public CacheObject(String string, String string2, AbstractTableModel abstractTableModel) {
        this(null, abstractTableModel, 2);
        this.deletedTitleString = string;
        this.deletedUrlString = string2;
    }

    public String getDeletedTitle() {
        return this.deletedTitleString;
    }

    public String getDeletedUrl() {
        return this.deletedUrlString;
    }

    public static String getColumnName(int n, int n2) {
        return ResourceManager.getMessage((String)keys[n2][n]);
    }

    public static int getColumnCount(int n) {
        return keys[n].length;
    }

    public static String getHeaderToolTipText(int n, int n2) {
        String string = "";
        string = keys[n2][n];
        return ResourceManager.getString((String)(string + ".tooltip"));
    }

    public static int getPreferredWidth(int n, int n2) {
        if (n2 == 0) {
            switch (n) {
                case 0: {
                    return 200;
                }
                case 1: {
                    return 140;
                }
                case 2: {
                    return 76;
                }
                case 3: {
                    return 76;
                }
                case 4: {
                    return 64;
                }
                case 5: {
                    return 64;
                }
            }
        } else if (n2 == 1) {
            switch (n) {
                case 0: {
                    return 120;
                }
                case 1: {
                    return 220;
                }
                case 2: {
                    return 76;
                }
                case 3: {
                    return 76;
                }
                case 4: {
                    return 64;
                }
                case 5: {
                    return 64;
                }
            }
        } else {
            if (n == 0) {
                return 200;
            }
            return 420;
        }
        return 600;
    }

    public static Class getClass(int n, int n2) {
        return class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = CacheObject.class$("javax.swing.JLabel")) : class$javax$swing$JLabel;
    }

    public Object getObject(int n) {
        if (this.tableType == 0) {
            switch (n) {
                case 0: {
                    return this.getTitleLabel();
                }
                case 1: {
                    return this.getVendorLabel();
                }
                case 2: {
                    return this.getTypeLabel();
                }
                case 3: {
                    return this.getDateLabel(0);
                }
                case 4: {
                    return this.getSizeLabel();
                }
                case 5: {
                    return this.getStatusLabel();
                }
            }
        } else if (this.tableType == 1) {
            switch (n) {
                case 0: {
                    return this.getNameLabel();
                }
                case 1: {
                    return this.getUrlLabel();
                }
                case 2: {
                    return this.getDateLabel(1);
                }
                case 3: {
                    return this.getDateLabel(2);
                }
                case 4: {
                    return this.getVersionLabel();
                }
                case 5: {
                    return this.getSizeLabel();
                }
            }
        }
        if (n == 0) {
            return this.getDeletedTitleLabel();
        }
        return this.getDeletedUrlLabel();
    }

    public boolean isEditable(int n) {
        return false;
    }

    public void setValue(int n, Object object) {
    }

    public String getTitleString() {
        if (this.titleString == null) {
            this.titleString = this.getTitle();
        }
        return this.titleString;
    }

    private TLabel getTitleLabel() {
        if (this.icon == null) {
            InformationDesc informationDesc;
            IconDesc iconDesc = null;
            LaunchDesc launchDesc = this.getLaunchDesc();
            if (launchDesc != null && (informationDesc = launchDesc.getInformation()) != null) {
                iconDesc = informationDesc.getIconLocation(24, 0);
            }
            if (iconDesc != null) {
                this.icon = new ViewerIcon(24, iconDesc.getLocation(), iconDesc.getVersion());
            }
            if (this.icon == null) {
                this.icon = java32;
            }
        }
        if (this.icon != null && this.icon.getIconWidth() > 0 && this.icon.getIconHeight() > 0) {
            titleLabel.setIcon(this.icon);
        } else {
            titleLabel.setIcon(java32);
        }
        titleLabel.setText(this.getTitleString());
        return titleLabel;
    }

    private TLabel getDeletedTitleLabel() {
        titleLabel.setIcon(null);
        titleLabel.setText(this.deletedTitleString);
        return titleLabel;
    }

    private TLabel getDeletedUrlLabel() {
        urlLabel.setText(this.deletedUrlString);
        return urlLabel;
    }

    public String getNameString() {
        if (this.nameString == null) {
            String string = this.cacheEntry.getURL();
            int n = string.lastIndexOf("/");
            int n2 = n < 0 || n >= string.length() - 1 ? 0 : n + 1;
            this.nameString = string.substring(n2);
            n = this.nameString.lastIndexOf(".jarjnlp");
            if (n > 0) {
                this.nameString = this.nameString.substring(0, n) + ".jnlp";
            }
        }
        return this.nameString;
    }

    private ImageIcon getJNLPIcon() {
        if (this.icon == null) {
            InformationDesc informationDesc;
            IconDesc iconDesc = null;
            LaunchDesc launchDesc = this.getLaunchDesc();
            if (launchDesc != null && (informationDesc = launchDesc.getInformation()) != null) {
                iconDesc = informationDesc.getIconLocation(24, 0);
            }
            if (iconDesc != null) {
                this.icon = new ViewerIcon(24, iconDesc.getLocation(), iconDesc.getVersion());
            }
            if (this.icon == null) {
                this.icon = jnlp24;
            }
        }
        return this.icon;
    }

    private ImageIcon getJarIcon() {
        return jar24;
    }

    private ImageIcon getClassIcon() {
        return class24;
    }

    private ImageIcon getImageIcon() {
        return image24;
    }

    private ImageIcon getOtherIcon() {
        return other24;
    }

    private ImageIcon getTypeIcon() {
        if (this.icon == null) {
            switch (this.getObjectType()) {
                case 1: {
                    this.icon = this.getJNLPIcon();
                    break;
                }
                case 2: {
                    this.icon = this.getJarIcon();
                    break;
                }
                case 3: {
                    this.icon = this.getClassIcon();
                    break;
                }
                case 4: {
                    this.icon = this.getImageIcon();
                    break;
                }
                default: {
                    this.icon = this.getOtherIcon();
                }
            }
        }
        return this.icon;
    }

    private TLabel getNameLabel() {
        titleLabel.setText(this.getNameString());
        titleLabel.setIcon(this.getTypeIcon());
        return titleLabel;
    }

    public String getVendorString() {
        if (this.vendorString == null) {
            this.vendorString = this.getVendor();
        }
        return this.vendorString;
    }

    private TLabel getVendorLabel() {
        vendorLabel.setText(this.getVendorString());
        return vendorLabel;
    }

    public static String getLaunchTypeString(int n) {
        switch (n) {
            case 1: {
                return ResourceManager.getMessage((String)"viewer.application");
            }
            case 2: {
                return ResourceManager.getMessage((String)"viewer.applet");
            }
            case 3: {
                return ResourceManager.getMessage((String)"viewer.extension");
            }
            case 4: {
                return ResourceManager.getMessage((String)"viewer.installer");
            }
        }
        return "";
    }

    public String getTypeString() {
        if (this.typeString == null) {
            this.typeString = CacheObject.getLaunchTypeString(this.getLaunchDesc().getLaunchType());
        }
        return this.typeString;
    }

    private TLabel getTypeLabel() {
        typeLabel.setText(this.getTypeString());
        return typeLabel;
    }

    public Date getDate(int n) {
        if (this.dateString[n] == null) {
            switch (n) {
                case 0: {
                    this.date[0] = this.getLastAccesed();
                    break;
                }
                case 1: {
                    this.date[1] = this.getLastModified();
                    break;
                }
                case 2: {
                    this.date[2] = this.getExpired();
                }
            }
            this.dateString[n] = this.date[n] != null ? df.format(this.date[n]) : "";
        }
        return this.date[n];
    }

    private TLabel getDateLabel(int n) {
        this.getDate(n);
        dateLabel[n].setText(this.dateString[n]);
        return dateLabel[n];
    }

    public long getSize() {
        if (this.sizeString == null) {
            this.theSize = this.getResourceSize();
            this.sizeString = this.theSize > 10240L ? " " + this.theSize / 1024L + " KB" : " " + this.theSize / 1024L + "." + this.theSize % 1024L / 102L + " KB";
        }
        return this.theSize;
    }

    private TLabel getSizeLabel() {
        this.getSize();
        sizeLabel.setText(this.sizeString);
        if (this.tableType == 0) {
            if (boldFont == null) {
                plainFont = sizeLabel.getFont();
                boldFont = plainFont.deriveFont(1);
            }
            this.getLocalApplicationProperties();
            if (this._lap != null && this._lap.isJnlpInstalled()) {
                sizeLabel.setFont(boldFont);
            } else {
                sizeLabel.setFont(plainFont);
            }
        }
        return sizeLabel;
    }

    public int getStatus() {
        if (this.statusInt < 0) {
            this.statusInt = 0;
            if (this.canLaunchOffline()) {
                this.statusInt |= 3;
            }
            if (this.hasHref()) {
                this.statusInt |= 1;
            }
            switch (this.statusInt) {
                case 0: {
                    this.statusIcon = noLaunchIcon;
                    if (this.getLaunchDesc().isApplicationDescriptor()) {
                        this.statusText = ResourceManager.getString((String)"viewer.norun1.tooltip", (String)this.getTypeString());
                        break;
                    }
                    this.statusText = ResourceManager.getString((String)"viewer.norun2.tooltip");
                    break;
                }
                case 1: {
                    this.statusIcon = onlineIcon;
                    this.statusText = ResourceManager.getString((String)"viewer.online.tooltip", (String)this.getTypeString());
                    break;
                }
                case 2: {
                    this.statusIcon = offlineIcon;
                    this.statusText = ResourceManager.getString((String)"viewer.offline.tooltip", (String)this.getTypeString());
                    break;
                }
                case 3: {
                    this.statusIcon = offlineIcon;
                    this.statusText = ResourceManager.getString((String)"viewer.onlineoffline.tooltip", (String)this.getTypeString());
                }
            }
        }
        return this.statusInt;
    }

    private TLabel getStatusLabel() {
        this.getStatus();
        if (this.statusIcon == null || this.statusIcon.getIconWidth() > 0 && this.statusIcon.getIconHeight() > 0) {
            statusLabel.setIcon(this.statusIcon);
            statusLabel.setToolTipText(this.statusText);
        }
        return statusLabel;
    }

    public static void hasFocus(Component component, boolean bl) {
        if (component instanceof TLabel) {
            ((TLabel)component).hasFocus(bl);
        }
    }

    public int compareColumns(CacheObject cacheObject, int n) {
        if (this.tableType == 1) {
            switch (n) {
                case 0: {
                    return this.compareStrings(this.getNameString(), cacheObject.getNameString());
                }
                case 1: {
                    return this.compareStrings(this.getUrlString(), cacheObject.getUrlString());
                }
                case 2: {
                    return this.compareDates(this.getDate(1), cacheObject.getDate(1));
                }
                case 3: {
                    return this.compareDates(this.getDate(2), cacheObject.getDate(2));
                }
                case 4: {
                    return this.compareStrings(this.getVersionString(), cacheObject.getVersionString());
                }
            }
            return this.compareLong(this.getSize(), cacheObject.getSize());
        }
        if (this.tableType == 0) {
            switch (n) {
                case 0: {
                    return this.compareStrings(this.getTitleString(), cacheObject.getTitleString());
                }
                case 1: {
                    return this.compareStrings(this.getVendorString(), cacheObject.getVendorString());
                }
                case 2: {
                    return this.compareStrings(this.getTypeString(), cacheObject.getTypeString());
                }
                case 3: {
                    return this.compareDates(this.getDate(0), cacheObject.getDate(0));
                }
                case 4: {
                    return this.compareLong(this.getSize(), cacheObject.getSize());
                }
            }
            return this.compareInt(this.getStatus(), cacheObject.getStatus());
        }
        if (this.tableType == 2) {
            switch (n) {
                case 0: {
                    return this.compareStrings(this.getDeletedTitle(), cacheObject.getDeletedTitle());
                }
            }
            return this.compareStrings(this.getDeletedUrl(), cacheObject.getDeletedUrl());
        }
        return 0;
    }

    private int compareStrings(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    private int compareDates(Date date, Date date2) {
        if (date == date2) {
            return 0;
        }
        if (date == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        return this.compareLong(date.getTime(), date2.getTime());
    }

    private int compareLong(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        return l < l2 ? -1 : 1;
    }

    private int compareInt(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }

    public CacheEntry getCE() {
        return this.cacheEntry;
    }

    public LaunchDesc getLaunchDesc() {
        if (this.cacheEntry == null || this.tableType == 1 && !this.cacheEntry.getURL().endsWith("jnlp")) {
            return null;
        }
        if (this._ld == null) {
            try {
                this._ld = LaunchDescFactory.buildDescriptor(this.cacheEntry.getDataFile(), null != this.cacheEntry ? URLUtil.getBase((URL)new URL(this.cacheEntry.getURL())) : null, null, new URL(this.cacheEntry.getURL()));
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
        return this._ld;
    }

    public LocalApplicationProperties getLocalApplicationProperties() {
        if (this._lap == null) {
            this._lap = Cache.getLocalApplicationProperties((CacheEntry)this.cacheEntry);
        }
        return this._lap;
    }

    public File getJnlpFile() {
        return this.cacheEntry.getDataFile();
    }

    public String getTitle() {
        try {
            return this.getLaunchDesc().getInformation().getTitle();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getVendor() {
        try {
            return this.getLaunchDesc().getInformation().getVendor();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getHref() {
        URL uRL = this.getLaunchDesc().getLocation();
        if (uRL != null) {
            return uRL.toString();
        }
        return null;
    }

    public File getIconFile() {
        try {
            IconDesc iconDesc = this.getLaunchDesc().getInformation().getIconLocation(24, 0);
            File file = DownloadEngine.getCachedFile((URL)iconDesc.getLocation(), (String)iconDesc.getVersion());
            if (file != null) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Date getLastAccesed() {
        return this.getLocalApplicationProperties().getLastAccessed();
    }

    public Date getLastModified() {
        long l = this.cacheEntry.getLastModified();
        return l > 0L ? new Date(l) : null;
    }

    public Date getExpired() {
        long l = this.cacheEntry.getExpirationDate();
        return l > 0L ? new Date(l) : null;
    }

    public long getResourceSize() {
        long l = 0L;
        if (this.tableType == 0) {
            l += LaunchDownload.getCachedSize(this.getLaunchDesc());
            l += this.cacheEntry.getSize();
        } else if (this.tableType == 1) {
            l += this.cacheEntry.getSize();
        }
        return l;
    }

    public String getVersionString() {
        if (this.versionString == null) {
            this.versionString = this.cacheEntry.getVersion();
            if (this.versionString == null) {
                this.versionString = "";
            }
        }
        return this.versionString;
    }

    public TLabel getVersionLabel() {
        versionLabel.setText(this.getVersionString());
        return versionLabel;
    }

    public String getUrlString() {
        return this.cacheEntry.getURL();
    }

    public String getCodebaseIP() {
        return this.cacheEntry.getCodebaseIP();
    }

    public TLabel getUrlLabel() {
        urlLabel.setText(this.cacheEntry.getURL());
        return urlLabel;
    }

    public boolean inFilter(int n) {
        return n == 0 || n == this.getLaunchDesc().getLaunchType();
    }

    public boolean hasHref() {
        if (this.getLaunchDesc().isApplicationDescriptor()) {
            return this._ld.getLocation() != null;
        }
        return false;
    }

    public boolean canLaunchOffline() {
        if (this.getLaunchDesc().isApplicationDescriptor()) {
            return this._ld.getInformation().supportsOfflineOperation();
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        dateLabel = new TLabel[3];
        imageMap = new HashMap();
        dash = new float[]{1.0f, 2.0f};
        _dashed = new BasicStroke(1.0f, 2, 0, 10.0f, dash, 0.0f);
    }

    private class TLabel
    extends JLabel {
        boolean _focus = false;

        public TLabel(int n) {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.setHorizontalAlignment(n);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this._focus && graphics instanceof Graphics2D) {
                Stroke stroke = ((Graphics2D)graphics).getStroke();
                ((Graphics2D)graphics).setStroke(_dashed);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                ((Graphics2D)graphics).setStroke(stroke);
            }
        }

        public void hasFocus(boolean bl) {
            this._focus = bl;
        }
    }

    private class ViewerIcon
    extends ImageIcon
    implements ImageLoaderCallback {
        private int _width;
        private int _height;

        public ViewerIcon(int n, String string) {
            this._width = n;
            this._height = n;
            try {
                URL uRL = URLUtil.fileToURL((File)new File(string));
                if (uRL != null && !this.isCached(uRL, null)) {
                    ImageLoader.getInstance().loadImage(uRL, (ImageLoaderCallback)this, true);
                }
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }

        public ViewerIcon(int n, URL uRL, String string) {
            this._width = n;
            this._height = n;
            try {
                if (!this.isCached(uRL, string)) {
                    ImageLoader.getInstance().loadImage(uRL, string, (ImageLoaderCallback)this, true);
                }
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }

        public ViewerIcon(int n, URL uRL) {
            this._width = n;
            this._height = n;
            if (uRL == null) {
                uRL = (class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = CacheObject.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource("image/java32.png");
                this._width = 24;
                this._height = 24;
            }
            try {
                if (uRL != null && !this.isCached(uRL, null)) {
                    ImageLoader.getInstance().loadImage(uRL, (ImageLoaderCallback)this, true);
                }
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }

        private boolean isCached(URL uRL, String string) {
            Image image = (Image)imageMap.get(this.getKey(uRL, string));
            if (image != null) {
                this.setImage(image);
                return true;
            }
            return false;
        }

        private String getKey(URL uRL, String string) {
            String string2 = "" + uRL + "-w=" + this._width + "-h=" + this._height;
            if (string != null) {
                string2 = string2 + "-version=" + string;
            }
            return string2;
        }

        public void imageAvailable(final URL uRL, final String string, Image image, File file) {
            final int n = image.getWidth(null);
            final int n2 = image.getHeight(null);
            final Image image2 = image;
            new Thread(new Runnable(){

                public void run() {
                    Image image = image2;
                    if (ViewerIcon.this._width > 0 && ViewerIcon.this._height > 0 && (ViewerIcon.this._width != n || ViewerIcon.this._height != n2)) {
                        image = image2.getScaledInstance(ViewerIcon.this._width, ViewerIcon.this._height, 1);
                    }
                    imageMap.put(ViewerIcon.this.getKey(uRL, string), image);
                    ViewerIcon.this.setImage(image);
                    CacheObject.this.tableModel.fireTableDataChanged();
                }
            }).start();
        }

        public void finalImageAvailable(URL uRL, String string, Image image, File file) {
            this.imageAvailable(uRL, string, image, file);
        }
    }
}

