/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.FilterSet;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.BooleanTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ui.GlobalFiltersPanel;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class FilterSetsPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    private static final String COLUMN_NAME_ACTIVE = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_ColumnNameActive");
    private static final String COLUMN_NAME_NAME = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_ColumnNameName");
    private static final String COLUMN_NAME_VALUE = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_ColumnNameValue");
    private static final String ADD_FILTER_SET_BUTTON_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_AddFilterSetButtonText");
    private static final String REMOVE_FILTER_SET_BUTTON_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_RemoveFilterSetButtonText");
    private static final String MOVE_UP_BUTTON_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_MoveUpButtonText");
    private static final String MOVE_DOWN_BUTTON_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_MoveDownButtonText");
    private static final String FILTERSET_NAME_LABEL_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_FilterSetNameLabelText");
    private static final String FILTERSET_TYPE_LABEL_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_FilterSetTypeLabelText");
    private static final String FILTERSET_TYPE_EXCLUSIVE_RADIO_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_FilterSetTypeExclusiveRadioText");
    private static final String FILTERSET_TYPE_INCLUSIVE_RADIO_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_FilterSetTypeInclusiveRadioText");
    private static final String ACTIVE_FILTERS_LABEL_TEXT = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_ActiveFiltersLabelText");
    private static final String DEFINED_FILTERSETS_BORDER_CAPTION = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_DefinedFilterSetsBorderCaption");
    private static final String FILTERSET_PROPERTIES_BORDER_CAPTION = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_FilterSetPropertiesBorderCaption");
    private static final String EDIT_GLOBAL_FILTERS_DIALOG_CAPTION = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_EditGlobalFiltersDialogCaption");
    private static final String HINT_MSG = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_HintMsg");
    private static final String DEFINED_FILTER_SETS_LIST_ACCESS_NAME = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_DefinedFilterSetsListAccessName");
    private static final String DEFINED_FILTER_SETS_LIST_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_DefinedFilterSetsListAccessDescr");
    private static final String ADD_FILTER_SET_BUTTON_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_AddFilterSetButtonAccessDescr");
    private static final String REMOVE_FILTER_SET_BUTTON_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_RemoveFilterSetButtonAccessDescr");
    private static final String MOVE_UP_BUTTON_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_MoveUpButtonAccessDescr");
    private static final String MOVE_DOWN_BUTTON_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_MoveDownButtonAccessDescr");
    private static final String ACTIVE_FILTERS_TABLE_ACCESS_NAME = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_ActiveFiltersTableAccessName");
    private static final String ACTIVE_FILTERS_TABLE_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_ActiveFiltersTableAccessDescr");
    private static final String FILTER_TYPE_EXCLUSIVE_RADIO_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_FilterTypeExclusiveRadioAccessDescr");
    private static final String FILTER_TYPE_INCLUSIVE_RADIO_ACCESS_DESCR = NbBundle.getMessage(FilterSetsPanel.class, (String)"FilterSetsPanel_FilterTypeInclusiveRadioAccessDescr");
    private static final String HELP_CTX_KEY = "FilterSetsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("FilterSetsPanel.HelpCtx");
    private static FilterSetsPanel defaultInstance;
    public final DefinedFilterSets filterSets;
    private ButtonGroup filterTypeButtonGroup;
    private FilterSet selectedFilterSet;
    private HTMLTextArea hintArea;
    private JButton addFilterSetButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeFilterSetButton;
    private JExtendedTable activeFiltersTable;
    private JLabel activeFiltersLabel;
    private JLabel filterNameLabel;
    private JLabel filterTypeLabel;
    private JList definedFilterSetsList;
    private JPanel buttonsPanel;
    private JPanel filterSetPropertiesPanel;
    private JPanel filterSetSettingsPanel;
    private JPanel filterSetsPreviewPanel;
    private JRadioButton filterTypeExclusiveRadio;
    private JRadioButton filterTypeInclusiveRadio;
    private JScrollPane activeFiltersScrollPane;
    private JScrollPane definedFilterSetsListScrollPane;
    private JTextField filterNameTextField;
    private final NetBeansProfiler nbProfiler;
    private final Class[] columnClasses;
    private final String[] columnNames;
    private String filterSetNameBeforeEditing;
    private Boolean[] selectedFilterSetChecks = new Boolean[0];
    private int selectedFilterSetIndex;

    private FilterSetsPanel() {
        this.nbProfiler = (NetBeansProfiler)Profiler.getDefault();
        this.filterSets = new DefinedFilterSets();
        this.columnNames = new String[]{COLUMN_NAME_ACTIVE, COLUMN_NAME_NAME, COLUMN_NAME_VALUE};
        this.columnClasses = new Class[]{Boolean.class, String.class, String.class};
        this.initComponents();
    }

    public static FilterSetsPanel getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FilterSetsPanel();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public FilterSet getSelectedFilterSet() {
        int n = this.getSelectedFilterSetIndex();
        if (n == -1) {
            return null;
        }
        return this.filterSets.getFilterSetAt(n);
    }

    public int getSelectedFilterSetIndex() {
        return this.definedFilterSetsList.getSelectedIndex();
    }

    public String getSelectedFilterSetName() {
        return (String)this.definedFilterSetsList.getSelectedValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addFilterSetButton) {
            this.addNewFilterSet();
        } else if (actionEvent.getSource() == this.removeFilterSetButton) {
            this.removeSelectedFilterSet();
        } else if (actionEvent.getSource() == this.moveUpButton) {
            this.moveSelectedFilterUp();
        } else if (actionEvent.getSource() == this.moveDownButton) {
            this.moveSelectedFilterDown();
        } else if (actionEvent.getSource() == this.filterTypeExclusiveRadio) {
            if (this.filterTypeExclusiveRadio.isSelected()) {
                this.selectedFilterSet.setExclusive();
            }
        } else if (actionEvent.getSource() == this.filterTypeInclusiveRadio && this.filterTypeInclusiveRadio.isSelected()) {
            this.selectedFilterSet.setInclusive();
        }
    }

    public void applyChanges() {
        this.nbProfiler.getDefinedFilterSets().setValuesFrom(this.filterSets);
        this.nbProfiler.saveGlobalFilters();
    }

    public void init(int n) {
        this.filterSets.setValuesFrom(this.nbProfiler.getDefinedFilterSets());
        if (n < this.filterSets.getFilterSetsCount()) {
            this.definedFilterSetsList.setSelectedIndex(n);
            this.makeDefinedFilterSetsListSelectionVisible();
        } else {
            this.definedFilterSetsList.clearSelection();
        }
        this.updateSelection();
    }

    public void processGlobalFiltersChanged() {
        if (this.activeFiltersTable != null) {
            this.updateSelectedFilterSetProperties();
            ((AbstractTableModel)this.activeFiltersTable.getModel()).fireTableDataChanged();
            this.activeFiltersTable.repaint();
        }
    }

    private void addNewFilterSet() {
        if (this.definedFilterSetsList != null) {
            this.filterSets.addFilterSet(new FilterSet(this.createUniqueFilterSetName()));
            DefinedFilterSetsListModel definedFilterSetsListModel = (DefinedFilterSetsListModel)this.definedFilterSetsList.getModel();
            definedFilterSetsListModel.fireIntervalAdded(definedFilterSetsListModel.getSize(), definedFilterSetsListModel.getSize());
            this.definedFilterSetsList.setSelectedIndex(definedFilterSetsListModel.getSize() - 1);
            this.makeDefinedFilterSetsListSelectionVisible();
            this.filterNameTextField.selectAll();
            this.filterNameTextField.requestFocus();
        }
    }

    private boolean containsFilterSetName(String string) {
        for (int i = 0; i < this.filterSets.getFilterSetsCount(); ++i) {
            if (!this.filterSets.getFilterSetAt(i).getFilterSetName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFilterSetNameExceptIndex(String string, int n) {
        for (int i = 0; i < this.filterSets.getFilterSetsCount(); ++i) {
            if (i == n || !this.filterSets.getFilterSetAt(i).getFilterSetName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String createUniqueFilterSetName() {
        return this.createUniqueFilterSetName(FilterSet.DEFAULT_FILTERSET_NAME);
    }

    private String createUniqueFilterSetName(String string) {
        int n = 1;
        String string2 = "";
        while (this.containsFilterSetName(string + string2)) {
            string2 = " (" + ++n + ")";
        }
        return string + string2;
    }

    private void initComponents() {
        this.filterTypeButtonGroup = new ButtonGroup();
        this.filterSetsPreviewPanel = new JPanel();
        this.definedFilterSetsList = new JList();
        this.definedFilterSetsListScrollPane = new JScrollPane();
        this.buttonsPanel = new JPanel();
        this.addFilterSetButton = new JButton();
        this.removeFilterSetButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.filterSetPropertiesPanel = new JPanel();
        this.filterSetSettingsPanel = new JPanel();
        this.filterNameLabel = new JLabel();
        this.filterNameTextField = new JTextField();
        this.filterTypeLabel = new JLabel();
        this.filterTypeExclusiveRadio = new JRadioButton();
        this.filterTypeInclusiveRadio = new JRadioButton();
        this.activeFiltersLabel = new JLabel();
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.setLayout(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(DEFINED_FILTERSETS_BORDER_CAPTION);
        this.filterSetsPreviewPanel.setLayout(new BorderLayout());
        this.filterSetsPreviewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 5, 5, 5), titledBorder));
        this.definedFilterSetsList.getAccessibleContext().setAccessibleName(DEFINED_FILTER_SETS_LIST_ACCESS_NAME);
        this.definedFilterSetsList.getAccessibleContext().setAccessibleDescription(DEFINED_FILTER_SETS_LIST_ACCESS_DESCR);
        this.definedFilterSetsList.setModel(new DefinedFilterSetsListModel());
        this.definedFilterSetsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, false);
            }
        });
        this.definedFilterSetsList.setSelectionMode(0);
        this.definedFilterSetsList.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.definedFilterSetsList.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.definedFilterSetsList.setVisibleRowCount(5);
        this.definedFilterSetsList.addListSelectionListener(new DefinedFilterSetsListSelectionListener());
        this.definedFilterSetsList.addKeyListener(new DefinedFilterSetsListKeyListener());
        this.definedFilterSetsListScrollPane.setViewportView(this.definedFilterSetsList);
        this.definedFilterSetsListScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0), this.definedFilterSetsListScrollPane.getBorder()));
        this.definedFilterSetsListScrollPane.setPreferredSize(new Dimension(470, 1));
        this.filterSetsPreviewPanel.add((Component)this.definedFilterSetsListScrollPane, "Center");
        this.buttonsPanel.setLayout(new GridLayout(4, 1, 0, 5));
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 5));
        Mnemonics.setLocalizedText((AbstractButton)this.addFilterSetButton, (String)ADD_FILTER_SET_BUTTON_TEXT);
        this.addFilterSetButton.getAccessibleContext().setAccessibleDescription(ADD_FILTER_SET_BUTTON_ACCESS_DESCR);
        this.addFilterSetButton.addActionListener(this);
        this.buttonsPanel.add(this.addFilterSetButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeFilterSetButton, (String)REMOVE_FILTER_SET_BUTTON_TEXT);
        this.removeFilterSetButton.getAccessibleContext().setAccessibleDescription(REMOVE_FILTER_SET_BUTTON_ACCESS_DESCR);
        this.removeFilterSetButton.setEnabled(false);
        this.removeFilterSetButton.addActionListener(this);
        this.buttonsPanel.add(this.removeFilterSetButton);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)MOVE_UP_BUTTON_TEXT);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(MOVE_UP_BUTTON_ACCESS_DESCR);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(this);
        this.buttonsPanel.add(this.moveUpButton);
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)MOVE_DOWN_BUTTON_TEXT);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(MOVE_DOWN_BUTTON_ACCESS_DESCR);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(this);
        this.buttonsPanel.add(this.moveDownButton);
        this.filterSetsPreviewPanel.add((Component)this.buttonsPanel, "East");
        this.add((Component)this.filterSetsPreviewPanel, "North");
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(FILTERSET_PROPERTIES_BORDER_CAPTION);
        this.filterSetPropertiesPanel.setLayout(new BorderLayout());
        this.filterSetPropertiesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 5, 5, 5), titledBorder2));
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer();
        BooleanTableCellRenderer booleanTableCellRenderer = new BooleanTableCellRenderer();
        this.activeFiltersTable = new JExtendedTable((TableModel)new ActiveFiltersTableModel());
        this.activeFiltersTable.getAccessibleContext().setAccessibleName(ACTIVE_FILTERS_TABLE_ACCESS_NAME);
        this.activeFiltersTable.getAccessibleContext().setAccessibleDescription(ACTIVE_FILTERS_TABLE_ACCESS_DESCR);
        this.activeFiltersTable.setRowSelectionAllowed(true);
        this.activeFiltersTable.setSelectionMode(0);
        this.activeFiltersTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.activeFiltersTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.activeFiltersTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.activeFiltersTable.setShowHorizontalLines(false);
        this.activeFiltersTable.setShowVerticalLines(true);
        this.activeFiltersTable.setRowMargin(0);
        this.activeFiltersTable.getTableHeader().setReorderingAllowed(false);
        this.activeFiltersTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)booleanTableCellRenderer);
        this.activeFiltersTable.setDefaultRenderer(String.class, (TableCellRenderer)labelTableCellRenderer);
        this.activeFiltersTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.activeFiltersTable.addKeyListener((KeyListener)new ActiveFiltersTableKeyListener());
        this.activeFiltersTable.addMouseListener((MouseListener)new ActiveFiltersTableMouseListener());
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(this.activeFiltersTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.activeFiltersTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet(this.activeFiltersTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.activeFiltersTable.setFocusTraversalKeys(1, hashSet);
        TableColumn tableColumn = this.activeFiltersTable.getColumnModel().getColumn(0);
        int n = new JButton((String)FilterSetsPanel.COLUMN_NAME_ACTIVE).getPreferredSize().width;
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn.setMaxWidth(n);
        this.activeFiltersScrollPane = new JScrollPane(22, 31);
        this.activeFiltersScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.activeFiltersScrollPane.getBorder()));
        this.activeFiltersScrollPane.setPreferredSize(new Dimension(1, 200));
        ActiveFiltersTableViewport activeFiltersTableViewport = new ActiveFiltersTableViewport((JTable)this.activeFiltersTable);
        this.activeFiltersScrollPane.setViewport(activeFiltersTableViewport);
        this.activeFiltersScrollPane.addMouseWheelListener((MouseWheelListener)this.activeFiltersTable);
        this.activeFiltersScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (FilterSetsPanel.this.activeFiltersScrollPane.getVerticalScrollBar().getModel().getExtent() == FilterSetsPanel.this.activeFiltersScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
                    FilterSetsPanel.this.activeFiltersScrollPane.getVerticalScrollBar().setEnabled(false);
                } else {
                    FilterSetsPanel.this.activeFiltersScrollPane.getVerticalScrollBar().setEnabled(true);
                }
            }
        });
        this.filterSetPropertiesPanel.add((Component)this.activeFiltersScrollPane, "Center");
        this.filterSetSettingsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.filterNameLabel, (String)FILTERSET_NAME_LABEL_TEXT);
        this.filterNameLabel.setLabelFor(this.filterNameTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints.anchor = 17;
        this.filterSetSettingsPanel.add((Component)this.filterNameLabel, gridBagConstraints);
        this.filterNameTextField.setText("");
        this.filterNameTextField.addKeyListener(new FilterNameTextFieldKeyListener());
        this.filterNameTextField.addFocusListener(new FilterNameTextFieldFocusListener());
        this.filterNameTextField.getDocument().addDocumentListener(new FilterNameTextFieldDocumentListener());
        this.filterNameTextField.setSelectionColor(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.filterNameTextField.setSelectedTextColor(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.filterSetSettingsPanel.add((Component)this.filterNameTextField, gridBagConstraints);
        this.filterTypeLabel.setText(FILTERSET_TYPE_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        gridBagConstraints.anchor = 17;
        this.filterSetSettingsPanel.add((Component)this.filterTypeLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.filterTypeExclusiveRadio, (String)FILTERSET_TYPE_EXCLUSIVE_RADIO_TEXT);
        this.filterTypeExclusiveRadio.getAccessibleContext().setAccessibleDescription(FILTER_TYPE_EXCLUSIVE_RADIO_ACCESS_DESCR);
        this.filterTypeExclusiveRadio.addActionListener(this);
        this.filterTypeButtonGroup.add(this.filterTypeExclusiveRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.filterSetSettingsPanel.add((Component)this.filterTypeExclusiveRadio, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.filterTypeInclusiveRadio, (String)FILTERSET_TYPE_INCLUSIVE_RADIO_TEXT);
        this.filterTypeInclusiveRadio.getAccessibleContext().setAccessibleDescription(FILTER_TYPE_INCLUSIVE_RADIO_ACCESS_DESCR);
        this.filterTypeInclusiveRadio.addActionListener(this);
        this.filterTypeButtonGroup.add(this.filterTypeInclusiveRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.filterSetSettingsPanel.add((Component)this.filterTypeInclusiveRadio, gridBagConstraints);
        this.activeFiltersLabel.setLabelFor((Component)this.activeFiltersTable);
        Mnemonics.setLocalizedText((JLabel)this.activeFiltersLabel, (String)ACTIVE_FILTERS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.filterSetSettingsPanel.add((Component)this.activeFiltersLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.filterSetSettingsPanel.add((Component)jPanel, gridBagConstraints);
        this.filterSetPropertiesPanel.add((Component)this.filterSetSettingsPanel, "North");
        this.filterSetPropertiesPanel.setVisible(false);
        this.add((Component)this.filterSetPropertiesPanel, "Center");
        Color color = UIManager.getColor("Panel.background");
        Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
        this.hintArea.setText(HINT_MSG);
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(color2);
        this.hintArea.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(7, 7, 10, 7, UIManager.getColor("Panel.background")), BorderFactory.createMatteBorder(10, 10, 10, 10, color2)));
        this.add((Component)this.hintArea, "South");
    }

    private void makeDefinedFilterSetsListSelectionVisible() {
        this.definedFilterSetsList.scrollRectToVisible(this.definedFilterSetsList.getCellBounds(this.definedFilterSetsList.getSelectedIndex(), this.definedFilterSetsList.getSelectedIndex()));
    }

    private void moveSelectedFilterDown() {
        int n;
        if (this.definedFilterSetsList != null && (n = this.definedFilterSetsList.getSelectedIndex()) < this.definedFilterSetsList.getModel().getSize() - 1) {
            this.filterSets.moveFilterSetDown(n);
            DefinedFilterSetsListModel definedFilterSetsListModel = (DefinedFilterSetsListModel)this.definedFilterSetsList.getModel();
            definedFilterSetsListModel.fireContentsChanged(n, n + 1);
            this.definedFilterSetsList.setSelectedIndex(n + 1);
            this.makeDefinedFilterSetsListSelectionVisible();
        }
    }

    private void moveSelectedFilterUp() {
        int n;
        if (this.definedFilterSetsList != null && (n = this.definedFilterSetsList.getSelectedIndex()) > 0) {
            this.filterSets.moveFilterSetUp(n);
            DefinedFilterSetsListModel definedFilterSetsListModel = (DefinedFilterSetsListModel)this.definedFilterSetsList.getModel();
            definedFilterSetsListModel.fireContentsChanged(n - 1, n);
            this.definedFilterSetsList.setSelectedIndex(n - 1);
            this.makeDefinedFilterSetsListSelectionVisible();
        }
    }

    private void processUniqueFilterSetNameCheckAt(int n) {
        int n2 = this.definedFilterSetsList.getSelectedIndex();
        if (n2 == -1) {
            return;
        }
        if (this.filterSets.getFilterSetAt(n).getFilterSetName().trim().length() == 0 || this.containsFilterSetNameExceptIndex(this.filterSets.getFilterSetAt(n).getFilterSetName(), n)) {
            this.filterSets.getFilterSetAt(n).setFilterSetName(this.createUniqueFilterSetName(this.filterSets.getFilterSetAt(n).getFilterSetName()));
            ((DefinedFilterSetsListModel)this.definedFilterSetsList.getModel()).fireContentsChanged(n, n);
        }
        this.filterNameTextField.setText(this.filterSets.getFilterSetAt(n2).getFilterSetName());
    }

    private void removeSelectedFilterSet() {
        int n;
        if (this.definedFilterSetsList != null && (n = this.definedFilterSetsList.getSelectedIndex()) != -1) {
            this.filterSets.removeFilterSet(n);
            DefinedFilterSetsListModel definedFilterSetsListModel = (DefinedFilterSetsListModel)this.definedFilterSetsList.getModel();
            definedFilterSetsListModel.fireIntervalRemoved(n, n);
            if (n != 0) {
                this.definedFilterSetsList.setSelectedIndex(n - 1);
            } else if (definedFilterSetsListModel.getSize() > 0) {
                this.definedFilterSetsList.setSelectedIndex(0);
            }
        }
    }

    private void toggleSelectedRowCheck() {
        int n = this.activeFiltersTable.getSelectedRow();
        boolean bl = this.selectedFilterSetChecks[n] == false;
        this.selectedFilterSetChecks[n] = bl;
        if (bl) {
            this.selectedFilterSet.addActiveGlobalFilter(this.nbProfiler.getGlobalFilters().getFilterNames()[n]);
        } else {
            this.selectedFilterSet.removeActiveGlobalFilter(this.nbProfiler.getGlobalFilters().getFilterNames()[n]);
        }
        ((AbstractTableModel)this.activeFiltersTable.getModel()).fireTableDataChanged();
        this.activeFiltersTable.setRowSelectionInterval(n, n);
        this.activeFiltersTable.repaint();
    }

    private void updateSelectedFilterSetProperties() {
        if (this.selectedFilterSet == null) {
            this.filterSetPropertiesPanel.setVisible(false);
            this.selectedFilterSetChecks = new Boolean[0];
        } else {
            if (!this.filterSetPropertiesPanel.isVisible()) {
                this.filterSetPropertiesPanel.setVisible(true);
            }
            this.filterNameTextField.setText(this.selectedFilterSet.getFilterSetName());
            if (this.selectedFilterSet.isExclusive()) {
                this.filterTypeExclusiveRadio.setSelected(true);
            } else {
                this.filterTypeInclusiveRadio.setSelected(true);
            }
            this.selectedFilterSetChecks = new Boolean[this.nbProfiler.getGlobalFilters().getFilterNames().length];
            for (int i = 0; i < this.selectedFilterSetChecks.length; ++i) {
                this.selectedFilterSetChecks[i] = this.selectedFilterSet.containsActiveGlobalFilter(this.nbProfiler.getGlobalFilters().getFilterNames()[i]) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        ((AbstractTableModel)this.activeFiltersTable.getModel()).fireTableDataChanged();
        this.activeFiltersTable.repaint();
    }

    private void updateSelection() {
        this.selectedFilterSetIndex = this.definedFilterSetsList.getSelectedIndex();
        this.selectedFilterSet = this.selectedFilterSetIndex == -1 ? null : this.filterSets.getFilterSetAt(this.selectedFilterSetIndex);
        this.updateSelectedFilterSetProperties();
    }

    private final class FilterNameTextFieldKeyListener
    extends KeyAdapter {
        private FilterNameTextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    keyEvent.consume();
                    FilterSetsPanel.this.processUniqueFilterSetNameCheckAt(FilterSetsPanel.this.definedFilterSetsList.getSelectedIndex());
                    FilterSetsPanel.this.filterTypeExclusiveRadio.requestFocus();
                    break;
                }
                case 27: {
                    keyEvent.consume();
                    FilterSetsPanel.this.filterNameTextField.setText(FilterSetsPanel.this.filterSetNameBeforeEditing);
                    FilterSetsPanel.this.filterNameTextField.selectAll();
                }
            }
        }
    }

    private final class FilterNameTextFieldFocusListener
    extends FocusAdapter {
        private int lastEditedFilterSetIndex;

        private FilterNameTextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.lastEditedFilterSetIndex = FilterSetsPanel.this.definedFilterSetsList.getSelectedIndex();
            FilterSetsPanel.this.filterSetNameBeforeEditing = FilterSetsPanel.this.filterNameTextField.getText();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FilterSetsPanel.this.processUniqueFilterSetNameCheckAt(this.lastEditedFilterSetIndex);
        }
    }

    private final class FilterNameTextFieldDocumentListener
    implements DocumentListener {
        private FilterNameTextFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateDefinedFilterSetsList();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateDefinedFilterSetsList();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateDefinedFilterSetsList();
        }

        private void updateDefinedFilterSetsList() {
            if (FilterSetsPanel.this.selectedFilterSet == null) {
                return;
            }
            String string = FilterSetsPanel.this.filterNameTextField.getText().trim();
            if (string.length() == 0) {
                FilterSetsPanel.this.selectedFilterSet.setFilterSetName("");
                string = FilterSetsPanel.this.createUniqueFilterSetName();
            }
            FilterSetsPanel.this.selectedFilterSet.setFilterSetName(string);
            DefinedFilterSetsListModel definedFilterSetsListModel = (DefinedFilterSetsListModel)FilterSetsPanel.this.definedFilterSetsList.getModel();
            definedFilterSetsListModel.fireContentsChanged(FilterSetsPanel.this.definedFilterSetsList.getSelectedIndex(), FilterSetsPanel.this.definedFilterSetsList.getSelectedIndex());
        }
    }

    private final class DefinedFilterSetsListSelectionListener
    implements ListSelectionListener {
        private DefinedFilterSetsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FilterSetsPanel.this.updateSelection();
            if (FilterSetsPanel.this.selectedFilterSetIndex == -1) {
                FilterSetsPanel.this.removeFilterSetButton.setEnabled(false);
                FilterSetsPanel.this.moveUpButton.setEnabled(false);
                FilterSetsPanel.this.moveDownButton.setEnabled(false);
            } else {
                FilterSetsPanel.this.removeFilterSetButton.setEnabled(true);
                if (FilterSetsPanel.this.selectedFilterSetIndex > 0) {
                    FilterSetsPanel.this.moveUpButton.setEnabled(true);
                } else {
                    FilterSetsPanel.this.moveUpButton.setEnabled(false);
                }
                if (FilterSetsPanel.this.selectedFilterSetIndex < FilterSetsPanel.this.definedFilterSetsList.getModel().getSize() - 1) {
                    FilterSetsPanel.this.moveDownButton.setEnabled(true);
                } else {
                    FilterSetsPanel.this.moveDownButton.setEnabled(false);
                }
            }
        }
    }

    private final class DefinedFilterSetsListModel
    extends AbstractListModel {
        private DefinedFilterSetsListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            return FilterSetsPanel.this.filterSets.getFilterSetAt(n).getFilterSetName();
        }

        @Override
        public int getSize() {
            return FilterSetsPanel.this.filterSets.getFilterSetsCount();
        }

        public void fireContentsChanged(int n, int n2) {
            this.fireContentsChanged(this, n, n2);
        }

        public void fireIntervalAdded(int n, int n2) {
            this.fireIntervalAdded(this, n, n2);
        }

        public void fireIntervalRemoved(int n, int n2) {
            this.fireIntervalRemoved(this, n, n2);
        }
    }

    private final class DefinedFilterSetsListKeyListener
    extends KeyAdapter {
        private DefinedFilterSetsListKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 127: {
                    keyEvent.consume();
                    FilterSetsPanel.this.removeSelectedFilterSet();
                    break;
                }
                case 78: {
                    if (keyEvent.getModifiers() == 2) {
                        keyEvent.consume();
                        FilterSetsPanel.this.addNewFilterSet();
                        break;
                    }
                }
                case 38: {
                    if (keyEvent.getModifiers() == 2) {
                        keyEvent.consume();
                        if (FilterSetsPanel.this.definedFilterSetsList.getSelectedIndex() <= 0) break;
                        FilterSetsPanel.this.moveSelectedFilterUp();
                        break;
                    }
                }
                case 40: {
                    if (keyEvent.getModifiers() == 2) {
                        keyEvent.consume();
                        if (FilterSetsPanel.this.definedFilterSetsList.getSelectedIndex() >= FilterSetsPanel.this.definedFilterSetsList.getModel().getSize() - 1) break;
                        FilterSetsPanel.this.moveSelectedFilterDown();
                        break;
                    }
                }
                case 27: {
                    FilterSetsPanel.this.processKeyEvent(keyEvent);
                }
            }
        }
    }

    private final class ActiveFiltersTableViewport
    extends JViewport
    implements TableColumnModelListener {
        private final JTableHeader tableHeader;

        public ActiveFiltersTableViewport(JTable jTable) {
            this.setView(jTable);
            this.setBackground(jTable.getBackground());
            this.tableHeader = jTable.getTableHeader();
            this.tableHeader.getColumnModel().addColumnModelListener(this);
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.repaint();
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.repaint();
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            this.repaint();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.repaint();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.paintVerticalLines(graphics);
        }

        private int getEmptySpaceY() {
            if (this.getView() == null) {
                return 0;
            }
            return this.getView().getHeight();
        }

        private void paintVerticalLines(Graphics graphics) {
            int n = this.getEmptySpaceY();
            graphics.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            for (int i = 0; i < this.tableHeader.getColumnModel().getColumnCount(); ++i) {
                Rectangle rectangle = this.tableHeader.getHeaderRect(i);
                graphics.drawLine(rectangle.x + rectangle.width - 1, n, rectangle.x + rectangle.width - 1, this.getHeight() - 1);
            }
        }
    }

    private final class ActiveFiltersTableMouseListener
    extends MouseAdapter {
        private ActiveFiltersTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() % 2 == 0) {
                int n = FilterSetsPanel.this.activeFiltersTable.getSelectedColumn();
                if (n == 0) {
                    return;
                }
                if (n == 1) {
                    FilterSetsPanel.this.toggleSelectedRowCheck();
                    return;
                }
                if (n == 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ActiveFiltersTableMouseListener.this.editGlobalFilterAtRow(FilterSetsPanel.this.activeFiltersTable.getSelectedRow());
                        }
                    });
                }
            }
        }

        private void editGlobalFilterAtRow(int n) {
            GlobalFiltersPanel globalFiltersPanel = GlobalFiltersPanel.getDefault();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)globalFiltersPanel, EDIT_GLOBAL_FILTERS_DIALOG_CAPTION, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
            Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
            globalFiltersPanel.init();
            dialog.pack();
            globalFiltersPanel.editFilterValueAtRow(n);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                globalFiltersPanel.applyChanges();
                FilterSetsPanel.getDefault().processGlobalFiltersChanged();
            }
        }
    }

    private final class ActiveFiltersTableModel
    extends AbstractTableModel {
        private ActiveFiltersTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return FilterSetsPanel.this.columnClasses[n];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            return FilterSetsPanel.this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return FilterSetsPanel.this.nbProfiler.getGlobalFilters().getFilterNames().length;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ((FilterSetsPanel)FilterSetsPanel.this).selectedFilterSetChecks[n] = (Boolean)object;
                boolean bl = (Boolean)object;
                if (bl) {
                    FilterSetsPanel.this.selectedFilterSet.addActiveGlobalFilter(FilterSetsPanel.this.nbProfiler.getGlobalFilters().getFilterNames()[n]);
                } else {
                    FilterSetsPanel.this.selectedFilterSet.removeActiveGlobalFilter(FilterSetsPanel.this.nbProfiler.getGlobalFilters().getFilterNames()[n]);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return FilterSetsPanel.this.selectedFilterSetChecks[n];
                }
                case 1: {
                    return FilterSetsPanel.this.nbProfiler.getGlobalFilters().getFilterNames()[n];
                }
                case 2: {
                    return FilterSetsPanel.this.nbProfiler.getGlobalFilters().getFilterValues()[n];
                }
            }
            return null;
        }
    }

    private final class ActiveFiltersTableKeyListener
    extends KeyAdapter {
        private ActiveFiltersTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 32: {
                    keyEvent.consume();
                    FilterSetsPanel.this.toggleSelectedRowCheck();
                    break;
                }
                case 10: {
                    FilterSetsPanel.this.toggleSelectedRowCheck();
                    break;
                }
                case 27: {
                    FilterSetsPanel.this.processKeyEvent(keyEvent);
                }
            }
        }
    }
}

