/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.ui.components.JExtendedComboBox;
import org.netbeans.modules.profiler.ui.FilterSetsPanel;
import org.netbeans.modules.profiler.ui.GlobalFiltersPanel;
import org.netbeans.modules.profiler.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.QuickFilterPanel;
import org.netbeans.modules.profiler.ui.panels.PreferredInstrFilterPanel;
import org.netbeans.modules.profiler.ui.panels.RootMethodsPanel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CPUSettingsBasicPanel
extends DefaultSettingsPanel
implements ActionListener,
PopupMenuListener,
HelpCtx.Provider {
    private static final String NO_ROOTS_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_NoRootsString");
    private static final String ONE_ROOT_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_OneRootString");
    private static final String MORE_ROOTS_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_MoreRootsString");
    private static final String QUICK_FILTER_DIALOG_CAPTION = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_QuickFilterDialogCaption");
    private static final String FILTER_SETS_DIALOG_CAPTION = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_FilterSetsDialogCaption");
    private static final String GLOBAL_FILTERS_DIALOG_CAPTION = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_GlobalFiltersDialogCaption");
    private static final String ENTIRE_APP_RADIO_TEXT = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_EntireAppRadioText");
    private static final String PART_APP_RADIO_TEXT = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_PartAppRadioText");
    private static final String STOPWATCH_RADIO_TEXT = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_StopwatchRadioText");
    private static final String FILTER_LABEL_TEXT = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_FilterLabelText");
    private static final String SHOW_FILTER_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_ShowFilterString");
    private static final String EDIT_FILTER_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_EditFilterString");
    private static final String EDIT_FILTERSET_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_EditFilterSetString");
    private static final String USE_PPS_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_UsePpsCheckboxText");
    private static final String SHOW_PPS_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_ShowPpsString");
    private static final String EDIT_GLOBAL_FILTER_STRING = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_EditGlobalFilterString");
    private static final String STP_ENTIREAPP_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpEntireAppTooltip");
    private static final String STP_PARTAPP_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpPartAppTooltip");
    private static final String STP_FILTER_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpFilterTooltip");
    private static final String STP_SHOWFILTER_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpShowFilterTooltip");
    private static final String STP_EDITFILTER_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpEditFilterTooltip");
    private static final String STP_MANAGEFILTERSETS_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpManageFilterSetsTooltip");
    private static final String STP_USEPPS_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpUsePpsTooltip");
    private static final String STP_SHOWPPS_TOOLTIP = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"StpShowPpsTooltip");
    private static final String SHOW_FILTER_CAPTION = NbBundle.getMessage(CPUSettingsBasicPanel.class, (String)"CPUSettingsBasicPanel_ShowFilterCaption");
    private static final String HELP_CTX_KEY = "CPUSettings.Basic.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("CPUSettings.Basic.HelpCtx");
    private HyperlinkLabel editFilterLink;
    private HyperlinkLabel editFilterSetsLink;
    private HyperlinkLabel partOfAppHintLink;
    private HyperlinkLabel profilingPointsLink;
    private HyperlinkLabel showFilterLink;
    private HyperlinkLabel stopwatchHintLink;
    private JButton globalFiltersButton;
    private JCheckBox profilingPointsCheckbox;
    private JComboBox filterCombo;
    private JLabel filterLabel;
    private JRadioButton entireAppRadio;
    private JRadioButton partOfAppRadio;
    private JRadioButton stopwatchRadio;
    private List<SimpleFilter> preferredInstrFilters;
    private Object selectedInstrumentationFilter = SimpleFilter.NO_FILTER;
    private Runnable profilingPointsDisplayer;
    private SimpleFilter quickFilter;
    private ClientUtils.SourceCodeSelection[] rootMethods = new ClientUtils.SourceCodeSelection[0];
    private boolean filterComboBoxPopupCancelled = false;
    private boolean lastProfilingPointsState;
    private boolean profilingPointsStateCache;

    public CPUSettingsBasicPanel() {
        this.initComponents();
    }

    public void setContext(List<SimpleFilter> list, Runnable runnable) {
        this.profilingPointsDisplayer = runnable;
        this.preferredInstrFilters = list;
        this.profilingPointsCheckbox.setEnabled(false);
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setInstrumentationFilter(Object object) {
        this.selectedInstrumentationFilter = object;
        this.updateFilterComboBoxItems();
        this.selectActiveComboItem();
        this.updateControls();
    }

    public Object getInstrumentationFilter() {
        return this.selectedInstrumentationFilter;
    }

    public void setProfilingType(int n) {
        this.entireAppRadio.setSelected(n == 8);
        this.partOfAppRadio.setSelected(n == 16);
        this.stopwatchRadio.setSelected(n == 32);
    }

    public int getProfilingType() {
        if (this.entireAppRadio.isSelected()) {
            return 8;
        }
        if (this.partOfAppRadio.isSelected()) {
            return 16;
        }
        return 32;
    }

    public void setQuickFilter(SimpleFilter simpleFilter) {
        this.quickFilter = simpleFilter;
    }

    public SimpleFilter getQuickFilter() {
        return this.quickFilter;
    }

    public void setRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.rootMethods = sourceCodeSelectionArray;
    }

    public ClientUtils.SourceCodeSelection[] getRootMethods() {
        return this.rootMethods;
    }

    public void setUseProfilingPoints(boolean bl) {
        this.profilingPointsCheckbox.setSelected(bl);
        this.updateEnabling();
    }

    public boolean getUseProfilingPoints() {
        return this.profilingPointsCheckbox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.globalFiltersButton) {
            CPUSettingsBasicPanel.performEditGlobalFiltersAction();
        } else if (actionEvent.getSource() == this.filterCombo) {
            this.updateComboLinks();
            this.updateControls();
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Tester Frame");
        CPUSettingsBasicPanel cPUSettingsBasicPanel = new CPUSettingsBasicPanel();
        cPUSettingsBasicPanel.setPreferredSize(new Dimension(375, 245));
        jFrame.getContentPane().add(cPUSettingsBasicPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.filterComboBoxPopupCancelled = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (!this.filterComboBoxPopupCancelled && this.quickFilter != null && this.quickFilter.equals(this.filterCombo.getSelectedItem())) {
            this.filterCombo.removePopupMenuListener(this);
            this.filterCombo.hidePopup();
            this.filterCombo.addPopupMenuListener(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CPUSettingsBasicPanel.this.performQuickFilterAction();
                }
            });
        }
        this.filterComboBoxPopupCancelled = false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.entireAppRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.entireAppRadio, (String)ENTIRE_APP_RADIO_TEXT);
        this.entireAppRadio.setToolTipText(STP_ENTIREAPP_TOOLTIP);
        this.entireAppRadio.setOpaque(false);
        this.entireAppRadio.setSelected(true);
        buttonGroup.add(this.entireAppRadio);
        this.entireAppRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsBasicPanel.this.updateControls();
            }
        });
        this.entireAppRadio.addActionListener(this.getSettingsChangeListener());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 30, 0, 0);
        this.add((Component)this.entireAppRadio, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, Math.max(((CPUSettingsBasicPanel)CPUSettingsBasicPanel.this).partOfAppRadio.getPreferredSize().height, ((CPUSettingsBasicPanel)CPUSettingsBasicPanel.this).partOfAppHintLink.getPreferredSize().height));
            }
        };
        this.partOfAppRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.partOfAppRadio, (String)PART_APP_RADIO_TEXT);
        this.partOfAppRadio.setToolTipText(STP_PARTAPP_TOOLTIP);
        this.partOfAppRadio.setOpaque(false);
        this.partOfAppRadio.setSelected(true);
        buttonGroup.add(this.partOfAppRadio);
        this.partOfAppRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsBasicPanel.this.updateControls();
            }
        });
        this.partOfAppRadio.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.partOfAppRadio, gridBagConstraints);
        Color color = Color.RED;
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        String string2 = "rgb(" + Color.GRAY.getRed() + "," + Color.GRAY.getGreen() + "," + Color.GRAY.getBlue() + ")";
        String string3 = "<nobr>" + MessageFormat.format(ONE_ROOT_STRING, string2, "") + "</nobr>";
        String string4 = "<nobr>" + MessageFormat.format(ONE_ROOT_STRING, string2, "color=\"" + string + "\"") + "</nobr>";
        this.partOfAppHintLink = new HyperlinkLabel(string3, string4, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performRootMethodsAction();
            }
        });
        this.partOfAppHintLink.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel.add((Component)((Object)this.partOfAppHintLink), gridBagConstraints);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.stopwatchRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.stopwatchRadio, (String)STOPWATCH_RADIO_TEXT);
        this.stopwatchRadio.setOpaque(false);
        this.stopwatchRadio.setSelected(true);
        buttonGroup.add(this.stopwatchRadio);
        this.stopwatchRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsBasicPanel.this.updateControls();
            }
        });
        this.stopwatchRadio.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.stopwatchRadio, gridBagConstraints);
        string3 = "<nobr><font color='" + string2 + "'>2 stopwatches defined, </font><a href='#'>view</a></nobr>";
        string4 = "<nobr><font color='" + string2 + "'>2 stopwatches defined, </font><a href='#' color=\"" + string + "\">view</a></nobr>";
        this.stopwatchHintLink = new HyperlinkLabel(string3, string4, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performRootMethodsAction();
            }
        });
        this.stopwatchHintLink.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel2.add((Component)((Object)this.stopwatchHintLink), gridBagConstraints);
        jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setVisible(false);
        this.filterLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)FILTER_LABEL_TEXT);
        this.filterLabel.setToolTipText(STP_FILTER_TOOLTIP);
        this.filterLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(25, 25, 0, 0);
        this.add((Component)this.filterLabel, gridBagConstraints);
        this.filterCombo = new JExtendedComboBox(){

            public int getPreferredWidth() {
                int n = super.getPreferredSize().width;
                n = Math.max(n, 220);
                n = Math.min(n, 300);
                return n;
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.getPreferredWidth(), super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.filterLabel.setLabelFor(this.filterCombo);
        this.filterCombo.setToolTipText(STP_FILTER_TOOLTIP);
        this.filterCombo.addActionListener(this);
        this.filterCombo.addActionListener(this.getSettingsChangeListener());
        this.filterCombo.addPopupMenuListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(25, 5, 0, 0);
        this.add((Component)this.filterCombo, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        string3 = "<nobr><a href='#'>" + SHOW_FILTER_STRING + "</a></nobr>";
        string4 = "<nobr><a href='#' color=\"" + string + "\">" + SHOW_FILTER_STRING + "</a></nobr>";
        this.showFilterLink = new HyperlinkLabel(string3, string4, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performShowFilterAction();
            }
        });
        this.showFilterLink.setToolTipText(STP_SHOWFILTER_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel3.add((Component)((Object)this.showFilterLink), gridBagConstraints);
        string3 = "<nobr><a href='#'>" + EDIT_FILTER_STRING + "</a></nobr>";
        string4 = "<nobr><a href='#' color=\"" + string + "\">" + EDIT_FILTER_STRING + "</a></nobr>";
        this.editFilterLink = new HyperlinkLabel(string3, string4, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performQuickFilterAction();
            }
        });
        this.editFilterLink.setVisible(false);
        this.editFilterLink.setToolTipText(STP_EDITFILTER_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel3.add((Component)((Object)this.editFilterLink), gridBagConstraints);
        string3 = "<nobr><a href='#'>" + EDIT_FILTERSET_STRING + "</a></nobr>";
        string4 = "<nobr><a href='#' color=\"" + string + "\">" + EDIT_FILTERSET_STRING + "</a></nobr>";
        this.editFilterSetsLink = new HyperlinkLabel(string3, string4, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performCustomizeFilterSetsAction();
            }
        });
        this.editFilterSetsLink.setToolTipText(STP_MANAGEFILTERSETS_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)((Object)this.editFilterSetsLink), gridBagConstraints);
        jPanel3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.profilingPointsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profilingPointsCheckbox, (String)USE_PPS_CHECKBOX_TEXT);
        this.profilingPointsCheckbox.setToolTipText(STP_USEPPS_TOOLTIP);
        this.profilingPointsCheckbox.setOpaque(false);
        this.profilingPointsCheckbox.setSelected(true);
        this.profilingPointsStateCache = this.profilingPointsCheckbox.isSelected();
        this.profilingPointsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsBasicPanel.this.updateEnabling();
            }
        });
        this.profilingPointsCheckbox.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel4.add((Component)this.profilingPointsCheckbox, gridBagConstraints);
        string3 = "<nobr><a href='#'>" + SHOW_PPS_STRING + "</a></nobr>";
        string4 = "<nobr><a href='#' color=\"" + string + "\">" + SHOW_PPS_STRING + "</a></nobr>";
        this.profilingPointsLink = new HyperlinkLabel(string3, string4, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performShowProfilingPointsAction();
            }
        });
        this.profilingPointsLink.setToolTipText(STP_SHOWPPS_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)((Object)this.profilingPointsLink), gridBagConstraints);
        jPanel4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 25, 10, 0);
        this.add((Component)jPanel4, gridBagConstraints);
        this.globalFiltersButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.globalFiltersButton, (String)EDIT_GLOBAL_FILTER_STRING);
        Dimension dimension = this.showFilterLink.getPreferredSize();
        Dimension dimension2 = this.editFilterLink.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        this.showFilterLink.setPreferredSize(dimension3);
        this.editFilterLink.setPreferredSize(dimension3);
    }

    private void performCustomizeFilterSetsAction() {
        FilterSetsPanel filterSetsPanel = FilterSetsPanel.getDefault();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)filterSetsPanel, FILTER_SETS_DIALOG_CAPTION, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialogDescriptor.setAdditionalOptions(new Object[]{this.globalFiltersButton});
        dialogDescriptor.setButtonListener((ActionListener)this);
        int n = 4;
        if (this.preferredInstrFilters != null) {
            n += this.preferredInstrFilters.size();
        }
        filterSetsPanel.init(Math.max(this.filterCombo.getSelectedIndex() - n, 0));
        dialog.pack();
        dialog.setVisible(true);
        dialogDescriptor.setButtonListener(null);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            filterSetsPanel.applyChanges();
            if (filterSetsPanel.getSelectedFilterSet() != null) {
                this.selectedInstrumentationFilter = filterSetsPanel.getSelectedFilterSet();
            }
            this.updateFilterComboBoxItems();
        }
    }

    private static void performEditGlobalFiltersAction() {
        GlobalFiltersPanel globalFiltersPanel = GlobalFiltersPanel.getDefault();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)globalFiltersPanel, GLOBAL_FILTERS_DIALOG_CAPTION, true, new Object[]{globalFiltersPanel.getOKButton(), globalFiltersPanel.getCancelButton()}, (Object)globalFiltersPanel.getOKButton(), 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        globalFiltersPanel.init();
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == globalFiltersPanel.getOKButton()) {
            globalFiltersPanel.applyChanges();
            FilterSetsPanel.getDefault().processGlobalFiltersChanged();
        }
    }

    private void performQuickFilterAction() {
        QuickFilterPanel quickFilterPanel = QuickFilterPanel.getDefault();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)quickFilterPanel, QUICK_FILTER_DIALOG_CAPTION, true, new Object[]{quickFilterPanel.getOKButton(), quickFilterPanel.getCancelButton()}, (Object)quickFilterPanel.getOKButton(), 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        quickFilterPanel.init(this.quickFilter);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == quickFilterPanel.getOKButton()) {
            quickFilterPanel.applyChanges();
            this.filterCombo.setSelectedItem(this.quickFilter);
        }
        this.updateControls();
        this.filterCombo.requestFocus();
    }

    private void performRootMethodsAction() {
        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = RootMethodsPanel.getSelectedRootMethods(this.rootMethods);
        if (sourceCodeSelectionArray != null) {
            this.rootMethods = sourceCodeSelectionArray;
            this.updateControls();
        }
    }

    private void performShowFilterAction() {
        this.selectedInstrumentationFilter = this.filterCombo.getSelectedItem();
        if (!this.preferredInstrFilters.contains(this.selectedInstrumentationFilter)) {
            return;
        }
        PreferredInstrFilterPanel preferredInstrFilterPanel = PreferredInstrFilterPanel.getDefault();
        PreferredInstrFilterPanel.FilterResolver filterResolver = new PreferredInstrFilterPanel.FilterResolver(){

            @Override
            protected String[] computeFilterValues() {
                SimpleFilter simpleFilter = SelectProfilingTask.getDefault().getResolvedPredefinedFilter((SimpleFilter)CPUSettingsBasicPanel.this.selectedInstrumentationFilter);
                String[] stringArray = FilterUtils.getSeparateFilters((String)simpleFilter.getFilterValue());
                return stringArray;
            }
        };
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)preferredInstrFilterPanel, MessageFormat.format(SHOW_FILTER_CAPTION, ((SimpleFilter)this.selectedInstrumentationFilter).getFilterName()), true, new Object[]{preferredInstrFilterPanel.OPEN_IN_QUICKFILTER_BUTTON, preferredInstrFilterPanel.CLOSE_BUTTON}, (Object)preferredInstrFilterPanel.CLOSE_BUTTON, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        preferredInstrFilterPanel.init(filterResolver);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == preferredInstrFilterPanel.OPEN_IN_QUICKFILTER_BUTTON) {
            String[] stringArray = filterResolver.getFilterValues();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i] + (i == stringArray.length - 1 ? "" : " "));
            }
            this.quickFilter.setFilterType(2);
            this.quickFilter.setFilterValue(stringBuffer.toString());
            this.performQuickFilterAction();
            return;
        }
        this.filterCombo.requestFocus();
    }

    private void performShowProfilingPointsAction() {
        this.profilingPointsDisplayer.run();
    }

    private void selectActiveComboItem() {
        int n = this.preferredInstrFilters != null && !this.preferredInstrFilters.isEmpty() ? 1 : 0;
        for (int i = 0; i < this.filterCombo.getItemCount(); ++i) {
            Object e = this.filterCombo.getItemAt(i);
            if (!e.equals(this.selectedInstrumentationFilter)) continue;
            n = i;
            break;
        }
        this.filterCombo.setSelectedIndex(n);
        this.updateComboLinks();
    }

    private void updateComboLinks() {
        this.selectedInstrumentationFilter = this.filterCombo.getSelectedItem();
        if (this.selectedInstrumentationFilter == null) {
            this.selectedInstrumentationFilter = SimpleFilter.NO_FILTER;
        }
        if (this.quickFilter.equals(this.selectedInstrumentationFilter)) {
            this.showFilterLink.setVisible(false);
            this.editFilterLink.setVisible(true);
        } else if (this.preferredInstrFilters != null && this.preferredInstrFilters.contains(this.selectedInstrumentationFilter)) {
            this.showFilterLink.setEnabled(true);
            this.showFilterLink.setVisible(true);
            this.editFilterLink.setVisible(false);
        } else {
            this.showFilterLink.setEnabled(false);
            this.showFilterLink.setVisible(true);
            this.editFilterLink.setVisible(false);
        }
    }

    private void updateControls() {
        this.partOfAppHintLink.setVisible(this.partOfAppRadio.isSelected());
        this.stopwatchHintLink.setVisible(this.stopwatchRadio.isSelected());
        boolean bl = true;
        boolean bl2 = true;
        if (this.partOfAppRadio.isSelected()) {
            Color color = Color.RED;
            String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
            String string2 = "rgb(" + Color.GRAY.getRed() + "," + Color.GRAY.getGreen() + "," + Color.GRAY.getBlue() + ")";
            String string3 = "";
            String string4 = "";
            if (this.rootMethods.length == 0) {
                string3 = "<nobr>" + MessageFormat.format(NO_ROOTS_STRING, string2, "") + "</nobr>";
                string4 = "<nobr>" + MessageFormat.format(NO_ROOTS_STRING, string2, "color=\"" + string + "\"") + "</nobr>";
                bl = false;
            } else if (this.rootMethods.length == 1) {
                string3 = "<nobr>" + MessageFormat.format(ONE_ROOT_STRING, string2, "") + "</nobr>";
                string4 = "<nobr>" + MessageFormat.format(ONE_ROOT_STRING, string2, "color=\"" + string + "\"") + "</nobr>";
                bl = true;
            } else {
                string3 = "<nobr>" + MessageFormat.format(MORE_ROOTS_STRING, string2, this.rootMethods.length, "") + "</nobr>";
                string4 = "<nobr>" + MessageFormat.format(MORE_ROOTS_STRING, string2, this.rootMethods.length, "color=\"" + string + "\"") + "</nobr>";
                bl = true;
            }
            this.partOfAppHintLink.setText(string3, string4);
        }
        if (this.quickFilter != null && this.quickFilter.equals(this.filterCombo.getSelectedItem()) && this.quickFilter.getFilterValue().trim().length() == 0) {
            bl2 = false;
        }
        if (bl && bl2) {
            SelectProfilingTask.getDefault().enableSubmitButton();
        } else {
            SelectProfilingTask.getDefault().disableSubmitButton();
        }
    }

    private void updateEnabling() {
        this.profilingPointsLink.setEnabled(this.profilingPointsCheckbox.isSelected() && this.profilingPointsCheckbox.isEnabled());
    }

    private void updateFilterComboBoxItems() {
        this.filterCombo.removeActionListener(this);
        this.filterCombo.removeAllItems();
        this.filterCombo.addItem(FilterUtils.NONE_FILTER);
        if (this.preferredInstrFilters != null && this.preferredInstrFilters.size() > 0) {
            for (int i = 0; i < this.preferredInstrFilters.size(); ++i) {
                this.filterCombo.addItem(this.preferredInstrFilters.get(i));
            }
        }
        this.filterCombo.addItem(new JSeparator());
        this.filterCombo.addItem(this.quickFilter);
        this.filterCombo.addItem(new JSeparator());
        DefinedFilterSets definedFilterSets = Profiler.getDefault().getDefinedFilterSets();
        for (int i = 0; i < definedFilterSets.getFilterSetsCount(); ++i) {
            this.filterCombo.addItem(definedFilterSets.getFilterSetAt(i));
        }
        this.selectActiveComboItem();
        this.filterCombo.addActionListener(this);
    }
}

