/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.lang.reflect.Member;
import java.util.Iterator;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ContextFactory;
import sun.org.mozilla.javascript.internal.InterfaceAdapter;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.Wrapper;

public abstract class VMBridge {
    static final VMBridge instance = VMBridge.makeInstance();

    private static VMBridge makeInstance() {
        String[] stringArray = new String[]{"sun.org.mozilla.javascript.internal.VMBridge_custom", "sun.org.mozilla.javascript.internal.jdk15.VMBridge_jdk15", "sun.org.mozilla.javascript.internal.jdk13.VMBridge_jdk13", "sun.org.mozilla.javascript.internal.jdk11.VMBridge_jdk11"};
        for (int i = 0; i != stringArray.length; ++i) {
            VMBridge vMBridge;
            String string = stringArray[i];
            Class<?> clazz = Kit.classOrNull(string);
            if (clazz == null || (vMBridge = (VMBridge)Kit.newInstanceOrNull(clazz)) == null) continue;
            return vMBridge;
        }
        throw new IllegalStateException("Failed to create VMBridge instance");
    }

    protected abstract Object getThreadContextHelper();

    protected abstract Context getContext(Object var1);

    protected abstract void setContext(Object var1, Context var2);

    protected abstract ClassLoader getCurrentThreadClassLoader();

    protected abstract boolean tryToMakeAccessible(Object var1);

    protected Object getInterfaceProxyHelper(ContextFactory contextFactory, Class<?>[] classArray) {
        throw Context.reportRuntimeError("VMBridge.getInterfaceProxyHelper is not supported");
    }

    protected Object newInterfaceProxy(Object object, ContextFactory contextFactory, InterfaceAdapter interfaceAdapter, Object object2, Scriptable scriptable) {
        throw Context.reportRuntimeError("VMBridge.newInterfaceProxy is not supported");
    }

    protected abstract boolean isVarArgs(Member var1);

    public Iterator<?> getJavaIterator(Context context, Scriptable scriptable, Object object) {
        if (object instanceof Wrapper) {
            Object object2 = ((Wrapper)object).unwrap();
            Iterator iterator = null;
            if (object2 instanceof Iterator) {
                iterator = (Iterator)object2;
            }
            return iterator;
        }
        return null;
    }
}

