/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java2d.Surface;

public class Texture
extends Surface {
    private static TexturePaint bluedots;
    private static TexturePaint greendots;
    private static TexturePaint triangles;
    private static TexturePaint blacklines;
    private static TexturePaint gradient;

    public Texture() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        Rectangle rectangle = new Rectangle(10, 10, n - 20, n2 / 2 - 20);
        graphics2D.setPaint(gradient);
        graphics2D.fill(rectangle);
        graphics2D.setPaint(Color.GREEN);
        graphics2D.setStroke(new BasicStroke(20.0f));
        graphics2D.draw(rectangle);
        graphics2D.setPaint(blacklines);
        graphics2D.setStroke(new BasicStroke(15.0f));
        graphics2D.draw(rectangle);
        Font font = new Font("Times New Roman", 1, n / 5);
        TextLayout textLayout = new TextLayout("Texture", font, graphics2D.getFontRenderContext());
        int n3 = (int)textLayout.getBounds().getWidth();
        int n4 = (int)textLayout.getBounds().getHeight();
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(n / 2 - n3 / 2, (double)n2 * 0.25 + (double)(n4 / 2)));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(shape);
        graphics2D.setPaint(greendots);
        graphics2D.fill(shape);
        rectangle.setLocation(10, n2 / 2 + 10);
        graphics2D.setPaint(triangles);
        graphics2D.fill(rectangle);
        graphics2D.setPaint(blacklines);
        graphics2D.setStroke(new BasicStroke(20.0f));
        graphics2D.draw(rectangle);
        graphics2D.setPaint(Color.GREEN);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.draw(rectangle);
        font = new Font("serif", 1, n / 4);
        textLayout = new TextLayout("Paint", font, graphics2D.getFontRenderContext());
        n3 = (int)textLayout.getBounds().getWidth();
        n4 = (int)textLayout.getBounds().getHeight();
        shape = textLayout.getOutline(AffineTransform.getTranslateInstance(n / 2 - n3 / 2, (double)n2 * 0.75 + (double)(n4 / 2)));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(5.0f));
        graphics2D.draw(shape);
        graphics2D.setPaint(bluedots);
        graphics2D.fill(shape);
    }

    public static void main(String[] stringArray) {
        Texture.createDemoFrame(new Texture());
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, 10, 10);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(5.0f, 10.0f);
        generalPath.lineTo(10.0f, 0.0f);
        generalPath.closePath();
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fill(generalPath);
        triangles = new TexturePaint(bufferedImage, new Rectangle(0, 0, 10, 10));
        bufferedImage = new BufferedImage(5, 5, 1);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, 5, 5);
        graphics2D.setColor(Color.GRAY);
        graphics2D.fillRect(1, 1, 4, 4);
        blacklines = new TexturePaint(bufferedImage, new Rectangle(0, 0, 5, 5));
        int n = 30;
        int n2 = 30;
        bufferedImage = new BufferedImage(n, n2, 1);
        graphics2D = bufferedImage.createGraphics();
        Color color = Color.WHITE;
        Color color2 = Color.LIGHT_GRAY;
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, (float)n * 0.35f, (float)n2 * 0.35f, color2));
        graphics2D.fillRect(0, 0, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(n, 0.0f, color, (float)n * 0.65f, (float)n2 * 0.35f, color2));
        graphics2D.fillRect(n / 2, 0, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(0.0f, n2, color, (float)n * 0.35f, (float)n2 * 0.65f, color2));
        graphics2D.fillRect(0, n2 / 2, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(n, n2, color, (float)n * 0.65f, (float)n2 * 0.65f, color2));
        graphics2D.fillRect(n / 2, n2 / 2, n / 2, n2 / 2);
        gradient = new TexturePaint(bufferedImage, new Rectangle(0, 0, n, n2));
        bufferedImage = new BufferedImage(2, 2, 1);
        bufferedImage.setRGB(0, 0, -1);
        bufferedImage.setRGB(1, 0, -1);
        bufferedImage.setRGB(0, 1, -1);
        bufferedImage.setRGB(1, 1, -16776961);
        bluedots = new TexturePaint(bufferedImage, new Rectangle(0, 0, 2, 2));
        bufferedImage = new BufferedImage(2, 2, 1);
        bufferedImage.setRGB(0, 0, -1);
        bufferedImage.setRGB(1, 0, -1);
        bufferedImage.setRGB(0, 1, -1);
        bufferedImage.setRGB(1, 1, -16711936);
        greendots = new TexturePaint(bufferedImage, new Rectangle(0, 0, 2, 2));
    }
}

