/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.liveconnect;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.plugin.javascript.JSClassLoader;
import sun.plugin.javascript.ReflectUtil;

public class JavaClass
implements InvocationDelegate {
    private Class clazz;
    private Bridge bridge;
    private Map methodMap;
    private Map fieldMap;
    private MemberBundle constructors;
    private Map lowerCaseMethodMap;
    private Map lowerCaseFieldMap;
    private boolean isArray;
    private Class componentType;

    public JavaClass(Class clazz, Bridge bridge) {
        this.clazz = clazz;
        this.bridge = bridge;
        this.isArray = clazz.isArray();
        if (this.isArray) {
            this.componentType = clazz.getComponentType();
        }
    }

    private static String argsToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                Object object = objectArray[i];
                String string = null;
                if (object != null) {
                    string = object.getClass().getName();
                }
                stringBuffer.append(string);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean hasField(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        blArray[0] = this.hasField0(string, object, bl2);
        return true;
    }

    private boolean hasField0(String string, Object object, boolean bl) {
        Field field;
        if (this.isArray) {
            if ("length".equals(string)) {
                return true;
            }
            try {
                int n = Integer.parseInt(string);
                return n >= 0 && n < Array.getLength(object);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.fieldMap == null) {
            this.collectFields();
        }
        if ((field = (Field)this.fieldMap.get(string)) != null) {
            return true;
        }
        field = (Field)this.lowerCaseFieldMap.get(string.toLowerCase());
        return field != null;
    }

    public boolean hasMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        blArray[0] = this.hasMethod0(string, object, bl2);
        return true;
    }

    private boolean hasMethod0(String string, Object object, boolean bl) {
        MemberBundle memberBundle;
        if (this.methodMap == null) {
            this.collectMethods();
        }
        if ((memberBundle = (MemberBundle)this.methodMap.get(string)) != null) {
            return true;
        }
        memberBundle = (MemberBundle)this.lowerCaseMethodMap.get(string.toLowerCase());
        return memberBundle != null;
    }

    public boolean hasFieldOrMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        blArray[0] = bl3 = this.hasField0(string, object, bl2) || this.hasMethod0(string, object, bl2);
        return true;
    }

    public boolean invoke(String string, Object object, Object[] objectArray, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
        resultArray[0] = this.invoke0(string, object, objectArray, bl2);
        return true;
    }

    private Result invoke0(String string, Object object, Object[] objectArray, boolean bl) throws Exception {
        MemberBundle memberBundle;
        if (this.methodMap == null) {
            this.collectMethods();
        }
        if ((memberBundle = (MemberBundle)this.methodMap.get(string)) == null) {
            memberBundle = (MemberBundle)this.lowerCaseMethodMap.get(string.toLowerCase());
        }
        if (memberBundle == null) {
            throw new NoSuchMethodException(string + " in class: " + this.clazz.getName());
        }
        return memberBundle.invoke(object, objectArray);
    }

    public Object findClass(String string) {
        throw new UnsupportedOperationException("Should not call this");
    }

    public Object newInstance(Object object, Object[] objectArray) throws Exception {
        if (this.constructors == null) {
            this.collectConstructors();
        }
        Result result = null;
        try {
            result = this.constructors.invoke(null, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = this.constructors.invoke(null, null);
        }
        return result.value();
    }

    public boolean getField(String string, Object object, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
        resultArray[0] = this.getField0(string, object, bl2);
        return true;
    }

    private Result getField0(String string, Object object, boolean bl) throws Exception {
        Field field;
        if (this.isArray) {
            if ("length".equals(string)) {
                return new Result(new Integer(Array.getLength(object)), false);
            }
            int n = Integer.parseInt(string);
            return new Result(Array.get(object, n), JavaClass.isBoxingClass(object.getClass().getComponentType()));
        }
        if (this.fieldMap == null) {
            this.collectFields();
        }
        if ((field = (Field)this.fieldMap.get(string)) == null) {
            field = (Field)this.lowerCaseFieldMap.get(string.toLowerCase());
        }
        if (field == null) {
            throw new NoSuchFieldException(string + " in class: " + this.clazz.getName());
        }
        return new Result(field.get(object), JavaClass.isBoxingClass(field.getType()));
    }

    public boolean setField(String string, Object object, Object object2, boolean bl, boolean bl2) throws Exception {
        if (this.isArray) {
            int n = Integer.parseInt(string);
            Array.set(object, n, this.bridge.convert(object2, this.componentType));
        } else {
            Field field;
            if (this.fieldMap == null) {
                this.collectFields();
            }
            if ((field = (Field)this.fieldMap.get(string)) == null) {
                field = (Field)this.lowerCaseFieldMap.get(string.toLowerCase());
            }
            if (field == null) {
                throw new NoSuchFieldException(string);
            }
            Class<?> clazz = field.getType();
            field.set(object, this.bridge.convert(object2, clazz));
        }
        return true;
    }

    private static boolean isBoxingClass(Class clazz) {
        return clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Character.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    private void collectMethods() {
        Method[] methodArray = ReflectUtil.getJScriptMethods(this.clazz);
        HashMap<String, MemberBundle> hashMap = new HashMap<String, MemberBundle>();
        HashMap<String, MemberBundle> hashMap2 = new HashMap<String, MemberBundle>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            MemberBundle memberBundle = (MemberBundle)hashMap.get(method.getName());
            if (memberBundle == null) {
                memberBundle = new MemberBundle();
                hashMap.put(method.getName(), memberBundle);
            }
            memberBundle.add(method);
            String string = method.getName().toLowerCase();
            memberBundle = (MemberBundle)hashMap2.get(string);
            if (memberBundle == null) {
                memberBundle = new MemberBundle();
                hashMap2.put(string, memberBundle);
            }
            memberBundle.add(method);
        }
        this.methodMap = hashMap;
        this.lowerCaseMethodMap = hashMap2;
    }

    private void collectConstructors() {
        Constructor<?>[] constructorArray = this.clazz.getConstructors();
        MemberBundle memberBundle = new MemberBundle();
        for (int i = 0; i < constructorArray.length; ++i) {
            memberBundle.add(constructorArray[i]);
        }
        this.constructors = memberBundle;
    }

    private void collectFields() {
        Field[] fieldArray = ReflectUtil.getJScriptFields(this.clazz);
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        HashMap<String, Field> hashMap2 = new HashMap<String, Field>();
        for (int i = 0; i < fieldArray.length; ++i) {
            hashMap.put(fieldArray[i].getName(), fieldArray[i]);
            hashMap2.put(fieldArray[i].getName().toLowerCase(), fieldArray[i]);
        }
        this.fieldMap = hashMap;
        this.lowerCaseFieldMap = hashMap2;
    }

    private static class ConstructorInfo
    extends MemberInfo {
        protected ConstructorInfo(Constructor constructor) {
            super(constructor);
            this.parameterTypes = constructor.getParameterTypes();
        }

        public Constructor getConstructor() {
            return (Constructor)this.getMember();
        }

        public Object invoke(Object object, Object[] objectArray) throws Exception {
            return JSClassLoader.newInstance(this.getConstructor(), objectArray);
        }

        public Class getReturnType() {
            return this.getConstructor().getDeclaringClass();
        }

        public boolean isBridge() {
            return false;
        }
    }

    private class MemberBundle {
        protected List members = new ArrayList();

        private MemberBundle() {
        }

        public void add(Method method) {
            MethodInfo methodInfo = new MethodInfo(method);
            if (!methodInfo.isBridge() && !this.members.contains(methodInfo)) {
                this.members.add(methodInfo);
            }
        }

        public void add(Constructor constructor) {
            this.members.add(new ConstructorInfo(constructor));
        }

        public Result invoke(Object object, Object[] objectArray) throws Exception {
            MemberInfo memberInfo = null;
            MemberInfo memberInfo2 = null;
            Class[] classArray = null;
            int n = 0;
            boolean bl = false;
            Object[] objectArray2 = this.members.iterator();
            while (objectArray2.hasNext()) {
                MemberInfo memberInfo3 = (MemberInfo)objectArray2.next();
                Class[] classArray2 = memberInfo3.getParameterTypes();
                if (objectArray == null ? classArray2.length != 0 : classArray2.length != objectArray.length) continue;
                int n2 = 0;
                for (int i = 0; i < classArray2.length; ++i) {
                    Object object2 = objectArray[i];
                    Class clazz = classArray2[i];
                    int n3 = JavaClass.this.bridge.conversionCost(object2, clazz);
                    if (n3 < 0) {
                        n2 = -1;
                        break;
                    }
                    n2 += n3;
                }
                if (n2 < 0) continue;
                if (memberInfo == null || n2 < n) {
                    memberInfo = memberInfo3;
                    classArray = memberInfo3.getParameterTypes();
                    n = n2;
                    bl = false;
                    continue;
                }
                if (n2 != n) continue;
                bl = true;
                memberInfo2 = memberInfo3;
            }
            if (memberInfo == null) {
                throw new IllegalArgumentException("No method found matching name " + ((MemberInfo)this.members.get(0)).getName() + " and arguments " + JavaClass.argsToString(objectArray));
            }
            if (bl) {
                throw new IllegalArgumentException("More than one method matching name " + ((MemberInfo)this.members.get(0)).getName() + " and arguments " + JavaClass.argsToString(objectArray) + "\n  Method 1: " + memberInfo.getMember().toString() + "\n  Method 2: " + memberInfo2.getMember().toString());
            }
            objectArray2 = null;
            if (objectArray != null) {
                objectArray2 = new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = JavaClass.this.bridge.convert(objectArray[i], classArray[i]);
                }
            }
            Object object3 = memberInfo.invoke(object, objectArray2);
            return new Result(object3, JavaClass.isBoxingClass(memberInfo.getReturnType()));
        }
    }

    private static abstract class MemberInfo {
        private Member member;
        protected Class[] parameterTypes;

        protected MemberInfo(Member member) {
            this.member = member;
        }

        protected Member getMember() {
            return this.member;
        }

        public String getName() {
            return this.getMember().getName();
        }

        public Class[] getParameterTypes() {
            return this.parameterTypes;
        }

        public abstract Object invoke(Object var1, Object[] var2) throws Exception;

        public abstract Class getReturnType();

        public abstract boolean isBridge();

        public String toString() {
            return this.member.toString();
        }
    }

    private static class MethodInfo
    extends MemberInfo {
        protected MethodInfo(Method method) {
            super(method);
            this.parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            Method method = this.getMethod();
            Method method2 = ((MethodInfo)object).getMethod();
            return method.getName().equals(method2.getName()) && method.getReturnType() == method2.getReturnType() && this.arraysEq(method.getParameterTypes(), method2.getParameterTypes());
        }

        public Method getMethod() {
            return (Method)this.getMember();
        }

        public Object invoke(Object object, Object[] objectArray) throws Exception {
            Object object2 = JSClassLoader.invoke(this.getMethod(), object, objectArray);
            if (object2 == null && this.getMethod().getReturnType() == Void.TYPE) {
                return Void.TYPE;
            }
            return object2;
        }

        public Class getReturnType() {
            return this.getMethod().getReturnType();
        }

        public boolean isBridge() {
            try {
                return this.getMethod().isBridge();
            }
            catch (Error error) {
                return false;
            }
        }

        private boolean arraysEq(Class[] classArray, Class[] classArray2) {
            if (classArray == null != (classArray2 == null)) {
                return false;
            }
            if (classArray == null) {
                return true;
            }
            if (classArray.length != classArray2.length) {
                return false;
            }
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == classArray2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

