/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.openide.explorer.UIException;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.IndexedEditorPanel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.IndexedNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

class IndexedPropertyEditor
implements ExPropertyEditor {
    private Object[] array;
    private PropertyEnv env;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Node.IndexedProperty indexedProperty = null;
    private IndexedEditorPanel currentEditorPanel;

    @Override
    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        propertyEnv.setChangeImmediate(false);
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (!(featureDescriptor instanceof Node.IndexedProperty)) {
            throw new IllegalStateException("This is not an array: " + featureDescriptor);
        }
        this.indexedProperty = (Node.IndexedProperty)featureDescriptor;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.array = null;
            this.firePropertyChange();
            return;
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException(this.env != null ? "Property whose value is not an array " + this.env.getFeatureDescriptor().getName() : "Unknown property - not attached yet.");
        }
        if (object.getClass().getComponentType().isPrimitive()) {
            this.array = Utilities.toObjectArray((Object)object);
        } else {
            this.array = (Object[])Array.newInstance(object.getClass().getComponentType(), ((Object[])object).length);
            System.arraycopy(object, 0, this.array, 0, this.array.length);
        }
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        if (this.array == null) {
            return null;
        }
        if (this.indexedProperty.getElementType().isPrimitive()) {
            return Utilities.toPrimitiveArray((Object[])this.array);
        }
        return this.array;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString(int n) {
        if (this.array[n] == null) {
            return "null";
        }
        try {
            this.indexedProperty.getIndexedPropertyEditor().setValue(this.array[n]);
            return this.indexedProperty.getIndexedPropertyEditor().getJavaInitializationString();
        }
        catch (NullPointerException nullPointerException) {
            return "null";
        }
    }

    @Override
    public String getJavaInitializationString() {
        if (this.array == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append(this.indexedProperty.getElementType().getName());
        if (this.array.length == 0) {
            stringBuffer.append("[0]");
        } else {
            stringBuffer.append("[] {\n\t");
            for (int i = 0; i < this.array.length; ++i) {
                try {
                    this.indexedProperty.getIndexedPropertyEditor().setValue(this.array[i]);
                    stringBuffer.append(this.indexedProperty.getIndexedPropertyEditor().getJavaInitializationString());
                }
                catch (NullPointerException nullPointerException) {
                    stringBuffer.append("null");
                }
                if (i != this.array.length - 1) {
                    stringBuffer.append(",\n\t");
                    continue;
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getAsText() {
        if (this.array == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        PropertyEditor propertyEditor = null;
        if (this.indexedProperty != null) {
            propertyEditor = this.indexedProperty.getIndexedPropertyEditor();
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (propertyEditor != null) {
                propertyEditor.setValue(this.array[i]);
                stringBuffer.append(propertyEditor.getAsText());
            } else {
                stringBuffer.append("null");
            }
            if (i == this.array.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string.equals("null")) {
            this.setValue(null);
            return;
        }
        if (string.equals("[]")) {
            this.setValue(Array.newInstance(this.indexedProperty.getElementType(), 0));
            return;
        }
        int n = string.indexOf(91);
        n = n < 0 || n + 1 >= string.length() ? 0 : ++n;
        int n2 = string.lastIndexOf(93);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 < n || n2 > string.length()) {
            return;
        }
        try {
            Object[] objectArray;
            PropertyEditor propertyEditor = this.indexedProperty.getIndexedPropertyEditor();
            if (propertyEditor == null) {
                throw new IllegalStateException("Indexed type has no property editor");
            }
            string = string.substring(n, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                objectArray = stringTokenizer.nextToken();
                propertyEditor.setAsText(objectArray.trim());
                linkedList.add(propertyEditor.getValue());
            }
            objectArray = linkedList.toArray((Object[])Array.newInstance(this.getConvertedType(), linkedList.size()));
            this.setValue(objectArray);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            UIException.annotateUser(illegalArgumentException, IndexedPropertyEditor.getString("EXC_ErrorInIndexedSetter"), IndexedPropertyEditor.getString("EXC_ErrorInIndexedSetter"), exception, new Date());
            throw illegalArgumentException;
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        if (this.array == null) {
            this.array = (Object[])Array.newInstance(this.getConvertedType(), 0);
            this.firePropertyChange();
        }
        DisplayIndexedNode displayIndexedNode = new DisplayIndexedNode(0);
        Node.Property property = displayIndexedNode.getPropertySets()[0].getProperties()[0];
        Node.Property[] propertyArray = new Node.Property[]{property};
        this.currentEditorPanel = new IndexedEditorPanel(this.createRootNode(), propertyArray);
        return this.currentEditorPanel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private Node createRootNode() {
        DisplayIndexedNode[] displayIndexedNodeArray = new DisplayIndexedNode[this.array.length];
        for (int i = 0; i < displayIndexedNodeArray.length; ++i) {
            displayIndexedNodeArray[i] = new DisplayIndexedNode(i);
        }
        MyIndexedRootNode myIndexedRootNode = new MyIndexedRootNode((Node[])displayIndexedNodeArray);
        Index index = (Index)myIndexedRootNode.getCookie(Index.class);
        for (int i = 0; i < displayIndexedNodeArray.length; ++i) {
            index.addChangeListener(WeakListeners.change((ChangeListener)displayIndexedNodeArray[i], (Object)index));
        }
        return myIndexedRootNode;
    }

    private Class getConvertedType() {
        Class clazz = this.indexedProperty.getElementType();
        if (clazz.isPrimitive()) {
            clazz = Utilities.getObjectType((Class)clazz);
        }
        return clazz;
    }

    void firePropertyChange() {
        this.propertySupport.firePropertyChange("value", null, null);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(IndexedPropertyEditor.class).getString(string);
    }

    private Object defaultValue() {
        Constable constable = null;
        if (this.indexedProperty.getElementType().isPrimitive()) {
            if (this.getConvertedType().equals(Integer.class)) {
                constable = new Integer(0);
            }
            if (this.getConvertedType().equals(Boolean.class)) {
                constable = Boolean.FALSE;
            }
            if (this.getConvertedType().equals(Byte.class)) {
                constable = new Byte(0);
            }
            if (this.getConvertedType().equals(Character.class)) {
                constable = new Character('\u0000');
            }
            if (this.getConvertedType().equals(Double.class)) {
                constable = new Double(0.0);
            }
            if (this.getConvertedType().equals(Float.class)) {
                constable = new Float(0.0f);
            }
            if (this.getConvertedType().equals(Long.class)) {
                constable = new Long(0L);
            }
            if (this.getConvertedType().equals(Short.class)) {
                constable = new Short(0);
            }
        } else {
            try {
                constable = (Constable)this.getConvertedType().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return constable;
    }

    static /* synthetic */ Object[] access$102(IndexedPropertyEditor indexedPropertyEditor, Object[] objectArray) {
        indexedPropertyEditor.array = objectArray;
        return objectArray;
    }

    private class MyIndexedRootNode
    extends IndexedNode {
        public MyIndexedRootNode(Node[] nodeArray) {
            this.getChildren().add(nodeArray);
            this.setName("IndexedRoot");
            this.setDisplayName(NbBundle.getBundle(IndexedPropertyEditor.class).getString("CTL_Index"));
        }

        public NewType[] getNewTypes() {
            NewType newType = new NewType(){

                public void create() {
                    Object object;
                    if (IndexedPropertyEditor.this.array != null) {
                        object = (Object[])Array.newInstance(IndexedPropertyEditor.this.getConvertedType(), IndexedPropertyEditor.this.array.length + 1);
                        System.arraycopy(IndexedPropertyEditor.this.array, 0, object, 0, IndexedPropertyEditor.this.array.length);
                        IndexedPropertyEditor.access$102(IndexedPropertyEditor.this, object);
                        ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[((IndexedPropertyEditor)IndexedPropertyEditor.this).array.length - 1] = IndexedPropertyEditor.this.defaultValue();
                    } else {
                        IndexedPropertyEditor.access$102(IndexedPropertyEditor.this, (Object[])Array.newInstance(IndexedPropertyEditor.this.getConvertedType(), 1));
                        ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[0] = IndexedPropertyEditor.this.defaultValue();
                    }
                    IndexedPropertyEditor.this.firePropertyChange();
                    object = new DisplayIndexedNode(IndexedPropertyEditor.this.array.length - 1);
                    MyIndexedRootNode.this.getChildren().add(new Node[]{object});
                    Index index = (Index)MyIndexedRootNode.this.getCookie(Index.class);
                    index.addChangeListener(WeakListeners.change((ChangeListener)object, (Object)index));
                }
            };
            return new NewType[]{newType};
        }
    }

    class DisplayIndexedNode
    extends AbstractNode
    implements ChangeListener {
        private int index;

        public DisplayIndexedNode(int n) {
            super(Children.LEAF);
            this.index = n;
            this.setName(Integer.toString(n));
            this.setDisplayName(Integer.toString(n));
        }

        protected SystemAction[] createActions() {
            try {
                return new SystemAction[]{SystemAction.get(Class.forName("org.openide.actions.MoveUpAction").asSubclass(SystemAction.class)), SystemAction.get(Class.forName("org.openide.actions.MoveDownAction").asSubclass(SystemAction.class))};
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = sheet.get("properties");
            if (set == null) {
                set = Sheet.createPropertiesSet();
                sheet.put(set);
            }
            set.put((Node.Property)new ValueProp());
            return sheet;
        }

        public void destroy() throws IOException {
            Object[] objectArray = (Object[])Array.newInstance(IndexedPropertyEditor.this.getConvertedType(), IndexedPropertyEditor.this.array.length - 1);
            System.arraycopy(IndexedPropertyEditor.this.array, 0, objectArray, 0, this.index);
            System.arraycopy(IndexedPropertyEditor.this.array, this.index + 1, objectArray, this.index, IndexedPropertyEditor.this.array.length - this.index - 1);
            IndexedPropertyEditor.access$102(IndexedPropertyEditor.this, objectArray);
            IndexedPropertyEditor.this.firePropertyChange();
            if (IndexedPropertyEditor.this.currentEditorPanel != null) {
                IndexedPropertyEditor.this.currentEditorPanel.getExplorerManager().setRootContext(IndexedPropertyEditor.this.createRootNode());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            Node node = this.getParentNode();
            Index index = (Index)node.getCookie(Index.class);
            if (index != null && (n = index.indexOf((Node)this)) != this.index) {
                if (n > this.index) {
                    Object object = IndexedPropertyEditor.this.array[this.index];
                    ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[this.index] = IndexedPropertyEditor.this.array[n];
                    ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[n] = object;
                }
                this.index = n;
                this.firePropertyChange(null, null, null);
                this.setDisplayName(Integer.toString(this.index));
                IndexedPropertyEditor.this.firePropertyChange();
            }
        }

        private class ValueProp
        extends PropertySupport {
            public ValueProp() {
                super(IndexedPropertyEditor.this.indexedProperty.getName(), IndexedPropertyEditor.this.indexedProperty.getElementType(), IndexedPropertyEditor.this.indexedProperty.getDisplayName(), IndexedPropertyEditor.this.indexedProperty.getShortDescription(), IndexedPropertyEditor.this.indexedProperty.canRead(), IndexedPropertyEditor.this.indexedProperty.canWrite());
            }

            public Object getValue() {
                if (DisplayIndexedNode.this.index < IndexedPropertyEditor.this.array.length) {
                    return IndexedPropertyEditor.this.array[DisplayIndexedNode.this.index];
                }
                return null;
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Object object2 = IndexedPropertyEditor.this.array[DisplayIndexedNode.this.index];
                ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[((DisplayIndexedNode)DisplayIndexedNode.this).index] = object;
                DisplayIndexedNode.this.firePropertyChange(this.getName(), object2, object);
                IndexedPropertyEditor.this.firePropertyChange();
            }

            public PropertyEditor getPropertyEditor() {
                return IndexedPropertyEditor.this.indexedProperty.getIndexedPropertyEditor();
            }
        }
    }
}

